/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.formplugin.util.MappingCfgUtil;

public class BillMappingHeaderConfigPlugin
extends AbstractFormPlugin
implements ClickListener {
    private Log log = LogFactory.getLog(BillMappingHeaderConfigPlugin.class);
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_DELETE = "btndelete";
    private static final String MENU_ENTRY = "entryentity";
    private static final String HEADER_TAG_Y = "1";
    private static final String HEADER_TAG_N = "0";
    private static final String ATTRIBUTE_DEFALT = "D";
    private static final String ATTRIBUTE_CUS = "C";
    private static final String MAPPING_NUMBER_FRONT = "CDN_";
    private static final String ADVCON_TOOL_BAR = "advcontoolbarap";
    private static final String BILL_TOOL_BAR = "billtoolbarap";
    private static final String CALL_BACK_BTN_DELETE = "callBackBtnDelete";
    private static final String T_DHC_BILLMAPPING = "t_dhc_billmapping";
    private static final String DHC_BILL_MAPPING_SAVE_TX = "fi/BillMappingHeaderConfigPlugin/saveHeaderConfiguration";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ADVCON_TOOL_BAR});
        this.addItemClickListeners(new String[]{BILL_TOOL_BAR});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData(MENU_ENTRY);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"dhc_billmapping", (String)EntityField.buildSelectField((String[])new String[]{"name", "mappingtype", "number", "cusattribute"}), (QFilter[])new QFilter[]{new QFilter("tag", "=", (Object)HEADER_TAG_Y)}, (String)"sequence");
        int csize = collection.size();
        if (csize == 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(MENU_ENTRY, csize);
        int i = 0;
        for (DynamicObject dyo : collection) {
            String name = dyo.getString("name");
            String mappingType = dyo.getString("mappingtype");
            String cusAttribute = dyo.getString("cusattribute");
            String number = dyo.getString("number");
            model.setValue("name", (Object)name, i);
            model.setValue("mappingtype", (Object)mappingType, i);
            model.setValue("cusattribute", (Object)cusAttribute, i);
            model.setValue("number", (Object)number, i);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeItemClick(BeforeItemClickEvent evt) {
        int n;
        int[] nArray;
        int[] selectRows;
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_DELETE)) {
            AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
            selectRows = grid.getEntryState().getSelectedRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"BillMappingHeaderConfigPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            nArray = selectRows;
            n = nArray.length;
        } else {
            DynamicObject billData;
            String name;
            if (!StringUtils.equals((CharSequence)key, (CharSequence)BTN_SAVE)) return;
            DynamicObjectCollection billCollectionCus = this.getEntryCusData();
            DynamicObjectCollection billCollectionAll = this.getModel().getEntryEntity(MENU_ENTRY);
            Iterator tipsMap = billCollectionCus.iterator();
            do {
                if (tipsMap.hasNext()) continue;
                List repeat = billCollectionAll.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("name"), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
                if (repeat == null) return;
                if (repeat.size() <= 0) return;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u9879 \u3010%s\u3011 \u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539", (String)"BillMappingHeaderConfigPlugin_8", (String)"fi-dhc-formplugin", (Object[])new Object[0]), repeat));
                evt.setCancel(true);
                return;
            } while (!StringUtils.isBlank((CharSequence)(name = (billData = (DynamicObject)tipsMap.next()).getString("name"))));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u540d\u79f0\u3002", (String)"BillMappingHeaderConfigPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        for (int i = 0; i < n; ++i) {
            int index = nArray[i];
            DynamicObject rowData = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
            String cusAttribute = rowData.getString("cusattribute");
            if (!StringUtils.equals((CharSequence)cusAttribute, (CharSequence)ATTRIBUTE_DEFALT)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9ed8\u8ba4\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BillMappingHeaderConfigPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Map<String, List<String>> tipsMap = this.checkMappingNumberExist(selectRows);
        if (tipsMap.size() <= 0) {
            this.getModel().deleteEntryRows(MENU_ENTRY, selectRows);
            return;
        }
        StringBuilder info = new StringBuilder();
        Iterator<Map.Entry<String, List<String>>> it = tipsMap.entrySet().iterator();
        info.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u9879\uff1a", (String)"BillMappingHeaderConfigPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        while (true) {
            if (!it.hasNext()) {
                info.append(ResManager.loadKDString((String)"\u5982\u5220\u9664\u5b57\u6bb5\uff0c\u4fdd\u5b58\u540e\u6240\u6709\u8bbe\u7f6e\u5c06\u4e00\u540c\u5220\u9664\u3002", (String)"BillMappingHeaderConfigPlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(info.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_BTN_DELETE));
                evt.setCancel(true);
                return;
            }
            Map.Entry<String, List<String>> entry2 = it.next();
            info.append(String.format(ResManager.loadKDString((String)"[%1$s]\u5df2\u5728%2$s\u505a\u4e86\u6620\u5c04\u503c\u8bbe\u7f6e", (String)"BillMappingHeaderConfigPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]), entry2.getKey(), entry2.getValue()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_SAVE)) {
            DynamicObjectCollection billCollection = this.getEntryCusData();
            DynamicObjectCollection headerCollection = MappingCfgUtil.getHeaderCusData();
            ArrayList<DynamicObject> addDatas = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> deleteDatas = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> modifyDatas = new ArrayList<DynamicObject>(16);
            ArrayList<Integer> headerMatch = new ArrayList<Integer>(16);
            for (int bi = 0; bi < billCollection.size(); ++bi) {
                DynamicObject billData = (DynamicObject)billCollection.get(bi);
                boolean billMatch = false;
                String billName = billData.getString("name");
                String billNumber = billData.getString("number");
                for (int hj = 0; hj < headerCollection.size(); ++hj) {
                    DynamicObject headerData = (DynamicObject)headerCollection.get(hj);
                    String headerName = headerData.getString("name");
                    String headerNumber = headerData.getString("number");
                    if (StringUtils.equals((CharSequence)billName, (CharSequence)headerName) && StringUtils.equals((CharSequence)billNumber, (CharSequence)headerNumber)) {
                        billMatch = true;
                        headerMatch.add(hj);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)billName, (CharSequence)headerName) || !StringUtils.equals((CharSequence)billNumber, (CharSequence)headerNumber)) continue;
                    modifyDatas.add(billData);
                    billMatch = true;
                    headerMatch.add(hj);
                }
                if (billMatch) continue;
                addDatas.add(billData);
            }
            for (int i = 0; i < headerCollection.size(); ++i) {
                if (headerMatch.contains(i)) continue;
                deleteDatas.add((DynamicObject)headerCollection.get(i));
            }
            List<DynamicObject> addDataSaves = this.buildAddData(addDatas);
            List<String> deleteDataSaves = this.buildDeleteData(deleteDatas);
            List<DynamicObject> modifyDataSaves = this.buildModifyData(modifyDatas);
            this.saveHeaderConfiguration(addDataSaves, deleteDataSaves, modifyDataSaves);
            if (addDataSaves.size() > 0 || deleteDataSaves.size() > 0 || modifyDataSaves.size() > 0) {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
            }
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_BTN_DELETE.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
            int[] selectRows = grid.getEntryState().getSelectedRows();
            this.getModel().deleteEntryRows(MENU_ENTRY, selectRows);
        }
    }

    private List<DynamicObject> buildAddData(List<DynamicObject> addDatas) {
        DynamicObjectCollection headerAllCollection;
        ArrayList<DynamicObject> addDataSaves = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection billAccesseds = QueryServiceHelper.query((String)"dhc_billaccessed", (String)EntityField.buildSelectField((String[])new String[]{"id", "name", "number"}), null);
        int numberCreatSq = 0;
        int sequence = 0;
        QFilter qFilter1 = new QFilter("cusattribute", "=", (Object)ATTRIBUTE_CUS);
        QFilter qFilter2 = new QFilter("tag", "=", (Object)HEADER_TAG_Y);
        DynamicObjectCollection headerCusCollection = QueryServiceHelper.query((String)"dhc_billmapping", (String)"number", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"id");
        if (headerCusCollection.size() > 0) {
            DynamicObject dyo = (DynamicObject)headerCusCollection.get(headerCusCollection.size() - 1);
            String cusNumber = dyo.getString("number");
            int length = cusNumber.length();
            String count = cusNumber.substring(MAPPING_NUMBER_FRONT.length(), length);
            numberCreatSq = Integer.parseInt(count) + 1;
        }
        if ((headerAllCollection = MappingCfgUtil.getHeaderAllData()).size() > 0) {
            DynamicObject maxSquenceHeader = (DynamicObject)headerAllCollection.get(headerAllCollection.size() - 1);
            sequence = maxSquenceHeader.getInt("sequence") + 1;
        }
        for (DynamicObject addData : addDatas) {
            String cusNumber = this.createCusNumber(numberCreatSq);
            DynamicObject saveDyo = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billmapping");
            saveDyo.set("name", addData.get("name"));
            saveDyo.set("number", (Object)cusNumber);
            saveDyo.set("mappingtype", (Object)addData.getString("mappingtype"));
            saveDyo.set("cusattribute", (Object)addData.getString("cusattribute"));
            saveDyo.set("tag", (Object)HEADER_TAG_Y);
            saveDyo.set("createtime", (Object)new Date());
            saveDyo.set("status", (Object)"A");
            saveDyo.set("enable", (Object)HEADER_TAG_Y);
            saveDyo.set("sequence", (Object)sequence);
            addDataSaves.add(saveDyo);
            for (DynamicObject dyn : billAccesseds) {
                DynamicObject saveDyn = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billmapping");
                saveDyn.set("name", addData.get("name"));
                saveDyn.set("number", (Object)cusNumber);
                saveDyn.set("mappingtype", (Object)addData.getString("mappingtype"));
                saveDyn.set("cusattribute", (Object)addData.getString("cusattribute"));
                saveDyn.set("tag", (Object)HEADER_TAG_N);
                saveDyn.set("bill", (Object)dyn.getString("id"));
                saveDyn.set("billname", (Object)dyn.getString("name"));
                saveDyn.set("billnumber", (Object)dyn.getString("number"));
                saveDyn.set("createtime", (Object)new Date());
                saveDyn.set("status", (Object)"A");
                saveDyn.set("enable", (Object)HEADER_TAG_Y);
                saveDyn.set("sequence", (Object)sequence);
                addDataSaves.add(saveDyn);
            }
            ++numberCreatSq;
            ++sequence;
        }
        return addDataSaves;
    }

    private List<String> buildDeleteData(List<DynamicObject> deleteDatas) {
        ArrayList<String> deleteDataSaves = new ArrayList<String>(16);
        for (DynamicObject dyo : deleteDatas) {
            String number = dyo.getString("number");
            deleteDataSaves.add(number);
        }
        return deleteDataSaves;
    }

    private List<DynamicObject> buildModifyData(List<DynamicObject> modifyDatas) {
        ArrayList<DynamicObject> modifyDataSaves = new ArrayList<DynamicObject>(16);
        for (DynamicObject dyo : modifyDatas) {
            DynamicObject[] collection;
            String number = dyo.getString("number");
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            for (DynamicObject dyn : collection = BusinessDataServiceHelper.load((String)"dhc_billmapping", (String)EntityField.buildSelectField((String[])new String[]{"id", "name", "modifytime"}), (QFilter[])new QFilter[]{qFilter})) {
                dyn.set("name", dyo.get("name"));
                dyn.set("modifytime", (Object)new Date());
            }
            modifyDataSaves.addAll(Arrays.asList(collection));
        }
        return modifyDataSaves;
    }

    private void saveHeaderConfiguration(List<DynamicObject> addDataSaves, List<String> deleteDataSaves, List<DynamicObject> modifyDataSaves) {
        DBRoute fi = DBRoute.of((String)"fi");
        boolean hasBillMapping = DB.exitsTable((DBRoute)fi, (String)T_DHC_BILLMAPPING);
        try (TXHandle tx = TX.requiresNew((String)DHC_BILL_MAPPING_SAVE_TX);){
            try {
                if (hasBillMapping) {
                    if (deleteDataSaves.size() > 0) {
                        QFilter qFilter = new QFilter("number", "in", deleteDataSaves);
                        DeleteServiceHelper.delete((String)"dhc_billmapping", (QFilter[])new QFilter[]{qFilter});
                    }
                    if (addDataSaves.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])addDataSaves.toArray(new DynamicObject[0]));
                    }
                    if (modifyDataSaves.size() > 0) {
                        SaveServiceHelper.update((DynamicObject[])modifyDataSaves.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
        catch (Throwable ex) {
            this.log.error("\u5217\u8868\u5b57\u6bb5\u8bbe\u7f6e\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\u3002", ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u8868\u5b57\u6bb5\u8bbe\u7f6e\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\u3002", (String)"BillMappingHeaderConfigPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            if (ex instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utException = (UndeclaredThrowableException)ex;
                if (utException.getUndeclaredThrowable() instanceof InvocationTargetException) {
                    InvocationTargetException _exception = (InvocationTargetException)utException.getUndeclaredThrowable();
                    throw new KDBizException(_exception.getTargetException().getMessage());
                }
                throw new KDBizException(utException.getUndeclaredThrowable().getMessage());
            }
            throw ex;
        }
    }

    private String createCusNumber(int i) {
        return MAPPING_NUMBER_FRONT.concat(String.valueOf(i));
    }

    private Map<String, List<String>> checkMappingNumberExist(int[] selectRows) {
        ArrayList<DynamicObject> deleteData = new ArrayList<DynamicObject>(16);
        for (int index : selectRows) {
            DynamicObject rowData = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
            deleteData.add(rowData);
        }
        DynamicObjectCollection headerCusCollection = MappingCfgUtil.getUnHeaderCusData();
        HashMap<String, List<String>> tipsMap = new HashMap<String, List<String>>(16);
        for (DynamicObject data : deleteData) {
            String number = data.getString("number");
            String name = data.getString("name");
            ArrayList<String> idList = new ArrayList<String>(16);
            for (DynamicObject headerCus : headerCusCollection) {
                String mappingValue;
                String numberCus = headerCus.getString("number");
                if (!StringUtils.equals((CharSequence)number, (CharSequence)numberCus) || !StringUtils.isNotBlank((CharSequence)(mappingValue = headerCus.getString("mappingnumber")))) continue;
                String billId = headerCus.getString("billname");
                idList.add(billId);
            }
            if (idList.size() <= 0) continue;
            tipsMap.put(name, idList);
        }
        return tipsMap;
    }

    private DynamicObjectCollection getEntryCusData() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(MENU_ENTRY);
        DynamicObjectCollection collectionClone = (DynamicObjectCollection)collection.clone();
        Iterator billIterator = collectionClone.iterator();
        while (billIterator.hasNext()) {
            DynamicObject item = (DynamicObject)billIterator.next();
            if (!StringUtils.equals((CharSequence)item.getString("cusattribute"), (CharSequence)ATTRIBUTE_DEFALT)) continue;
            billIterator.remove();
        }
        return collectionClone;
    }
}

