/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class BillMappingStatusPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String billTypeKey = "billtype";
    private static final String paramNumberKey = "paramNumber";
    private static final String otherMappedBillStatusKey = "otherMappedBillStatus";
    private static final String btnOkKey = "btnok";
    private static final String entryEntityKey = "entryentity";
    private static final String statusKeyKey = "statuskey";
    private static final String statusNameKey = "statusname";
    private static final String currentMappedBillStatusKey = "currentMappedBillStatus";
    private static List<String> currentMappedBillStatus;

    public void initialize() {
        Button btn = (Button)this.getView().getControl(btnOkKey);
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel mainModel = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        List otherMappedBillStatus = (List)param.getCustomParam(otherMappedBillStatusKey);
        String billType = (String)param.getCustomParam(billTypeKey);
        String paramNumber = (String)param.getCustomParam(paramNumberKey);
        List<BillStatusProp.StatusItemPro> billAllStatusItems = this.getBillAllStatusItems(billType, paramNumber);
        if (billAllStatusItems == null || billAllStatusItems.size() == 0) {
            return;
        }
        ArrayList<BillStatusProp.StatusItemPro> notUsedStatusItems = new ArrayList<BillStatusProp.StatusItemPro>();
        for (BillStatusProp.StatusItemPro statusItemPro : billAllStatusItems) {
            if (otherMappedBillStatus.contains(statusItemPro.getStatusKey())) continue;
            notUsedStatusItems.add(statusItemPro);
        }
        int notUsedStatusItemsSize = notUsedStatusItems.size();
        if (notUsedStatusItemsSize > 0) {
            mainModel.batchCreateNewEntryRow(entryEntityKey, notUsedStatusItemsSize);
            for (int i = 0; i < notUsedStatusItemsSize; ++i) {
                mainModel.setValue(statusKeyKey, (Object)((BillStatusProp.StatusItemPro)notUsedStatusItems.get(i)).getStatusKey(), i);
                mainModel.setValue(statusNameKey, (Object)((BillStatusProp.StatusItemPro)notUsedStatusItems.get(i)).getStatusName(), i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryEntityKey);
        currentMappedBillStatus = (List)param.getCustomParam(currentMappedBillStatusKey);
        HashSet<String> billStatusSet = new HashSet<String>(currentMappedBillStatus);
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (currentMappedBillStatus != null && currentMappedBillStatus.size() > 0) {
            DynamicObjectCollection billStatusCollection = (DynamicObjectCollection)entryGrid.getModel().getDataEntity().get(entryEntityKey);
            for (DynamicObject status : billStatusCollection) {
                String statusKey = status.get(3).toString();
                int index = Integer.parseInt(status.get(1).toString()) - 1;
                if (!billStatusSet.contains(statusKey)) continue;
                selectRows.add(index);
                entryGrid.selectRows(index, false);
            }
            entryGrid.selectRows(selectRows.stream().mapToInt(Integer::valueOf).toArray(), 0);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (btnOkKey.equals(clickKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryEntityKey);
            IDataModel entryModel = entryGrid.getModel();
            int remainingRowsCount = this.getModel().getEntryRowCount(entryEntityKey);
            int[] ints = entryGrid.getSelectRows();
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            ArrayList<String> newMappedBillStatus = new ArrayList<String>();
            for (int i = 0; i < ints.length; ++i) {
                String statusKey = entryModel.getValue(statusKeyKey, ints[i]).toString();
                String statusName = entryModel.getValue(statusNameKey, ints[i]).toString();
                if (!StringUtils.isNotEmpty((String)statusKey) || !StringUtils.isNotEmpty((String)statusName)) continue;
                returnData.put(statusKey, statusName);
                newMappedBillStatus.add(statusKey);
            }
            boolean flag = false;
            if (currentMappedBillStatus != null) {
                Collections.sort(currentMappedBillStatus);
                Collections.sort(newMappedBillStatus);
                flag = !currentMappedBillStatus.equals(newMappedBillStatus);
            } else if (newMappedBillStatus.size() > 0) {
                flag = true;
            }
            String isUpdateMapped = flag + "";
            returnData.put("isUpdateMapped", isUpdateMapped);
            returnData.put("isWholeMapped", remainingRowsCount == ints.length ? "true" : "false");
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("exit".equals(callBackId)) {
            this.getView().close();
        }
    }

    private List<BillStatusProp.StatusItemPro> getBillAllStatusItems(String billType, String paramNumber) {
        EntityType entityType = (EntityType)EntityMetadataCache.getDataEntityType((String)billType).getAllEntities().get(billType);
        if (entityType == null) {
            return null;
        }
        DynamicProperty billStatusPropDynamicProperty = entityType.getProperty(paramNumber);
        if (billStatusPropDynamicProperty == null || !(billStatusPropDynamicProperty instanceof BillStatusProp)) {
            ConfirmCallBackListener exitConfirm = new ConfirmCallBackListener("exit");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u6620\u5c04\u503c\u9519\u8bef\uff0c\u8bf7\u8fd4\u56de\u91cd\u65b0\u914d\u7f6e\"\u5355\u636e\u72b6\u6001\"\u6620\u5c04\u503c\u3002", (String)"BillMappingStatusPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, exitConfirm);
            return null;
        }
        BillStatusProp billStatusProp = (BillStatusProp)billStatusPropDynamicProperty;
        return billStatusProp.getStatusItems();
    }
}

