/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.enums.OperationRuleEnum;
import kd.fi.dhc.formplugin.util.MetaDataUtil;

public class BillOperationEditPlugin
extends AbstractBillPlugIn {
    private static final String DHC_OPERATION_LIST = "dhc_operationlist";
    private static final String FIELD_BIND_BILL = "bindbill";
    private static final String FIELD_OPERATION_NAME = "operationname";
    private static final String FIELD_OPERATION_NUMBER = "operationnumber";
    private static final String CALL_BACK_OPERATION_LIST = "callBackOperationList";
    private static final String OP_DELETE = "delete";
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String OP_SUBMIT_AND_NEW = "submitandnew";
    private static final String OP_UNSUBMIT = "unsubmit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD_OPERATION_NAME});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (FIELD_OPERATION_NAME.equals(key)) {
            DynamicObject bindBill = (DynamicObject)this.getModel().getValue(FIELD_BIND_BILL);
            if (bindBill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u63a5\u5165\u5355\u636e\u3002", (String)"BillOperationEditPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            } else {
                this.openOperationList(bindBill.getString("number"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (CALL_BACK_OPERATION_LIST.equals(actionId)) {
            List returnData = (List)event.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            StringBuilder operationName = new StringBuilder();
            StringBuilder operationNumber = new StringBuilder();
            for (Map dataMap : returnData) {
                if (operationName.length() > 0) {
                    operationName.append(", ");
                    operationNumber.append(", ");
                }
                operationName.append((String)dataMap.get("operationName"));
                operationNumber.append((String)dataMap.get("operationNumber"));
            }
            this.getModel().setValue(FIELD_OPERATION_NAME, (Object)operationName.toString());
            this.getModel().setValue(FIELD_OPERATION_NUMBER, (Object)operationNumber.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        Object source = event.getSource();
        if (source instanceof Save && event.getOperationResult().isSuccess()) {
            this.saveOpBizRule();
            this.addDataInitRecord();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (FIELD_BIND_BILL.equalsIgnoreCase(propName)) {
            DynamicObject billEntity = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (billEntity == null) {
                this.getModel().setValue(FIELD_OPERATION_NAME, null);
                this.getModel().setValue(FIELD_OPERATION_NUMBER, null);
                return;
            }
            String entityInnerId = billEntity.getString("accessedbillnew_id");
            DynamicObject formDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityInnerId)});
            this.getModel().setValue("innerid", formDyo.get("dentityid"));
            String entityNumber = billEntity.getString("number");
            this.spliceOpNameAndNumber(entityNumber);
        }
    }

    private void openOperationList(String entityNumber) {
        List opList = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (opList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u672a\u7ed1\u5b9a\u64cd\u4f5c\u3002", (String)"BillOperationEditPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter param = new FormShowParameter();
            param.setFormId(DHC_OPERATION_LIST);
            param.getOpenStyle().setShowType(ShowType.NonModal);
            param.setCustomParam("entityNumber", (Object)entityNumber);
            String selectedOperation = (String)this.getModel().getValue(FIELD_OPERATION_NUMBER);
            param.setCustomParam("selectedOperation", (Object)selectedOperation);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_OPERATION_LIST);
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    private void spliceOpNameAndNumber(String entityNumber) {
        List<ComboItem> operationList = MetaDataUtil.getEntityOperationList(entityNumber);
        if (operationList.isEmpty()) {
            return;
        }
        StringBuilder operationName = new StringBuilder();
        StringBuilder operationNumber = new StringBuilder();
        for (ComboItem operation : operationList) {
            String number = operation.getValue();
            if (!OP_DELETE.equalsIgnoreCase(number) && !OP_SAVE.equalsIgnoreCase(number) && !OP_SUBMIT.equalsIgnoreCase(number) && !OP_SUBMIT_AND_NEW.equalsIgnoreCase(number) && !OP_UNSUBMIT.equalsIgnoreCase(number)) continue;
            if (operationName.length() > 0) {
                operationName.append(", ");
            }
            operationName.append(operation.getCaption());
            if (operationNumber.length() > 0) {
                operationNumber.append(", ");
            }
            operationNumber.append(number);
        }
        this.getModel().setValue(FIELD_OPERATION_NAME, (Object)operationName.toString());
        this.getModel().setValue(FIELD_OPERATION_NUMBER, (Object)operationNumber.toString());
    }

    private void saveOpBizRule() {
        DynamicObject bindBill = (DynamicObject)this.getModel().getValue(FIELD_BIND_BILL);
        String operationNumber = (String)this.getModel().getValue(FIELD_OPERATION_NUMBER);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)bindBill.getString("number"), (String)OperationRuleEnum.Data_Synchronization.getValue(), this.transformStringToList(operationNumber));
        } else if (status.equals((Object)OperationStatus.EDIT)) {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)bindBill.getString("number"), (String)OperationRuleEnum.Data_Synchronization.getValue());
            OpBizRuleSetServiceHelper.clearCache();
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)bindBill.getString("number"), (String)OperationRuleEnum.Data_Synchronization.getValue(), this.transformStringToList(operationNumber));
        }
    }

    private void addDataInitRecord() {
        Object innerId = this.getModel().getValue("innerid");
        QFilter idFilter = new QFilter("bill.id", "=", innerId);
        boolean exists = QueryServiceHelper.exists((String)"dhc_billdatainit", (QFilter[])new QFilter[]{idFilter});
        if (exists) {
            return;
        }
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billdatainit");
        dyn.set("bill", innerId);
        dyn.set("initstatus", (Object)"A");
        dyn.set("initfinishtime", null);
        dyn.set("initbegintime", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
    }

    private List<String> transformStringToList(String str) {
        String[] split = str.split(",");
        ArrayList<String> res = new ArrayList<String>(16);
        for (String s : split) {
            res.add(s.trim());
        }
        return res;
    }
}

