/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboItem;
import kd.fi.dhc.formplugin.util.MetaDataUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BillOperationFormListPlugin
extends AbstractBillPlugIn {
    private static final String CONTROL_ENTITY_LIST = "entitylist";
    private static final String FIELD_OPERATION_NAME = "operationname";
    private static final String FIELD_OPERATION_NUMBER = "operationnumber";
    private static final String BTN_OK = "btn_ok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String entityNumber = (String)param.getCustomParam("entityNumber");
        String selectedOperation = (String)param.getCustomParam("selectedOperation");
        List<ComboItem> operationList = MetaDataUtil.getEntityOperationList(entityNumber);
        if (!operationList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(CONTROL_ENTITY_LIST, operationList.size());
            ArrayList<Integer> selectRowList = new ArrayList<Integer>();
            int i = 0;
            for (ComboItem operation : operationList) {
                this.getModel().setValue(FIELD_OPERATION_NAME, (Object)operation.getCaption(), i);
                this.getModel().setValue(FIELD_OPERATION_NUMBER, (Object)operation.getValue(), i);
                if (selectedOperation.contains(operation.getValue())) {
                    selectRowList.add(i);
                }
                ++i;
            }
            this.getPageCache().put("selectRows", this.transformListToString(selectRowList));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String selectRows = this.getPageCache().get("selectRows");
        int[] selectRowArr = this.transformStringToArr(selectRows);
        if (selectRowArr != null && selectRowArr.length > 0) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(CONTROL_ENTITY_LIST);
            grid.selectRows(selectRowArr, 0);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.getView().returnDataToParent(this.getSelectData());
            this.getView().close();
        }
    }

    private List<Map<String, String>> getSelectData() {
        int[] rows;
        ArrayList<Map<String, String>> returnData = new ArrayList<Map<String, String>>(16);
        AbstractGrid entryList = (AbstractGrid)this.getView().getControl(CONTROL_ENTITY_LIST);
        for (int row : rows = entryList.getEntryState().getSelectedRows()) {
            HashMap<String, String> ret = new HashMap<String, String>(4);
            String operationName = (String)this.getModel().getValue(FIELD_OPERATION_NAME, row);
            String operationNumber = (String)this.getModel().getValue(FIELD_OPERATION_NUMBER, row);
            ret.put("operationName", operationName);
            ret.put("operationNumber", operationNumber);
            returnData.add(ret);
        }
        return returnData;
    }

    private String transformListToString(List<Integer> list) {
        StringBuilder res = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            res.append(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                res.append(',');
                res.append(list.get(i));
            }
        }
        return res.toString();
    }

    private int[] transformStringToArr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String[] split = str.split(",");
        int[] res = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            res[i] = NumberUtils.toInt((String)split[i].trim());
        }
        return res;
    }
}

