/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;

public class BillSubjectEditPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final String SPLIT_CHAR = "_";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbmain"});
        TextEdit rulefieldid = (TextEdit)this.getControl("rulefieldid");
        rulefieldid.addButtonClickListener((ClickListener)this);
        Button cancel = (Button)this.getControl("cancel");
        cancel.addClickListener((ClickListener)this);
        Button ok = (Button)this.getControl("ok");
        ok.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String entryName = (String)this.getView().getFormShowParameter().getCustomParam("entryName");
        String entryNumber = (String)this.getView().getFormShowParameter().getCustomParam("entryNumber");
        if (StringUtils.isBlank((CharSequence)entryName) || StringUtils.isBlank((CharSequence)entryNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u62a5\u8d26\u7ed1\u5b9a\u5355\u636e\u3002", (String)"BillSubjectEditPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        model.setValue("billname", (Object)entryName);
        model.setValue("billnumber", (Object)entryNumber);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        if ("pretext".equalsIgnoreCase(propName) || "posttext".equalsIgnoreCase(propName) || "rulefieldid".equalsIgnoreCase(propName)) {
            this.setNumber(model);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        IDataModel model = this.getModel();
        String key = c.getKey();
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        String entryName = (String)this.getView().getFormShowParameter().getCustomParam("entryName");
        String entryNumber = (String)this.getView().getFormShowParameter().getCustomParam("entryNumber");
        if (StringUtils.isBlank((CharSequence)entryName) || StringUtils.isBlank((CharSequence)entryNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u62a5\u8d26\u7ed1\u5b9a\u5355\u636e\u3002", (String)"BillSubjectEditPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("rulefieldid".equals(key)) {
            this.getRuleShow(entryNumber, entryName);
        } else if ("cancel".equals(key)) {
            this.getView().close();
        } else if ("ok".equals(key)) {
            OperationResult result = null;
            result = this.getView().invokeOperation("save");
            String number = String.valueOf(model.getValue("remark"));
            String id = "0";
            if (result != null) {
                if (CollectionUtils.isEmpty((Collection)result.getAllErrorOrValidateInfo())) {
                    id = String.valueOf(result.getSuccessPkIds().get(0));
                } else {
                    throw new KDBizException(((IOperateInfo)result.getAllErrorOrValidateInfo().get(0)).getMessage());
                }
            }
            retMap.put("number", number);
            retMap.put("id", id);
            this.getView().returnDataToParent(retMap);
            this.getView().close();
        }
    }

    private void getRuleShow(String entryNumber, String entryName) {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "dhc_proptree");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("entityKey", (Object)entryNumber);
        showParameter.setCustomParam("entityName", (Object)entryName);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "propertyTree");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        this.setNumber(model);
    }

    private void setNumber(IDataModel model) {
        StringBuilder appendnumber = new StringBuilder();
        int size = model.getEntryRowCount("entryentity");
        if (size == 0) {
            model.setValue("remark", null);
        }
        for (int i = 0; i < size; ++i) {
            String oldappendnumber;
            String rulefieldid;
            if (i != 0) {
                appendnumber.append('_');
            }
            String pretext = (String)model.getValue("pretext", i);
            String posttext = (String)model.getValue("posttext", i);
            if (StringUtils.isNotBlank((CharSequence)pretext)) {
                appendnumber.append(pretext);
            }
            if (StringUtils.isNotBlank((CharSequence)(rulefieldid = (String)model.getValue("rulefieldid", i)))) {
                appendnumber.append(rulefieldid);
            }
            if (StringUtils.isNotBlank((CharSequence)posttext)) {
                appendnumber.append(posttext);
            }
            String newappendnumber = (oldappendnumber = appendnumber + "").endsWith(SPLIT_CHAR) ? oldappendnumber.substring(0, oldappendnumber.length() - 1) : oldappendnumber;
            model.setValue("remark", (Object)newappendnumber);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        if ("propertyTree".equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            Map ret = (Map)e.getReturnData();
            int index = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("rulefieldid", ret.get("alias"), index);
            model.setValue("mark", ret.get("mark"), index);
        }
    }
}

