/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.constant.EntityField;

public class FormListF7Plugin
extends AbstractFormPlugin {
    private static final String FORM_ENTRY = "entryentity";
    private static final String FORM_NUMBER = "formnumber";
    private static final String FORM_NAME = "formname";
    private static final String FORM_ID = "formid";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String IS_VISIBLE_TRUE = "1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        QFilter filter = new QFilter("isvisible", "=", (Object)IS_VISIBLE_TRUE);
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"dhc_billaccessed", (String)EntityField.buildSelectField((String[])new String[]{"name", "number", "accessedbillnew", "accessedbill", "accessedbill_id"}), (QFilter[])new QFilter[]{filter});
        this.getModel().deleteEntryData(FORM_ENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FORM_NUMBER, new Object[0]);
        vs.addField(FORM_NAME, new Object[0]);
        vs.addField(FORM_ID, new Object[0]);
        for (DynamicObject bill : billList) {
            QFilter qFilter = new QFilter("id", "=", (Object)bill.getString("number"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_entityinfo", (String)"name,dentityid", (QFilter[])new QFilter[]{qFilter});
            String formName = null;
            String formId = null;
            if (dynamicObject != null) {
                formName = dynamicObject.getString("name");
                formId = dynamicObject.getString("dentityid");
            }
            if (!StringUtils.isNotEmpty(formName)) continue;
            vs.addRow(new Object[]{bill.getString("number"), formName, formId});
        }
        model.batchCreateNewEntryRow(FORM_ENTRY, vs);
        model.endInit();
        this.getView().updateView(FORM_ENTRY);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equalsIgnoreCase(key)) {
            this.packageDataAndCloseView();
        }
    }

    private void packageDataAndCloseView() {
        EntryGrid entry = (EntryGrid)this.getView().getControl(FORM_ENTRY);
        int[] selectRows = entry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FormListF7Plugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity(FORM_ENTRY, selectRows[0]);
        HashMap<String, String> returnMap = new HashMap<String, String>(4);
        returnMap.put("formId", row.getString(FORM_ID));
        returnMap.put("formName", row.getString(FORM_NAME));
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }
}

