/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.InitExeStatusEnum;

public class InitProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String TOTAL_VALUE = "totalvalue";
    private static final String INIT_AMOUNT_VALUE = "initamountvalue";
    private static final String FAIL_AMOUNT_VALUE = "failamountvalue";
    private static final String CACHE_FORM_META_NUMBER = "formMetaNumber";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String formMetaNumber = (String)param.getCustomParam("fromMetaNumber");
        this.getPageCache().put(CACHE_FORM_META_NUMBER, formMetaNumber);
        QFilter numberFilter = new QFilter("bill.number", "=", (Object)formMetaNumber);
        DynamicObjectCollection recordList = QueryServiceHelper.query((String)"dhc_datainitrecord", (String)EntityField.buildSelectField((String[])new String[]{"billtotal", "saveamount", "initamount"}), (QFilter[])new QFilter[]{numberFilter}, (String)"createtime desc");
        Label totalValue = (Label)this.getView().getControl(TOTAL_VALUE);
        Label initAmountValue = (Label)this.getView().getControl(INIT_AMOUNT_VALUE);
        Label failAmountValue = (Label)this.getView().getControl(FAIL_AMOUNT_VALUE);
        if (recordList.isEmpty()) {
            totalValue.setText("#N/A");
            initAmountValue.setText("#N/A");
            failAmountValue.setText("#N/A");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InitProgressFormPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject record = (DynamicObject)recordList.get(0);
            int billTotal = (Integer)record.get("billtotal");
            int initAmount = (Integer)record.get("saveamount");
            int failAmount = 0;
            totalValue.setText("" + billTotal);
            initAmountValue.setText("" + initAmount);
            failAmountValue.setText("" + failAmount);
        }
        this.startProgress();
    }

    public void onProgress(ProgressEvent evt) {
        Label failValue;
        String formMetaNumber = this.getPageCache().get(CACHE_FORM_META_NUMBER);
        QFilter numberFilter = new QFilter("bill.number", "=", (Object)formMetaNumber);
        DynamicObjectCollection recordList = QueryServiceHelper.query((String)"dhc_datainitrecord", (String)EntityField.buildSelectField((String[])new String[]{"billtotal", "saveamount", "initamount", "exestatus"}), (QFilter[])new QFilter[]{numberFilter}, (String)"createtime desc");
        if (recordList.isEmpty()) {
            return;
        }
        DynamicObject record = (DynamicObject)recordList.get(0);
        BigDecimal billTotal = record.getBigDecimal("billtotal");
        BigDecimal initAmount = record.getBigDecimal("initamount");
        BigDecimal saveAmount = record.getBigDecimal("saveamount");
        if (billTotal.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal progress = initAmount.multiply(BigDecimal.valueOf(100.0)).divide(billTotal, 1);
            evt.setProgress(progress.intValue());
        } else {
            evt.setProgress(100);
        }
        String exeStatus = record.getString("exestatus");
        if (InitExeStatusEnum.EXE_SUCCESS.getValue().equals(exeStatus)) {
            evt.setText(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b8c\u6210", (String)"InitProgressFormPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            failValue = (Label)this.getView().getControl(FAIL_AMOUNT_VALUE);
            failValue.setText("" + billTotal.subtract(saveAmount).intValue());
            this.stopProgress();
        } else if (InitExeStatusEnum.EXE_FAILURE.getValue().equals(exeStatus)) {
            evt.setText(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u51fa\u73b0\u5f02\u5e38\u3002", (String)"InitProgressFormPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            failValue = (Label)this.getView().getControl(FAIL_AMOUNT_VALUE);
            failValue.setText("" + billTotal.subtract(saveAmount).intValue());
            this.stopProgress();
        }
        Label totalValue = (Label)this.getView().getControl(TOTAL_VALUE);
        totalValue.setText("" + billTotal.intValue());
        Label initAmountValue = (Label)this.getView().getControl(INIT_AMOUNT_VALUE);
        initAmountValue.setText("" + saveAmount.intValue());
    }

    private void startProgress() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.start();
    }

    private void stopProgress() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.stop();
    }
}

