/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.dto.MyBillStatus;
import kd.fi.dhc.helper.SscImageServiceHelper;
import kd.fi.dhc.service.FieldMapService;
import kd.fi.dhc.service.impl.FieldMapServiceImpl;
import kd.fi.dhc.util.BillShowParameterUtil;
import kd.fi.dhc.util.FormValidationUtil;

public class MyBillListPlugin
extends AbstractListPlugin {
    private List<FilterColumn> commonFilterColumnList = new ArrayList<FilterColumn>();
    private FieldMapService service = new FieldMapServiceImpl();
    private static final String CK_BILLKIND = "billkind";
    private static Log log = LogFactory.getLog(MyBillListPlugin.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView view = this.getView();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if ("doctrackup".equals(operateKey) || "doctrackdown".equals(operateKey)) {
            if (!FormValidationUtil.isSelectRowsInvalid(this.getView(), selectedRows, false)) return;
            args.setCancel(true);
            return;
        }
        if ("donothing-viewimage".equals(operateKey)) {
            if (FormValidationUtil.isSelectRowsInvalid(this.getView(), selectedRows, false)) {
                args.setCancel(true);
                return;
            }
            long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
            String selectField = EntityField.buildSelectField((String[])new String[]{"id", "billid", "bill.number", "billnew.id"});
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"dhc_mybilllist", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (dyo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u5f71\u50cf\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5355\u636eID\u3002", (String)"MyBillListPlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billId = dyo.getString("billid");
            String billType = dyo.getString("billnew.id");
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setBillId(billId);
            ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
            if (imageInfoInside == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"MyBillListPlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String imageNumber = imageInfoInside.getImageNo();
            SscImageServiceHelper.viewphoto((String)imageNumber, (String)billId, (String)billType, (IFormView)this.getView());
            return;
        }
        if (!"donothing-viewflow".equals(operateKey)) return;
        if (FormValidationUtil.isSelectRowsInvalid(this.getView(), selectedRows, false)) {
            args.setCancel(true);
            return;
        }
        long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"dhc_mybilllist", (String)EntityField.buildSelectField((String[])new String[]{"id", "billid", "billnew.number"}), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dyo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5355\u636eID\u3002", (String)"MyBillListPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String billId = dyo.getString("billid");
        try {
            String entityNumber = dyo.getString("billnew.number");
            WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)this.getView().getPageId(), (String)entityNumber, (Object)billId);
            return;
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"MyBillListPlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.commonFilterColumnList = args.getCommonFilterColumns();
        if (!this.isOverClick()) {
            for (FilterColumn column : this.commonFilterColumnList) {
                CommonFilterColumn commonColumn = (CommonFilterColumn)column;
                if (!StringUtils.equals((CharSequence)commonColumn.getFieldName(), (CharSequence)"billnew.name")) continue;
                this.iniL5Filter(commonColumn);
                String cacheValue = SerializationUtils.toJsonString((Object)commonColumn.getComboItems());
                this.getPageCache().put("allbill", cacheValue);
                this.getPageCache().put("l5bill", cacheValue);
                column.setDefaultValue("");
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String billKindJson = this.getPageCache().get(CK_BILLKIND);
        if (StringUtils.isNotBlank((CharSequence)billKindJson)) {
            this.getPageCache().put(CK_BILLKIND, "");
        }
        super.filterColumnSetFilter(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String key = args.getFieldName();
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.contains((CharSequence)key, (CharSequence)"billnew.")) {
            List idList;
            String selectedField = "entryentity.billnew.number";
            String billKindJson = this.getPageCache().get(CK_BILLKIND);
            ArrayList<QFilter> qFilter = new ArrayList<QFilter>(1);
            if (StringUtils.isNotBlank((CharSequence)billKindJson) && !(idList = (List)SerializationUtils.fromJsonString((String)billKindJson, List.class)).isEmpty()) {
                qFilter.add(new QFilter("id", "in", (Object)idList));
            }
            DynamicObjectCollection collections = QueryServiceHelper.query((String)"dhc_billclassification", (String)selectedField, (QFilter[])qFilter.toArray(new QFilter[0]));
            ArrayList<String> billIdList = new ArrayList<String>(10);
            for (DynamicObject dyo : collections) {
                billIdList.add(dyo.getString("entryentity.billnew.number"));
            }
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("id", "in", billIdList));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        CommonFilterColumn l5column = this.getL5CommonFilterColumn(this.commonFilterColumnList);
        List fastFilterValue = args.getSearchClickEvent().getFastFilterValues();
        if (fastFilterValue != null && fastFilterValue.size() > 0 && l5column != null) {
            this.rebuildL5FilterFromCache(l5column);
            return;
        }
        Map commonFilters = args.getCurrentCommonFilter();
        if (commonFilters != null) {
            this.getPageCache().put("isoverclick", "true");
            List fieldName = (List)commonFilters.get("FieldName");
            List value = (List)commonFilters.get("Value");
            if (fieldName != null && fieldName.size() > 0 && value != null && value.size() > 0) {
                String currentFieldName = (String)fieldName.get(0);
                if (StringUtils.equals((CharSequence)currentFieldName, (CharSequence)"billkind.id")) {
                    ArrayList<Long> longId = new ArrayList<Long>(3);
                    for (Object obj : value) {
                        String objTmp = obj + "";
                        if (!StringUtils.isNotBlank((CharSequence)obj.toString()) || StringUtils.equals((CharSequence)"null", (CharSequence)objTmp)) continue;
                        longId.add(Long.valueOf(objTmp));
                    }
                    if (!longId.isEmpty()) {
                        this.rebuildCommonFilter(longId, this.commonFilterColumnList);
                        this.getPageCache().put(CK_BILLKIND, SerializationUtils.toJsonString(longId));
                    } else {
                        this.rebuildCommonFilter(null, this.commonFilterColumnList);
                        this.getPageCache().put(CK_BILLKIND, "");
                    }
                    this.focusCommonFilter(args);
                } else if (l5column != null) {
                    this.rebuildL5FilterFromCache(l5column);
                }
            }
        } else if (l5column != null) {
            this.rebuildL5FilterReturnFromSchemeSerach(l5column);
        }
    }

    private void rebuildL5FilterReturnFromSchemeSerach(CommonFilterColumn l5column) {
        if (this.getPageCache().get("allbill") != null && l5column != null) {
            List l5ComboItem = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("allbill"), ComboItem.class);
            l5column.setComboItems(l5ComboItem);
        }
    }

    private void rebuildL5FilterFromCache(CommonFilterColumn l5column) {
        if (this.getPageCache().get("l5bill") != null && l5column != null) {
            List l5ComboItem = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("l5bill"), ComboItem.class);
            l5column.setComboItems(l5ComboItem);
        }
    }

    public void setFilter(SetFilterEvent e) {
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        QFilter currentPerson = new QFilter("applicant", "=", (Object)currentUserId);
        currentPerson.or(new QFilter("creator", "=", (Object)currentUserId));
        e.addCustomQFilter(currentPerson);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fielldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)fielldName, (CharSequence)"billno")) {
            ListSelectedRow selectRow = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo();
            Long selectid = (Long)selectRow.getPrimaryKeyValue();
            this.showBillForm(selectid);
        }
    }

    private void showBillForm(Long selectDataId) {
        DynamicObject selectBillData = this.getSelectBillData(selectDataId);
        if (selectBillData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"MyBillListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = selectBillData.getString("billnew.id");
        String billId = selectBillData.getString("billid");
        if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)billId)) {
            BillShowParameter parameter = BillShowParameterUtil.getBusBillShowParamter(formId, billId);
            if (parameter != null) {
                parameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"MyBillListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getSelectBillData(Long selectDataId) {
        return QueryServiceHelper.queryOne((String)"dhc_mybilllist", (String)"billid,billnew.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectDataId)});
    }

    private void rebuildCommonFilter(List<Long> billkind, List<FilterColumn> filterColumnList) {
        CommonFilterColumn l5column = this.getL5CommonFilterColumn(filterColumnList);
        if (l5column != null) {
            if (StringUtils.isBlank(billkind)) {
                List l5ComboItem = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("allbill"), ComboItem.class);
                l5column.setComboItems(l5ComboItem);
                this.getPageCache().put("l5bill", SerializationUtils.toJsonString((Object)l5column.getComboItems()));
            } else {
                this.rebuildL5Filter(l5column, billkind);
            }
        }
    }

    private void iniL5Filter(CommonFilterColumn l5column) {
        this.setL5ColumnItems(l5column, null);
    }

    private void rebuildL5Filter(CommonFilterColumn l5column, List<Long> billkind) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", billkind)};
        if (!billkind.isEmpty()) {
            this.setL5ColumnItems(l5column, qFilters);
            this.getPageCache().put("l5bill", SerializationUtils.toJsonString((Object)l5column.getComboItems()));
        }
    }

    private void setL5ColumnItems(CommonFilterColumn l5column, QFilter[] qfilters) {
        String selectedField = "entryentity.billnew.dentityid,entryentity.billnew.name,entryentity.billnew.number";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"dhc_billclassification", (String)selectedField, (QFilter[])qfilters);
        ArrayList<ComboItem> l5ComboItem = new ArrayList<ComboItem>();
        ArrayList<String> billTypeIds = new ArrayList<String>();
        for (DynamicObject dyo : collections) {
            String billTypeId = dyo.getString("entryentity.billnew.dentityid");
            String billNumber = dyo.getString("entryentity.billnew.number");
            String billName = dyo.getString("entryentity.billnew.name");
            if (!StringUtils.isNotBlank((CharSequence)billTypeId) || billTypeIds.contains(billTypeId)) continue;
            ComboItem item = new ComboItem();
            item.setId(billTypeId);
            item.setCaption(new LocaleString(billName));
            item.setValue(billNumber);
            l5ComboItem.add(item);
            billTypeIds.add(billTypeId);
        }
        l5column.setComboItems(l5ComboItem);
    }

    private CommonFilterColumn getL5CommonFilterColumn(List<FilterColumn> filterColumnList) {
        CommonFilterColumn l5column = null;
        for (FilterColumn column : filterColumnList) {
            CommonFilterColumn commonColumn = (CommonFilterColumn)column;
            if (!StringUtils.equals((CharSequence)commonColumn.getFieldName(), (CharSequence)"billnew.name")) continue;
            l5column = commonColumn;
        }
        return l5column;
    }

    private void focusCommonFilter(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        for (Map filter : customFiterList) {
            String fieldName;
            List fieldNames = (List)filter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)"bill.id", (CharSequence)(fieldName = fieldNames.get(0).toString()))) continue;
            filter.replace("Value", Collections.singletonList(""));
        }
    }

    private boolean isOverClick() {
        return StringUtils.equals((CharSequence)this.getPageCache().get("isoverclick"), (CharSequence)"true");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u5f00\u59cb\u6267\u884cbeforeCreateListDataProvider___" + System.currentTimeMillis());
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u5f00\u59cb\u6267\u884cgetData___" + System.currentTimeMillis());
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                HashMap billInfoMap = new HashMap(22);
                collection.forEach(v -> {
                    String billId = String.valueOf(v.get("billid"));
                    if (StringUtils.isNotBlank((CharSequence)billId) && v.containsProperty("billnew")) {
                        billInfoMap.put(String.valueOf(v.get("billid")), String.valueOf(v.get("billnew.number")));
                    }
                });
                if (billInfoMap.size() > 0) {
                    try {
                        ArrayList pkId = new ArrayList(billInfoMap.keySet());
                        MyBillListPlugin.this.setNextAuditor(collection, pkId);
                        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u7ed3\u675f\u52a8\u6001\u663e\u793a\u5f53\u524d\u5904\u7406\u4eba\u5217___" + System.currentTimeMillis());
                        MyBillListPlugin.this.setBillStatus(collection, billInfoMap);
                        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u7ed3\u675f\u52a8\u6001\u66f4\u65b0\u5355\u636e\u72b6\u6001___" + System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        log.error("ErWorkFlowFlexListForOtherPlugin >>>>> \u8bbe\u7f6e\u5ba1\u6279\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    }
                }
                return collection;
            }
        });
        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u7ed3\u675f\u6267\u884cbeforeCreateListDataProvider___" + System.currentTimeMillis());
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> pkId) {
        Map<String, String> auditorsNameMap = this.getNextAuditor(pkId);
        collection.forEach(v -> {
            String pkIdTemp = String.valueOf(v.get("billid"));
            try {
                v.set("currentdealer", (Object)(auditorsNameMap.get(pkIdTemp) == null ? "" : auditorsNameMap.get(pkIdTemp)));
            }
            catch (Exception e) {
                log.error("\u4e0b\u4e00\u6b65\u5ba1\u6279\u4eba\u5b57\u6bb5\u5728\u5217\u8868\u4e2d\u4e0d\u5b58\u5728", (Throwable)e);
            }
        });
    }

    private Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>(20);
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            String pkid = (String)entry.getKey();
            List node = (List)allPro.get(pkid);
            node.forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (auditor != null && !"".equals(auditor.trim())) {
                    nodeStr = nodeStr + " / " + auditor;
                }
                if (nodeStr.length() > 26) {
                    nodeStr = nodeStr.substring(0, 26);
                }
                nodeMap.put(pkid, nodeStr);
            });
        }
        return nodeMap;
    }

    private void setBillStatus(DynamicObjectCollection collection, Map<String, String> billInfoMap) {
        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u5f00\u59cb\u6267\u884csetBillStatus___" + System.currentTimeMillis());
        Map<String, MyBillStatus> billStatusMap = this.getBillStatus(billInfoMap);
        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u83b7\u53d6\u5355\u636e\u72b6\u6001\u7ed3\u675f___" + System.currentTimeMillis());
        collection.forEach(v -> {
            String pkIdTemp = String.valueOf(v.get("billid"));
            try {
                MyBillStatus statusValue = (MyBillStatus)billStatusMap.get(pkIdTemp);
                if (statusValue != null) {
                    String reimburseStatus = statusValue.getReimburseStatus();
                    String billStatus = statusValue.getBillStatus();
                    String bizStatus = statusValue.getBizStatus();
                    v.set("reimbursestatus", (Object)reimburseStatus);
                    v.set("billstatusext", (Object)billStatus);
                    v.set("businessstatus", (Object)bizStatus);
                }
            }
            catch (Exception var4) {
                log.info("\u4e0b\u4e00\u6b65\u5ba1\u6279\u4eba\u5b57\u6bb5\u5728\u5217\u8868\u4e2d\u4e0d\u5b58\u5728");
            }
        });
        log.info("\u3010==\u6027\u80fd\u68c0\u67e5==\u3011 \u7ed3\u675f\u6267\u884csetBillStatus___" + System.currentTimeMillis());
    }

    private Map<String, MyBillStatus> getBillStatus(Map<String, String> billInfoMap) {
        Map<String, List<String>> reorgData = this.orgBillBaseBillType(billInfoMap);
        HashMap<String, MyBillStatus> billStatusMap = new HashMap<String, MyBillStatus>(20);
        for (Map.Entry<String, List<String>> entry : reorgData.entrySet()) {
            String billType = entry.getKey();
            List billIds = entry.getValue().stream().map(v -> Long.parseLong(v.trim())).collect(Collectors.toList());
            QFilter[] qryFilters = new QFilter[]{new QFilter("id", "in", billIds)};
            String selectFields = this.getSelectFieldsWithBillType(billType);
            if (StringUtils.isBlank((CharSequence)selectFields)) continue;
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)billType, (String)selectFields, (QFilter[])qryFilters);
            if (StringUtils.equals((CharSequence)"er_tripreqbill", (CharSequence)billType)) {
                this.updateTripreqBillStatusMap(billStatusMap, billType, queryData);
                continue;
            }
            this.updateBillStatusMap(billStatusMap, billType, queryData, false);
        }
        return billStatusMap;
    }

    private Map<String, List<String>> orgBillBaseBillType(Map<String, String> billInfoMap) {
        HashMap<String, List<String>> rtnData = new HashMap<String, List<String>>(20);
        for (Map.Entry<String, String> entry : billInfoMap.entrySet()) {
            String billId = entry.getKey();
            String billType = entry.getValue();
            if (StringUtils.isBlank((CharSequence)billType)) continue;
            ArrayList<String> billIdList = (ArrayList<String>)rtnData.get(billType);
            if (billIdList == null) {
                billIdList = new ArrayList<String>(1);
                billIdList.add(billId);
                rtnData.put(billType, billIdList);
                continue;
            }
            billIdList.add(billId);
        }
        return rtnData;
    }

    private String getSelectFieldsWithBillType(String billType) {
        String selectField = null;
        String billStatus = this.service.getBillStatusField(billType);
        if (StringUtils.isNotBlank((CharSequence)billStatus)) {
            String isLoan;
            selectField = EntityField.buildSelectField((String[])new String[]{"id", billStatus});
            String string = isLoan = "er_tripreqbill".equals(billType) ? "isloan" : null;
            if (StringUtils.isNotBlank((CharSequence)isLoan)) {
                selectField = EntityField.buildSelectField((String[])new String[]{selectField, isLoan});
            }
        }
        return selectField;
    }

    private void updateBillStatusMap(Map<String, MyBillStatus> billStatusMap, String billType, DynamicObject data) {
        String billStatusName;
        boolean isLoan;
        String billId = data.getString("id");
        String billStatus = "";
        String reimburseStatus = "";
        String bizStatus = "";
        String billStatusField = this.service.getBillStatusField(billType);
        if (StringUtils.isBlank((CharSequence)billStatusField)) {
            return;
        }
        String string = billStatus = data.getString(billStatusField) == null ? "" : data.getString(billStatusField);
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            return;
        }
        reimburseStatus = StringUtils.equals((CharSequence)"er_tripreqbill", (CharSequence)billType) ? ((isLoan = data.getBoolean("isloan")) ? this.service.getRemiStatus(billType.concat("_loan"), billStatus) : this.service.getRemiStatus(billType, billStatus)) : this.service.getRemiStatus(billType, billStatus);
        if (reimburseStatus == null) {
            reimburseStatus = "";
        }
        if ((billStatusName = this.service.getBillStatusName(billType, billStatus)) == null) {
            billStatusName = "";
        }
        MyBillStatus status = new MyBillStatus();
        status.setBillStatus(billStatusName);
        status.setReimburseStatus(reimburseStatus);
        billStatusMap.put(billId, status);
    }

    private void updateTripreqBillStatusMap(Map<String, MyBillStatus> billStatusMap, String billType, DynamicObjectCollection queryData) {
        if (queryData.isEmpty()) {
            return;
        }
        DynamicObjectCollection loanData = new DynamicObjectCollection(queryData.getDynamicObjectType(), queryData.getParent());
        for (DynamicObject data : queryData) {
            boolean isLoan = data.getBoolean("isloan");
            if (!isLoan) continue;
            queryData.remove((Object)data);
            loanData.add((Object)data);
        }
        if (!loanData.isEmpty()) {
            this.updateBillStatusMap(billStatusMap, billType, loanData, true);
        }
        if (!queryData.isEmpty()) {
            this.updateBillStatusMap(billStatusMap, billType, queryData, false);
        }
    }

    private void updateBillStatusMap(Map<String, MyBillStatus> billStatusMap, String billType, DynamicObjectCollection queryData, boolean isLoan) {
        String id;
        MyBillStatus status;
        String billStatus = "";
        String reimburseStatus = "";
        String billStatusField = this.service.getBillStatusField(billType);
        if (StringUtils.isBlank((CharSequence)billStatusField)) {
            return;
        }
        HashMap<String, String> idToBillStatus = new HashMap<String, String>(20);
        for (Object data : queryData) {
            String string = data.getString("id");
            String string2 = billStatus = data.getString(billStatusField) == null ? "" : data.getString(billStatusField);
            if (StringUtils.isBlank((CharSequence)billStatus)) continue;
            idToBillStatus.put(string, billStatus);
        }
        Map statusMap = isLoan ? this.service.getRemiStatus(billType.concat("_loan")) : this.service.getRemiStatus(billType);
        if (null == statusMap) {
            for (Map.Entry entry : idToBillStatus.entrySet()) {
                MyBillStatus status2 = new MyBillStatus();
                status2.setReimburseStatus("");
                billStatusMap.put((String)entry.getKey(), status2);
            }
        } else {
            for (Map.Entry entry : idToBillStatus.entrySet()) {
                String id3 = (String)entry.getKey();
                String billStatusValue = (String)entry.getValue();
                reimburseStatus = (String)statusMap.get(billStatusValue);
                status = new MyBillStatus();
                status.setReimburseStatus(reimburseStatus == null ? "" : reimburseStatus);
                billStatusMap.put(id3, status);
            }
        }
        Map statusNameMap = this.service.getBillStatusName(billType);
        if (null == statusMap) {
            for (Map.Entry entry : idToBillStatus.entrySet()) {
                id = (String)entry.getKey();
                status = billStatusMap.get(id);
                status.setBillStatus("");
            }
        } else {
            for (Map.Entry entry : idToBillStatus.entrySet()) {
                id = (String)entry.getKey();
                status = billStatusMap.get(id);
                String billStatusName = (String)statusNameMap.get(idToBillStatus.get(id));
                status.setBillStatus(billStatusName == null ? "" : billStatusName);
            }
        }
    }
}

