/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.CustomBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.dhc.config.meta.CustomizedField;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.RequestBillTypeEnum;
import kd.fi.dhc.helper.SscImageServiceHelper;
import kd.fi.dhc.service.impl.FieldMapServiceImpl;
import kd.fi.dhc.util.BillShowParameterUtil;
import kd.fi.dhc.util.FormValidationUtil;

public class MyBillListReformRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private List<FilterColumn> commonFilterColumnList = new ArrayList<FilterColumn>(10);
    private static final String CK_BILLTYPE = "billtype";
    private static final String CK_BILLKIND = "billkind";
    private static final String DISCK_ISSCHEMA = "disschema";
    private static final String DISCK_PKIDLIST = "dispkidlist";
    private static Log log = LogFactory.getLog(MyBillListReformRptPlugin.class);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl("reportlistap");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IDataModel model = this.getModel();
        model.getEntryEntity("reportlistap");
        List<DynamicObject> selectedRows = this.getSelectRows();
        if (("doctrackup".equals(formOperate.getOperateKey()) || "doctrackdown".equals(formOperate.getOperateKey())) && FormValidationUtil.isSelectRowsInvalid((IFormView)this.getView(), selectedRows.size(), false)) {
            args.setCancel(true);
        }
    }

    private List<DynamicObject> getSelectRows() {
        ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>(1);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        Map state = reportList.getEntryState().getState();
        Object rowIndex = state.get("selRows");
        if (rowIndex instanceof List) {
            List rowIndexList = (List)rowIndex;
            IReportListModel reportModel = reportList.getReportModel();
            for (Object indexTmp : rowIndexList) {
                if (!(indexTmp instanceof Integer)) continue;
                Integer index = (Integer)indexTmp;
                DynamicObject selectedRow = reportModel.getRowData(index.intValue());
                selectedRows.add(selectedRow);
            }
        }
        return selectedRows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IReportView view = this.getView();
        if ("viewimage".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            List<DynamicObject> selectedRows = this.getSelectRows();
            if (FormValidationUtil.isSelectRowsInvalid((IFormView)this.getView(), selectedRows.size(), false)) {
                return;
            }
            long id = selectedRows.get(0).getLong("id");
            String selectField = EntityField.buildSelectField((String[])new String[]{"id", "billid", "bill.number", "billnew.id"});
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"dhc_mybilllist", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (dyo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u5f71\u50cf\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5355\u636eID\u3002", (String)"MyBillListPlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billId = dyo.getString("billid");
            String billType = dyo.getString("billnew.id");
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setBillId(billId);
            ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
            if (imageInfoInside == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"MyBillListPlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String imageNumber = imageInfoInside.getImageNo();
            SscImageServiceHelper.viewphoto((String)imageNumber, (String)billId, (String)billType, (IFormView)this.getView());
            return;
        }
        if (!"viewflowchart".equals(e.getOperateKey())) return;
        if (!e.getOperationResult().isSuccess()) return;
        List<DynamicObject> selectedRows = this.getSelectRows();
        if (FormValidationUtil.isSelectRowsInvalid((IFormView)this.getView(), selectedRows.size(), false)) {
            return;
        }
        long id = selectedRows.get(0).getLong("id");
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"dhc_mybilllist", (String)EntityField.buildSelectField((String[])new String[]{"id", "billid", "billnew.number"}), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dyo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5355\u636eID\u3002", (String)"MyBillListPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String billId = dyo.getString("billid");
        try {
            String entityNumber = dyo.getString("billnew.number");
            WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)this.getView().getPageId(), (String)entityNumber, (Object)billId);
            return;
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"MyBillListPlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent args, ReportQueryParam queryParam) {
        super.filterContainerInit(args, queryParam);
        this.commonFilterColumnList = args.getCommonFilterColumns();
        if (!this.isOverClick()) {
            for (FilterColumn column : this.commonFilterColumnList) {
                CommonFilterColumn commonColumn = (CommonFilterColumn)column;
                String columnName = commonColumn.getFieldName();
                if (StringUtils.equals((CharSequence)columnName, (CharSequence)"billtype1")) {
                    this.iniL5Filter(commonColumn);
                    String cacheValue = SerializationUtils.toJsonString((Object)commonColumn.getComboItems());
                    this.getPageCache().put("allbill", cacheValue);
                    this.getPageCache().put("l5bill", cacheValue);
                    String firstValue = null;
                    if (((CustomBaseDataFilterColumn)column).getComboItems().size() > 0) {
                        firstValue = ((ComboItem)((CustomBaseDataFilterColumn)column).getComboItems().get(0)).getValue();
                    }
                    column.setDefaultValue("");
                    this.getPageCache().put(CK_BILLTYPE, firstValue);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)columnName, (CharSequence)"createtime")) continue;
                column.setDefaultValue("63");
            }
            this.getPageCache().put("isoverclick", "true");
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi-dhc");
            cache.put(DISCK_ISSCHEMA, (Object)"false");
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
        log.info("\u3010\u6027\u80fd\u68c0\u67e5\u3011\u5bfc\u51fa\u524d\u9009\u4e2d\u884c\u8fc7\u6ee4\u5f00\u59cb\u6267\u884c-------" + System.currentTimeMillis());
        ReportList billList = (ReportList)this.getView().getControl("reportlistap");
        ArrayList selRows = (ArrayList)billList.getEntryState().get("selRows");
        if (!data.isEmpty() && selRows.size() > 0) {
            ArrayList<DynamicObject> filteredData = new ArrayList<DynamicObject>();
            for (DynamicObject dyo : data) {
                int fseq = (Integer)dyo.get("fseq");
                if (!selRows.contains(fseq)) continue;
                filteredData.add(dyo);
            }
            if (!filteredData.isEmpty()) {
                data.clear();
                data.addAll(filteredData);
            }
        }
        log.info("\u3010\u6027\u80fd\u68c0\u67e5\u3011\u5bfc\u51fa\u524d\u9009\u4e2d\u884c\u8fc7\u6ee4\u7ed3\u675f\u6267\u884c-------" + System.currentTimeMillis());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String key = args.getFieldName();
        if (key.contains(CK_BILLTYPE)) {
            List idList;
            String selectedField = "entryentity.billnew.number";
            String billKindJson = this.getPageCache().get(CK_BILLKIND);
            ArrayList<QFilter> qFilter = new ArrayList<QFilter>(1);
            if (StringUtils.isNotBlank((CharSequence)billKindJson) && !(idList = (List)SerializationUtils.fromJsonString((String)billKindJson, List.class)).isEmpty()) {
                qFilter.add(new QFilter("id", "in", (Object)idList));
            }
            DynamicObjectCollection collections = QueryServiceHelper.query((String)"dhc_billclassification", (String)selectedField, (QFilter[])qFilter.toArray(new QFilter[0]));
            ArrayList<String> billIdList = new ArrayList<String>(10);
            for (DynamicObject dyo : collections) {
                billIdList.add(dyo.getString("entryentity.billnew.number"));
            }
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("id", "in", billIdList));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map commonFilters;
        super.filterContainerSearchClick(args);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi-dhc");
        CommonFilterColumn l5column = this.getL5CommonFilterColumn(this.commonFilterColumnList);
        List fastFilterValue = args.getSearchClickEvent().getFastFilterValues();
        if (fastFilterValue != null && fastFilterValue.size() > 0 && l5column != null) {
            this.rebuildL5FilterFromCache(l5column);
        }
        if ((commonFilters = args.getCurrentCommonFilter()) != null) {
            cache.put(DISCK_ISSCHEMA, (Object)"false");
            this.getPageCache().put("isoverclick", "true");
            List fieldName = (List)commonFilters.get("FieldName");
            List value = (List)commonFilters.get("Value");
            if (fieldName != null && fieldName.size() > 0 && value != null && value.size() > 0) {
                String currentFieldName = (String)fieldName.get(0);
                if (StringUtils.equals((CharSequence)currentFieldName, (CharSequence)"billkind.id")) {
                    ArrayList<Long> longId = new ArrayList<Long>(3);
                    for (Object obj : value) {
                        String objTmp = obj + "";
                        if (!StringUtils.isNotBlank((CharSequence)obj.toString()) || StringUtils.equals((CharSequence)"null", (CharSequence)objTmp)) continue;
                        longId.add(Long.valueOf(objTmp));
                    }
                    if (!longId.isEmpty()) {
                        this.rebuildCommonFilter(longId, this.commonFilterColumnList);
                        this.getPageCache().put(CK_BILLKIND, SerializationUtils.toJsonString(longId));
                    } else {
                        this.rebuildCommonFilter(null, this.commonFilterColumnList);
                        this.getPageCache().put(CK_BILLKIND, "");
                    }
                    this.focusCommonFilter(args);
                } else if (l5column != null) {
                    this.rebuildL5FilterFromCache(l5column);
                }
            }
        } else if (l5column != null) {
            this.rebuildL5FilterReturnFromSchemeSerach(l5column);
            cache.put(DISCK_ISSCHEMA, (Object)"true");
            Set<Long> pkidList = this.analyzeSchemeSearchTmp(args);
            if (!pkidList.isEmpty()) {
                String pkidStr = SerializationUtils.toJsonString(pkidList);
                cache.put(DISCK_PKIDLIST, (Object)pkidStr);
            } else {
                cache.put(DISCK_PKIDLIST, (Object)"");
            }
        }
    }

    private Set<Long> analyzeSchemeSearchTmp(FilterContainerSearchClickArgs args) {
        ArrayList<QFilter> comQFilterList = new ArrayList<QFilter>(4);
        List filterMap = (List)args.getSearchClickEvent().getFilterValues().get("schemefilter");
        for (Map map : filterMap) {
            String fieldName = (String)((List)map.get("FieldName")).get(0);
            QFilter qFilter = args.getSearchClickEvent().getQFilter(fieldName);
            if ((qFilter = this.analyzeComFilter(qFilter, fieldName)) == null) continue;
            comQFilterList.add(qFilter);
        }
        List qFilters = args.getSearchClickEvent().getFilterParameter().getQFilters();
        for (QFilter qFilter : qFilters) {
            if (!(qFilter.getValue() instanceof QEmptyValue)) continue;
            String property = qFilter.getProperty();
            qFilter = this.analyzeComFilter(qFilter, property);
            comQFilterList.add(qFilter);
        }
        return this.qryBillIdFromMyBill(comQFilterList);
    }

    private QFilter analyzeComFilter(QFilter qFilter, String filedName) {
        if (StringUtils.isBlank((CharSequence)filedName) || qFilter == null) {
            return null;
        }
        String changeProperty = "";
        filedName = qFilter.getProperty();
        if (StringUtils.equals((CharSequence)"applicant", (CharSequence)filedName)) {
            changeProperty = "applicant.name";
            qFilter.__setProperty(changeProperty);
            this.changeFilterProperty(qFilter, changeProperty);
        } else if (StringUtils.equals((CharSequence)"company", (CharSequence)filedName)) {
            changeProperty = "company.name";
            qFilter.__setProperty(changeProperty);
            this.changeFilterProperty(qFilter, changeProperty);
        }
        if (StringUtils.equals((CharSequence)"billtype1.name", (CharSequence)filedName)) {
            changeProperty = "billnew.name";
            qFilter.__setProperty("billnew.name");
            this.changeFilterProperty(qFilter, changeProperty);
        }
        if (StringUtils.equals((CharSequence)"billtype1.id", (CharSequence)filedName)) {
            changeProperty = "billnew.id";
            qFilter.__setProperty("billnew.id");
            this.changeFilterProperty(qFilter, changeProperty);
        }
        return qFilter;
    }

    private void changeFilterProperty(QFilter qFilter, String s) {
        List innerQFilters = qFilter.getNests(true);
        for (QFilter.QFilterNest inFilter : innerQFilters) {
            inFilter.getFilter().__setProperty(s);
        }
    }

    private Set<Long> qryBillIdFromMyBill(List<QFilter> comFilterList) {
        HashSet<Long> rtnSet = new HashSet<Long>(16);
        String selectField = "billid";
        DynamicObjectCollection dyoCollection = QueryServiceHelper.query((String)"dhc_mybilllist", (String)selectField, (QFilter[])comFilterList.toArray(new QFilter[0]));
        for (DynamicObject dyo : dyoCollection) {
            rtnSet.add(dyo.getLong("billid"));
        }
        return rtnSet;
    }

    private void rebuildL5FilterReturnFromSchemeSerach(CommonFilterColumn l5column) {
        if (this.getPageCache().get("allbill") != null) {
            List l5ComboItem = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("allbill"), ComboItem.class);
            l5column.setComboItems(l5ComboItem);
        }
    }

    private void rebuildL5FilterFromCache(CommonFilterColumn l5column) {
        if (this.getPageCache().get("l5bill") != null) {
            List l5ComboItem = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("l5bill"), ComboItem.class);
            l5column.setComboItems(l5ComboItem);
        }
    }

    private void rebuildCommonFilter(List<Long> billkind, List<FilterColumn> filterColumnList) {
        CommonFilterColumn l5column = this.getL5CommonFilterColumn(filterColumnList);
        if (l5column != null) {
            if (StringUtils.isBlank(billkind)) {
                List l5ComboItem = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("allbill"), ComboItem.class);
                l5column.setComboItems(l5ComboItem);
                this.getPageCache().put("l5bill", SerializationUtils.toJsonString((Object)l5column.getComboItems()));
            } else {
                this.rebuildL5Filter(l5column, billkind);
            }
        }
    }

    private void iniL5Filter(CommonFilterColumn l5column) {
        this.setL5ColumnItems(l5column, null);
    }

    private void rebuildL5Filter(CommonFilterColumn l5column, List<Long> billkind) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", billkind)};
        this.setL5ColumnItems(l5column, qFilters);
        this.getPageCache().put("l5bill", SerializationUtils.toJsonString((Object)l5column.getComboItems()));
    }

    private void setL5ColumnItems(CommonFilterColumn l5column, QFilter[] qfilters) {
        String selectedField = "entryentity.billnew.dentityid,entryentity.billnew.name,entryentity.billnew.number";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"dhc_billclassification", (String)selectedField, (QFilter[])qfilters);
        ArrayList<ComboItem> l5ComboItem = new ArrayList<ComboItem>();
        ArrayList<String> billTypeIds = new ArrayList<String>();
        for (DynamicObject dyo : collections) {
            String billTypeId = dyo.getString("entryentity.billnew.dentityid");
            String billNumber = dyo.getString("entryentity.billnew.number");
            String billName = dyo.getString("entryentity.billnew.name");
            if (!StringUtils.isNotBlank((CharSequence)billTypeId) || billTypeIds.contains(billTypeId)) continue;
            ComboItem item = new ComboItem();
            item.setId(billTypeId);
            item.setCaption(new LocaleString(billName));
            item.setValue(billNumber);
            l5ComboItem.add(item);
            billTypeIds.add(billTypeId);
        }
        l5column.setComboItems(l5ComboItem);
    }

    private CommonFilterColumn getL5CommonFilterColumn(List<FilterColumn> filterColumnList) {
        CommonFilterColumn l5column = null;
        for (FilterColumn column : filterColumnList) {
            CommonFilterColumn commonColumn = (CommonFilterColumn)column;
            if (!StringUtils.equals((CharSequence)commonColumn.getFieldName(), (CharSequence)"billtype1")) continue;
            l5column = commonColumn;
        }
        return l5column;
    }

    private void focusCommonFilter(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        for (Map filter : customFiterList) {
            String fieldName;
            List fieldNames = (List)filter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)"billtype1.id", (CharSequence)(fieldName = fieldNames.get(0).toString()))) continue;
            filter.replace("Value", Collections.singletonList(""));
        }
        ReportQueryParam qryParam = this.getView().getQueryParam();
        List filterItemInfoList = qryParam.getFilter().getFilterItems();
        filterItemInfoList.removeIf(f -> StringUtils.equals((CharSequence)"billtype1.id", (CharSequence)f.getPropName()));
    }

    private boolean isOverClick() {
        return StringUtils.equals((CharSequence)this.getPageCache().get("isoverclick"), (CharSequence)"true");
    }

    private void showBillForm(Long selectDataId) {
        DynamicObject selectBillData = this.getSelectBillData(selectDataId);
        if (selectBillData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"MyBillListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = selectBillData.getString("billnew.id");
        String billId = selectBillData.getString("billid");
        if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)billId)) {
            BillShowParameter parameter = BillShowParameterUtil.getBusBillShowParamter(formId, billId);
            if (parameter != null) {
                parameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"MyBillListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getSelectBillData(Long selectDataId) {
        return QueryServiceHelper.queryOne((String)"dhc_mybilllist", (String)"billid,bill.number,billnew.name,billnew.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectDataId)});
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fielldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fielldName, (CharSequence)"billnoshow")) {
            int index = args.getRowIndex();
            DynamicObject selectRow = ((ReportList)this.getControl("reportlistap")).getReportModel().getRowData(index);
            Long selectid = selectRow.getLong("id");
            this.showBillForm(selectid);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        HashMap<String, String> billInfoMap = new HashMap<String, String>(22);
        for (DynamicObject dyo : rowData) {
            String billId = dyo.getString("billid");
            if (StringUtils.isNotBlank((CharSequence)billId)) {
                String billType = dyo.getString("billtypeno");
                billInfoMap.put(billId, billType);
            }
            String string = dyo.getString("billtypeno");
        }
        if (billInfoMap.size() > 0) {
            ArrayList<String> billIdList = new ArrayList<String>(billInfoMap.keySet());
            try {
                log.info("\u8bbe\u7f6e\u5f53\u524d\u5904\u7406\u4eba\uff1a" + System.currentTimeMillis());
                this.setNextAuditor(rowData, billIdList);
                log.info("\u5b9e\u65f6\u66f4\u65b0\u5f71\u50cf\u72b6\u6001\uff1a" + System.currentTimeMillis());
                this.updateBillImageStatus(rowData, billIdList);
                Map<String, List<String>> reorgData = this.orgBillBaseBillType(billInfoMap);
                log.info("\u5b9e\u65f6\u66f4\u65b0\u5355\u636e\u72b6\u6001\u4e0e\u62a5\u8d26\u72b6\u6001\uff1a" + System.currentTimeMillis());
                this.updateBillStatus(rowData, reorgData);
                log.info("\u5b9e\u65f6\u66f4\u65b0\u52a8\u6001\u5b57\u6bb5\uff1a" + System.currentTimeMillis());
                this.showCustomizedField(rowData, reorgData);
            }
            catch (Exception e) {
                log.error("MyBillListReformRptPlugin.processRowData\u6570\u636e\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"MyBillListPlugin_8", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showCustomizedField(DynamicObjectCollection rowData, Map<String, List<String>> reorgData) {
        HashMap custFieldValueMap = new HashMap(200);
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        List customizedColumList = service.getAllCustomizedField();
        if (customizedColumList == null || customizedColumList.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : reorgData.entrySet()) {
            String billType = entry.getKey();
            List<String> billIds = entry.getValue();
            List<Long> billIdList = this.transformIdList(billIds);
            List customizedFieldList = service.getAllCusFieldByBillType(billType, customizedColumList);
            String selectField = this.getCustomSelectField(customizedFieldList);
            if (StringUtils.isBlank((CharSequence)selectField)) continue;
            selectField = EntityField.buildSelectField((String[])new String[]{"id", selectField});
            QFilter[] qryFilters = new QFilter[]{new QFilter("id", "in", billIdList)};
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)billType, (String)selectField, (QFilter[])qryFilters);
            for (DynamicObject dyo : queryData) {
                String billId = String.valueOf(dyo.get("id"));
                int size = customizedFieldList.size();
                HashMap<String, Object> childMap = new HashMap<String, Object>(size);
                for (int i = 0; i < size; ++i) {
                    Object custFieldValue;
                    String custFieldId = ((CustomizedField)customizedColumList.get(i)).getCustomizedFieldId();
                    String custField = (String)customizedFieldList.get(i);
                    if (StringUtils.isBlank((CharSequence)custField) || StringUtils.isBlank((CharSequence)custFieldId)) continue;
                    if (custField.equals("requestbilltype")) {
                        custFieldValue = dyo.getString(custField);
                        childMap.put(custFieldId, RequestBillTypeEnum.getTypeByValAndBillType((String)custFieldValue, (String)billType).getName());
                        continue;
                    }
                    custFieldValue = dyo.get(custField);
                    childMap.put(custFieldId, custFieldValue);
                }
                custFieldValueMap.put(billId, childMap);
            }
        }
        for (DynamicObject dyo : rowData) {
            Map childMap;
            String billId = dyo.getString("billid");
            if (StringUtils.isBlank((CharSequence)billId) || (childMap = (Map)custFieldValueMap.get(billId)) == null) continue;
            for (Map.Entry entry : childMap.entrySet()) {
                String custFieldId = (String)entry.getKey();
                Object custFieldValue = entry.getValue();
                if (custFieldValue == null) continue;
                dyo.set(custFieldId, custFieldValue);
            }
        }
    }

    private String getCustomSelectField(List<String> customizedFieldList) {
        if (customizedFieldList == null || customizedFieldList.size() == 0) {
            return null;
        }
        StringBuilder selectFieldBuilder = new StringBuilder();
        int size = customizedFieldList.size();
        for (int i = 0; i < size; ++i) {
            String cusField = customizedFieldList.get(i);
            if (!StringUtils.isNotBlank((CharSequence)cusField)) continue;
            selectFieldBuilder.append(cusField);
            if (i >= size - 1) continue;
            selectFieldBuilder.append(',');
        }
        String selectField = selectFieldBuilder.toString();
        if (selectField.endsWith(",")) {
            selectField = selectField.substring(0, selectField.length() - 1);
        }
        return selectField;
    }

    private void updateBillImageStatus(DynamicObjectCollection rowData, List<String> billIdList) {
        String billImageStatus;
        String billId;
        QFilter[] qFilters = new QFilter[]{new QFilter("billid", "in", billIdList)};
        String selectField = "billid,imagestate";
        DynamicObjectCollection qryResult = QueryServiceHelper.query((String)"task_billimagemap", (String)selectField, (QFilter[])qFilters);
        HashMap<String, String> billImageStatusMap = new HashMap<String, String>(200);
        for (DynamicObject dyo : qryResult) {
            billId = dyo.getString("billid");
            if (!StringUtils.isNotBlank((CharSequence)billId) || !StringUtils.isNotBlank((CharSequence)(billImageStatus = dyo.getString("imagestate")))) continue;
            billImageStatusMap.put(billId, billImageStatus);
        }
        for (DynamicObject dyo : rowData) {
            billId = dyo.getString("billid");
            if (StringUtils.isBlank((CharSequence)billId) || !StringUtils.isNotBlank((CharSequence)(billImageStatus = (String)billImageStatusMap.get(billId)))) continue;
            dyo.set("imagestatusshow", (Object)billImageStatus);
        }
    }

    private void updateBillStatus(DynamicObjectCollection rowData, Map<String, List<String>> reorgData) {
        HashMap<String, String> billStatusMap = new HashMap<String, String>(200);
        HashMap<String, String> reimbuStatusMap = new HashMap<String, String>(200);
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        for (Map.Entry<String, List<String>> entry : reorgData.entrySet()) {
            String billType = entry.getKey();
            List<String> billIds = entry.getValue();
            String billStatusField = service.getBillStatusField(billType);
            if (StringUtils.isBlank((CharSequence)billStatusField)) continue;
            List<Long> billIdList = this.transformIdList(billIds);
            QFilter[] qryFilters = new QFilter[]{new QFilter("id", "in", billIdList)};
            String selectField = EntityField.buildSelectField((String[])new String[]{"id", billStatusField});
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)billType, (String)selectField, (QFilter[])qryFilters);
            List statusMapList = service.getStatusMapList(billType);
            Map statusMap = statusMapList == null ? null : (Map)statusMapList.get(0);
            Map statusNameMap = statusMapList == null ? null : (Map)statusMapList.get(1);
            for (DynamicObject dyo : queryData) {
                String reimStatus;
                String billId = String.valueOf(dyo.get("id"));
                String billStatusValue = String.valueOf(dyo.get(billStatusField));
                if (!StringUtils.isNotBlank((CharSequence)billStatusValue)) continue;
                String billStatusName = service.getBillStatusName(statusNameMap, billStatusValue);
                if (StringUtils.isNotBlank((CharSequence)billStatusName)) {
                    billStatusMap.put(billId, billStatusName);
                }
                if (!StringUtils.isNotBlank((CharSequence)(reimStatus = service.getRemiStatus(statusMap, billStatusValue)))) continue;
                reimbuStatusMap.put(billId, reimStatus);
            }
        }
        for (DynamicObject dyo : rowData) {
            String reimStatus;
            String billId = dyo.getString("billid");
            if (StringUtils.isBlank((CharSequence)billId)) continue;
            String billStatus = (String)billStatusMap.get(billId);
            if (StringUtils.isNotBlank((CharSequence)billStatus)) {
                dyo.set("billstatus", (Object)billStatus);
            }
            if (!StringUtils.isNotBlank((CharSequence)(reimStatus = (String)reimbuStatusMap.get(billId)))) continue;
            dyo.set("reimstashow", (Object)reimStatus);
        }
    }

    private Map<String, List<String>> orgBillBaseBillType(Map<String, String> billInfoMap) {
        HashMap<String, List<String>> rtnData = new HashMap<String, List<String>>(200);
        for (Map.Entry<String, String> entry : billInfoMap.entrySet()) {
            String billId = entry.getKey();
            String billType = entry.getValue();
            if (StringUtils.isBlank((CharSequence)billType)) continue;
            ArrayList<String> billIdList = (ArrayList<String>)rtnData.get(billType);
            if (billIdList == null) {
                billIdList = new ArrayList<String>(1);
                billIdList.add(billId);
                rtnData.put(billType, billIdList);
                continue;
            }
            billIdList.add(billId);
        }
        return rtnData;
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> pkId) {
        Map<String, String> auditorsNameMap = this.getNextAuditor(pkId);
        collection.forEach(v -> {
            String pkIdTemp = String.valueOf(v.get("billid"));
            try {
                v.set("currentdealer", (Object)(auditorsNameMap.get(pkIdTemp) == null ? "" : auditorsNameMap.get(pkIdTemp)));
            }
            catch (Exception e) {
                log.error("\u4e0b\u4e00\u6b65\u5ba1\u6279\u4eba\u5b57\u6bb5\u5728\u5217\u8868\u4e2d\u4e0d\u5b58\u5728", (Throwable)e);
            }
        });
    }

    private Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>(20);
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            String pkid = (String)entry.getKey();
            List node = (List)allPro.get(pkid);
            node.forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (auditor != null && !"".equals(auditor.trim())) {
                    nodeStr = nodeStr + " / " + auditor;
                }
                if (nodeStr.length() > 26) {
                    nodeStr = nodeStr.substring(0, 26);
                }
                nodeMap.put(pkid, nodeStr);
            });
        }
        return nodeMap;
    }

    private List<Long> transformIdList(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> idList = new ArrayList<Long>(ids.size());
        for (String id : ids) {
            idList.add(Long.valueOf(id));
        }
        return idList;
    }
}

