/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.dhc.config.meta.CustomizedField;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.service.impl.FieldMapServiceImpl;
import kd.fi.dhc.util.DateUtil;
import kd.fi.hdc.cache.DhcDistributeCache;

public class RptMyBillShowPlugin
extends AbstractReportListDataPlugin {
    private static final String DISCK_ISSCHEMA = "disschema";

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        DhcDistributeCache.put((String)"cache_my_list_query_count", (Object)0);
        Long currentUserId = RequestContext.get().getCurrUserId();
        List<QFilter> queryFilterList = this.getQFilters(queryParam);
        QFilter curUserFilter = new QFilter("creator", "=", (Object)currentUserId).or(new QFilter("applicant", "=", (Object)currentUserId));
        queryFilterList.add(curUserFilter);
        List filterItems = queryParam.getFilter().getFilterItems();
        DataSet dataSet = this.getDataSetBuilder(filterItems).build();
        IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
        byBatchInfo.setCountPerBatch(1);
        return dataSet;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String fixedField = this.getFixedSelectField();
        Long currentUserId = RequestContext.get().getCurrUserId();
        List<QFilter> queryFilterList = this.getQFilters(reportQueryParam);
        QFilter curUserFilter = new QFilter("creator", "=", (Object)currentUserId).or(new QFilter("applicant", "=", (Object)currentUserId));
        queryFilterList.add(curUserFilter);
        IReportBatchQueryInfo byBatchInfo = reportQueryParam.byBatchInfo();
        List<QFilter> dateQFilter = this.getBatchDateQFilter(byBatchInfo);
        queryFilterList.addAll(dateQFilter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"RptMyBillShowPlugin.fixedQry", (String)"dhc_mybilllist", (String)fixedField, (QFilter[])queryFilterList.toArray(new QFilter[0]), (String)"createtime desc");
        this.putCountCache(dataSet);
        return dataSet;
    }

    private List<QFilter> getQFilters(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        qFilterList.addAll(this.transFastFilterFromParam(reportQueryParam));
        qFilterList.addAll(this.transformReportQryParam(reportQueryParam));
        return qFilterList;
    }

    private List<QFilter> transFastFilterFromParam(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        FastFilter fastFilter = reportQueryParam.getFilter().getFastFilter();
        if (fastFilter == null) {
            return qFilterList;
        }
        List fastFilterValue = fastFilter.getFastFilter();
        if (fastFilterValue == null) {
            return qFilterList;
        }
        for (Map eachFilterValue : fastFilterValue) {
            List fieldNameList = (List)eachFilterValue.get("FieldName");
            List valueList = (List)eachFilterValue.get("Value");
            QFilter qFilter = null;
            boolean isFirstConnection = true;
            for (Object nameTmp : fieldNameList) {
                String name = (String)nameTmp;
                if (name.contains("billtype")) {
                    name = "bill.name";
                }
                for (Object valueTmp : valueList) {
                    String value = (String)valueTmp;
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    value = "%" + value + "%";
                    if (isFirstConnection) {
                        qFilter = new QFilter(name, "like", (Object)value);
                        isFirstConnection = false;
                        continue;
                    }
                    if (qFilter == null) continue;
                    qFilter = qFilter.or(new QFilter(name, "like", (Object)value));
                }
            }
            if (qFilter == null) continue;
            qFilterList.add(qFilter);
        }
        return qFilterList;
    }

    private List<QFilter> transformReportQryParam(ReportQueryParam param) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi-dhc");
        String isSchemaSearch = (String)cache.get(DISCK_ISSCHEMA);
        if (StringUtils.equals((CharSequence)isSchemaSearch, (CharSequence)"true")) {
            List qFilters = param.getFilter().getQFilters();
            for (QFilter qFilter : qFilters) {
                String property = qFilter.getProperty();
                qFilter = this.analyzeComFilter(qFilter, property);
                qFilterList.add(qFilter);
            }
        } else {
            List filterItemInfoList = param.getFilter().getFilterItems();
            for (FilterItemInfo filterItemInfo : filterItemInfoList) {
                String propName = filterItemInfo.getPropName();
                if (!StringUtils.isNotBlank((CharSequence)propName)) continue;
                String compareType = filterItemInfo.getCompareType();
                Object propValue = filterItemInfo.getValue();
                String propertyName = filterItemInfo.getPropName();
                if (propName.contains("billtype")) {
                    if (propValue == null || !StringUtils.isNotBlank((CharSequence)compareType)) continue;
                    String property = propertyName.replace("billtype", "billnew");
                    property = property.replace("billnew1", "billnew");
                    qFilterList.add(new QFilter(property, compareType, propValue));
                    continue;
                }
                if (propName.equals("company")) {
                    qFilterList.add(new QFilter("company.name", compareType, propValue));
                    continue;
                }
                if (propName.equals("applicant")) {
                    qFilterList.add(new QFilter("applicant.name", compareType, propValue));
                    continue;
                }
                if (propValue == null || !StringUtils.isNotBlank((CharSequence)compareType)) continue;
                qFilterList.add(new QFilter(propName, compareType, propValue));
            }
        }
        return qFilterList;
    }

    private QFilter analyzeComFilter(QFilter qFilter, String filedName) {
        if (StringUtils.isBlank((CharSequence)filedName) || qFilter == null) {
            return null;
        }
        String changeProperty = "";
        filedName = qFilter.getProperty();
        if (StringUtils.equals((CharSequence)"applicant", (CharSequence)filedName)) {
            changeProperty = "applicant.name";
            qFilter.__setProperty(changeProperty);
            this.changeFilterProperty(qFilter, changeProperty);
        } else if (StringUtils.equals((CharSequence)"company", (CharSequence)filedName)) {
            changeProperty = "company.name";
            qFilter.__setProperty(changeProperty);
            this.changeFilterProperty(qFilter, changeProperty);
        }
        if (StringUtils.equals((CharSequence)"billtype1.name", (CharSequence)filedName)) {
            changeProperty = "billnew.name";
            qFilter.__setProperty("billnew.name");
            this.changeFilterProperty(qFilter, changeProperty);
        }
        if (StringUtils.equals((CharSequence)"billtype1.id", (CharSequence)filedName)) {
            changeProperty = "billnew.id";
            qFilter.__setProperty("billnew.id");
            this.changeFilterProperty(qFilter, changeProperty);
        }
        return qFilter;
    }

    private void changeFilterProperty(QFilter qFilter, String s) {
        List innerQFilters = qFilter.getNests(true);
        for (QFilter.QFilterNest inFilter : innerQFilters) {
            inFilter.getFilter().__setProperty(s);
        }
    }

    private String getFixedSelectField() {
        return EntityField.buildSelectField((String[])new String[]{"id", "billid", "billno", "billkind.name", "bill.name", "billsubject", "amount", "reimbursestatus", "billstatusext", "imagestatus", "currentdealer", "applicant.name", "createtime", "company.name", "bill.number", "currency", "billnew.name"});
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        List customizedFiledList = service.getAllCustomizedField();
        for (CustomizedField field : customizedFiledList) {
            String fieldName = field.getCustomizedFieldName();
            String fieldNo = field.getCustomizedFieldId();
            if (!StringUtils.isNotBlank((CharSequence)fieldName) || !StringUtils.isNotBlank((CharSequence)fieldNo)) continue;
            columns.add((AbstractReportColumn)this.createColumn(new LocaleString(fieldName), fieldNo));
        }
        return super.getColumns(columns);
    }

    private ReportColumn createColumn(LocaleString caption, String fieldKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType("text");
        column.setWidth(new LocaleString("160px"));
        return column;
    }

    private DataSetBuilder getDataSetBuilder(List<FilterItemInfo> filterItems) {
        Date startDate = null;
        Date endDate = null;
        for (FilterItemInfo filter : filterItems) {
            String property = filter.getPropName();
            String cp = filter.getCompareType();
            if (property.equals("createtime") && cp.equals(">=")) {
                startDate = (Date)filter.getValue();
                continue;
            }
            if (!property.equals("createtime") || !cp.equals("<")) continue;
            endDate = (Date)filter.getValue();
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("beginDate", (DataType)DateType.DateType), new Field("endDate", (DataType)DateType.DateType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar beginCalender = new GregorianCalendar();
        beginCalender.setTime(startDate);
        GregorianCalendar endCalender = new GregorianCalendar();
        endCalender.setTime(endDate);
        Integer count = (int)DateUtil.getDistanceOfTwoDate((Date)startDate, (Date)endDate);
        int times = 5;
        if (count > 300) {
            times = Math.floorDiv(count, 60);
        }
        for (int i = 0; i < 99999; i += times) {
            calendar.setTime(startDate);
            ((Calendar)calendar).add(5, i);
            Date dayBeginDate = calendar.getTime();
            ((Calendar)calendar).add(5, times);
            Date dayEndDate = calendar.getTime();
            if (dayBeginDate.compareTo(endDate) == 0) break;
            if (dayEndDate.after(endDate)) {
                dataSetBuilder.append(new Object[]{dayBeginDate, endDate});
                break;
            }
            dataSetBuilder.append(new Object[]{dayBeginDate, dayEndDate});
        }
        return dataSetBuilder;
    }

    private List<QFilter> getBatchDateQFilter(IReportBatchQueryInfo byBatchInfo) {
        List currentBatchRows = byBatchInfo.getCurrentBatchRows();
        ArrayList<QFilter> dateQFilter = new ArrayList<QFilter>(2);
        Row currentBatchRow = (Row)currentBatchRows.get(0);
        Date beginDate = currentBatchRow.getDate("beginDate");
        Date endDate = currentBatchRow.getDate("endDate");
        dateQFilter.add(new QFilter("createtime", ">=", (Object)beginDate));
        dateQFilter.add(new QFilter("createtime", "<", (Object)endDate));
        return dateQFilter;
    }

    private void putCountCache(DataSet dataSet) {
        DataSet dataSet1 = dataSet.copy();
        Integer num = dataSet1.count("id", false);
        String countStr = DhcDistributeCache.get((String)"cache_my_list_query_count");
        Integer count = 0;
        if (StringUtils.isNotBlank((CharSequence)countStr)) {
            count = Integer.valueOf(countStr);
        }
        count = count + num;
        if (num > 0) {
            DhcDistributeCache.put((String)"cache_my_list_query_count", (Object)count);
        }
    }
}

