/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.fi.dhc.formplugin.AppMenuTreePlugin;
import kd.fi.dhc.formplugin.util.AppMenuUtil;

public class SubjectMenuTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String APP_NUMBER = "dhc";
    private static final String BOS_DEV_PORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String MENU_TREE = "menutreeview";
    private static final String MENU_ENTRY = "menuentryentity";
    private static final String TOOL_BAR = "toolbarap";
    private static final String SEARCH_AP = "searchap";
    private static final String FIELD_CHECKBOX = "checkboxfield";
    private static final String FIELD_MENU_ID = "menuid";
    private static final String FIELD_PARENT_MENU_ID = "parentmenuid";
    private static final String FIELD_BIND_BILL = "bindbill";
    private static final String FIELD_BILL_SUBJECT = "billsubject";
    private static final String FIELD_BILL_SUBJECT_ID = "billsubjectid";
    private static final String FIELD_BILL_NUMBER = "bindbillnum";
    private static final String FIELD_MENU_SEQ = "menuseq";
    private static final String HELP_CENTER_FLAG = "#hpce";
    private static final String CUSTOMIZED_MENU_FLAG = "#customized";
    private static final String CALL_BACK_SAVE = "saveSubjectCallBack";
    private static final String CACHE_APP_ID = "appId";
    private static final String CACHE_APP_NAME = "appName";
    private static final String CACHE_ROOT = "root";
    private static final String CACHE_NODE_LEVEL = "nodeLevel";
    private static final String CACHE_CUST_NODEIDS = "customizedNodeIds";
    private static final String CACHE_CHECKED_NODE_ID = "checkedNodeId";
    private static final String CACHE_CHECKED_PARENT_NODE_ID = "checkedParentNodeId";
    private static final String ENTITY_BILLSUBJECT = "dhc_billsubject";
    private static final String MAP_BILL_SUBJECT = "billSubjectMap";
    private static final String CACHE_SEARCH_TEXT = "lastSearchText";
    private Log logger = LogFactory.getLog(AppMenuTreePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TextEdit billSubject = (TextEdit)this.getView().getControl(FIELD_BILL_SUBJECT);
        billSubject.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String appId = this.getCurrentAppId();
        if (appId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"AppMenuTreePlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            this.logger.error("kd.ssc.task.rbc.AppMenuTreePlugin.afterCreateNewData: \u6839\u636e\u5e94\u7528\u7f16\u7801 [dhc] \u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u672a\u67e5\u51fa\u6570\u636e\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728\u6216\u5e94\u7528\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01");
            return;
        }
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        String firstL4Node = this.renderMenuTree(metadata);
        this.showMenuListSub(firstL4Node, metadata);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        IDataModel model = this.getModel();
        String key = c.getKey();
        int currentRow = model.getEntryCurrentRowIndex(MENU_ENTRY);
        if (StringUtils.equals((CharSequence)FIELD_BILL_SUBJECT, (CharSequence)key)) {
            String billName = (String)model.getValue(FIELD_BIND_BILL, currentRow);
            String billNumber = (String)model.getValue(FIELD_BILL_NUMBER, currentRow);
            this.getTaskSubject(billName, billNumber, model);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (FIELD_CHECKBOX.equalsIgnoreCase(propertyName)) {
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            Map nodeInfo = tree.getTreeState().getFocusNode();
            if (nodeInfo.get("id") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String nodeId = nodeInfo.get("id").toString();
            String appId = this.getCurrentAppId();
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
            this.showMenuList(nodeId, metadata);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String appId = this.getCurrentAppId();
        String appName = this.getCurrentAppName();
        AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
        int index = grid.getEntryState().getFocusRow();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        if (e.getSource() instanceof MoveEntryUp) {
            this.moveEntryUp(e, index, appId, appMeta);
        } else if (e.getSource() instanceof MoveEntryDown) {
            this.moveEntryDown(e, index, appId, appMeta);
        }
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeInfo.get("id").toString();
        String nodeText = nodeInfo.get("text").toString();
        String parentNodeId = nodeInfo.get("parentid").toString();
        TreeNode root = new TreeNode("", appId, appName);
        AppMetadata appEditMeta = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        List<TreeNode> nodeList = this.getNodeList(appEditMeta);
        root.addChildren(nodeList);
        tree.updateNode(root);
        TreeNode newNode = new TreeNode(parentNodeId, nodeId, nodeText);
        tree.focusNode(newNode);
        tree.showNode(nodeId);
        tree.treeNodeClick(parentNodeId, nodeId);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String appId = this.getCurrentAppId();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        this.showMenuListSub(nodeId, appMeta);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btnsave")) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entrys = model.getEntryEntity(MENU_ENTRY);
            boolean isok = true;
            for (DynamicObject entry : entrys) {
                if (!StringUtils.isBlank((CharSequence)entry.getString(FIELD_BILL_SUBJECT))) continue;
                isok = false;
                break;
            }
            if (isok) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SubjectMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5355\u636e\u4e3b\u9898\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u5355\u636e\u4e3b\u9898\u518d\u4fdd\u5b58", (String)"SubjectMenuTreePlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        String appId = this.getCurrentAppId();
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        String appType = appMetadata.getDevType();
        String appName = this.getCurrentAppName();
        TreeNode root = new TreeNode("", appId, appName);
        List<TreeNode> nodeList = this.getNodeList(appMetadata);
        root.addChildren(nodeList);
        if (evt.getReturnData() != null && CALL_BACK_SAVE.equals(actionId)) {
            Map ret = (Map)evt.getReturnData();
            IDataModel model = this.getModel();
            model.setValue(FIELD_BILL_SUBJECT, ret.get("number"));
            model.setValue(FIELD_BILL_SUBJECT_ID, ret.get("id"));
        }
    }

    private void getTaskSubject(String entryName, String entryNumber, IDataModel model) {
        Long billSubjectId;
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(ENTITY_BILLSUBJECT);
        if (StringUtils.isNotBlank((Object)model.getValue(FIELD_BILL_SUBJECT_ID)) && (billSubjectId = (Long)model.getValue(FIELD_BILL_SUBJECT_ID)) != 0L) {
            showParameter.setPkId((Object)billSubjectId);
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.setCustomParam("entryName", (Object)entryName);
        showParameter.setCustomParam("entryNumber", (Object)entryNumber);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_SAVE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getCurrentAppId() {
        String appId = this.getPageCache().get(CACHE_APP_ID);
        if (StringUtils.isEmpty((CharSequence)appId)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)APP_NUMBER);
            DynamicObject app = QueryServiceHelper.queryOne((String)BOS_DEV_PORTAL_BIZ_APP, (String)"id, name", (QFilter[])new QFilter[]{numberFilter});
            appId = app == null ? null : app.getString("id");
            this.getPageCache().put(CACHE_APP_ID, appId);
            String appName = app == null ? null : app.getString("name");
            this.getPageCache().put(CACHE_APP_NAME, appName);
        }
        return appId;
    }

    private String getCurrentAppName() {
        String appName = this.getPageCache().get(CACHE_APP_NAME);
        if (StringUtils.isEmpty((CharSequence)appName)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)APP_NUMBER);
            DynamicObject app = QueryServiceHelper.queryOne((String)BOS_DEV_PORTAL_BIZ_APP, (String)"id, name", (QFilter[])new QFilter[]{numberFilter});
            appName = app == null ? null : app.getString("name");
            this.getPageCache().put(CACHE_APP_NAME, appName);
            String appId = app == null ? null : app.getString("id");
            this.getPageCache().put(CACHE_APP_ID, appId);
        }
        return appName;
    }

    private String renderMenuTree(AppMetadata metadata) {
        String appId = metadata.getId();
        String appName = metadata.getName().getLocaleValue();
        TreeNode root = new TreeNode("", appId, appName);
        List<TreeNode> nodeList = this.getBillNodeList(metadata);
        root.addChildren(nodeList);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addNode(root);
        tree.showNode(appId);
        TreeNode firstL4Node = root;
        if (nodeList != null && nodeList.size() > 0) {
            firstL4Node = nodeList.get(0);
            tree.focusNode(nodeList.get(0));
        } else {
            tree.focusNode(root);
        }
        return firstL4Node.getId();
    }

    private List<TreeNode> getBillNodeList(AppMetadata appMeta) {
        String appId = appMeta.getId();
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> menuTreeNodeId = new ArrayList<String>(8);
        ArrayList<TreeNode> menuTreeNode = new ArrayList<TreeNode>(8);
        for (AppMenuElement menuElement : menuElements) {
            String menuNumber;
            String parentMenuId = menuElement.getParentId();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) || (menuNumber = menuElement.getNumber()) == null || !menuNumber.endsWith(CUSTOMIZED_MENU_FLAG) || CUSTOMIZED_MENU_FLAG.equalsIgnoreCase(menuNumber)) continue;
            String menuId = menuElement.getId();
            menuTreeNodeId.add(menuId);
            String menuName = (String)menuElement.getName().getDefaultItem();
            TreeNode treeNode = new TreeNode(appId, menuId, menuName);
            menuTreeNode.add(treeNode);
        }
        this.getPageCache().put(CACHE_CUST_NODEIDS, SerializationUtils.toJsonString(menuTreeNodeId));
        return menuTreeNode;
    }

    private List<TreeNode> getNodeList(AppMetadata appMeta) {
        String appId = appMeta.getId();
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> menuIds = new ArrayList<String>(32);
        for (Object menuElement : menuElements) {
            String menuId = menuElement.getId();
            menuIds.add(menuId);
        }
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = (String)menuElement.getName().getDefaultItem();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            TreeNode treeNode = new TreeNode(appId, menuId, menuName);
            firMenuList.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>(16);
        this.getMenuTreeNode(menuElements, firMenuList, nodeLevel);
        this.getPageCache().put(CACHE_NODE_LEVEL, SerializationUtils.toJsonString(nodeLevel));
        return firMenuList;
    }

    private void getMenuTreeNode(List<AppMenuElement> menuElements, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel) {
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = (String)menuElement.getName().getDefaultItem();
            for (TreeNode parentNode : parentMenuList) {
                String parentNodeId = parentNode.getId();
                if (!parentNodeId.equals(parentMenuId)) continue;
                TreeNode childNode = new TreeNode(parentMenuId, menuId, menuName, false);
                this.buildNode(parentNode, childNode);
                nodeLevel.put(menuId, 2);
            }
        }
    }

    private void showMenuListSub(String selectNodeId, AppMetadata appMeta) {
        Set<Map<String, Object>> selectedMenuInfos = this.getSelectedMenuInfos(selectNodeId, appMeta);
        boolean isChecked = (Boolean)this.getModel().getValue(FIELD_CHECKBOX);
        int appNum = 0;
        if (selectedMenuInfos.size() > 0) {
            ArrayList<String> billFormNumbers = new ArrayList<String>(8);
            ArrayList<String> billFormNames = new ArrayList<String>(8);
            List customizedNodeIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_CUST_NODEIDS), List.class);
            for (Map<String, Object> menuJsonObject : selectedMenuInfos) {
                String formName = (String)menuJsonObject.get("formName");
                String formNumber = (String)menuJsonObject.get("formNumber");
                String parentMenuId = (String)menuJsonObject.get("parentId");
                if ("".equals(formName) || billFormNumbers.contains(formNumber) || !customizedNodeIds.contains(parentMenuId)) continue;
                ++appNum;
                billFormNumbers.add(formNumber);
                billFormNames.add(formName);
            }
            this.getModel().deleteEntryData(MENU_ENTRY);
            if (appNum == 0) {
                return;
            }
            this.getModel().batchCreateNewEntryRow(MENU_ENTRY, appNum);
            DynamicObjectCollection billSubjectObjs = QueryServiceHelper.query((String)ENTITY_BILLSUBJECT, (String)"id,billname,billnumber,remark", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", (Object)billFormNumbers.toArray(new String[0]))});
            int i = 0;
            HashMap<String, String> billSubjectMap = new HashMap<String, String>(8);
            IDataModel model = this.getModel();
            for (DynamicObject billSubjectObj : billSubjectObjs) {
                String formBill = billSubjectObj.getString("billname");
                String formNumber = billSubjectObj.getString("billnumber");
                if (StringUtils.isNotBlank((CharSequence)formBill) && StringUtils.isNotBlank((CharSequence)formNumber)) {
                    billFormNames.remove(formBill);
                    billFormNumbers.remove(formNumber);
                }
                String billSubject = billSubjectObj.getString("remark");
                Long billSubjectId = billSubjectObj.getLong("id");
                model.setValue(FIELD_BIND_BILL, (Object)formBill, i);
                model.setValue(FIELD_BILL_NUMBER, (Object)formNumber, i);
                model.setValue(FIELD_BILL_SUBJECT, (Object)billSubject, i);
                model.setValue(FIELD_BILL_SUBJECT_ID, (Object)billSubjectId, i);
                billSubjectMap.put(formNumber, billSubject);
                ++i;
            }
            if (billFormNames.size() > 0) {
                for (int j = 0; j < billFormNames.size(); ++j) {
                    model.setValue(FIELD_BIND_BILL, billFormNames.get(j), i + j);
                    model.setValue(FIELD_BILL_NUMBER, billFormNumbers.get(j), i + j);
                }
            }
            this.getPageCache().put(MAP_BILL_SUBJECT, SerializationUtils.toJsonString(billSubjectMap));
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(MENU_ENTRY);
            entryGrid.setPageIndex(1);
        } else {
            this.getModel().deleteEntryData(MENU_ENTRY);
        }
    }

    private void showMenuList(String selectNodeId, AppMetadata appMeta) {
        Set<Map<String, Object>> selectedMenuInfos = this.getSelectedMenuInfos(selectNodeId, appMeta);
        boolean isChecked = (Boolean)this.getModel().getValue(FIELD_CHECKBOX);
        boolean hasHelpCenter = false;
        for (Map<String, Object> selectedMenuInfo : selectedMenuInfos) {
            String menuId = (String)selectedMenuInfo.get("id");
            if (!menuId.endsWith(HELP_CENTER_FLAG)) continue;
            hasHelpCenter = true;
        }
        int appNum = selectedMenuInfos.size();
        if (appNum > 0) {
            this.getModel().deleteEntryData(MENU_ENTRY);
            this.getModel().batchCreateNewEntryRow(MENU_ENTRY, selectedMenuInfos.size());
            Iterator<Map<String, Object>> menuInfo = selectedMenuInfos.iterator();
            int i = 0;
            while (menuInfo.hasNext()) {
                Map<String, Object> menuJsonObject = menuInfo.next();
                this.getModel().setValue(FIELD_BIND_BILL, menuJsonObject.get(FIELD_BIND_BILL), i);
                this.getModel().setValue(FIELD_BILL_SUBJECT, menuJsonObject.get(FIELD_BILL_SUBJECT), i);
                String openType = (String)menuJsonObject.get("openType");
                this.getModel().setValue(FIELD_MENU_ID, menuJsonObject.get("id"), i);
                this.getModel().setValue(FIELD_PARENT_MENU_ID, menuJsonObject.get("parentId"), i);
                this.getModel().setValue(FIELD_MENU_SEQ, menuJsonObject.get("menuSeq"), i);
                ++i;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(MENU_ENTRY);
            entryGrid.setPageIndex(1);
        } else {
            this.getModel().deleteEntryData(MENU_ENTRY);
        }
    }

    private Set<Map<String, Object>> getSelectedMenuInfos(String selectNodeId, AppMetadata appMeta) {
        String appId = this.getCurrentAppId();
        List menuElements = appMeta.getAppMenus();
        LinkedHashSet<Map<String, Object>> selectedMenuInfos = new LinkedHashSet<Map<String, Object>>();
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        ArrayList<String> menuIds = new ArrayList<String>(32);
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            menuIds.add(menuId);
        }
        boolean isChecked = (Boolean)this.getModel().getValue(FIELD_CHECKBOX);
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            String parentMenuId = menuElement.getParentId();
            HashMap<String, Object> menuInfo = new HashMap<String, Object>(8);
            String formId = menuElement.getFormId();
            String formName = this.getFormName(formId);
            String formNumber = this.getFormNumber(formId);
            menuInfo.put("formName", formName);
            menuInfo.put("formNumber", formNumber);
            menuInfo.put("menuName", menuElement.getName().getDefaultItem());
            menuInfo.put("parentId", parentMenuId);
            menuInfo.put("id", menuId);
            if (selectNodeId.equals(menuId)) {
                selectedMenuInfos.add(menuInfo);
                this.recursionMenuInfo(menuElements, selectedMenuInfos, menuId, isChecked);
                continue;
            }
            if (!selectNodeId.equals(appId) || !StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            selectedMenuInfos.add(menuInfo);
            this.recursionMenuInfo(menuElements, selectedMenuInfos, menuId, true);
        }
        return selectedMenuInfos;
    }

    private String getFormNumber(String formId) {
        String formNumber = "";
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            try {
                AbstractMetadata formMeta = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
                if (formMeta != null) {
                    FormMetadata fm = (FormMetadata)formMeta;
                    formNumber = fm.getKey();
                }
            }
            catch (Exception exception) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8868\u5355\u5143\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"AppMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                this.logger.error("kd.ssc.task.rbc.AppMenuTreePlugin.getFormName: \u6839\u636e\u8868\u5355Id [" + formId + "] \u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u51fa\u9519\uff01", (Throwable)exception);
            }
        }
        return formNumber;
    }

    private String getFormName(String formId) {
        String formName = "";
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            try {
                AbstractMetadata formMeta = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
                if (formMeta != null) {
                    FormMetadata fm = (FormMetadata)formMeta;
                    formName = fm.getName().getLocaleValue();
                }
            }
            catch (Exception exception) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8868\u5355\u5143\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"AppMenuTreePlugin_10", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                this.logger.error("kd.ssc.task.rbc.AppMenuTreePlugin.getFormName: \u6839\u636e\u8868\u5355Id [" + formId + "] \u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u51fa\u9519\uff01", (Throwable)exception);
            }
        }
        return formName;
    }

    private void recursionMenuInfo(List<AppMenuElement> menuElements, Set<Map<String, Object>> menuList, String filterMenuId, boolean isChecked) {
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            String parentMenuId = menuElement.getParentId();
            if (!filterMenuId.equals(parentMenuId)) continue;
            HashMap<String, Object> menuInfo = new HashMap<String, Object>(8);
            String formId = menuElement.getFormId();
            String formName = this.getFormName(formId);
            String formNumber = this.getFormNumber(formId);
            menuInfo.put("formName", formName);
            menuInfo.put("formNumber", formNumber);
            menuInfo.put("menuName", menuElement.getName().getDefaultItem());
            menuInfo.put("parentId", parentMenuId);
            menuInfo.put("id", menuId);
            menuList.add(menuInfo);
            if (!isChecked) continue;
            this.recursionMenuInfo(menuElements, menuList, menuId, true);
        }
    }

    private void buildNode(TreeNode parentNode, TreeNode childNode) {
        int seq = 0;
        if (parentNode.getChildren() != null) {
            seq = parentNode.getChildren().size();
        }
        parentNode.addChild(seq, childNode);
    }

    private void moveEntryUp(BeforeDoOperationEventArgs e, int index, String appId, AppMetadata appMeta) {
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        DynamicObject menuInfo = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
        Integer currentSeq = menuInfo.getInt(FIELD_MENU_SEQ);
        String currentMenuId = menuInfo.getString(FIELD_MENU_ID);
        String currentParentMenuId = menuInfo.getString(FIELD_PARENT_MENU_ID);
        if (index <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u662f\u7b2c\u4e00\u884c\u3002", (String)"AppMenuTreePlugin_11", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            e.setCancel(true);
        } else {
            DynamicObject beforeRow = this.getModel().getEntryRowEntity(MENU_ENTRY, index - 1);
            Integer beforeMenuSeq = beforeRow.getInt(FIELD_MENU_SEQ);
            String beforeMenuId = beforeRow.getString(FIELD_MENU_ID);
            String beforeParentMenuId = beforeRow.getString(FIELD_PARENT_MENU_ID);
            if (currentParentMenuId.equals(beforeMenuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u4e0a\u79fb\u3002", (String)"AppMenuTreePlugin_12", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if ((StringUtils.isBlank((CharSequence)currentParentMenuId) || appIds.contains((Object)currentParentMenuId)) && StringUtils.isNotBlank((CharSequence)beforeParentMenuId) && !appIds.contains((Object)beforeParentMenuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u4e0a\u79fb\u3002", (String)"AppMenuTreePlugin_12", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (beforeMenuSeq.equals(currentSeq)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u4e0e\u4e0a\u4e00\u884c\u83dc\u5355\u5e8f\u53f7\u4e00\u81f4\uff0c\u8bf7\u5728\u83dc\u5355\u4e2d\u8c03\u6574\u5e8f\u53f7\u3002", (String)"AppMenuTreePlugin_13", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            for (int i = 0; i < appMeta.getAppMenus().size(); ++i) {
                AppMenuElement menu = (AppMenuElement)appMeta.getAppMenus().get(i);
                String menuId = menu.getId();
                if (menuId.equals(currentMenuId)) {
                    menu.setSeq(beforeMenuSeq.shortValue());
                    continue;
                }
                if (!menuId.equals(beforeMenuId)) continue;
                menu.setSeq(currentSeq.shortValue());
            }
            e.setCancel(true);
            AppMetaServiceHelper.save((AppMetadata)appMeta);
        }
    }

    private void moveEntryDown(BeforeDoOperationEventArgs e, int index, String appId, AppMetadata appMeta) {
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        DynamicObject menuInfo = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
        Integer currentSeq = menuInfo.getInt(FIELD_MENU_SEQ);
        String currentMenuId = menuInfo.getString(FIELD_MENU_ID);
        String currentParentMenuId = menuInfo.getString(FIELD_PARENT_MENU_ID);
        DynamicObject nextRow = this.getModel().getEntryRowEntity(MENU_ENTRY, index + 1);
        if (nextRow == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"AppMenuTreePlugin_14", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            e.setCancel(true);
        } else {
            Integer nextMenuSeq = nextRow.getInt(FIELD_MENU_SEQ);
            String nextMenuId = nextRow.getString(FIELD_MENU_ID);
            String nextParentMenuId = nextRow.getString(FIELD_PARENT_MENU_ID);
            if (currentMenuId.equals(nextParentMenuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u79fb\u52a8\u3002", (String)"AppMenuTreePlugin_15", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)currentParentMenuId) && !appIds.contains((Object)currentParentMenuId) && (StringUtils.isBlank((CharSequence)nextParentMenuId) || appIds.contains((Object)nextParentMenuId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u79fb\u52a8\u3002", (String)"AppMenuTreePlugin_15", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (nextMenuSeq.equals(currentSeq)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u4e0e\u4e0b\u4e00\u884c\u83dc\u5355\u5e8f\u53f7\u4e00\u81f4\uff0c\u8bf7\u5728\u83dc\u5355\u4e2d\u8c03\u6574\u5e8f\u53f7\u3002", (String)"AppMenuTreePlugin_16", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            for (int i = 0; i < appMeta.getAppMenus().size(); ++i) {
                AppMenuElement menu = (AppMenuElement)appMeta.getAppMenus().get(i);
                String menuId = menu.getId();
                if (menuId.equals(currentMenuId)) {
                    menu.setSeq(nextMenuSeq.shortValue());
                    continue;
                }
                if (!menuId.equals(nextMenuId)) continue;
                menu.setSeq(currentSeq.shortValue());
            }
            e.setCancel(true);
            AppMetaServiceHelper.save((AppMetadata)appMeta);
        }
    }
}

