/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin.exception;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.dhc.util.RecordExceptionUtil;

public class ExceptionRecordListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ExceptionRecordListPlugin.class);
    private static final String OP_RERUN = "rerun";
    private static final String OP_VIEW_STACK = "viewstack";
    private static final String OP_VIEW_PARAM = "viewparam";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null) {
            String key = args.getOperateKey();
            if (OP_RERUN.equals(key)) {
                BillList list = (BillList)this.getControl("billlistap");
                list.clearSelection();
                list.refresh();
            } else if (OP_VIEW_STACK.equals(key)) {
                this.viewField("excreason_tag", ResManager.loadKDString((String)"\u5f02\u5e38\u5806\u6808", (String)"ExceptionRecordListPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            } else if (OP_VIEW_PARAM.equals(key)) {
                this.viewField("excargument_tag", ResManager.loadKDString((String)"\u5f02\u5e38\u53c2\u6570", (String)"ExceptionRecordListPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billnumber")) {
            ListSelectedRow selectedRow = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
            long selectId = (Long)selectedRow.getPrimaryKeyValue();
            this.showBillForm(selectId);
        }
    }

    private void viewField(String fieldName, String tip) {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() <= 0) {
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ExceptionRecordListPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        Object id = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject excRecord = BusinessDataServiceHelper.loadSingle((Object)id, (String)"dhc_exceptionrecord", (String)fieldName);
        RecordExceptionUtil.openShowDetailDialog((IFormView)this.getView(), (String)tip, (String)excRecord.getString(fieldName));
    }

    private void showBillForm(Long selectDataId) {
        if (selectDataId == 0L) {
            return;
        }
        DynamicObject excRecord = BusinessDataServiceHelper.loadSingle((Object)selectDataId, (String)"dhc_exceptionrecord", (String)"billid,billtype.number");
        if (excRecord == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"ExceptionRecordListPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = excRecord.getString("billtype.number");
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(formId);
            parameter.setPkId((Object)excRecord.getString("billid"));
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

