/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin.inquirybill;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.lang.Lang;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.dhc.util.BaseDataHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class InquiryBillEditPlugin
extends AbstractBillPlugIn {
    private static final String DHC_KNOWLEDGE_ADD_BILL = "dhc_knowledge_add";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.initBaseInfo("newData");
    }

    public void afterCopyData(EventObject e) {
        this.initBaseInfo("newData");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBaseInfo("bindData");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        evt.getOperationKey();
        switch (itemKey) {
            case "addknowledge": {
                this.onAddKnowledgeClick(evt);
                break;
            }
            case "viewknowledge": {
                this.onViewKnowledgeClick(evt);
                break;
            }
        }
    }

    private void onAddKnowledgeClick(BeforeItemClickEvent evt) {
        IDataModel dataModel = this.getModel();
        String questionDesc = (String)dataModel.getValue("questiondesc");
        if (StringUtils.isBlank((CharSequence)questionDesc)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u95ee\u9898\u63cf\u8ff0\u3002", (String)"InquiryBillEditPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String questionReply = (String)dataModel.getValue("questionreply");
        if (StringUtils.isBlank((CharSequence)questionReply)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u95ee\u9898\u56de\u590d\u3002", (String)"InquiryBillEditPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        this.showKnowledgeAddBill("addknowledge");
    }

    private void onViewKnowledgeClick(BeforeItemClickEvent evt) {
        this.showKnowledgeAddBill("viewknowledge");
    }

    private void showKnowledgeAddBill(String srcOperation) {
        BillShowParameter billShowParameter = new BillShowParameter();
        this.initKnowledgeAddBillShowParameter(billShowParameter, srcOperation);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void initKnowledgeAddBillShowParameter(BillShowParameter billShowParameter, String srcOperation) {
        IDataModel dataModel;
        Long inquiryBillId;
        Object[] knowledgeAddObjs;
        billShowParameter.setFormId(DHC_KNOWLEDGE_ADD_BILL);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("viewknowledge".equals(srcOperation)) {
            billShowParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u77e5\u8bc6\u95ee\u7b54", (String)"InquiryBillEditPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
        if (!ArrayUtils.isEmpty((Object[])(knowledgeAddObjs = InquiryBillEditPlugin.queryKnowledgeAddByInquiryBillId(inquiryBillId = (Long)(dataModel = this.getModel()).getValue("id"))))) {
            Long targetPkId = knowledgeAddObjs[0].getLong("id");
            billShowParameter.setPkId((Object)targetPkId);
        }
        String questionDesc = (String)dataModel.getValue("questiondesc");
        String questionReply = (String)dataModel.getValue("questionreply");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("inquiryBillId", inquiryBillId);
        customParams.put("questionDesc", questionDesc);
        customParams.put("questionReply", questionReply);
        customParams.put("operation", srcOperation);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
        customParams.put("sscId", sscId);
        this.getPageCache().put("sscId", sscId);
        billShowParameter.setCustomParams(customParams);
    }

    public static DynamicObject[] queryKnowledgeAddByInquiryBillId(Long inquiryBillId) {
        return BusinessDataServiceHelper.load((String)DHC_KNOWLEDGE_ADD_BILL, (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter[]{new QFilter("inquirybillid", "=", (Object)inquiryBillId)});
    }

    private void initBaseInfo(String caller) {
        IDataModel model = this.getModel();
        BillView view = (BillView)this.getView();
        OperationStatus status = view.getStatus();
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        Long creatorId = (Long)creator.getPkValue();
        DynamicObject creator_ = BusinessDataServiceHelper.loadSingleFromCache((Object)creatorId, (String)"bos_user");
        Image applierPic = (Image)this.getControl("applierpic");
        applierPic.setUrl(BaseDataHelper.getUserImage((Long)creatorId));
        Label applierv = (Label)this.getControl("applierv");
        applierv.setText(creator_.getString("name"));
        Label telv = (Label)this.getControl("telv");
        Object val = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)((IDataEntityProperty)creator_.getDataEntityType().getProperties().get((Object)"phone")), (String)Lang.get().toString(), (String)"FORM", (DynamicObject)creator_, (Object)creator_.getString("phone"));
        telv.setText(String.valueOf(val));
        Long deptId = UserServiceHelper.getUserMainOrgId((long)creatorId);
        if (deptId <= 0L) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u63d0\u5355\u4eba\u9700\u8981\u4e3b\u804c\u4f4d\u624d\u80fd\u63d0\u5355\uff0c\u8bf7\u5230\u201c\u7cfb\u7edf\u670d\u52a1\u4e91>\u57fa\u7840\u670d\u52a1>\u4eba\u5458\u201d\u5904\u8bbe\u7f6e\u3002", (String)"InquiryBillEditPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            this.processError((IFormView)view);
            return;
        }
        if ("ADDNEW".equals(status.name()) && "newData".equals(caller)) {
            model.setValue("dept", (Object)deptId);
            model.setValue("applierpositionv", (Object)UserServiceHelper.getUserMainJob((long)creatorId));
        }
        if ("ADDNEW".equals(status.name()) && "newData".equals(caller)) {
            Map companyInfo = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            model.setValue("company", companyInfo.get("id"));
        }
    }

    private void processError(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"tbmain"});
        view.setVisible(Boolean.TRUE, new String[]{"tbmain1"});
        view.setEnable(Boolean.FALSE, new String[]{"contentpanel"});
    }
}

