/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin.inquirybill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.mircoservice.result.ServiceResult;

public class KnowledgeAddEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final Log log = LogFactory.getLog(KnowledgeAddEditPlugin.class);
    private static final String PARAM_INQUIRYBILL_INQUIRYBILLID = "inquiryBillId";
    private static final String PARAM_INQUIRYBILL_QUESTIONDESC = "questionDesc";
    private static final String PARAM_INQUIRYBILL_QUESTIONREPLY = "questionReply";
    private static final String PARAM_INQUIRYBILL_OPERATION = "operation";
    private static final String FORM_SOM_KNOWLEDGE_INFO = "som_knowledge_info";
    private static final String CACHEKEY_CLICKROW_AREA = "clickRow_area";
    private static final String CACHEKEY_CLICKROW_SUBJECT = "clickRow_subject";
    private static final String CACHEKEY_CLICKROW_KNOWLEDGE = "clickRow_knowledge";
    private static final String CACHEKEY_CLICKROW_INDEX = "clickRow_index";
    private static final String KNOWLEDGE_INFO_CLOSECALLBACK_ACTIONID = "knowledge_info_closeCallback";
    private static final String KNOWLEDGE_SUBJECT_QUICKADD_CLOSECALLBACK_ACTIONID = "knowledge_subject_quickadd_closeCallback";
    private static final String KNOWLEDGEENTRY_DELETE_ACTIONID = "knowledgeEntry_delete_actionId";
    private static final String KNOWLEDGEENTRY_AREA_ACTIONID = "knowledgeEntry_area_actionId";
    private static final String CACHEKEY_KNOWLEDGE_DELETE_ROWS = "knowledge_delete_rows";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("knowledgeentry");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object source = pkEvent.getSource();
            if (source instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)source).getKey())) {
                String inquiryBillOperation = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_INQUIRYBILL_OPERATION);
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String operationkey = operationColItem.getOperationKey();
                    if ("addknowledge".equalsIgnoreCase(inquiryBillOperation)) {
                        if (!"viewKnowledge".equalsIgnoreCase(operationkey)) continue;
                        operationColItem.setVisible(false);
                        operationColItem.setLocked(true);
                        continue;
                    }
                    if (!"viewknowledge".equalsIgnoreCase(inquiryBillOperation) || !"editknowledge".equalsIgnoreCase(operationkey)) continue;
                    operationColItem.setVisible(false);
                    operationColItem.setLocked(true);
                }
            }
        });
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("knowledgeentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit areaEdit = (BasedataEdit)this.getView().getControl("area");
        areaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        areaEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        BasedataEdit subjectEdit = (BasedataEdit)this.getView().getControl("subject");
        subjectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        subjectEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        IPageCache pageCache = this.getPageCache();
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
        pageCache.put("sscId", sscId);
        String name = e.getProperty().getName();
        if ("area".equals(name)) {
            listShowParameter.setMultiSelect(false);
            listShowParameter.setCustomParam("sscId", (Object)sscId);
            if (null != sscId) {
                QFilter qFilter = new QFilter("usessc.fbasedataid.id", "=", (Object)Long.parseLong(sscId));
                listShowParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("subject".equals(name)) {
            String areaId = pageCache.get(CACHEKEY_CLICKROW_AREA);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)areaId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u77e5\u8bc6\u9886\u57df\u3002", (String)"KnowledgeAddEditPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("area", "=", (Object)Long.parseLong(areaId));
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u77e5\u8bc6\u7c7b\u76ee", (String)"KnowledgeAddEditPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long inquiryBillId = Long.valueOf(customParams.get(PARAM_INQUIRYBILL_INQUIRYBILLID).toString());
        String questionDesc = (String)customParams.get(PARAM_INQUIRYBILL_QUESTIONDESC);
        String questionReply = (String)customParams.get(PARAM_INQUIRYBILL_QUESTIONREPLY);
        String srcOperation = (String)customParams.get(PARAM_INQUIRYBILL_OPERATION);
        IPageCache pageCache = this.getPageCache();
        pageCache.put(PARAM_INQUIRYBILL_INQUIRYBILLID, inquiryBillId.toString());
        pageCache.put(PARAM_INQUIRYBILL_QUESTIONDESC, questionDesc);
        pageCache.put(PARAM_INQUIRYBILL_QUESTIONREPLY, questionReply);
        pageCache.put(PARAM_INQUIRYBILL_OPERATION, srcOperation);
        Long billInquiryBillId = (Long)dataModel.getValue("inquirybillid");
        if (KnowledgeAddEditPlugin.isNullOrZero(billInquiryBillId) && "addknowledge".equalsIgnoreCase(srcOperation)) {
            dataModel.setValue("inquirybillid", (Object)inquiryBillId);
        }
        if ("viewknowledge".equalsIgnoreCase(srcOperation)) {
            IFormView formView = this.getView();
            formView.setVisible(Boolean.FALSE, new String[]{"tb_new", "tb_del"});
            formView.setEnable(Boolean.FALSE, new String[]{"knowledgeentry"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate formOp = (FormOperate)source;
            String operateKey = formOp.getOperateKey();
            IPageCache pageCache = this.getPageCache();
            String areaId = pageCache.get(CACHEKEY_CLICKROW_AREA);
            String subjectId = pageCache.get(CACHEKEY_CLICKROW_SUBJECT);
            if ("editknowledge".equalsIgnoreCase(operateKey)) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)areaId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u77e5\u8bc6\u9886\u57df\u3002", (String)"KnowledgeAddEditPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)subjectId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u77e5\u8bc6\u7c7b\u76ee\u3002", (String)"KnowledgeAddEditPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showKnowledgeInfoBill("editknowledge");
            } else if ("viewKnowledge".equalsIgnoreCase(operateKey)) {
                this.showKnowledgeInfoBill("viewKnowledge");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "area": {
                this.onAreaChanged(e);
                break;
            }
        }
    }

    private void onAreaChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getPageCache();
        String curRowAreaId = pageCache.get(CACHEKEY_CLICKROW_AREA);
        String curRowIndex = pageCache.get(CACHEKEY_CLICKROW_INDEX);
        String curRowSubjectId = pageCache.get(CACHEKEY_CLICKROW_SUBJECT);
        ChangeData[] changeDataArray = e.getChangeSet();
        DynamicObject newArea = (DynamicObject)changeDataArray[0].getNewValue();
        if (newArea == null) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)curRowSubjectId)) {
                this.getModel().setValue("subject", null, Integer.parseInt(curRowIndex));
            }
        } else {
            Long areaId = newArea.getLong("id");
            if (KnowledgeAddEditPlugin.isNotNullOrZero(areaId)) {
                this.getModel().setValue("area", (Object)areaId, Integer.parseInt(curRowIndex));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)curRowSubjectId) && (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)curRowAreaId) || !curRowAreaId.equals(areaId.toString()))) {
                this.getModel().setValue("subject", null, Integer.parseInt(curRowIndex));
            }
        }
    }

    private void showKnowledgeInfoBill(String operateKey) {
        DynamicObject dbKnowledgeInfo;
        String knowledgeId = this.getPageCache().get(CACHEKEY_CLICKROW_KNOWLEDGE);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)knowledgeId) && (dbKnowledgeInfo = BusinessDataServiceHelper.loadSingle((Object)knowledgeId, (String)FORM_SOM_KNOWLEDGE_INFO, (String)"id,name")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u95ee\u7b54\u4e0d\u5b58\u5728\u6216\u8005\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KnowledgeAddEditPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        this.initKnowledgeInfoShowParameter(billShowParameter, operateKey);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject clickRow;
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int row = evt.getRow();
        if (StringUtils.equals((CharSequence)"knowledgeentry", (CharSequence)entryGrid.getKey()) && (clickRow = entryGrid.getModel().getEntryRowEntity("knowledgeentry", row)) != null) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put(CACHEKEY_CLICKROW_AREA, clickRow.getString("area.id"));
            pageCache.put(CACHEKEY_CLICKROW_SUBJECT, clickRow.getString("subject.id"));
            pageCache.put(CACHEKEY_CLICKROW_KNOWLEDGE, KnowledgeAddEditPlugin.isNullOrZero(clickRow.getLong("knowledge")) ? "" : clickRow.getString("knowledge"));
            pageCache.put(CACHEKEY_CLICKROW_INDEX, row + "");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"knowledgeentry", (CharSequence)e.getEntryProp().getName())) {
            IDataModel dataModel = this.getModel();
            int[] deleteRows = e.getRowIndexs();
            ArrayList<Integer> deleteIndexes = new ArrayList<Integer>(deleteRows.length);
            for (int i = 0; i < deleteRows.length; ++i) {
                deleteIndexes.add(deleteRows[i]);
            }
            int notNullRows = 0;
            for (int i = 0; i < deleteRows.length; ++i) {
                DynamicObject subject;
                int rowIndex = deleteRows[i];
                DynamicObject deleteRow = dataModel.getEntryRowEntity("knowledgeentry", rowIndex);
                if (deleteRow == null) continue;
                Long knowledgeId = 0L;
                Long areaId = 0L;
                Long subjectId = 0L;
                knowledgeId = deleteRow.getLong("knowledge");
                DynamicObject area = (DynamicObject)deleteRow.get("area");
                if (area != null) {
                    areaId = area.getLong("id");
                }
                if ((subject = (DynamicObject)deleteRow.get("subject")) != null) {
                    subjectId = subject.getLong("id");
                }
                if (knowledgeId.equals(0L) && areaId.equals(0L) && subjectId.equals(0L)) continue;
                ++notNullRows;
            }
            if (notNullRows > 0) {
                this.getPageCache().put(CACHEKEY_KNOWLEDGE_DELETE_ROWS, SerializationUtils.toJsonString(deleteIndexes));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KNOWLEDGEENTRY_DELETE_ACTIONID, (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u975e\u7a7a\u767d\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"KnowledgeAddEditPlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]), notNullRows), MessageBoxOptions.YesNo, confirmCallBackListener);
                e.setCancel(true);
                return;
            }
        }
    }

    private void initKnowledgeInfoShowParameter(BillShowParameter billShowParameter, String operateKey) {
        billShowParameter.setFormId(FORM_SOM_KNOWLEDGE_INFO);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IPageCache pageCache = this.getPageCache();
        String areaId = pageCache.get(CACHEKEY_CLICKROW_AREA);
        String subjectId = pageCache.get(CACHEKEY_CLICKROW_SUBJECT);
        String knowledgeId = pageCache.get(CACHEKEY_CLICKROW_KNOWLEDGE);
        String questionDesc = pageCache.get(PARAM_INQUIRYBILL_QUESTIONDESC);
        String questionReply = pageCache.get(PARAM_INQUIRYBILL_QUESTIONREPLY);
        String rowIndex = pageCache.get(CACHEKEY_CLICKROW_INDEX);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("areaId", Long.parseLong(areaId));
        customParams.put("subjectId", Long.parseLong(subjectId));
        customParams.put(PARAM_INQUIRYBILL_QUESTIONDESC, questionDesc);
        customParams.put(PARAM_INQUIRYBILL_QUESTIONREPLY, questionReply);
        customParams.put("rowIndex", rowIndex);
        customParams.put("srcWindow", "dhc_knowledge_add");
        if ("editknowledge".equalsIgnoreCase(operateKey)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)knowledgeId)) {
                customParams.put(PARAM_INQUIRYBILL_OPERATION, "addNew");
                billShowParameter.setStatus(OperationStatus.ADDNEW);
            } else {
                customParams.put(PARAM_INQUIRYBILL_OPERATION, "edit");
                billShowParameter.setPkId((Object)knowledgeId);
                billShowParameter.setStatus(OperationStatus.EDIT);
            }
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KNOWLEDGE_INFO_CLOSECALLBACK_ACTIONID));
        } else if ("viewKnowledge".equalsIgnoreCase(operateKey)) {
            customParams.put(PARAM_INQUIRYBILL_OPERATION, "view");
            billShowParameter.setPkId((Object)knowledgeId);
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        billShowParameter.setCustomParams(customParams);
        billShowParameter.addCustPlugin("kd.ssc.task.formplugin.smartcs.InquiryBillAddKnowledgeInfoEditPlugin");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnDatas;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(KNOWLEDGE_INFO_CLOSECALLBACK_ACTIONID)) {
            Map returnDatas2 = (Map)closedCallBackEvent.getReturnData();
            if (returnDatas2 != null) {
                Long knowledgeInfoId = (Long)returnDatas2.get("pkId");
                int rowIndex = Integer.parseInt(returnDatas2.get("rowIndex").toString());
                Long areaId = (Long)returnDatas2.get("areaId");
                Long subjectId = (Long)returnDatas2.get("subjectId");
                String number = returnDatas2.get("number").toString();
                String question = returnDatas2.get("question").toString();
                if (KnowledgeAddEditPlugin.isNotNullOrZero(knowledgeInfoId)) {
                    DynamicObject curRowSubject;
                    IDataModel dataModel = this.getModel();
                    boolean isNeedSave = false;
                    Long curRowAreaId = 0L;
                    Long curRowSubjectId = 0L;
                    Long curRowKnowledgeInfoId = 0L;
                    String curNumber = "";
                    String curQuestion = "";
                    DynamicObject curRowArea = (DynamicObject)dataModel.getValue("area", rowIndex);
                    if (curRowArea != null) {
                        curRowAreaId = curRowArea.getLong("id");
                    }
                    if ((curRowSubject = (DynamicObject)dataModel.getValue("subject", rowIndex)) != null) {
                        curRowSubjectId = curRowSubject.getLong("id");
                    }
                    curRowKnowledgeInfoId = (Long)dataModel.getValue("knowledge", rowIndex);
                    curNumber = (String)dataModel.getValue("knowledgenum", rowIndex);
                    curQuestion = (String)dataModel.getValue("knowledgename", rowIndex);
                    if (KnowledgeAddEditPlugin.isNullOrZero(curRowKnowledgeInfoId)) {
                        this.getModel().setValue("knowledge", (Object)knowledgeInfoId, rowIndex);
                        isNeedSave = true;
                    }
                    if (KnowledgeAddEditPlugin.isNullOrZero(curRowAreaId) || !curRowAreaId.equals(areaId)) {
                        this.getModel().setValue("area", (Object)areaId, rowIndex);
                        isNeedSave = true;
                    }
                    if (KnowledgeAddEditPlugin.isNullOrZero(curRowSubjectId) || !curRowSubjectId.equals(subjectId)) {
                        this.getModel().setValue("subject", (Object)subjectId, rowIndex);
                        isNeedSave = true;
                    }
                    if (StringUtils.isBlank((CharSequence)curNumber) || !curNumber.equals(number)) {
                        this.getModel().setValue("knowledgenum", (Object)number, rowIndex);
                        isNeedSave = true;
                    }
                    if (StringUtils.isBlank((CharSequence)curQuestion) || !curQuestion.equals(question)) {
                        this.getModel().setValue("knowledgename", (Object)question, rowIndex);
                        isNeedSave = true;
                    }
                    if (isNeedSave) {
                        this.getView().invokeOperation("save");
                        this.getView().updateView("knowledgeentry");
                    }
                }
            }
        } else if (actionId.equals(KNOWLEDGE_SUBJECT_QUICKADD_CLOSECALLBACK_ACTIONID) && (returnDatas = (Map)closedCallBackEvent.getReturnData()) != null) {
            Object knowledgeSubjectId = returnDatas.get("pkId");
            Object rowIndex = returnDatas.get("rowIndex");
            if (knowledgeSubjectId != null) {
                IDataModel dataModel = this.getModel();
                int row = Integer.parseInt(rowIndex + "");
                dataModel.setValue("subject", knowledgeSubjectId, row);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String srcOperation = this.getPageCache().get(PARAM_INQUIRYBILL_OPERATION);
        if ("addknowledge".equalsIgnoreCase(srcOperation)) {
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection knowledgeClcts = dataModel.getEntryEntity("knowledgeentry");
            ArrayList<Integer> deleteIndexes = new ArrayList<Integer>(knowledgeClcts.size());
            for (int i = 0; i < knowledgeClcts.size(); ++i) {
                DynamicObject subject;
                DynamicObject knowledge = (DynamicObject)knowledgeClcts.get(i);
                Long knowledgeId = knowledge.getLong("knowledge");
                if (KnowledgeAddEditPlugin.isNullOrZero(knowledgeId)) {
                    deleteIndexes.add(i);
                    continue;
                }
                DynamicObject dbKnowledgeInfo = null;
                try {
                    dbKnowledgeInfo = BusinessDataServiceHelper.loadSingle((Object)knowledgeId, (String)FORM_SOM_KNOWLEDGE_INFO, (String)"area, group");
                }
                catch (Exception ex) {
                    log.error("beforeClosed som_knowledge_info loadSingle occur error, knowledgeId:" + knowledgeId);
                    log.error("beforeClosed som_knowledge_info loadSingle occur error, exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                    continue;
                }
                Long areaId = 0L;
                Long subjectId = 0L;
                DynamicObject area = (DynamicObject)knowledge.get("area");
                if (area != null) {
                    areaId = area.getLong("id");
                }
                if ((subject = (DynamicObject)knowledge.get("subject")) != null) {
                    subjectId = subject.getLong("id");
                }
                this.getPageCache().put(CACHEKEY_CLICKROW_INDEX, i + "");
                this.getPageCache().put(CACHEKEY_CLICKROW_AREA, areaId.toString());
                this.getPageCache().put(CACHEKEY_CLICKROW_SUBJECT, subjectId.toString());
                Long dbAreaId = dbKnowledgeInfo.getLong("area.id");
                Long dbSubjectId = dbKnowledgeInfo.getLong("group.id");
                if (!areaId.equals(dbAreaId)) {
                    dataModel.setValue("area", (Object)dbAreaId, i);
                }
                if (subjectId.equals(dbSubjectId)) continue;
                dataModel.setValue("subject", (Object)dbSubjectId, i);
            }
            dataModel.beginInit();
            int[] deleteIndexesArray = new int[deleteIndexes.size()];
            for (int i = 0; i < deleteIndexes.size(); ++i) {
                deleteIndexesArray[i] = (Integer)deleteIndexes.get(i);
            }
            dataModel.deleteEntryRows("knowledgeentry", deleteIndexesArray);
            dataModel.endInit();
            this.getView().invokeOperation("save");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)messageBoxClosedEvent.getCallBackId(), (CharSequence)KNOWLEDGEENTRY_DELETE_ACTIONID) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            List<Integer> deleteIndexes = this.getKnowledgeDeleteRowsFromCache();
            IDataModel dataModel = this.getModel();
            int[] deleteIndexesArray = new int[deleteIndexes.size()];
            dataModel.beginInit();
            for (int i = 0; i < deleteIndexes.size(); ++i) {
                ServiceResult<Void> serviceResult;
                Long knowledgeId;
                deleteIndexesArray[i] = deleteIndexes.get(i);
                DynamicObject deleteRow = dataModel.getEntryRowEntity("knowledgeentry", deleteIndexes.get(i).intValue());
                if (deleteRow == null || !KnowledgeAddEditPlugin.isNotNullOrZero(knowledgeId = Long.valueOf(deleteRow.getLong("knowledge"))) || (serviceResult = this.invokeKnowledgeDeleteService(knowledgeId)).getSuccess().booleanValue()) continue;
                this.getView().showErrorNotification(serviceResult.getMessage());
                return;
            }
            dataModel.deleteEntryRows("knowledgeentry", deleteIndexesArray);
            this.getModel().endInit();
            this.getView().invokeOperation("save");
            this.getView().updateView("knowledgeentry");
        }
    }

    private ServiceResult<Void> invokeKnowledgeDeleteService(Long knowledgeId) {
        String jsonResult = (String)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"KnowledgeService", (String)"deleteById", (Object[])new Object[]{knowledgeId});
        return (ServiceResult)JSON.parseObject((String)jsonResult, ServiceResult.class);
    }

    private List<Integer> getKnowledgeDeleteRowsFromCache() {
        String deleteIndexes = this.getPageCache().get(CACHEKEY_KNOWLEDGE_DELETE_ROWS);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)deleteIndexes)) {
            return new ArrayList<Integer>();
        }
        return (List)SerializationUtils.fromJsonString((String)deleteIndexes, List.class);
    }

    public static boolean isNullOrZero(Long longValue) {
        return longValue == null || longValue == 0L;
    }

    public static boolean isNotNullOrZero(Long longValue) {
        return !KnowledgeAddEditPlugin.isNullOrZero(longValue);
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent beforeQuickAddNewEvent) {
        Object source = beforeQuickAddNewEvent.getSource();
        BasedataEdit basedataEdit = (BasedataEdit)source;
        FormShowParameter formShowParameter = beforeQuickAddNewEvent.getShowParameter();
        String key = basedataEdit.getKey();
        if ("area".equals(key)) {
            this.showAddAreaForm(formShowParameter);
        } else if ("subject".equals(key)) {
            beforeQuickAddNewEvent.setCancel(true);
            this.showAddSubjectForm();
        }
    }

    private void showAddAreaForm(FormShowParameter formShowParameter) {
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57df", (String)"KnowledgeAddEditPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    private void showAddSubjectForm() {
        String areaId = this.getPageCache().get(CACHEKEY_CLICKROW_AREA);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)areaId)) {
            return;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(FORM_SOM_KNOWLEDGE_INFO);
        formShowParameter.setCustomParam("operate", (Object)"addnew");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u77e5\u8bc6\u7c7b\u76ee", (String)"KnowledgeAddEditPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("areaId", (Object)areaId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KNOWLEDGE_SUBJECT_QUICKADD_CLOSECALLBACK_ACTIONID));
        formShowParameter.addCustPlugin("kd.ssc.task.formplugin.smartcs.InquiryBillAddKnowledgeSubjectEditPlugin");
        StyleCss css = this.getStyleCss();
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private StyleCss getStyleCss() {
        StyleCss css = new StyleCss();
        css.setWidth("320px");
        css.setHeight("195px");
        return css;
    }
}

