/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.runnable;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.dto.BillDataInitMessage;
import kd.fi.dhc.factory.PublisherFactory;
import kd.fi.dhc.service.InitDataExceptionService;
import kd.fi.dhc.util.DataInitStatusUtil;
import kd.fi.dhc.util.DataSynchronizationUtil;
import kd.fi.hdc.cache.DhcDistributeCache;
import org.apache.commons.lang3.time.DateUtils;

public class MessagePublisher4Init
implements Runnable {
    private static Log log = LogFactory.getLog(MessagePublisher4Init.class);

    @Override
    public void run() {
        List<Map<String, Object>> billDataList = this.getBillDataFromCache();
        MessagePublisher dataInitPublisher = PublisherFactory.getBillDataInitPub();
        for (Map<String, Object> billData : billDataList) {
            Date finishTime;
            Date startTime;
            String billMetaNumber = (String)billData.get("cache_bill_meta_number");
            try {
                String pattern = "yyyy-MM-dd HH:mm:ss";
                String startTimeStr = (String)billData.get("cache_start_time");
                startTime = DateUtils.parseDate((String)startTimeStr, (String[])new String[]{pattern});
                String finishTimeStr = (String)billData.get("cache_finish_time");
                finishTime = DateUtils.parseDate((String)finishTimeStr, (String[])new String[]{pattern});
            }
            catch (ParseException e) {
                log.error("\u62a5\u8d26\u6570\u636e\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38\uff0c\u683c\u5f0f\u5316\u8d77\u6b62\u65f6\u95f4\u51fa\u9519\uff01", (Throwable)e);
                continue;
            }
            Date initDate = startTime;
            try {
                while (DateUtils.truncatedCompareTo((Date)initDate, (Date)finishTime, (int)5) <= 0) {
                    BillDataInitMessage msg = new BillDataInitMessage(billMetaNumber, initDate);
                    dataInitPublisher.publish((Object)msg);
                    initDate = DateUtils.addDays((Date)initDate, (int)1);
                    Thread.sleep(300L);
                }
            }
            catch (InterruptedException e) {
                String billId = DataSynchronizationUtil.getBillIdByBillMetaNumber((String)billMetaNumber);
                DynamicObject dym = DataInitStatusUtil.setStatusAsExFail((String)billId);
                SaveServiceHelper.update((DynamicObject)dym);
                this.recordErrorException(billMetaNumber, initDate, e);
                log.error("\u62a5\u8d26\u6570\u636e\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38\uff0c\u6d88\u606f\u53d1\u9001\u961f\u5217\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        this.clearCache();
    }

    private List<Map<String, Object>> getBillDataFromCache() {
        String billDataJson = DhcDistributeCache.get((String)"cache_bill_data_4_init");
        return (List)SerializationUtils.fromJsonString((String)billDataJson, List.class);
    }

    private void clearCache() {
        DhcDistributeCache.remove((String)"cache_bill_data_4_init");
    }

    private void recordErrorException(String entityNumber, Date errorDate, Exception e) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String errorMsg = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316%1s\u5355\u521b\u5efa\u65f6\u95f4\u4e3a%2s\u7684\u6570\u636e\uff0c\u53d1\u9001mq\u6d88\u606f\u5f02\u5e38\u3002", (String)"MessagePublisher4Init_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]), entityNumber, sdf.format(errorDate));
        HashMap<String, Date> args = new HashMap<String, Date>(1);
        args.put("startDate", errorDate);
        String argsString = SerializationUtils.toJsonString(args);
        InitDataExceptionService exService = new InitDataExceptionService();
        exService.saveException(entityNumber, "BillDataInitConsumer", "onMessage", (Throwable)e, errorMsg, argsString, true);
    }
}

