/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.schedule.BillDataStructure;
import kd.fi.dhc.schedule.BillStatusFieldStructure;
import kd.fi.hdc.cache.DhcDistributeCache;

public class StatusUpdateScheduler
extends AbstractTask {
    private static final Log log = LogFactory.getLog(StatusUpdateScheduler.class);
    private static final String ALGO_KEY = "fi.dhc.StatusUpdateScheduler";
    private static final String CK_PAGE_INDEX = "statusUpdateSch";
    private static final int ONCE_SIZE = 100000;
    private static final QFilter[] FILTERS = new QFilter[]{new QFilter("reimbursestatus", "in", (Object)new String[]{"0", "1"})};
    private static final String SELECT_FIELDS = EntityField.buildSelectField((String[])new String[]{"id", "billid", "bill.number", "billnew.id", "billstatus"});
    private static final String UPDATE_SQL = "update t_dhc_mybilllist SET fbillstatus = ?,freimbursestatus = ?,fbillstatusext = ?  where fid = ?";
    private final Map<String, BillStatusFieldStructure> billStatusFieldMap = new HashMap<String, BillStatusFieldStructure>(64);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.prepareBillStatusFieldMap();
        this.synBillStatus();
    }

    private void synBillStatus() {
        Integer pageIndex = (Integer)DhcDistributeCache.get((String)CK_PAGE_INDEX, Integer.class);
        if (pageIndex == null) {
            pageIndex = 0;
            DhcDistributeCache.put((String)CK_PAGE_INDEX, (Object)0);
        }
        int size = 0;
        HashMap<String, List> billDataMap = new HashMap<String, List>(32);
        ArrayList<Object[]> updateDataList = new ArrayList<Object[]>(5000);
        ArrayList<Object> deleteDataIds = new ArrayList<Object>(500);
        Throwable throwable = null;
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, "dhc_mybilllist", SELECT_FIELDS, FILTERS, null, pageIndex * 100000, 100000);){
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ++size;
                String billType = row.getString("billnew.id");
                BillDataStructure dataStructure = new BillDataStructure();
                dataStructure.setId(row.getLong("id"));
                dataStructure.setBillId(row.getLong("billid"));
                dataStructure.setStatus(row.getString("billstatus"));
                List list = billDataMap.computeIfAbsent(billType, k -> new ArrayList(5000));
                list.add(dataStructure);
                if (list.size() < 5000) continue;
                this.buildHandleData(billType, list, updateDataList, deleteDataIds);
                billDataMap.remove(billType);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : billDataMap.entrySet()) {
            this.buildHandleData((String)entry.getKey(), (List)entry.getValue(), updateDataList, deleteDataIds);
        }
        if (updateDataList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_SQL, updateDataList);
        }
        if (deleteDataIds.size() > 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"dhc_mybilllist");
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleteDataIds.toArray());
        }
        if (size < 100000) {
            DhcDistributeCache.put((String)CK_PAGE_INDEX, (Object)0);
        } else {
            DhcDistributeCache.put((String)CK_PAGE_INDEX, (Object)(pageIndex + 1));
        }
    }

    private void buildHandleData(String entityNumber, List<BillDataStructure> billDataList, List<Object[]> updateDataList, List<Object> deleteDataIds) {
        Map<Long, BillDataStructure> billIdDataMap = billDataList.stream().collect(Collectors.toMap(BillDataStructure::getBillId, d -> d, (d1, d2) -> d1));
        QFilter filter = new QFilter("id", "in", billIdDataMap.keySet());
        BillStatusFieldStructure statusField = this.billStatusFieldMap.get(entityNumber);
        if (statusField == null) {
            return;
        }
        String statusFieldKey = statusField.getStatusFieldKey();
        Map<String, String> statusValueNameMap = statusField.getStatusValueNameMap();
        Map<String, String> statusValueMappingMap = statusField.getStatusValueMappingMap();
        String selectFields = "id," + statusFieldKey;
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, entityNumber, selectFields, filter.toArray());){
            for (Row row : ds) {
                Long billId = row.getLong("id");
                String newStatusValue = row.getString(statusFieldKey);
                BillDataStructure dataStructure = billIdDataMap.remove(billId);
                if (dataStructure.getStatus().equals(newStatusValue)) continue;
                Object[] updateStatus = new Object[]{newStatusValue, statusValueMappingMap.get(newStatusValue) != null ? statusValueMappingMap.get(newStatusValue) : " ", statusValueNameMap.get(newStatusValue) != null ? statusValueNameMap.get(newStatusValue) : " ", dataStructure.getId()};
                updateDataList.add(updateStatus);
            }
        }
        if (!billIdDataMap.isEmpty()) {
            List thisDeleteIds = billIdDataMap.values().stream().map(BillDataStructure::getId).collect(Collectors.toList());
            deleteDataIds.addAll(thisDeleteIds);
        }
    }

    private void prepareBillStatusFieldMap() {
        String selectField = EntityField.buildSelectField((String[])new String[]{"billnumber", "number", "mappingnumber"});
        QFilter filter = new QFilter("number", "in", (Object)new String[]{"reimbursestatus", "billstatus"});
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, "dhc_billmapping", selectField, filter.toArray());){
            for (Row row : ds) {
                String billNumber = row.getString("billnumber");
                String mappingValue = row.getString("mappingnumber");
                if (StringUtils.isEmpty((String)billNumber) || StringUtils.isEmpty((String)mappingValue)) continue;
                BillStatusFieldStructure billStatusField = this.billStatusFieldMap.computeIfAbsent(billNumber, k -> new BillStatusFieldStructure());
                String fieldNumber = row.getString("number");
                if ("billstatus".equals(fieldNumber)) {
                    BillStatusProp statusProp;
                    if (billStatusField.getStatusFieldKey() != null || (statusProp = (BillStatusProp)EntityMetadataCache.getDataEntityType((String)billNumber).getProperty(mappingValue)) == null) continue;
                    billStatusField.setStatusFieldKey(mappingValue);
                    Map<String, String> statusValueNameMap = statusProp.getStatusItems().stream().collect(Collectors.toMap(BillStatusProp.StatusItemPro::getStatusKey, s -> s.getStatusName().getLocaleValue()));
                    billStatusField.setStatusValueNameMap(statusValueNameMap);
                    continue;
                }
                if (billStatusField.getStatusValueMappingMap() != null) continue;
                billStatusField.setStatusValueMappingMap(this.buildStatusMapping(mappingValue));
            }
        }
    }

    private Map<String, String> buildStatusMapping(String mappingJson) {
        Map statusMap;
        if (StringUtils.isEmpty((String)mappingJson)) {
            return null;
        }
        try {
            statusMap = (Map)SerializationUtils.fromJsonString((String)mappingJson, Map.class);
        }
        catch (Exception e) {
            log.error("StatusUpdateScheduler.buildStatusMapping jason \u89e3\u6790\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            return null;
        }
        HashMap<String, String> statusMappingMap = new HashMap<String, String>(4);
        for (Map.Entry entry : statusMap.entrySet()) {
            String[] billStatusArr;
            String reimburseStatus = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            for (String str : billStatusArr = value.split(",")) {
                String[] childValue;
                String billStatus;
                if (StringUtils.isEmpty((String)str) || !StringUtils.isNotEmpty((String)(billStatus = (childValue = str.split("_"))[0]))) continue;
                statusMappingMap.put(billStatus, reimburseStatus);
            }
        }
        return statusMappingMap;
    }
}

