/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.bd.mircoservice.exception.BizExceptionUtils;
import kd.fi.bd.mircoservice.result.ServiceResult;
import kd.fi.dhc.InquiryBillService;
import kd.fi.dhc.enums.AssistantDataEnum;
import kd.fi.dhc.mircoservice.exception.FIDHCBizException;
import kd.fi.dhc.mircoservice.pojo.dto.inquirybill.InquiryBillAddDTO;
import kd.fi.dhc.mircoservice.pojo.vo.AssistantDataVO;
import kd.fi.dhc.mircoservice.result.FIDHCErrorCode;
import kd.fi.dhc.mircoservice.validator.InquiryBillValidator;
import kd.fi.dhc.util.DateUtil;
import kd.fi.dhc.util.DynamicObjectUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateUtils;

public class InquiryBillServiceImpl
implements InquiryBillService {
    private static Log logger = LogFactory.getLog(InquiryBillServiceImpl.class);
    private static final String BOS_USER = "bos_user";
    private static final String BILLSTATUS_DRAFT = "A";
    private static final String BILLSTATUS_SUBMIT = "B";
    private static final String BILLSTATUS_PASSED = "C";
    private static final String CLOUD_NAME_ESC = "ESC";

    public String queryQuestionTypes() {
        this.logInfo("queryQuestionTypes accept a request");
        ServiceResult result = new ServiceResult();
        try {
            List<AssistantDataVO> voList = this.doQueryQuestionTypes();
            result.setData(voList);
        }
        catch (Exception e) {
            BizExceptionUtils.handle((Exception)e, (ServiceResult)result);
        }
        String jsonResult = result.toJSONString();
        this.logInfo("queryQuestionTypes service result:" + jsonResult);
        return jsonResult;
    }

    public String queryQuestionSubTypes() {
        this.logInfo("queryQuestionSubTypes accept a request");
        ServiceResult result = new ServiceResult();
        try {
            List<AssistantDataVO> voList = this.doQueryQuestionSubTypes();
            result.setData(voList);
        }
        catch (Exception e) {
            BizExceptionUtils.handle((Exception)e, (ServiceResult)result);
        }
        String jsonResult = result.toJSONString();
        this.logInfo("queryQuestionSubTypes service result:" + jsonResult);
        return jsonResult;
    }

    public String add(String params) {
        this.logInfo("add accept request,params:" + params);
        ServiceResult result = new ServiceResult();
        try {
            InquiryBillAddDTO addDTO = InquiryBillValidator.validateAddAndTransferDTO((String)params);
            Long billId = this.doAdd(addDTO);
            result.setData((Object)billId);
        }
        catch (Exception e) {
            BizExceptionUtils.handle((Exception)e, (ServiceResult)result);
        }
        String jsonResult = result.toJSONString();
        this.logInfo("add service result:" + jsonResult);
        return jsonResult;
    }

    private List<AssistantDataVO> doQueryQuestionTypes() {
        DynamicObject[] questionTypes = DynamicObjectUtils.queryAssistantDatas((String)this.getESCBizCloudId(), (String)AssistantDataEnum.INQUIRY_BILL_QUESTION_TYPE.getCode());
        List<AssistantDataVO> voList = this.transferAssistantDataToVOList(questionTypes);
        return voList;
    }

    private List<AssistantDataVO> doQueryQuestionSubTypes() {
        DynamicObject[] questionTypes = DynamicObjectUtils.queryAssistantDatas((String)this.getESCBizCloudId(), (String)AssistantDataEnum.INQUIRY_BILL_QUESTION_SUB_TYPE.getCode());
        List<AssistantDataVO> voList = this.transferAssistantDataToVOList(questionTypes);
        return voList;
    }

    private List<AssistantDataVO> transferAssistantDataToVOList(DynamicObject[] assistantData) {
        ArrayList<AssistantDataVO> voList = new ArrayList<AssistantDataVO>();
        if (ArrayUtils.isNotEmpty((Object[])assistantData)) {
            for (DynamicObject data : assistantData) {
                AssistantDataVO vo = new AssistantDataVO();
                vo.setId((Long)data.getPkValue());
                vo.setNumber(data.getString("number"));
                vo.setName(data.getString("name"));
                voList.add(vo);
            }
        }
        return voList;
    }

    private String getESCBizCloudId() {
        return DynamicObjectUtils.getBizCloudIdByNumber((String)CLOUD_NAME_ESC);
    }

    private Long doAdd(InquiryBillAddDTO addDTO) throws ParseException {
        DynamicObject inquiryBill = this.initInquiryBill(addDTO);
        Long billId = this.saveInquiryBill(inquiryBill);
        this.logInfo("doAdd inquiryBill billId:" + billId);
        return billId;
    }

    private DynamicObject initInquiryBill(InquiryBillAddDTO addDTO) throws ParseException {
        DynamicObject inquiryBill = BusinessDataServiceHelper.newDynamicObject((String)"dhc_inquirybill");
        inquiryBill.set("applydate", (Object)DateUtils.parseDate((String)DateUtil.getDate(), (String[])new String[]{"yyyy-MM-dd"}));
        inquiryBill.set("createtime", (Object)TimeServiceHelper.now());
        inquiryBill.set("billstatus", (Object)BILLSTATUS_DRAFT);
        inquiryBill.set("questiondesc", (Object)addDTO.getQuestionDesc());
        this.setQuestionType(inquiryBill, addDTO.getQuestionTypeId());
        this.setQuestionSubType(inquiryBill, addDTO.getQuestionSubTypeId());
        Long userId = addDTO.getUserId();
        inquiryBill.set("creator", (Object)userId);
        this.initApplierInfo(inquiryBill, userId);
        inquiryBill.set("billno", (Object)this.generateNumberByRule(inquiryBill));
        return inquiryBill;
    }

    private Long saveInquiryBill(DynamicObject inquiryBill) {
        DynamicObject saveObj = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inquiryBill})[0];
        return (Long)saveObj.getPkValue();
    }

    private void setQuestionType(DynamicObject inquiryBill, Long questionTypeId) {
        boolean isQuestionTypeExists = DynamicObjectUtils.isAssistantDataExists((String)this.getESCBizCloudId(), (String)AssistantDataEnum.INQUIRY_BILL_QUESTION_TYPE.getCode(), (Long)questionTypeId);
        if (!isQuestionTypeExists) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_QUESTIONTYPEID_IS_INCORRECT, new Object[0]);
        }
        inquiryBill.set("questiontypeid", (Object)questionTypeId);
    }

    private void setQuestionSubType(DynamicObject inquiryBill, Long questionSubTypeId) {
        boolean isQuestionSubTypeExists = DynamicObjectUtils.isAssistantDataExists((String)this.getESCBizCloudId(), (String)AssistantDataEnum.INQUIRY_BILL_QUESTION_SUB_TYPE.getCode(), (Long)questionSubTypeId);
        if (!isQuestionSubTypeExists) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_QUESTIONSUBTYPEID_IS_INCORRECT, new Object[0]);
        }
        inquiryBill.set("questionsubtypeid", (Object)questionSubTypeId);
    }

    private String generateNumberByRule(DynamicObject object) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)object.getDataEntityType().getName(), (DynamicObject)object, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)object);
    }

    private void initApplierInfo(DynamicObject inquiryBill, Long creatorId) {
        DynamicObject creator = BusinessDataServiceHelper.loadSingleFromCache((Object)creatorId, (String)BOS_USER);
        if (creator == null) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_USERID_INCORRECT, new Object[0]);
        }
        Long deptId = UserServiceHelper.getUserMainOrgId((long)creatorId);
        if (deptId <= 0L) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_USER_NEED_MAINDEPT, new Object[0]);
        }
        inquiryBill.set("dept", (Object)deptId);
        inquiryBill.set("applierpositionv", (Object)UserServiceHelper.getUserMainJob((long)creatorId));
        Map companyInfo = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        inquiryBill.set("company", companyInfo.get("id"));
    }

    private void logInfo(String infoLog) {
        if (logger.isInfoEnabled()) {
            logger.info(infoLog);
        }
    }

    private void logError(String errorLog) {
        if (logger.isErrorEnabled()) {
            logger.error(errorLog);
        }
    }

    private void logDebug(String debugLog) {
        if (logger.isDebugEnabled()) {
            logger.debug(debugLog);
        }
    }

    private void tryTriggerProcess(String businessKey, String operation, String entityNumber, Map<String, Object> variables) {
        this.logInfo("tryTriggerProcess businessKey:" + businessKey + ",operation:" + operation + ", entityNumber:" + entityNumber);
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)businessKey);
        if (CollectionUtils.isEmpty((Collection)allApprovalRecord)) {
            WorkflowServiceHelper.tryTriggerProcess((String)businessKey, (String)operation, (String)entityNumber, variables);
        }
    }
}

