/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.web.actions;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.mc.TripInfo;
import kd.bos.dc.utils.TripUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.RevProxyUtil;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import org.apache.commons.lang.StringUtils;

public class ErTripAction {
    private static final Log logger = LogFactory.getLog(ErTripAction.class);
    private static final String dev = "13711111111";
    private static final String pro = "13722222222";

    public void syncOrder(HttpServletRequest request, HttpServletResponse response) {
        this.handleTripPostData(request, response, "syncOrder");
    }

    public void syncStatement(HttpServletRequest request, HttpServletResponse response) {
        this.handleTripPostData(request, response, "syncStatement");
    }

    public void syncInvoiceOrder(HttpServletRequest request, HttpServletResponse response) {
        this.handleTripPostData(request, response, "syncInvoiceOrder");
    }

    private void handleTripPostData(HttpServletRequest request, HttpServletResponse response, String method) {
        Map bodyParam;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ApiRequestContext.initThreadLocal((HttpServletRequest)request, (HttpServletResponse)response);
        ApiRequestContext context = ApiRequestContext.get();
        Map paramMap = context.getParameterMap();
        String bodyStr = context.getPostData();
        if (bodyStr != null && StringUtils.isNotEmpty((String)bodyStr.trim()) && (bodyParam = (Map)SerializationUtils.fromJsonString((String)bodyStr, Map.class)) != null) {
            paramMap.putAll(bodyParam);
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u5165\u53c2:" + SerializationUtils.toJsonString((Object)paramMap));
        try {
            String url = (String)paramMap.get("portal");
            if (StringUtils.isBlank((String)url)) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u5165\u53c2portal\u7f3a\u5931");
                throw new Exception(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u7684\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u52a0\u5165\u201cportal\u201d\u3002", (String)"ErTripAction_5", (String)"fi-er-webapi", (Object[])new Object[0]));
            }
            if (url.equals("dev") || url.equals("pro")) {
                this.handleRequestOld(resultMap, paramMap, method);
            } else {
                String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                this.handleRequestNew(resultMap, paramMap, method, tenantId);
            }
        }
        catch (Exception e) {
            resultMap.put("errno", "500");
            resultMap.put("errmsg", String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"ErTripAction_6", (String)"fi-er-webapi", (Object[])new Object[0]), e.getMessage()));
            logger.error("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u5931\u8d25:", (Throwable)e);
        }
        this.dealWithResult(resultMap, context);
        logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u82cd\u7a79\u7cfb\u7edf\u5904\u7406\u8bf7\u6c42\u6570\u636e\u7ed3\u675f,\u8fd4\u56de\u7ed3\u679c:" + SerializationUtils.toJsonString(resultMap));
    }

    private void handleRequestOld(Map<String, Object> resultMap, Map<String, String> paramMap, String method) throws Exception {
        logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u83b7\u53d6\u79df\u6237,\u6a21\u5f0f\u4e00:\u6839\u636e\u5916\u90e8\u7cfb\u7edf\u6807\u8bc6\u83b7\u53d6\u5bf9\u5e94\u7684\u79df\u6237\u4fe1\u606f");
        String url = paramMap.get("portal");
        if (url.endsWith("dev")) {
            url = dev;
        } else if (url.endsWith("pro")) {
            url = pro;
        }
        String outSystemFlag = paramMap.get("corpId");
        logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u5916\u90e8\u7cfb\u7edf\u6807\u8bc6:" + outSystemFlag);
        List tripInfos = TripUtils.getTripInfo((String)outSystemFlag);
        if (tripInfos.size() > 0) {
            for (TripInfo trip : tripInfos) {
                if (!url.equals(trip.getUser())) continue;
                logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u79df\u6237TenantId:%s,\u8d26\u5957AccountId:%s,\u534f\u8bae\u7528\u6237Phone:%s", trip.getTenantId(), trip.getAccountId(), trip.getUser()));
                RequestContextCreator.createForTripSI((String)trip.getTenantId(), (String)trip.getAccountId(), (String)"1");
                this.saveErrorLogDO(paramMap.get("service"), method, paramMap);
                this.invokeTripService(resultMap, paramMap, method);
                break;
            }
        }
        if (tripInfos.size() < 1 || resultMap.get("errno") == null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u6839\u636e\u5916\u90e8\u7cfb\u7edf\u6807\u8bc6\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u79df\u6237\u4fe1\u606f,\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\u5c06\u8be5\u5916\u90e8\u7cfb\u7edf\u6807\u8bc6\u7ef4\u62a4\u5230\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3");
            throw new Exception(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u672a\u627e\u5230\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErTripAction_7", (String)"fi-er-webapi", (Object[])new Object[0]));
        }
    }

    private void handleRequestNew(Map<String, Object> resultMap, Map<String, String> paramMap, String method, String tenantId) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u83b7\u53d6\u79df\u6237,\u6a21\u5f0f\u4e8c:\u8bf7\u6c42\u6570\u636e\u4e2d\u643a\u5e26\u79df\u6237\u4fe1\u606f");
        String accountId = paramMap.get("portal");
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u79df\u6237TenantId:%s,\u8d26\u5957AccountId:%s", tenantId, accountId));
        RequestContextCreator.createForTripSI((String)tenantId, (String)accountId, (String)"1");
        this.saveErrorLogDO(paramMap.get("service"), method, paramMap);
        this.invokeTripService(resultMap, paramMap, method);
    }

    private void invokeTripService(Map<String, Object> resultMap, Map<String, String> paramMap, String method) {
        String service = paramMap.get("service");
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u82cd\u7a79\u7cfb\u7edf\u5904\u7406\u670d\u52a1\u5546:[%s],\u540c\u6b65:[%s]\u7684\u8bf7\u6c42\u6570\u636e\u5f00\u59cb", service, method));
        if ("XIECHENG".equalsIgnoreCase(service)) {
            paramMap.put("service", "CTripService");
            ErTripAction.invokeITripService("synOrderFromTrip", paramMap);
        } else if ("ZHONGXING".equalsIgnoreCase(service)) {
            paramMap.put("service", "ETripService");
            switch (method) {
                case "syncOrder": {
                    ErTripAction.invokeITripService("synOrderFromTrip", paramMap);
                    break;
                }
                case "syncStatement": {
                    ErTripAction.invokeITripService("synSettlementsFromTrip", paramMap);
                    break;
                }
                case "syncInvoiceOrder": {
                    ErTripAction.invokeITripService("syncInvoiceOrder", paramMap);
                }
            }
        }
        resultMap.put("errno", "0");
        resultMap.put("errmsg", ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"ErTripAction_4", (String)"fi-er-webapi", (Object[])new Object[0]));
    }

    private static <T> T invokeITripService(String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"ITripService", (String)methodName, (Object[])paras);
    }

    private void dealWithResult(Map<String, Object> resultMap, ApiRequestContext ctx) {
        HttpServletResponse response = ctx.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(JSONUtils.toString(resultMap).getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveErrorLogDO(String server, String method, Object data) {
        try {
            String function = "";
            switch (method) {
                case "syncOrder": {
                    function = "orderInvoke";
                    break;
                }
                case "syncStatement": {
                    function = "checkingInvoke";
                    break;
                }
                case "syncInvoiceOrder": {
                    function = "invoiceReceiveInvoke";
                }
            }
            MainEntityType billType = EntityMetadataCache.getDataEntityType((String)"er_trip_log");
            DynamicObject errorLogDO = new DynamicObject((DynamicObjectType)billType);
            errorLogDO.set("traceid", (Object)RequestContext.get().getTraceId());
            errorLogDO.set("server", (Object)server);
            errorLogDO.set("function", (Object)function);
            errorLogDO.set("synctime", (Object)new Date());
            errorLogDO.set("status", (Object)"A");
            errorLogDO.set("requestdata", TripSyncLogUtils.genJsonStr((Object)data));
            errorLogDO.set("requestdata_tag", this.genClobJsonStr(data));
            errorLogDO.set("message", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u5546\u63a8\u9001\u6570\u636e\u3002", (String)"ErTripAction_9", (String)"fi-er-webapi", (Object[])new Object[0]));
            errorLogDO.set("message_tag", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u5546\u63a8\u9001\u6570\u636e\u3002", (String)"ErTripAction_9", (String)"fi-er-webapi", (Object[])new Object[0]));
            LinkedList<DynamicObject> dynamicObjects = new LinkedList<DynamicObject>();
            dynamicObjects.add(errorLogDO);
            SaveServiceHelper.save((IDataEntityType)billType, (Object[])dynamicObjects.toArray());
        }
        catch (Throwable e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u63a5\u6536\u5916\u90e8\u6570\u636e,\u4fdd\u5b58\u5546\u65c5\u96c6\u6210\u65e5\u5fd7\u5931\u8d25:", e);
        }
    }

    private Object genClobJsonStr(Object data) {
        if (data instanceof String) {
            data = JSON.parse((String)data.toString());
        }
        return JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
    }
}

