/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.er.botp.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AbstractPubReimburseConvertPlugin
extends AbstractConvertPlugIn {
    protected static String ISPUBLICREIM_TO_PAYABLE = "ispublicreim_to_payable";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        ArrayList notValidId = new ArrayList(1);
        QFilter[] qFilters = new QFilter[]{new QFilter("billno", "in", selectedRows.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList()))};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)this.getSrcMainType().getName(), (String)"company", (QFilter[])qFilters);
        Map map = Stream.of(bills).collect(Collectors.groupingBy(v -> v.getLong("company.id"), Collectors.mapping(DataEntityBase::getPkValue, Collectors.toList())));
        for (Map.Entry<Long, List<Object>> entry : map.entrySet()) {
            if (!this.getPayable(entry)) continue;
            notValidId.addAll(entry.getValue());
        }
        if (!notValidId.isEmpty()) {
            e.getCustQFilters().add(new QFilter("id", "not in", notValidId));
            e.setCustFilterExpression(String.format("id not in (%s)", StringUtils.join(notValidId, (String)",")));
            e.setCustFilterDesc(this.getFilterDesc());
        }
    }

    protected boolean getPayable(Map.Entry<Long, List<Object>> entry) {
        boolean payable = AbstractPubReimburseConvertPlugin.getBoolParamResult(entry.getKey(), ISPUBLICREIM_TO_PAYABLE);
        return payable;
    }

    protected String getFilterDesc() {
        return "xxxx";
    }

    protected static boolean getBoolParamResult(Long companyId, String paramName) {
        Object isCtl = AbstractPubReimburseConvertPlugin.getEMParameter(companyId, paramName);
        if (isCtl instanceof String) {
            String isCtlStr = (String)isCtl;
            return "1".equals(isCtlStr);
        }
        return false;
    }

    private static Object getEMParameter(long companyId, String parameterName) {
        AppParam appParam = AbstractPubReimburseConvertPlugin.getAppParam(companyId);
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)parameterName.toLowerCase());
        return value;
    }

    private static AppParam getAppParam(long companyId) {
        String appId = "10MYBGBYHXDU";
        String viewType = "01";
        Long orgId = companyId;
        Long actBookId = 0L;
        AppParam appParam = new AppParam(appId, viewType, orgId, actBookId);
        return appParam;
    }
}

