/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.formplugin.budget;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;

public class BillShowBudgetExt
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(BillShowBudgetExt.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String expenseItemSign;
        DynamicObject expenseItem;
        super.propertyChanged(e);
        if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) {
            logger.info("\u5f53\u524d\u9875\u9762\u4e0d\u9700\u8981\u67e5\u8be2\u9884\u7b97");
            return;
        }
        String propName = e.getProperty().getName();
        String extBudgetProp = ErStdConfig.getBudgetPropExt();
        if (!extBudgetProp.contains(propName) || extBudgetProp.contains("expenseitem") || extBudgetProp.contains("tripexpenseitem")) {
            return;
        }
        IDataModel dataModel = this.getModel();
        String entityId = dataModel.getDataEntityType().getName();
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityId);
        IDataEntityProperty property = entity.findProperty(propName);
        if (property == null) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if ((expenseItem = (DynamicObject)dataModel.getValue(expenseItemSign = this.getExpenseItemSign(entityId), rowIndex)) == null) {
            return;
        }
        dataModel.setValue(expenseItemSign, null, rowIndex);
        dataModel.setValue(expenseItemSign, expenseItem.getPkValue(), rowIndex);
        this.getView().updateView(expenseItemSign, rowIndex);
    }

    protected String getExpenseItemSign(String entityId) {
        String expenseItemSign = "expenseitem";
        if ("er_tripreqbill".equalsIgnoreCase(entityId) || "er_tripreimbursebill".equalsIgnoreCase(entityId) || "er_tripentryedit".equalsIgnoreCase(entityId)) {
            expenseItemSign = "tripexpenseitem";
        }
        return expenseItemSign;
    }
}

