/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.formplugin.budget;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;

public class EASBgBalanceListPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(EASBgBalanceListPlugin.class);
    private static final String tableKey = "budgetdata";
    private static final String msgKey = "errormsg";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u53ef\u7528\u9884\u7b97\u3002", (String)"EASBgBalanceListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = parentView.getModel();
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u53ef\u7528\u9884\u7b97\u3002", (String)"EASBgBalanceListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        BillEntityType mainType = null;
        if (model.getDataEntityType() instanceof BillEntityType) {
            mainType = (BillEntityType)model.getDataEntityType();
        }
        if (mainType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53\u4e0d\u662f\u5355\u636e\u7c7b\u578b\uff0c\u65e0\u53ef\u7528\u9884\u7b97\u3002", (String)"EASBgBalanceListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject billDO = model.getDataEntity(true);
        String iscNumber = IscHelper.getEasBgIscNumber((DynamicObject)billDO);
        String billstatus = billDO.getString("billstatus");
        if (IscHelper.isEasShareBudget((String)iscNumber) && (billstatus == null || billstatus.equals("A"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u524d\u5206\u644a\u4ec5\u652f\u6301\u63d0\u4ea4\u540e\u67e5\u770b\u9884\u7b97\u3002", (String)"EASBgBalanceListPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Object bgJson = null;
        try {
            String targetJson = IscHelper.buildTargetBillJson((DynamicObject)billDO, (String)iscNumber);
            if (targetJson.contains("\"entries\":[]")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u65e0\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff0c\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"EASBgBalanceListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String flowNumber = IscHelper.getISCSettingValue((String)"eas_query_bg_flownum");
            bgJson = StringUtils.isNotBlank((CharSequence)flowNumber) ? IscHelper.execBudgetService((String)flowNumber, (String)"btnQueryEASBillBudget", (String)targetJson) : IscHelper.doEASFacade((String)"btnQueryEASBillBudget", (Object)targetJson);
        }
        catch (KDBizException kdBizExcepetion) {
            logger.info("EAS\u96c6\u6210,\u67e5\u8be2\u9884\u7b97\u5931\u8d25,\u96c6\u6210\u5e73\u53f0\u8f6c\u6362\u5355\u636e\u6570\u636e\u51fa\u9519 \u6216\u8005 \u96c6\u6210\u4e91\u8bbe\u7f6e-\u8fde\u63a5\u914d\u7f6e\u7f16\u53f7\u4e0d\u5b58\u5728:" + kdBizExcepetion.getMessage());
            this.getView().showMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u7b97\u5931\u8d25\u3002\u539f\u56e0\u53ef\u80fd\u662f\u96c6\u6210\u5e73\u53f0\u8f6c\u6362\u5355\u636e\u6570\u636e\u51fa\u9519\u6216\u8005\u201c\u96c6\u6210\u4e91\u8bbe\u7f6e>\u8fde\u63a5\u914d\u7f6e\u201d\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillShowBudgetEAS_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        catch (Exception exception) {
            logger.error("EAS\u96c6\u6210,\u67e5\u8be2\u9884\u7b97\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!\u8be6\u7ec6\u4fe1\u606f:", (Throwable)exception);
            String detail = ErExceptionServiceHelper.getStackTrace((Throwable)exception);
            int start = detail.lastIndexOf("BgControlException:");
            if (start == -1) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EM-W-774784", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u7b97\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u8be6\u7ec6\u4fe1\u606f:%s", (String)"EASBgBalanceListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), IscHelper.getExceptionDescription((String)detail)));
            }
            return;
        }
        this.convertJsonData(bgJson);
    }

    private void convertJsonData(Object bgJson) {
        try {
            Map bgMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(bgJson), Map.class);
            if (bgMap == null || bgMap.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u65e0\u53ef\u7528\u9884\u7b97\u4f59\u989d\u3002", (String)"EASBgBalanceListPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Map dimensiondata = (Map)bgMap.get("dimensiondata");
            if (dimensiondata == null || dimensiondata.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u65e0\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff0c\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"EASBgBalanceListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            List budgetdata = (List)bgMap.get(tableKey);
            if (budgetdata == null || budgetdata.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u65e0\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff0c\u9884\u7b97\u6570\u636e\u4e3a\u7a7a\u3002", (String)"EASBgBalanceListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<List<Object>> data = new ArrayList<List<Object>>();
            int i = 0;
            for (Map budgetdataMap : budgetdata) {
                ArrayList<Object> row = new ArrayList<Object>();
                int index = ++i;
                if (i > 1000) break;
                row.add(index);
                row.add(index);
                for (String dimensionKey : dimensiondata.keySet()) {
                    row.add(budgetdataMap.get(dimensionKey) == null ? "" : budgetdataMap.get(dimensionKey));
                }
                data.add(row);
            }
            this.createGrid(dimensiondata);
            this.setData(dimensiondata, data);
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    private void createGrid(Map<String, String> colNameInfos) {
        HashMap<String, Object> args = new HashMap<String, Object>(4);
        args.put("rk", "rk");
        args.put("seq", "fseq");
        args.put("columns", this.createColumns(colNameInfos));
        HashMap<String, Object> meta = new HashMap<String, Object>(4);
        meta.put("key", tableKey);
        meta.put("methodname", "createGridColumns");
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
        this.getView().setVisible(Boolean.TRUE, new String[]{tableKey});
        this.getView().setVisible(Boolean.FALSE, new String[]{msgKey});
    }

    private List<Map<String, Object>> createColumns(Map<String, String> colNameInfos) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(16);
        cols.add(this.genSeqColumn());
        for (Map.Entry<String, String> colNameInfo : colNameInfos.entrySet()) {
            String colKey = colNameInfo.getKey();
            String colValue = colNameInfo.getValue();
            cols.add(this.createColumn(colKey, colValue));
        }
        return cols;
    }

    private Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("dataIndex", "fseq");
        map.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EASBgBalanceListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    private Map<String, Object> createColumn(String colKey, String colValue) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("dataIndex", colKey);
        map.put("header", new LocaleString(colValue));
        map.put("visible", Boolean.TRUE);
        return map;
    }

    private void setData(Map<String, String> colNameInfos, List<List<Object>> rs) {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("dataindex", this.getDataIndex(colNameInfos));
        data.put("rows", rs);
        data.put("datacount", rs.size());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(tableKey, "data", data);
    }

    private Map<String, Integer> getDataIndex(Map<String, String> colNameInfos) {
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.addAll(colNameInfos.keySet());
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(4);
        dataIndex.put("rk", 0);
        dataIndex.put("fseq", 1);
        for (int i = 0; i < colNames.size(); ++i) {
            dataIndex.put((String)colNames.get(i), i + 2);
        }
        return dataIndex;
    }

    private void setError(Throwable ex) {
        this.setMsg(ErExceptionServiceHelper.getStackTrace((Throwable)ex));
    }

    private void setMsg(String msg) {
        this.getView().setVisible(Boolean.FALSE, new String[]{tableKey});
        this.getView().setVisible(Boolean.TRUE, new String[]{msgKey});
        this.getModel().setValue(msgKey, (Object)(msg + "\r\n"));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

