/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.StringUtils;

public class AbstractFeeStandardControlFormPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(AbstractFeeStandardControlFormPlugin.class);
    private List<String> dimensions = null;
    private Boolean openFeeStand = null;
    private Object defaultReimlevel = null;
    protected BillSettingRuleInfo ruleInfo = null;
    private boolean hasInit = false;
    protected static final String MEETTING = "meetting";
    protected static final String REFRESHFEE = "refreshFee:";

    protected BillSettingRuleInfo getBillSettingRuleInfo() {
        if (this.ruleInfo == null && !this.hasInit) {
            this.ruleInfo = BillSettingRuleUtil.getBillSettingRuleInfo((IDataModel)this.getModel());
            this.hasInit = true;
        }
        return this.ruleInfo;
    }

    protected DynamicObject getBizItem() {
        return (DynamicObject)this.getModel().getValue("bizitem");
    }

    protected List<String> getCurDimensions() {
        if (this.dimensions == null) {
            this.dimensions = FeeStandardHelper.collectDimension((DynamicObject)this.getBizItem());
        }
        return this.dimensions;
    }

    protected Boolean getOpenFeeStand() {
        if (this.getModel().getValue("company") != null) {
            if (this.openFeeStand == null) {
                this.openFeeStand = FeeStandardHelper.isOpenFeeStand((DynamicObject)this.getBizItem(), (Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
        } else {
            this.openFeeStand = false;
        }
        return this.openFeeStand;
    }

    protected void setOpenFeeStandNull() {
        this.openFeeStand = null;
        this.ruleInfo = null;
        this.hasInit = false;
    }

    protected void commonAfterCreateNewData() {
        String bizitemNum = (String)this.getView().getFormShowParameter().getCustomParam("bizitem");
        if (StringUtils.isBlank((CharSequence)bizitemNum)) {
            bizitemNum = (String)this.getView().getFormShowParameter().getCustomParam("reimbursetype");
        }
        if (StringUtils.isNotBlank((CharSequence)bizitemNum)) {
            this.getModel().setValue("reimbursetype", (Object)bizitemNum);
        } else {
            String reimbursetype = (String)this.getModel().getValue("reimbursetype");
            bizitemNum = reimbursetype == null ? "expense" : reimbursetype;
        }
        this.getModel().setValue("bizitem", (Object)FeeStandardHelper.queryBizItem((String)bizitemNum));
        this.initreimburselevel();
    }

    protected void initreimburselevel() {
        if (this.getOpenFeeStand().booleanValue() && !ErStdConfig.getBoolean((String)"feestand.cancel.initreimlevel")) {
            Object reimburselevelHasDefaultVal = this.reimburselevelHasDefaultVal();
            if (reimburselevelHasDefaultVal != null) {
                this.getModel().setValue("reimburselevel_bill", reimburselevelHasDefaultVal);
                this.changeEntryReimburseLevel(reimburselevelHasDefaultVal);
            } else {
                this.defaultReimlevel = null;
                this.getModel().setValue("reimburselevel_bill", this.getDefaultReimlevel());
                this.changeEntryReimburseLevel(this.getDefaultReimlevel());
            }
        }
    }

    protected void changeEntryReimburseLevel(Object reimburselevel) {
        int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("reimburselevel", reimburselevel, i);
        }
    }

    protected Object reimburselevelHasDefaultVal() {
        EntryProp property = (EntryProp)this.getModel().getDataEntityType().getProperty("expenseentryentity");
        BasedataProp reimburselevelProp = (BasedataProp)property.getDynamicCollectionItemPropertyType().getProperty("reimburselevel");
        if (reimburselevelProp.getDefValue2() != null) {
            return this.getBasedataid(reimburselevelProp.getDefValue2());
        }
        BasedataProp reimburselevelBillProp = (BasedataProp)this.getModel().getDataEntityType().getProperty("reimburselevel_bill");
        if (reimburselevelBillProp.getDefValue2() != null) {
            return this.getBasedataid(reimburselevelBillProp.getDefValue2());
        }
        return null;
    }

    private Object getBasedataid(FieldDefValue defValue) {
        try {
            Map basedataMap = (Map)SerializationUtils.fromJsonString((String)defValue.getFuncParameter(), Map.class);
            return basedataMap.get("id");
        }
        catch (Exception e) {
            logger.error("getBasedataid failed", (Throwable)e);
            return null;
        }
    }

    protected void setDefaultReimburselevel(AfterAddRowEventArgs e) {
        if ("expenseentryentity".equals(e.getEntryProp().getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                if (!this.getOpenFeeStand().booleanValue() || this.getModel().getValue("reimburselevel", row.getRowIndex()) != null) continue;
                this.getModel().setValue("reimburselevel", this.getModel().getValue("reimburselevel_bill"), row.getRowIndex());
            }
        }
    }

    protected void setDefaultFeeStandCurrency(AfterAddRowEventArgs e) {
        if ("expenseentryentity".equals(e.getEntryProp().getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                if (!this.getOpenFeeStand().booleanValue() || this.getModel().getValue("feestandcurrency", row.getRowIndex()) != null) continue;
                this.getModel().setValue("feestandcurrency", this.getModel().getValue("currency"), row.getRowIndex());
            }
        }
    }

    protected void commonAfterBindData() {
        this.getModel().setValue("openfeestand", (Object)this.getOpenFeeStand());
        if (this.getOpenFeeStand().booleanValue() && this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            this.refreshFeeStand();
        }
        this.setReimburseTypeCombo();
    }

    protected void fireRefreshFeeStandard() {
        this.fireRefreshFeeStandard(-1);
    }

    protected void fireRefreshFeeStandard(int rowIndex) {
        if (!FeeStandardHelper.firedRefreshEvent((int)rowIndex)) {
            if (!this.getOpenFeeStand().booleanValue()) {
                return;
            }
            this.getView().addClientCallBack(REFRESHFEE.concat(String.valueOf(rowIndex)));
            if (rowIndex == -1) {
                this.getModel().beginInit();
                for (int i = 0; i < this.getModel().getEntryRowCount("expenseentryentity"); ++i) {
                    this.getModel().setValue("feestandarddesc", (Object)"...", i);
                    this.getModel().setValue("feestandardamt", (Object)BigDecimal.ZERO, i);
                    this.getView().updateView("feestandarddesc", i);
                    this.getView().updateView("feestandardamt", i);
                }
                this.getModel().endInit();
            } else {
                this.getModel().setValue("feestandarddesc", (Object)"...", rowIndex);
                this.getModel().setValue("feestandardamt", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    protected List<Integer> varInCalcExpr(int rowIndex, String propName) {
        ArrayList indexes = null;
        if (rowIndex == -1) {
            int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
            indexes = Lists.newArrayListWithExpectedSize((int)entryRowCount);
            for (int i = 0; i < entryRowCount; ++i) {
                this.collectIndex(i, propName, indexes);
            }
        } else {
            indexes = Lists.newArrayListWithExpectedSize((int)1);
            IDataEntityProperty property = this.getModel().getProperty(propName);
            if (property != null && property.getParent() != null && "expenseentryentity".equals(property.getParent().getName())) {
                this.collectIndex(rowIndex, propName, indexes);
            }
        }
        return indexes;
    }

    private void collectIndex(int rowIndex, String propName, List<Integer> indexs) {
        DynamicObject feeStand = (DynamicObject)this.getModel().getValue("feestandid", rowIndex);
        if (feeStand != null) {
            String calcExpr = feeStand.getString("calcexpr");
            BOSExpression bosExpression = new BOSExpression(calcExpr);
            for (String var : bosExpression.getVars()) {
                if (!var.equals(propName)) continue;
                indexs.add(rowIndex);
            }
        }
    }

    protected void calcControlAmt(int rowIndex) {
        DynamicObject feeStand = (DynamicObject)this.getModel().getValue("feestandid", rowIndex);
        if (feeStand != null) {
            String expr = feeStand.getString("calcexpr");
            this.getModel().setValue("controlamt", this.calcControlAmtByExpr(rowIndex, expr), rowIndex);
        } else {
            this.getModel().setValue("controlamt", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private Object calcControlAmtByExpr(int rowIndex, String expr) {
        RowDataModel rowModel = new RowDataModel("expenseentryentity", this.getModel());
        ExpressionParameter calcParameter = new ExpressionParameter(expr, rowModel, (FunctionManage)null);
        calcParameter.setActiveRow((Object)this.getModel().getEntryRowEntity("expenseentryentity", rowIndex));
        return CalcExprParser.getExpressionValue((ExpressionParameter)calcParameter);
    }

    protected boolean matchDimensions(String name, List<String> queryDimensions) {
        for (String dimension : queryDimensions) {
            if (!dimension.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void commonCallBack(ClientCallBackEvent e) {
        if (e.getName().startsWith(REFRESHFEE)) {
            int rowIndex = -1;
            String rowIndexStr = e.getName().replace(REFRESHFEE, "");
            if (StringUtils.isNumeric((CharSequence)rowIndexStr)) {
                rowIndex = Integer.parseInt(rowIndexStr);
            }
            if (rowIndex == -1) {
                this.refreshFeeStand();
            } else {
                this.refreshFeeStand(rowIndex);
            }
        }
    }

    protected void refreshFeeStand() {
        for (int i = 0; i < this.getModel().getEntryRowCount("expenseentryentity"); ++i) {
            this.refreshFeeStand(i);
        }
    }

    protected void refreshFeeStand(int rowIndex) {
        List<String> matchDimensions;
        Map<String, Object> dimensionMap;
        DynamicObject feeStand;
        DynamicObject bizItem;
        if (this.getModel().getEntryRowCount("expenseentryentity") == 0) {
            return;
        }
        DynamicObject expenseitem = (DynamicObject)this.getModel().getValue("expenseitem", rowIndex);
        if (expenseitem != null && !"3".equals(expenseitem.get("isreimburseamountctl"))) {
            this.getModel().setValue("feestandid", null, rowIndex);
            this.getModel().setValue("feestandardamt", (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue("controlamt", (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue("feestandarddesc", (Object)ResManager.loadKDString((String)"\u975e\u8d39\u7528\u6807\u51c6\u63a7\u5236", (String)"FeeStandardControlFormPlugin_nofeestandcontrol", (String)"fi-er-formplugin", (Object[])new Object[0]), rowIndex);
            this.getModel().setValue("isover", (Object)false, rowIndex);
            return;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = null;
        currency = FeeStandardHelper.headCurrencyControl() ? (DynamicObject)this.getModel().getValue("feestandcurrency", rowIndex) : (DynamicObject)this.getModel().getValue("entrycurrency", rowIndex);
        Collection feeStandList = FeeStandardHelper.queryFeeStandard((DynamicObject)company, (DynamicObject)currency, (DynamicObject)expenseitem, (DynamicObject)(bizItem = this.getBizItem()));
        if (!feeStandList.isEmpty() && (feeStand = FeeStandardHelper.matchFeeStandardInMemory((Collection)feeStandList, dimensionMap = this.buildDimensionMap(matchDimensions = this.getCurDimensions(), rowIndex), (Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()))) != null) {
            String standDesc = FeeStandardHelper.getDesc((DynamicObject)feeStand);
            this.getModel().setValue("feestandid", (Object)feeStand, rowIndex);
            this.getModel().setValue("feestandardamt", feeStand.get("standardamount"), rowIndex);
            this.getModel().setValue("feestandarddesc", (Object)standDesc, rowIndex);
            this.calcIsOverStd(rowIndex);
            return;
        }
        this.getModel().setValue("feestandid", null, rowIndex);
        this.getModel().setValue("feestandardamt", (Object)BigDecimal.ZERO, rowIndex);
        this.getModel().setValue("controlamt", (Object)BigDecimal.ZERO, rowIndex);
        this.getModel().setValue("feestandarddesc", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6807\u51c6", (String)"FeeStandardControlFormPlugin_nofeestandsetting", (String)"fi-er-formplugin", (Object[])new Object[0]), rowIndex);
        this.calcIsOverStd(rowIndex);
    }

    protected void calcIsOverStd(int rowIndex) {
        FeeStandardHelper.calcIsOverStd((int)rowIndex, (IDataModel)this.getModel());
    }

    private Map<String, Object> buildDimensionMap(List<String> matchDimensions, int rowIndex) {
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)matchDimensions.size());
        for (String dimension : matchDimensions) {
            IDataEntityProperty property = this.getModel().getProperty(dimension);
            if (property != null) {
                dimensionMap.put(dimension, this.getModel().getValue(dimension, rowIndex));
                continue;
            }
            throw new KDBizException(dimension + "is not exist in billfield");
        }
        return dimensionMap;
    }

    protected Object getDefaultReimlevel() {
        ErTripStdServiceImp tripStdService;
        DynamicObject reimburseLevel;
        if (this.defaultReimlevel == null && (reimburseLevel = (tripStdService = new ErTripStdServiceImp()).queryReimburseLevel((Long)((DynamicObject)this.getModel().getValue("applier")).getPkValue(), (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue(), null)) != null) {
            this.defaultReimlevel = reimburseLevel.getPkValue();
        }
        return this.defaultReimlevel;
    }

    @Deprecated
    protected void expenseItemFilterByStandType(BeforeF7SelectEvent p0) {
    }

    protected void calcOtherStandAmt(int rowIndex) {
        DynamicObject feeStand = (DynamicObject)this.getModel().getValue("feestandid", rowIndex);
        if (feeStand != null && feeStand.getBoolean("otherstand")) {
            this.getModel().setValue("otherstandamount", feeStand.get("otherstandamount"), rowIndex);
            this.getModel().setValue("otherstandarddesc", (Object)FeeStandardHelper.getOtherDesc((DynamicObject)feeStand), rowIndex);
            this.getModel().setValue("othercontrolamt", this.getOtherControlAmt(rowIndex), rowIndex);
        } else {
            this.getModel().setValue("otherstandamount", null, rowIndex);
            this.getModel().setValue("otherfeeamount", null, rowIndex);
            this.getModel().setValue("otherstandarddesc", null, rowIndex);
            this.getModel().setValue("othercontrolamt", null, rowIndex);
            this.getModel().setValue("wineway", (Object)"3", rowIndex);
        }
    }

    private Object getOtherControlAmt(int rowIndex) {
        int whiteNum = (Integer)this.getModel().getValue("whiteml", rowIndex);
        int redNum = (Integer)this.getModel().getValue("redml", rowIndex);
        int totalNum = whiteNum / 500 + redNum / 750;
        BigDecimal otherStandAmt = (BigDecimal)this.getModel().getValue("otherstandamount", rowIndex);
        return otherStandAmt.multiply(new BigDecimal(totalNum));
    }

    protected void bizItemPanelPageRules() {
        boolean bizitemPanelVisible = this.bizItemPanelVisible();
        this.getView().setVisible(Boolean.valueOf(bizitemPanelVisible), new String[]{"biziteminfopanelap"});
    }

    protected boolean bizItemPanelVisible() {
        return AbstractFeeStandardControlFormPlugin.existHeadProp(this.getModel());
    }

    public static boolean existHeadProp(IDataModel model) {
        return FeeStandardHelper.existHeadProp((IDataModel)model);
    }

    protected void calcControlAmt(String propName, int rowIndex) {
        if ("feestandardamt".equals(propName)) {
            this.calcControlAmt(rowIndex);
        } else {
            List<Integer> changeRowIndexs = this.varInCalcExpr(rowIndex, propName);
            if (!changeRowIndexs.isEmpty()) {
                for (Integer changeRowIndex : changeRowIndexs) {
                    this.calcControlAmt(changeRowIndex);
                }
            }
        }
    }

    private void setReimburseTypeCombo() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("reimbursetype");
        DynamicObject bizItem = this.getBizItem();
        if (comboEdit != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            if (bizItem != null) {
                ComboItem assertComboitem;
                ComboItem comboitem = new ComboItem();
                comboitem.setCaption(new LocaleString(bizItem.getLocaleString("name").getLocaleValue()));
                comboitem.setValue(bizItem.getString("number"));
                comboItems.add(comboitem);
                if ("expense".equals(bizItem.getString("number")) && (assertComboitem = this.getComboByNum("asset")) != null) {
                    comboItems.add(assertComboitem);
                }
            } else {
                ComboItem expense;
                ComboItem assertComboitem = this.getComboByNum("asset");
                if (assertComboitem != null) {
                    comboItems.add(assertComboitem);
                }
                if ((expense = this.getComboByNum("expense")) != null) {
                    comboItems.add(expense);
                }
            }
            comboEdit.setComboItems(comboItems);
        }
    }

    private ComboItem getComboByNum(String comboNum) {
        ComboProp reimbursetypeProp = (ComboProp)this.getModel().getDataEntityType().getProperty("reimbursetype");
        if (reimbursetypeProp != null) {
            List comboItems = reimbursetypeProp.getComboItems();
            for (ValueMapItem valueMapItem : comboItems) {
                if (!comboNum.equals(valueMapItem.getValue())) continue;
                ComboItem comboitem = new ComboItem();
                comboitem.setCaption(valueMapItem.getName());
                comboitem.setValue(valueMapItem.getValue());
                comboitem.setImageKey(valueMapItem.getImageKey());
                return comboitem;
            }
        }
        return null;
    }

    public static boolean headProp(IDataModel model, String propName) {
        return FeeStandardHelper.headProp((IDataModel)model, (String)propName);
    }

    protected void fastFillBill(Object[] feeStandPks) {
        HashMap<Long, List> enableExpItemMap = new HashMap<Long, List>();
        int[] newRows = this.getModel().batchCreateNewEntryRow("expenseentryentity", feeStandPks.length);
        DynamicObject bizitem = (DynamicObject)this.getModel().getValue("bizitem");
        List collectDimension = FeeStandardHelper.collectDimension((DynamicObject)bizitem);
        List relExpenseItems = null;
        for (int i = 0; i < feeStandPks.length; ++i) {
            DynamicObject feeStand = BusinessDataServiceHelper.loadSingleFromCache((Object)feeStandPks[i], (String)"er_standard");
            DynamicObject row = this.getModel().getEntryRowEntity("expenseentryentity", i);
            Long costDept = ErCommonUtils.getPk((Object)row.getDynamicObject("entrycostdept"));
            relExpenseItems = (List)enableExpItemMap.get(costDept);
            if (relExpenseItems == null) {
                relExpenseItems = ExpenseItemServiceHelper.getAllEnableExpItemNoLeaf((DynamicObject)row);
                enableExpItemMap.put(costDept, relExpenseItems);
            }
            if (relExpenseItems.contains(ErCommonUtils.getPk((Object)feeStand.get("expenseitem")))) {
                this.getModel().setValue("expenseitem", feeStand.get("expenseitem"), newRows[i]);
            }
            if (FeeStandardHelper.headCurrencyControl()) {
                this.getModel().setValue("entrycurrency", this.getModel().getValue("currency"), newRows[i]);
            } else {
                this.getModel().setValue("entrycurrency", feeStand.get("currency"), newRows[i]);
                if (!FeeStandardHelper.equals((Object)feeStand.get("currency"), (Object)this.getModel().getValue("currency"))) {
                    this.getModel().setValue("iscurrency", (Object)true);
                }
            }
            this.getModel().setValue("feestandcurrency", feeStand.get("currency"), newRows[i]);
            this.setDimensionValue(collectDimension, feeStand, newRows[i]);
        }
    }

    private void setDimensionValue(List<String> collectDimension, DynamicObject feeStand, int rowIndex) {
        for (String dimension : collectDimension) {
            IDataEntityProperty property = this.getModel().getProperty(dimension);
            if (property == null) continue;
            this.getModel().setValue(dimension, feeStand.get(dimension), rowIndex);
        }
    }

    protected void clearFeeStand() {
        for (int i = 0; i < this.getModel().getEntryRowCount("expenseentryentity"); ++i) {
            this.getModel().setValue("feestandid", null, i);
            this.calcOtherStandAmt(i);
        }
    }
}

