/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class AvaliableAmountCardFormPlugin
extends GridCardPlugin {
    private static final Log log = LogFactory.getLog(AvaliableAmountCardFormPlugin.class);
    public static final String LAB_AMOUNT = "lab_amount";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{LAB_AMOUNT});
    }

    public void afterBindData(EventObject e) {
        Long userId = Long.valueOf(RequestContext.getOrCreate().getUserId());
        Long companyId = ErCommonUtils.getCompany((Long)userId);
        if (companyId == null) {
            return;
        }
        Long companyCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Long)companyId);
        if (companyCurrencyId == null) {
            log.info("\u8be5\u516c\u53f8(id=" + companyId + ")\u672a\u67e5\u8be2\u5230\u672c\u4f4d\u5e01");
            return;
        }
        LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
        QFilter qFilter = QFilter.of((String)"employee=? and dateyear=? and auditstatus='1' and amounttype='1' and currency=?", (Object[])new Object[]{userId, String.valueOf(currentLocalDate.getYear()), companyCurrencyId});
        DynamicObject[] reimburseAmountDOs = BusinessDataServiceHelper.load((String)"er_reimburseamount", (String)"company, expenseitem, currency", (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDOs == null || reimburseAmountDOs.length < 1) {
            log.info(String.format("\u9996\u9875\u4e2a\u4eba\u53ef\u7528\u989d\u5ea6\u5c55\u793a: \u7528\u6237:%d, \u5f53\u524d\u65e5\u671f:%s, \u5728\u989d\u5ea6\u7ef4\u62a4\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7528\u6237\u4efb\u4f55\u6570\u636e", userId, currentLocalDate));
            return;
        }
        log.info(String.format("\u9996\u9875\u4e2a\u4eba\u53ef\u7528\u989d\u5ea6\u5c55\u793a: \u7528\u6237:%d, \u5f53\u524d\u65e5\u671f:%s, \u5728\u989d\u5ea6\u7ef4\u62a4\u8868\u4e2d\u672a\u67e5\u8be2\u7ed3\u679c\u672a:%s", userId, currentLocalDate, SerializationUtils.toJsonString((Object)reimburseAmountDOs)));
        BigDecimal balanceAmountTotal = BigDecimal.ZERO;
        for (DynamicObject reimburseAmountDO : reimburseAmountDOs) {
            DynamicObject companyDO = reimburseAmountDO.getDynamicObject("company");
            DynamicObject expenseItemDO = reimburseAmountDO.getDynamicObject("expenseitem");
            DynamicObject currencyDO = reimburseAmountDO.getDynamicObject("currency");
            ReimburseAmountControlService controlService = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)expenseItemDO.getString("reimburseamountctlmethod")));
            BigDecimal balanceAmount = controlService.getReimburseBalanceAmount((Long)companyDO.getPkValue(), userId, (Long)expenseItemDO.getPkValue(), (Long)currencyDO.getPkValue(), YearMonth.from(currentLocalDate), Collections.emptyList());
            balanceAmountTotal = balanceAmountTotal.add(balanceAmount);
        }
        String[] moneyString = ErCommonUtils.getFormattedMoneyStringWithUnit((BigDecimal)balanceAmountTotal, (int)2);
        Label lab_amount = (Label)this.getControl(LAB_AMOUNT);
        lab_amount.setText(moneyString[0]);
        Label lab_currencyunit = (Label)this.getControl("lab_currencyunit");
        lab_currencyunit.setText(moneyString[1]);
    }

    public void click(EventObject evt) {
        Control control;
        Object source = evt.getSource();
        if (source instanceof Control && StringUtils.equals((CharSequence)(control = (Control)source).getKey(), (CharSequence)LAB_AMOUNT)) {
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("er_employee_amount_query");
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)reportShowParameter);
        }
    }
}

