/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class FeeStandardListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(FeeStandardListPlugin.class);
    private static final String BARCONTROL = "bar_control";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BARCONTROL, "summarycontrol", "cancelsummarycontrol"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        Object source = evt.getSource();
        if (source instanceof Donothing) {
            String operateKey = evt.getOperateKey();
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ListView view = (ListView)this.getView();
            if (StringUtils.equalsIgnoreCase((CharSequence)"summarycontrol", (CharSequence)operateKey)) {
                if (!this.canSummaryControl(selectedRows, (IFormView)view)) {
                    return;
                }
                try {
                    this.setStandardsToSelectedBill(selectedRows);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u6807\u51c6\u6210\u529f\u3002", (String)"FeeStandardListPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    view.refresh();
                }
                catch (Exception e) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u6807\u51c6\u5931\u8d25\u3002", (String)"FeeStandardListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    logger.error("setStandardsToSelectedBill>>>", (Throwable)e);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"cancelsummarycontrol", (CharSequence)operateKey)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("cancelsummarycontrol", (IFormPlugin)this);
                view.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u53d6\u6d88\u5173\u8054\u5417\uff1f", (String)"FeeStandardListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"cancelsummarycontrol", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ListView view = (ListView)this.getView();
            try {
                this.removeStandardsToSelectedBill(selectedRows);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\u3002", (String)"FeeStandardListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                view.refresh();
            }
            catch (Exception e) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u5931\u8d25\u3002", (String)"FeeStandardListPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                logger.error("removeStandardsToSelectedBill>>>", (Throwable)e);
            }
        }
    }

    private void setStandardsToSelectedBill(ListSelectedRowCollection selectedRows) {
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues == null || primaryKeyValues.length == 0) {
            return;
        }
        DynamicObject[] selectBills = BusinessDataServiceHelper.load((String)"er_standard", (String)"summarycontrol,relatedstandard", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        if (selectBills.length > 0) {
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    DynamicObjectCollection relatedstandards;
                    for (DynamicObject selectBill : selectBills) {
                        relatedstandards = selectBill.getDynamicObjectCollection("relatedstandard");
                        relatedstandards.clear();
                        selectBill.set("relatedstandard", (Object)relatedstandards);
                    }
                    SaveServiceHelper.save((DynamicObject[])selectBills);
                    for (DynamicObject selectBill : selectBills) {
                        relatedstandards = selectBill.getDynamicObjectCollection("relatedstandard");
                        if (relatedstandards.isEmpty()) {
                            relatedstandards.addNew();
                        }
                        DynamicObjectType standardType = (DynamicObjectType)((DynamicObject)relatedstandards.get(0)).getDataEntityType();
                        for (Object r : primaryKeyValues) {
                            DynamicObject tmpDynamicObject = new DynamicObject(standardType);
                            tmpDynamicObject.set("fbasedataid", r);
                            tmpDynamicObject.set("FBASEDATAID_id", r);
                            relatedstandards.add((Object)tmpDynamicObject);
                        }
                        selectBill.set("relatedstandard", (Object)relatedstandards);
                        selectBill.set("summarycontrol", (Object)Boolean.TRUE);
                    }
                    SaveServiceHelper.save((DynamicObject[])selectBills);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.error("----\u5f00\u542f\u6c47\u603b\u63a7\u5236\u5f02\u5e38\u62a5\u9519----", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("----\u5f00\u542f\u6c47\u603b\u63a7\u5236\u5f02\u5e38\u62a5\u9519----", (Throwable)e);
            }
        }
    }

    private void removeStandardsToSelectedBill(ListSelectedRowCollection selectedRows) {
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues == null || primaryKeyValues.length == 0) {
            return;
        }
        Collection selectBills = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"er_standard").values();
        if (!selectBills.isEmpty()) {
            DynamicObject[] billList;
            HashSet<Long> ids = new HashSet<Long>();
            for (DynamicObject selectBill : selectBills) {
                DynamicObjectCollection relatedstandards = selectBill.getDynamicObjectCollection("relatedstandard");
                if (relatedstandards == null || relatedstandards.size() <= 0) continue;
                for (DynamicObject relatedstandard : relatedstandards) {
                    if (relatedstandard == null) continue;
                    ids.add(relatedstandard.getLong("FBASEDATAID_id"));
                }
            }
            if (!ids.isEmpty() && (billList = BusinessDataServiceHelper.load((String)"er_standard", (String)"summarycontrol,relatedstandard", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})).length > 0) {
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        for (DynamicObject bill : billList) {
                            bill.set("summarycontrol", (Object)Boolean.FALSE);
                            bill.set("relatedstandard", null);
                        }
                        SaveServiceHelper.save((DynamicObject[])billList);
                    }
                    catch (Exception e) {
                        txHandle.markRollback();
                        logger.error("----\u53d6\u6d88\u6c47\u603b\u63a7\u5236\u5f02\u5e38\u62a5\u9519----", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("----\u53d6\u6d88\u6c47\u603b\u63a7\u5236\u5f02\u5e38\u62a5\u9519----", (Throwable)e);
                }
            }
        }
    }

    public boolean canSummaryControl(ListSelectedRowCollection selectedRows, IFormView view) {
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues == null || primaryKeyValues != null && primaryKeyValues.length < 2) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c112\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FeeStandardListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Collection selectBills = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"er_standard").values();
        if (!selectBills.isEmpty()) {
            Set currencyset = selectBills.stream().map(v -> v.get("currency") != null ? ((DynamicObject)v.get("currency")).getPkValue() : null).collect(Collectors.toSet());
            Set createorgSet = selectBills.stream().map(v -> v.get("createorg") != null ? ((DynamicObject)v.get("createorg")).getPkValue() : null).collect(Collectors.toSet());
            Set ctlperiodSet = selectBills.stream().map(v -> !StringUtils.isEmpty((CharSequence)v.getString("ctlperiod")) ? v.getString("ctlperiod") : "").collect(Collectors.toSet());
            Set ctlnumberSet = selectBills.stream().map(v -> v.getInt("ctlnumber")).collect(Collectors.toSet());
            Set opensummarycontrolSet = selectBills.stream().filter(m -> m.getBoolean("summarycontrol")).map(v -> v.getBoolean("summarycontrol")).collect(Collectors.toSet());
            Set summarycontrolSet = selectBills.stream().map(v -> v.getBoolean("summarycontrol")).collect(Collectors.toSet());
            Set actualreimexpenseSet = selectBills.stream().map(v -> v.getBoolean("actualreimexpense")).collect(Collectors.toSet());
            if (opensummarycontrolSet != null && opensummarycontrolSet.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u51c6\u5df2\u88ab\u5173\u8054\uff0c\u8bf7\u5148\u53d6\u6d88\u5173\u8054\u3002", (String)"FeeStandardListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            Set openActualreimSet = selectBills.stream().filter(m -> m.getBoolean("actualreimexpense")).map(v -> v.getBoolean("actualreimexpense")).collect(Collectors.toSet());
            if (openActualreimSet != null && openActualreimSet.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u5b9e\u62a5\u5b9e\u9500\u6570\u636e\uff0c\u4e0d\u5141\u5f00\u542f\u6c47\u603b\u63a7\u5236\u3002", (String)"FeeStandardListPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            if (currencyset.size() != 1 || createorgSet.size() != 1 || ctlperiodSet.size() != 1 || ctlnumberSet.size() != 1 || summarycontrolSet.size() != 1 || actualreimexpenseSet.size() != 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u3001\u5e01\u79cd\u3001\u63a7\u5236\u5468\u671f\u3001\u62a5\u9500\u9891\u7387\u3001\u6c47\u603b\u63a7\u5236\u53ca\u5b9e\u62a5\u5b9e\u9500\u5b57\u6bb5\u503c\u987b\u76f8\u540c\u3002", (String)"FeeStandardListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

