/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control.mob;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClientCallBackEvent;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.formplugin.amount.control.AbstractFeeStandardControlFormPlugin;
import kd.fi.er.formplugin.daily.web.iface.ICurrencyCalculator;
import org.apache.commons.lang3.StringUtils;

public class FeeStandardControlFormPluginSecondPageMob
extends AbstractFeeStandardControlFormPlugin
implements ICurrencyCalculator {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Object reimburselevel_bill;
        super.afterCreateNewData(e);
        this.copyValue("bizitem");
        List collectDimension = FeeStandardHelper.collectDimension((DynamicObject)this.getBizItem());
        Set<String> copyValueFields = FeeStandardControlFormPluginSecondPageMob.getCopyValueFields();
        for (String field : collectDimension) {
            if (!FeeStandardHelper.headProp((IDataModel)this.getModel(), (String)field)) continue;
            copyValueFields.add(field);
        }
        this.copyValue(copyValueFields.toArray(new String[0]));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (!params.containsKey("entryedit") && !params.containsKey("index") && (reimburselevel_bill = this.getModel().getValue("reimburselevel_bill")) != null) {
            this.changeEntryReimburseLevel(reimburselevel_bill);
        }
    }

    private static Set<String> getCopyValueFields() {
        HashSet copyValueFields = Sets.newHashSetWithExpectedSize((int)16);
        copyValueFields.add("company");
        copyValueFields.add("openfeestand");
        copyValueFields.add("reimbursetype");
        copyValueFields.add("applier");
        copyValueFields.add("cityarea_bill");
        copyValueFields.add("daysnum_bill");
        copyValueFields.add("escortnum_bill");
        copyValueFields.add("meetgrade_bill");
        copyValueFields.add("meettype_bill");
        copyValueFields.add("reimburselevel_bill");
        copyValueFields.add("treatnum_bill");
        copyValueFields.add("treattype_bill");
        copyValueFields.add("bizitem");
        return copyValueFields;
    }

    private void copyValue(String ... fields) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            for (String field : fields) {
                this.getModel().setValue(field, parentView.getModel().getValue(field));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.headCurrencyControlPageRules();
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldMustInput((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldNameForMob((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldHidden((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
    }

    private void headCurrencyControlPageRules() {
        Control control = this.getView().getControl("expenseentryentity");
        if (control instanceof CardEntry) {
            if (!this.getOpenFeeStand().booleanValue()) {
                ((CardEntry)control).setChildVisible(false, -1, new String[]{"feestandcurrency", "feeexchangerate", "curothercontrolamt", "curotherfeeamount", "curcontrolamt", "othercontrolamt", "otherfeeamount", "controlamt"});
            } else if (FeeStandardHelper.headCurrencyControl()) {
                ((CardEntry)control).setChildVisible(false, -1, new String[]{"othercontrolamt", "otherfeeamount", "controlamt"});
            } else {
                ((CardEntry)control).setChildVisible(false, -1, new String[]{"feestandcurrency", "feeexchangerate", "curothercontrolamt", "curotherfeeamount", "curcontrolamt"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BillSettingRuleUtil.setFieldLockByExprWhenPropertyChange((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView(), (String)propName, (int)rowIndex);
        if ("wineway".equals(propName) && (e.getChangeSet()[0].getNewValue() == null || StringUtils.isBlank((CharSequence)e.getChangeSet()[0].getNewValue().toString()))) {
            this.getModel().setValue("wineway", (Object)"3");
        } else if ("feestandcurrency".equals(propName)) {
            Object propNewValue = e.getChangeSet()[0].getNewValue();
            if (propNewValue != null) {
                this.refreshExchangeRate(this.getModel(), (DynamicObject)propNewValue, "feeexchangerate", "feequotetype", rowIndex);
            }
        } else if ("entrycurrency".equals(propName)) {
            Object propNewValue = e.getChangeSet()[0].getNewValue();
            if (propNewValue != null && !FeeStandardHelper.headCurrencyControl()) {
                this.getModel().setValue("feestandcurrency", propNewValue, rowIndex);
            }
        } else if ("feeexchangerate".equals(propName) || "controlamt".equals(propName) || "othercontrolamt".equals(propName)) {
            BigDecimal controlAmt = (BigDecimal)this.getModel().getValue("controlamt", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)controlAmt, (String)"curcontrolamt", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
            BigDecimal otherControlAmt = (BigDecimal)this.getModel().getValue("othercontrolamt", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)otherControlAmt, (String)"curothercontrolamt", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
        } else if ("otherfeeamount".equals(propName)) {
            BigDecimal otherFeeAmount = (BigDecimal)this.getModel().getValue("otherfeeamount", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)otherFeeAmount, (String)"curotherfeeamount", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
        }
        if (this.getOpenFeeStand().booleanValue()) {
            this.calcControlAmt(propName, rowIndex);
            if ("currency".equals(propName) || "expenseitem".equals(propName) || "feestandcurrency".equals(propName) || this.matchDimensions(propName, this.getCurDimensions())) {
                this.fireRefreshFeeStandard(rowIndex);
            } else if ("controlamt".equals(propName) || "curcontrolamt".equals(propName) || "othercontrolamt".equals(propName) || "curothercontrolamt".equals(propName) || "expeapproveamount".equals(propName) || "expeapprovecurramount".equals(propName) || "otherfeeamount".equals(propName) || "curotherfeeamount".equals(propName) || "otherstandamount".equals(propName) || "wineway".equals(propName)) {
                this.calcIsOverStd(rowIndex);
            } else if ("feestandid".equals(propName)) {
                this.calcOtherStandAmt(rowIndex);
            }
            if ("redml".equals(propName) || "whiteml".equals(propName)) {
                this.calcOtherStandAmt(rowIndex);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        this.commonCallBack(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.setDefaultReimburselevel(e);
        this.setDefaultFeeStandCurrency(e);
        this.headCurrencyControlPageRules();
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldHidden((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
    }
}

