/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.bill.publicreimbursebill;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.publicbiz.bill.publicreim.PublicReimBillEdit;
import org.apache.commons.lang.StringUtils;

public class PublicReimburseExpenseMobFormPlugin
extends AbstractMobFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(PublicReimburseExpenseMobFormPlugin.class);

    public void registerListener(EventObject e) {
        if (this.getControl("expenseentryentity") != null) {
            ((EntryGrid)this.getControl("expenseentryentity")).addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel parentModel = parentView.getModel();
            IDataModel model = view.getModel();
            Object detailType = parentModel.getValue("detailtype");
            model.setValue("detailtype", detailType);
            String writeofftype = (String)parentModel.getValue("writeofftype");
            model.setValue("writeofftype", (Object)writeofftype);
            boolean drawProject = "biztype_project".equals(detailType);
            view.setVisible(Boolean.valueOf(!drawProject), new String[]{"buttonap"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        if (view != null && view.getParentView() != null && ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
            this.getModel().setValue("isenableinvoice", view.getParentView().getModel().getValue("isenableinvoice"));
            this.getModel().setValue("automapinvoice", view.getParentView().getModel().getValue("automapinvoice"));
            this.getModel().setValue("projecttype", view.getParentView().getModel().getValue("projecttype"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "expeapproveamount": 
            case "expeapprovecurramount": {
                PublicReimBillEdit.recountWriteBackAmount(model, rowIndex);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        IFormView view = this.getView();
        int parentIndex = -1;
        FormShowParameter param = view.getFormShowParameter();
        Long sourceBillId = 0L;
        String billType = "";
        IDataModel parentModel = null;
        if (param != null && param.getCustomParam("index") != null && view.getViewNoPlugin(param.getParentPageId()) != null && view.getViewNoPlugin(param.getParentPageId()).getModel() != null) {
            parentIndex = (Integer)param.getCustomParam("index");
            parentModel = view.getViewNoPlugin(param.getParentPageId()).getModel();
        }
        if ((StringUtils.equals((String)"entrycontractno", (String)fieldName) || StringUtils.equals((String)"entrycontractname", (String)fieldName) || StringUtils.equals((String)"entryprojectno", (String)fieldName)) && parentModel != null && parentIndex != -1) {
            billType = (String)parentModel.getValue("wbsrcbilltype", parentIndex);
            sourceBillId = (Long)parentModel.getValue("wbsrcbillid", parentIndex);
            if (StringUtils.equals((String)"contract", (String)billType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u6682\u4e0d\u652f\u6301\u67e5\u770b\u9879\u76ee\u4e91\u5408\u540c\u3002", (String)"PublicReimBillEdit_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject contractObject;
                if (StringUtils.equals((String)"entryprojectno", (String)fieldName)) {
                    if (!StringUtils.isBlank((String)billType) && !billType.endsWith("_mob")) {
                        billType = "project".equals(billType) ? "er_applyprojectbill_mob" : billType + "_mob";
                    }
                } else if (!StringUtils.isEmpty((String)((String)parentModel.getValue("entrycontractno", parentIndex))) && (contractObject = QueryServiceHelper.queryOne((String)"er_contractbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("contractcode", "=", parentModel.getValue("entrycontractno", parentIndex))})) != null) {
                    billType = "er_contractbill_mob";
                    sourceBillId = (Long)contractObject.get("id");
                }
                this.openLinkClick(sourceBillId, billType, "1GARA29DA8+R");
            }
        }
    }

    protected void openLinkClick(Long sourceBillId, String billType, String appId) {
        try {
            if (sourceBillId == null || sourceBillId == 0L || StringUtils.isBlank((String)billType)) {
                return;
            }
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("FormId", billType);
            customParam.put("Status", BillOperationStatus.VIEW.getValue());
            customParam.put("hiddenmtoolbarap", Boolean.TRUE.toString());
            customParam.put("billId", sourceBillId);
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            if (!StringUtils.isBlank((String)appId)) {
                formShowParameter.setAppId(appId);
            }
            formShowParameter.setCustomParams(customParam);
            formShowParameter.setFormId("er_dlbill_tabap_inh");
            formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)billType).getCaption().getLocaleValue());
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6570\u636e\u53d1\u751f\u5f02\u5e38\u3002", (String)"PublicReimListPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            log.error("openLinkClick error", (Object)e.getMessage());
        }
    }
}

