/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp;

import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ErBillToAccountChangeBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Map<String, String> ORIGIN_CHANGE_PROP_MAP;
    private static final String FINAPBILL_ENTITYID = "ap_finapbill";
    private static final String APPLYPAY_ENTITYID = "er_applypaybill";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        Long[] billIDs = (Long[])selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).toArray(Long[]::new);
        String srcBillType = this.getSrcMainType().getName();
        DynamicObjectCollection query = QueryServiceHelper.query((String)srcBillType, (String)"id,company", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIDs)});
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (int i = 0; i < query.size(); ++i) {
            multiMap.put((Object)((DynamicObject)query.get(i)).getLong("company"), (Object)((DynamicObject)query.get(i)).getLong("id"));
        }
        List custQFilters = e.getCustQFilters();
        if (!multiMap.isEmpty()) {
            Set keySet = multiMap.keySet();
            for (Long companyid : keySet) {
                if (!ErCommonUtils.storageLimits((Long)companyid, (String)srcBillType)) continue;
                e.setCustFilterDesc(ResManager.loadKDString((String)"\u9009\u4e2d\u5355\u636e\u6ca1\u6709\u6536\u6b3e\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4", (String)"ErBillToAccountChangeBillConvertPlugin_storageLimits", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCustFilterExpression(String.format("id not in (%s)", StringUtils.join((Iterable)multiMap.get((Object)companyid), (String)",")));
                custQFilters.add(new QFilter("id", "not in", (Object)multiMap.get((Object)companyid)));
                return;
            }
        }
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)srcBillType, (Long[])billIDs, null);
        Long tableID = EntityMetadataCache.loadTableDefine((String)"er_accountchangebill", (String)"originalentry").getTableId();
        Set exsitPushEntry = bfRows.stream().filter(bfRow -> bfRow.getId().getTableId().compareTo(tableID) == 0).map(bfRow -> bfRow.getId().getEntryId()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("originalentry.id", "in", exsitPushEntry);
        qFilter.and("billstatus", "not in", (Object)new String[]{"E", "I"});
        DynamicObjectCollection exsitChangeBill = QueryServiceHelper.query((String)"er_accountchangebill", (String)"billno,originalentry.sourceentryid, originalentry.sourcebillno, originalentry.sourcerow", (QFilter[])new QFilter[]{qFilter});
        Set sourceEntryIds = exsitChangeBill.stream().map(row -> Long.valueOf(row.getString("originalentry.sourceentryid"))).collect(Collectors.toSet());
        if (!exsitChangeBill.isEmpty()) {
            String template = ResManager.loadKDString((String)"\u5355\u636e%1$s\u6536\u6b3e\u4fe1\u606f\u7b2c%2$s\u884c\u5b58\u4e0b\u6e38\u5b58\u5728\u9014\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u5355%3$s\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"ErBillToAccountChangeBillConvertPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
            StringBuilder errMsgBuilder = new StringBuilder();
            for (DynamicObject bill : exsitChangeBill) {
                errMsgBuilder.append(String.format(template, bill.getString("originalentry.sourcebillno"), bill.getString("originalentry.sourcerow"), bill.getString("billno")));
                errMsgBuilder.append("\n");
            }
            e.setCustFilterDesc(errMsgBuilder.toString());
            e.setCustFilterExpression(String.format("accountentry.id not in (%s)", StringUtils.join((Object[])sourceEntryIds.toArray(), (String)",")));
            custQFilters.add(new QFilter("accountentry.id", "not in", sourceEntryIds));
            return;
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)srcBillType)) {
            ErChangeAccountConvertUtils.PublicReimBurseBFRowDataHandler handler = ErChangeAccountConvertUtils.PublicReimBurseBFRowDataHandlerBuilder().setBFRow(bfRows).build();
            Map finApbill = handler.getFinApbill();
            if (!finApbill.isEmpty()) {
                String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0b\u6e38\u5b58\u5728\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"ErBillToAccountChangeBillConvertPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                e.setCustFilterDesc(errMsg);
                e.setCustFilterExpression("billstatus = '-1'");
                e.getCustQFilters().add(new QFilter("billstatus", "=", (Object)"-1"));
                return;
            }
            Set canSelectApplyPaybillPks = handler.getAccountEntryAssociateWithApplyPayBill();
            if (!canSelectApplyPaybillPks.isEmpty()) {
                custQFilters.add(new QFilter("billstatus", "=", (Object)"E").or(new QFilter("billstatus", "=", (Object)"F").and(new QFilter("accountentry.buildedamount", "!=", (Object)BigDecimal.ZERO))));
                custQFilters.add(new QFilter("accountentry.id", "in", (Object)canSelectApplyPaybillPks));
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5ba1\u6838\u901a\u8fc7\u3001\u7b49\u5f85\u4ed8\u6b3e\uff08\u5bf9\u5e94\u6536\u6b3e\u5206\u5f55\u7684\u5df2\u51fa\u5355\u91d1\u989d\u4e3a0\u6216\u4e0b\u6e38\u6302\u8d26\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u51fa\u5355\u91d1\u989d\u4e3a0\uff09\uff0c\u624d\u53ef\u4ee5\u8fdb\u884c\u4e0b\u63a8\u53d8\u66f4\u3002", (String)"ErBillToAccountChangeBillConvertPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
                e.setCustFilterDesc(msg);
                e.setCustFilterExpression(String.format("billstatus= 'E' or (billstatus='F' and accountentry.buildedamount!=0) and accountentry.id in (%s)", StringUtils.join((Object[])canSelectApplyPaybillPks.toArray(), (String)",")));
                return;
            }
            QFilter originalQFilter = new QFilter("billstatus", "=", (Object)"E").or(new QFilter("billstatus", "=", (Object)"F").and(new QFilter("accountentry.buildedamount", "=", (Object)BigDecimal.ZERO)));
            e.getCustQFilters().add(originalQFilter);
            e.setCustFilterExpression("billstatus= 'E' or ( billstatus='F' and accountentry.buildedamount=0 )");
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5ba1\u6838\u901a\u8fc7\u3001\u7b49\u5f85\u4ed8\u6b3e\uff08\u5bf9\u5e94\u6536\u6b3e\u5206\u5f55\u7684\u5df2\u51fa\u5355\u91d1\u989d\u4e3a0\uff09\uff0c\u624d\u53ef\u4ee5\u8fdb\u884c\u4e0b\u63a8\u53d8\u66f4\u3002", (String)"ErBillToAccountChangeBillConvertPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedData : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = extendedData.getDataEntity();
            this.createChangeEntry(targetBill);
        }
    }

    private void createChangeEntry(DynamicObject targetBill) {
        int index;
        DynamicObjectCollection changeEntry = targetBill.getDynamicObjectCollection("changeentry");
        DynamicObjectCollection originEntry = targetBill.getDynamicObjectCollection("originalentry");
        for (int i = index = changeEntry.size(); i < originEntry.size(); ++i) {
            DynamicObject originRow = (DynamicObject)originEntry.get(i);
            DynamicObject changeRow = changeEntry.addNew();
            for (Map.Entry<String, String> entry : ORIGIN_CHANGE_PROP_MAP.entrySet()) {
                changeRow.set(entry.getValue(), originRow.get(entry.getKey()));
            }
        }
    }

    static {
        Map<String, String> tamp = Arrays.stream(new String[][]{{"sourcebillno", "changebillno"}, {"sourcerow", "changerow"}, {"payertype", "changepayertype"}, {"payername", "changepayername"}, {"supplier", "changesupplier"}, {"customer", "changecustomer"}, {"casorg", "changecasorg"}, {"payeer", "changepayeer"}, {"payeraccount", "changepayeraccount"}, {"payeraccountname", "changepayeraccountname"}, {"payerbank", "changepayerbank"}, {"sourcecurrency", "changecurrency"}, {"sourceamount", "changeamount"}, {"sourcebillid", "changebillid"}, {"sourceentryid", "changeentryid"}, {"sourcebilltype", "changebilltype"}}).collect(Collectors.toMap(entry -> entry[0], entry -> entry[1]));
        ORIGIN_CHANGE_PROP_MAP = Collections.unmodifiableMap(tamp);
    }
}

