/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class LoanToRepayMentConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().getName());
        List<Long> appliers = Stream.of(billDataEntitys).map(v -> v.getDataEntity().getLong("applier.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> payerMap = this.getDefautPayerInfo(appliers);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject payerInfo;
            DynamicObject repaymentbill = billDataEntity.getDataEntity();
            String payername = repaymentbill.getString("payername");
            if ((payername == null || StringUtils.equalsIgnoreCase((CharSequence)"", (CharSequence)payername)) && (payerInfo = payerMap.get(repaymentbill.getLong("applier.id"))) != null) {
                repaymentbill.set("payer", (Object)payerInfo);
                repaymentbill.set("payerbank", payerInfo.get("payerbank"));
                repaymentbill.set("payeraccount", payerInfo.get("payeraccount"));
                repaymentbill.set("payername", payerInfo.get("outpayer"));
                repaymentbill.set("payeraccountname", payerInfo.get("payeraccountname"));
            }
            DynamicObject company = (DynamicObject)repaymentbill.get("company");
            DynamicObject costCompany = (DynamicObject)repaymentbill.get("costCompany");
            Long currnecyId = ErCommonUtils.getPk((Object)repaymentbill.get("currency"));
            int exchangeRateFrom = SystemParamterUtil.getExchangeRateFrom((Long)((Long)company.getPkValue()));
            Date curr = null;
            curr = 0 == exchangeRateFrom ? new Date() : (Date)repaymentbill.get("repaymentdate");
            DynamicObjectCollection repaymententry = repaymentbill.getDynamicObjectCollection("repaymententry");
            for (DynamicObject dyn : repaymententry) {
                BigDecimal repayexchangerate = dyn.getBigDecimal("repayexchangerate");
                if (repayexchangerate != null && repayexchangerate.compareTo(BigDecimal.ZERO) != 0) continue;
                Long sourceCurrencyId = (Long)((DynamicObject)dyn.get("accountcurrency")).getPkValue();
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateAndQuoteType((Object)company.getPkValue(), (Object)costCompany.getPkValue(), (Long)sourceCurrencyId, (Long)currnecyId, (Date)curr);
                dyn.set("repayexchangerate", exchangeRateAndQuoteType.get("exchangeRate"));
            }
        }
    }

    private Map<Long, DynamicObject> getDefautPayerInfo(List<Long> appliers) {
        QFilter q1 = new QFilter("payer", "in", appliers);
        QFilter q2 = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_payeer", (String)"outpayer,payer,payerbank,payeraccount, payeraccountname", (QFilter[])new QFilter[]{q1, q2});
        return Stream.of(load).collect(Collectors.toMap(k -> k.getLong("payer.id"), Function.identity(), (payer1, payer2) -> payer1));
    }
}

