/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.tripbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.trip.context.OrderExpenseDetailContext;
import kd.fi.er.business.trip.context.data.ExchangeRateDataKey;
import kd.fi.er.business.trip.context.data.ExchangeRateDataObject;
import kd.fi.er.business.trip.context.data.ExchangeRates;
import kd.fi.er.business.trip.context.data.TripItemDataObject;
import kd.fi.er.business.trip.context.data.TripItems;
import kd.fi.er.business.trip.dailybiz.TripBusinessRelatDailyBusinessUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.botp.tripbill.AbstractTripDefaultToReimburseConvertPlugin;
import org.apache.commons.lang3.StringUtils;

public class TripreqbillToTripreimbursebillConverPlugin
extends AbstractTripDefaultToReimburseConvertPlugin {
    private static final Log logger = LogFactory.getLog(TripreqbillToTripreimbursebillConverPlugin.class);

    @Override
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("tripentrysourceid");
        e.addSrcField("travelers");
    }

    protected void genOrderEntrys(ExtendedDataEntity billDataEntity, Map<String, DynamicProperty> srcfldPro, DynamicObject targetBill) {
        Long time = System.currentTimeMillis();
        List sourceBillRows = (List)billDataEntity.getValue("ConvertSource");
        ArrayList<Long> reqBillIds = new ArrayList<Long>(sourceBillRows.size());
        ArrayList<String> reqBillNos = new ArrayList<String>(sourceBillRows.size());
        for (int i = 0; i < sourceBillRows.size(); ++i) {
            Long reqbillId = (Long)srcfldPro.get("id").getValue(sourceBillRows.get(i));
            String reqbillNo = (String)srcfldPro.get("billno").getValue(sourceBillRows.get(i));
            reqBillIds.add(reqbillId);
            reqBillNos.add(reqbillNo);
        }
        Long companyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company"));
        List notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByReq(reqBillIds, reqBillNos, (Long)companyId);
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return;
        }
        OrderExpenseDetailContext orderExpenseDetailContext = new OrderExpenseDetailContext();
        this.buildExchangeRates(orderExpenseDetailContext, notReimbursedOrderList, targetBill);
        this.buildTripItems(orderExpenseDetailContext, targetBill);
        this.buildTripareaOrgCtrlFilter(orderExpenseDetailContext, targetBill);
        List noTripIdNotReimbursedOrderList = notReimbursedOrderList;
        Map notReimbursedOrderTripIdMap = notReimbursedOrderList.stream().collect(Collectors.groupingBy(v -> v.getString("tripid"), Collectors.mapping(v -> v, Collectors.toList())));
        boolean isShowInvoiceEntry = SystemParamterUtil.getIsShowInvoiceEntry((long)companyId);
        DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
        TripReimburseServiceHelper.adjuestTripEntrys((DynamicObjectCollection)targetTripEntrys);
        List<DynamicObject> currentTripOrders = null;
        Long forBeginTime = System.currentTimeMillis();
        for (int i = 0; i < targetTripEntrys.size(); ++i) {
            DynamicObject targetTripEntry = (DynamicObject)targetTripEntrys.get(i);
            String currentSourcetripid = targetTripEntry.getString("tripentrysourceid");
            Set<Long> travelerIdSet = this.getTargetTravelerIdSet(targetTripEntry);
            if (i > 0 && currentTripOrders != null && !currentSourcetripid.equals(((DynamicObject)targetTripEntrys.get(i - 1)).getString("tripentrysourceid"))) {
                this.initMappingNotExistTravlerOrders(targetBill, (DynamicObject)targetTripEntrys.get(i - 1), currentTripOrders, isShowInvoiceEntry, orderExpenseDetailContext);
            }
            if ((currentTripOrders = notReimbursedOrderTripIdMap.get(currentSourcetripid)) == null || currentTripOrders.size() < 1) continue;
            noTripIdNotReimbursedOrderList.removeAll(currentTripOrders);
            List successInitOrderBills = TripReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)targetTripEntry, travelerIdSet, currentTripOrders, (boolean)isShowInvoiceEntry, null, null, (OrderExpenseDetailContext)orderExpenseDetailContext);
            if (successInitOrderBills.isEmpty()) continue;
            currentTripOrders.removeAll(successInitOrderBills);
        }
        Long forEndTime = System.currentTimeMillis();
        this.dealMealOrderBill(targetBill, noTripIdNotReimbursedOrderList, targetTripEntrys, isShowInvoiceEntry, orderExpenseDetailContext);
        Long mealOrderEndTime = System.currentTimeMillis();
        DynamicObject lastTargetTripEntry = (DynamicObject)targetTripEntrys.get(targetTripEntrys.size() - 1);
        this.initMappingNotExistTravlerOrders(targetBill, lastTargetTripEntry, currentTripOrders, isShowInvoiceEntry, orderExpenseDetailContext);
        Long travlerOrdersFirstEndTime = System.currentTimeMillis();
        DynamicObject firstTargetTripEntry = (DynamicObject)targetTripEntrys.get(0);
        this.initMappingNotExistTravlerOrders(targetBill, firstTargetTripEntry, noTripIdNotReimbursedOrderList, isShowInvoiceEntry, orderExpenseDetailContext);
        Long travlerOrdersSecondEndTime = System.currentTimeMillis();
        TripReimburseServiceHelper.updateBillHeadAmount((DynamicObject)targetBill);
        logger.info("TripreqbillToTripreimbursebillConverPlugin.genOrderEntrys \u51fa\u5dee\u7533\u8bf7\u5355\u4e0b\u63a8\u8017\u8d39 {},spend1:{},spend2:{},spend3:{},spend:{}", new Object[]{System.currentTimeMillis() - time, forEndTime - time, mealOrderEndTime - forEndTime, travlerOrdersFirstEndTime - mealOrderEndTime, travlerOrdersSecondEndTime - travlerOrdersFirstEndTime});
        HashSet<Long> currencySet = new HashSet<Long>();
        Long headCurrencyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("currency"));
        if (null != headCurrencyId) {
            currencySet.add(headCurrencyId);
        }
        for (DynamicObject entry : targetTripEntrys) {
            Long curryid = ErCommonUtils.getPk((Object)entry.get("tripcurrency"));
            if (null == curryid) continue;
            currencySet.add(curryid);
        }
        if (currencySet.size() > 1) {
            targetBill.set("iscurrency", (Object)Boolean.TRUE);
        }
    }

    private void buildExchangeRates(OrderExpenseDetailContext orderExpenseDetailContext, List<DynamicObject> orderList, DynamicObject targetBill) {
        if (null == orderList || orderList.isEmpty() || null == targetBill) {
            return;
        }
        DynamicObject company = targetBill.getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)company);
        DynamicObject tripReimCurrency = targetBill.getDynamicObject("currency");
        Long tripReimCurrencyId = tripReimCurrency == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)tripReimCurrency);
        Object bizDate = targetBill.get("bizdate");
        Date bizDateDate = bizDate == null ? new Date() : (Date)bizDate;
        ExchangeRates exchangeRates = orderExpenseDetailContext.getExchangeRates();
        for (DynamicObject order : orderList) {
            Long costCompanyId;
            Object orderCurrency = order.get("currency");
            Long orderCurrencyId = orderCurrency == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)orderCurrency);
            Object costCompany = order.get("expcommitcomnum");
            Long l = costCompanyId = costCompany == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)costCompany);
            ExchangeRateDataKey exchangeRateDataKey = new ExchangeRateDataKey(companyId.longValue(), costCompanyId.longValue(), orderCurrencyId.longValue(), tripReimCurrencyId.longValue(), bizDateDate);
            if (exchangeRates.exist(exchangeRateDataKey)) continue;
            Map exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)costCompany, (Long)orderCurrencyId, (Long)tripReimCurrencyId, (Object)bizDate);
            ExchangeRateDataObject exchangeRateDataObject = new ExchangeRateDataObject(exchangeRateDataKey, exchangeMap);
            exchangeRates.put(exchangeRateDataObject);
        }
    }

    private void buildTripItems(OrderExpenseDetailContext orderExpenseDetailContext, DynamicObject targetBill) {
        if (null == targetBill) {
            return;
        }
        DynamicObject company = targetBill.getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)company);
        DynamicObject[] tripItemDyObjs = TripBusinessRelatDailyBusinessUtil.getExpenseitemByOrder((Long)companyId);
        if (tripItemDyObjs != null) {
            ArrayList<TripItemDataObject> tripItemlist = new ArrayList<TripItemDataObject>(tripItemDyObjs.length);
            for (DynamicObject tripItem : tripItemDyObjs) {
                String operationType = tripItem.getString("operationtype");
                operationType = operationType == null ? "" : operationType;
                HashSet operationTypeSet = new HashSet();
                Collections.addAll(operationTypeSet, operationType.split(","));
                TripItemDataObject tripItemDataObject = new TripItemDataObject(operationTypeSet, tripItem);
                tripItemlist.add(tripItemDataObject);
            }
            HashMap<Long, ArrayList<TripItemDataObject>> orgTripItemMap = new HashMap<Long, ArrayList<TripItemDataObject>>();
            orgTripItemMap.put(companyId, tripItemlist);
            TripItems TripItems2 = new TripItems(orgTripItemMap);
            orderExpenseDetailContext.setTripItems(TripItems2);
        }
    }

    private void buildTripareaOrgCtrlFilter(OrderExpenseDetailContext orderExpenseDetailContext, DynamicObject targetBill) {
        if (null == targetBill) {
            return;
        }
        DynamicObject company = targetBill.getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)company);
        String orgType = ErCommonUtils.getTripAreaOrgType();
        DynamicObject areaUseOrg = targetBill.getDynamicObject(orgType);
        Long areaUseOrgId = areaUseOrg == null ? Long.valueOf(0L) : ErCommonUtils.getPk((Object)areaUseOrg);
        HashMap<Long, QFilter> tripAreaOrgCtrlFilterMap = new HashMap<Long, QFilter>();
        if (Long.compare(companyId, areaUseOrgId) == 0) {
            QFilter baseFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_triparea", (Long)companyId, (String)"id");
            tripAreaOrgCtrlFilterMap.put(companyId, baseFilter);
        } else {
            QFilter companyIdBaseFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_triparea", (Long)companyId, (String)"id");
            QFilter areaUseOrgIdBaseFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_triparea", (Long)areaUseOrgId, (String)"id");
            tripAreaOrgCtrlFilterMap.put(companyId, companyIdBaseFilter);
            tripAreaOrgCtrlFilterMap.put(areaUseOrgId, areaUseOrgIdBaseFilter);
        }
        orderExpenseDetailContext.setTripAreaOrgCtrlFilterMap(tripAreaOrgCtrlFilterMap);
    }

    private void initMappingNotExistTravlerOrders(DynamicObject targetBill, DynamicObject lastTargetTripEntry, List<DynamicObject> tripOrders, boolean isShowInvoiceEntry, OrderExpenseDetailContext orderExpenseDetailContext) {
        Set<Long> travelerIdSet;
        if (tripOrders == null || tripOrders.isEmpty()) {
            return;
        }
        Set<Long> finalTravelerIdSet = travelerIdSet = this.getTargetTravelerIdSet(lastTargetTripEntry);
        tripOrders.stream().forEach(tripOrder -> {
            Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId((DynamicObject)tripOrder);
            finalTravelerIdSet.add(sourcetravelerId);
        });
        TripReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)lastTargetTripEntry, finalTravelerIdSet, tripOrders, (boolean)isShowInvoiceEntry, null, null, (OrderExpenseDetailContext)orderExpenseDetailContext);
    }

    private Set<Long> getTargetTravelerIdSet(DynamicObject targetTripEntry) {
        DynamicObjectCollection travelers = targetTripEntry.getDynamicObjectCollection("travelers");
        if (travelers == null || travelers.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> travelerIdSet = new HashSet<Long>(travelers.size());
        for (DynamicObject traveler : travelers) {
            Long travelerId = ErCommonUtils.getPk((Object)traveler.get("fbasedataid_id"));
            travelerIdSet.add(travelerId);
        }
        return travelerIdSet;
    }

    private void dealMealOrderBill(DynamicObject targetBill, List<DynamicObject> tripOrders, DynamicObjectCollection targetTripEntrys, boolean isShowInvoiceEntry, OrderExpenseDetailContext orderExpenseDetailContext) {
        if (CollectionUtils.isEmpty(tripOrders)) {
            return;
        }
        ArrayList mealOrderBills = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject orderBill : tripOrders) {
            String orderFormId = orderBill.getDynamicObjectType().getName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_mealbill")) continue;
            mealOrderBills.add(orderBill);
        }
        tripOrders.removeAll(mealOrderBills);
        HashMap<Long, List<DynamicObject>> entryAndOrderBillMap = new HashMap<Long, List<DynamicObject>>(16);
        ArrayList notFitBills = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject mealOrderBill : mealOrderBills) {
            HashMap<String, Long> allMatchMap = new HashMap<String, Long>(2);
            HashMap<String, Long> cityMatchMap = new HashMap<String, Long>(2);
            HashMap<String, Long> dateMatchMap = new HashMap<String, Long>(2);
            Date happendDate = mealOrderBill.getDate("happenddate");
            String mealCityName = mealOrderBill.getString("mealcityname");
            String orderNum = mealOrderBill.getString("ordernum");
            for (DynamicObject targetTripEntry : targetTripEntrys) {
                DynamicObject toCity = (DynamicObject)targetTripEntry.get("to");
                String toCityName = "";
                if (toCity != null) {
                    toCityName = toCity.getLocaleString("name").getLocaleValue();
                }
                Date startDate = targetTripEntry.getDate("startdate");
                Date endDate = targetTripEntry.getDate("enddate");
                Long pk = targetTripEntry.getLong("tripentrysourceid");
                boolean fitCity = this.judgeCity(mealCityName, toCityName);
                boolean fitDate = this.judgeDate(startDate, endDate, happendDate);
                if (fitCity && fitDate) {
                    allMatchMap.put(orderNum, pk);
                    break;
                }
                if (fitCity) {
                    cityMatchMap.put(orderNum, pk);
                    continue;
                }
                if (!fitDate) continue;
                dateMatchMap.put(orderNum, pk);
            }
            if (allMatchMap.containsKey(orderNum)) {
                this.putDataToMap((Long)allMatchMap.get(orderNum), mealOrderBill, entryAndOrderBillMap);
                continue;
            }
            if (cityMatchMap.containsKey(orderNum)) {
                this.putDataToMap((Long)cityMatchMap.get(orderNum), mealOrderBill, entryAndOrderBillMap);
                continue;
            }
            if (dateMatchMap.containsKey(orderNum)) {
                this.putDataToMap((Long)dateMatchMap.get(orderNum), mealOrderBill, entryAndOrderBillMap);
                continue;
            }
            notFitBills.add(mealOrderBill);
        }
        if (CollectionUtils.isNotEmpty((Collection)notFitBills)) {
            this.initMappingNotExistTravlerOrders(targetBill, (DynamicObject)targetTripEntrys.get(0), notFitBills, isShowInvoiceEntry, orderExpenseDetailContext);
        }
        Set entries = entryAndOrderBillMap.entrySet();
        for (Map.Entry entry : entries) {
            Long pk = (Long)entry.getKey();
            DynamicObject tripEntry = targetTripEntrys.stream().filter(dynamicObject -> Objects.equals(dynamicObject.getLong("tripentrysourceid"), pk)).findFirst().get();
            this.initMappingNotExistTravlerOrders(targetBill, tripEntry, (List)entryAndOrderBillMap.get(pk), isShowInvoiceEntry, orderExpenseDetailContext);
        }
    }

    private void putDataToMap(Long pk, DynamicObject mealOrderBill, Map<Long, List<DynamicObject>> entryAndOrderBillMap) {
        if (!entryAndOrderBillMap.containsKey(pk)) {
            ArrayList bills = Lists.newArrayListWithCapacity((int)16);
            bills.add(mealOrderBill);
            entryAndOrderBillMap.put(pk, bills);
            return;
        }
        List<DynamicObject> dynamicObjects = entryAndOrderBillMap.get(pk);
        dynamicObjects.add(mealOrderBill);
        entryAndOrderBillMap.put(pk, dynamicObjects);
    }

    private boolean judgeDate(Date startDate, Date endDate, Date happendDate) {
        return happendDate.before(endDate) && happendDate.after(startDate);
    }

    private boolean judgeCity(String mealCityName, String toCityName) {
        if (TripreqbillToTripreimbursebillConverPlugin.judgeCityName(mealCityName)) {
            mealCityName = mealCityName.substring(0, mealCityName.length() - 1);
        }
        if (TripreqbillToTripreimbursebillConverPlugin.judgeCityName(toCityName)) {
            toCityName = toCityName.substring(0, toCityName.length() - 1);
        }
        return StringUtils.equals((CharSequence)mealCityName, (CharSequence)toCityName);
    }

    private static boolean judgeCityName(String cityName) {
        return cityName.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"CitySuffix_0", (String)"fi-er-business", (Object[])new Object[0])) || cityName.endsWith(ResManager.loadKDString((String)"\u533a", (String)"CitySuffix_1", (String)"fi-er-business", (Object[])new Object[0])) || cityName.endsWith(ResManager.loadKDString((String)"\u53bf", (String)"CitySuffix_2", (String)"fi-er-business", (Object[])new Object[0])) || cityName.endsWith(ResManager.loadKDString((String)"\u81ea\u6cbb\u533a", (String)"CitySuffix_3", (String)"fi-er-business", (Object[])new Object[0]));
    }
}

