/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;

public class ErDailyReimSelectBillPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ENTRY_NAME = "entryentity";
    private static final String algoKey = ErDailyReimSelectBillPlugin.class.getName();

    public void afterCreateNewData(EventObject e) {
        int[] rowIndexs;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue("writeofftype", this.getView().getFormShowParameter().getCustomParam("writeofftype"));
        List<Map<String, Object>> bills = this.getBillList();
        if (bills == null || bills.isEmpty()) {
            return;
        }
        for (int rowIndex : rowIndexs = model.batchCreateNewEntryRow(ENTRY_NAME, bills.size())) {
            Map<String, Object> row = bills.get(rowIndex);
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                model.setValue(entry.getKey(), entry.getValue(), rowIndex);
            }
        }
    }

    private List<Map<String, Object>> getBillList() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List entityList = (List)formShowParameter.getCustomParam("filterentity");
        try (DataSet resultDataSet = this.getUpEntityData(entityList);){
            if (resultDataSet != null) {
                Map customParam = (Map)formShowParameter.getCustomParam("filterbill");
                Field[] fields = resultDataSet.getRowMeta().getFields();
                Iterator iterator = resultDataSet.iterator();
                HashMap showDataMap = new HashMap();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    List selectEntryids = (List)customParam.get(row.getString("billid"));
                    if (selectEntryids != null && selectEntryids.size() > 0 && selectEntryids.contains(row.getLong("entryid")) || row.getBigDecimal("orgibalanceamount").compareTo(BigDecimal.ZERO) == 0) continue;
                    int mapSize = 10;
                    HashMap<String, Object> rowValue = new HashMap<String, Object>(mapSize);
                    for (Field field : fields) {
                        String name = field.getName();
                        rowValue.put(name, row.get(name));
                    }
                    Long billid = (Long)row.get("billid");
                    if (showDataMap.get(billid) != null) {
                        ((List)showDataMap.get(billid)).add(rowValue);
                        continue;
                    }
                    ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                    list.add(rowValue);
                    showDataMap.put(billid, list);
                }
                for (Map.Entry entry : showDataMap.entrySet()) {
                    List showList = (List)entry.getValue();
                    if (showList == null || showList.isEmpty()) continue;
                    result.addAll(showList);
                }
            }
        }
        return result;
    }

    private DataSet getUpEntityData(List<String> entityList) {
        DataSet result = null;
        for (String entityName : entityList) {
            if (result == null) {
                result = this.queryEntitydata(entityName);
                continue;
            }
            result = result.union(this.queryEntitydata(entityName));
        }
        return result;
    }

    protected DataSet queryEntitydata(String entityName) {
        DataSet result = null;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object company = formShowParameter.getCustomParam("company");
        Object costCompany = formShowParameter.getCustomParam("costcompany");
        Object currency = formShowParameter.getCustomParam("currency");
        Object applier = formShowParameter.getCustomParam("applier");
        Object org = formShowParameter.getCustomParam("org");
        QFilter companyFilter = this.getParamFilter(applier, company, costCompany, org);
        if (currency != null) {
            companyFilter.and("currency", "=", currency);
        }
        if (entityName.equalsIgnoreCase("er_dailyloanbill")) {
            String detailtype;
            IDataModel pModel;
            IFormView parentView;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(new QFilter("billstatus", "=", (Object)"G"), new QFilter("expenseentryentity.orgiexpebalanceamount", "<>", (Object)0)));
            filters.add(companyFilter);
            String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
            if ("2".equals(applyprojectbillRelated) && (parentView = this.getView().getParentView()) != null && (pModel = parentView.getModel()) != null && ErEntityTypeUtils.isPublicReimburseBill((String)parentView.getEntityId()) && "biztype_project".equals(detailtype = (String)pModel.getValue("detailtype"))) {
                DynamicObjectCollection expenseEntrys = pModel.getEntryEntity("expenseentryentity");
                Set projectNoList = expenseEntrys.stream().map(exp -> exp.getString("entryprojectno")).collect(Collectors.toSet());
                filters.add(new QFilter("expenseentryentity.applyprojectno", "in", projectNoList));
            }
            result = QueryServiceHelper.queryDataSet((String)(algoKey + ".one"), (String)"er_dailyloanbill", (String)"id as billid, billno, description as reason, currency.id as currency, expenseentryentity.id as entryid, 'expenseentryentity' as entrykey,expenseentryentity.entrycostdept as costdept,expenseentryentity.entrycostcompany as costcompany, expenseentryentity.expenseitem as expitem, expenseentryentity.entrycurrency as oricurrency, expenseentryentity.exchangerate as exchangerate,expenseentryentity.orgiexpebalanceamount as orgibalanceamount, expenseentryentity.expebalanceamount as balanceamount , 'er_dailyloanbill' as formtype", (QFilter[])filters.toArray(new QFilter[0]), null);
        } else if (entityName.equalsIgnoreCase("er_tripreqbill")) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(new QFilter("billstatus", "=", (Object)"G"), new QFilter("tripentry.oriaccbalanceamount", "<>", (Object)0)));
            filters.add(companyFilter);
            result = QueryServiceHelper.queryDataSet((String)(algoKey + ".two"), (String)"er_tripreqbill", (String)"id as billid, billno, description as reason, currency.id as currency, tripentry.id as entryid, 'tripentry' as entrykey,tripentry.entrycostdept as costdept,tripentry.entrycostcompany as costcompany,tripentry.tripexpenseitem as expitem, tripentry.tripcurrency as oricurrency, tripentry.tripexchangerate as exchangerate,tripentry.oriaccbalanceamount as orgibalanceamount, tripentry.accbalanceamount as balanceamount, 'er_tripreqbill' as formtype", (QFilter[])filters.toArray(new QFilter[0]), null);
        }
        return result;
    }

    private QFilter getParamFilter(Object companyID, Object costCompany) {
        Long comId = companyID instanceof Integer ? Long.valueOf(((Integer)companyID).longValue()) : (Long)companyID;
        String range = SystemParamterUtil.getLoanDrawRange((Long)comId);
        if (range.equals("0")) {
            return new QFilter("company", "=", (Object)comId);
        }
        return new QFilter("costcompany", "=", costCompany);
    }

    private QFilter getParamFilter(Object applierId, Object companyID, Object costCompany, Object orgID) {
        Long comId = companyID instanceof Integer ? Long.valueOf(((Integer)companyID).longValue()) : (Long)companyID;
        String range = SystemParamterUtil.getLoanDrawRange((Long)comId);
        if (range.equals("0")) {
            return new QFilter("company", "=", (Object)comId).and(new QFilter("applier", "=", applierId).or(new QFilter("projectower.FBASEDATAID_id", "in", applierId)));
        }
        if (range.equals("1")) {
            return new QFilter("costcompany", "=", costCompany).and(new QFilter("applier", "=", applierId).or(new QFilter("projectower.FBASEDATAID_id", "in", applierId)));
        }
        return new QFilter("org", "=", orgID);
    }

    private QFilter getProjectOwerFilter(FormShowParameter formShowParameter) {
        return new QFilter("projectower.FBASEDATAID_id", "in", formShowParameter.getCustomParam("applier"));
    }

    protected QFilter[] getTripLoanFilters(FormShowParameter formShowParameter, Object company) {
        return new QFilter[]{new QFilter("applier", "=", formShowParameter.getCustomParam("applier")).or(this.getProjectOwerFilter(formShowParameter)), new QFilter("billstatus", "=", (Object)"G")};
    }

    protected QFilter[] getDailyLoanFilters(FormShowParameter formShowParameter, Object company) {
        return new QFilter[]{new QFilter("applier", "=", formShowParameter.getCustomParam("applier")).or(this.getProjectOwerFilter(formShowParameter)), new QFilter("billstatus", "=", (Object)"G"), new QFilter("relatedbiz", "=", formShowParameter.getCustomParam("relatedbiz")), new QFilter("expenseentryentity.orgiexpebalanceamount", "<>", (Object)0)};
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_ok": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_NAME);
                int[] rowIndexs = entryGrid.getSelectRows();
                if (rowIndexs != null && rowIndexs.length > 0) {
                    this.getView().returnDataToParent(this.getAllSelectRows(rowIndexs));
                }
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }

    private Map<String, ListSelectedRowCollection> getAllSelectRows(int[] rowIndexs) {
        IDataModel model = this.getModel();
        HashMap<String, ListSelectedRowCollection> returnData = new HashMap<String, ListSelectedRowCollection>();
        int index = 0;
        for (int i : rowIndexs) {
            String formType = (String)model.getValue("formtype", i);
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData.get(formType);
            if (listSelectedRowCollection == null) {
                listSelectedRowCollection = new ListSelectedRowCollection();
                returnData.put(formType, listSelectedRowCollection);
            }
            ListSelectedRow listSelectedRow = new ListSelectedRow(model.getValue("billid", i), Boolean.TRUE);
            listSelectedRow.setBillNo((String)model.getValue("billno", i));
            listSelectedRow.setEntryEntityKey((String)model.getValue("entrykey", i));
            listSelectedRow.setEntryPrimaryKeyValue(model.getValue("entryid", i));
            listSelectedRow.setPageIndex(0);
            listSelectedRow.setRowKey(index++);
            listSelectedRow.setFormID(formType);
            listSelectedRowCollection.add((Object)listSelectedRow);
        }
        return returnData;
    }
}

