/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.RepaymentAssociateUtil;

public class ErReapymentSelectBillPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ENTRY_NAME = "entryentity";
    private static final String STATUS_EDIT = "edit";
    private static final String STATUS_LIST = "list";
    private int[] rowIndex = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_ok": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_NAME);
                int[] rowIndexs = entryGrid.getSelectRows();
                if (rowIndexs != null) {
                    this.getView().returnDataToParent(this.getSelectData(rowIndexs));
                }
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }

    private Object getSelectData(int[] rowIndexs) {
        ArrayList recBillInfos = Lists.newArrayListWithExpectedSize((int)2);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_NAME);
        for (int row : rowIndexs) {
            recBillInfos.add(collection.get(row));
        }
        return recBillInfos;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject repaymentBill;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String selType = (String)this.getView().getFormShowParameter().getCustomParam("selType");
        Object srcBillId = this.getView().getFormShowParameter().getCustomParam("repaymentbillId");
        if (!srcBillId.equals(0L) && (repaymentBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"er_repaymentbill", (String)"applier.name,payeraccount,buildrelationway")) != null) {
            List<Map<String, Object>> curSelectedRows;
            List<Map<String, Object>> recBills = this.getCanAssociateBills(repaymentBill);
            Map<Long, List<Long>> repay_rec_relation = this.getNotValidBill(repaymentBill);
            this.filterData(repaymentBill.getPkValue(), recBills, repay_rec_relation);
            if (STATUS_LIST.equals(selType) && (curSelectedRows = this.getCurSelectRows(repaymentBill, repay_rec_relation)).size() > 0) {
                int[] rowIndexs = model.batchCreateNewEntryRow(ENTRY_NAME, curSelectedRows.size());
                Iterator<Map<String, Object>> iterator = curSelectedRows.iterator();
                int[] nArray = rowIndexs;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int rowIndex = nArray[i];
                    Map<String, Object> row = iterator.next();
                    for (Map.Entry<String, Object> entry : row.entrySet()) {
                        model.setValue(entry.getKey(), entry.getValue(), rowIndex);
                    }
                }
                this.rowIndex = rowIndexs;
            }
            if (recBills != null && recBills.size() > 0) {
                int[] rowIndexs = model.batchCreateNewEntryRow(ENTRY_NAME, recBills.size());
                Iterator<Map<String, Object>> iterator = recBills.iterator();
                for (int rowIndex : rowIndexs) {
                    Map<String, Object> row = iterator.next();
                    for (Map.Entry<String, Object> entry : row.entrySet()) {
                        model.setValue(entry.getKey(), entry.getValue(), rowIndex);
                    }
                }
            }
        }
    }

    private List<Map<String, Object>> getCurSelectRows(DynamicObject repaymentBill, Map<Long, List<Long>> repay_rec_relation) {
        List<Long> curSelectRows = repay_rec_relation.get(repaymentBill.getPkValue());
        if (curSelectRows.size() > 0) {
            QFilter idFilter = new QFilter("id", "in", curSelectRows);
            DynamicObject[] recbills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"billno,bizdate,receivingtype,payeebank,accountbank,currency,exchangerate,actrecamt,localamt,approveamount", (QFilter[])new QFilter[]{idFilter});
            return RepaymentAssociateUtil.convertResult((DynamicObject[])recbills);
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int[] rowIndexs = this.rowIndex;
        if (rowIndexs != null && rowIndexs.length > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_NAME);
            entryGrid.selectRows(rowIndexs, -1);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(ENTRY_NAME, "selectRows", new Object[]{rowIndexs});
        }
    }

    private void filterData(Object repaymentBillPk, List<Map<String, Object>> recBills, Map<Long, List<Long>> repay_rec_relation) {
        ArrayList allRecBillPks = Lists.newArrayList();
        repay_rec_relation.entrySet().stream().map(v -> (List)v.getValue()).forEach(v -> allRecBillPks.addAll(v));
        Iterator<Map<String, Object>> iterator = recBills.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            if (!allRecBillPks.contains(next.get("id"))) continue;
            iterator.remove();
        }
    }

    private Map<Long, List<Long>> getNotValidBill(DynamicObject repaymentBill) {
        QFilter applierFilter = new QFilter("applier", "=", repaymentBill.get("applier.id"));
        DynamicObjectCollection repaymentbills = QueryServiceHelper.query((String)"er_repaymentbill", (String)"id,recentry.recbillid", (QFilter[])new QFilter[]{applierFilter});
        return repaymentbills.stream().collect(Collectors.groupingBy(v -> v.getLong("id"), Collectors.mapping(v -> v.getLong("recentry.recbillid"), Collectors.toList())));
    }

    private List<Map<String, Object>> getCanAssociateBills(DynamicObject repaymentBill) {
        DynamicObject[] recBills = RepaymentAssociateUtil.getCanAssociateBills((DynamicObject)repaymentBill);
        return RepaymentAssociateUtil.convertResult((DynamicObject[])recBills);
    }
}

