/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.Pair;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.Recorder;
import kd.fi.er.formplugin.botp.up.service.IBotpDrawService;
import kd.fi.er.formplugin.botp.up.service.ValidBillArg;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import org.apache.commons.lang3.StringUtils;

public class BotpDrawServiceStdImpl
implements IBotpDrawService {
    private static final String ALGOKEY = BotpDrawServiceStdImpl.class.toString();
    private static final Log logger = LogFactory.getLog(BotpDrawServiceStdImpl.class);
    private IDataModel model;
    private IFormView view;

    public BotpDrawServiceStdImpl(IDataModel model, IFormView view) {
        this.model = model;
        this.view = view;
    }

    @Override
    public <T> List<T> getValidBills(Map<Long, List<Long>> existPks, ValidBillArg ... args) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (args.length > 0) {
            DataSet dataSet = null;
            for (ValidBillArg arg : args) {
                DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)arg.getEntityName(), (String)arg.getSelectField(), (QFilter[])arg.getQFilters(), null);
                dataSet = dataSet == null ? queryDataSet : dataSet.union(queryDataSet);
            }
            this.convertResult(existPks, result, dataSet);
        }
        return result;
    }

    private void convertResult(Map<Long, List<Long>> existPks, List<Map<String, Object>> result, DataSet dataSet) {
        try (DataSet resultDataSet = dataSet;){
            Field[] fields = resultDataSet.getRowMeta().getFields();
            Iterator iterator = resultDataSet.iterator();
            HashMap showDataMap = new HashMap();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (existPks != null && !existPks.isEmpty() && existPks.get(row.getLong("billid")) != null && existPks.get(row.getLong("billid")).contains(row.getLong("entryid"))) continue;
                int mapSize = 10;
                HashMap<String, Object> rowValue = new HashMap<String, Object>(mapSize);
                for (Field field : fields) {
                    String name = field.getName();
                    rowValue.put(name, row.get(name));
                }
                Long billid = (Long)row.get("billid");
                if (showDataMap.get(billid) != null) {
                    ((List)showDataMap.get(billid)).add(rowValue);
                    continue;
                }
                ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                list.add(rowValue);
                showDataMap.put(billid, list);
            }
            boolean isValidate = ErStdConfig.getBoolean((String)"applytoreimburse.validate.loanbill");
            if (!showDataMap.isEmpty()) {
                if (!isValidate) {
                    BotpDrawServiceUtil.removeExistDownLoanBill(showDataMap, (boolean)false);
                }
                for (Map.Entry entry : showDataMap.entrySet()) {
                    List showList = (List)entry.getValue();
                    if (showList == null || showList.isEmpty()) continue;
                    result.addAll(showList);
                }
            }
        }
    }

    @Override
    @Deprecated
    public List<DynamicObject> draw(Map.Entry<String, ListSelectedRowCollection> bill) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)4);
        ListSelectedRowCollection rows = bill.getValue();
        String entityName = bill.getKey();
        DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)entityName, (String)this.model.getDataEntityType().getName(), (IFormView)this.view, (ListSelectedRowCollection)rows);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (result.isSuccess()) {
            BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, (List)resultList, (BillEntityType)((BillEntityType)this.model.getDataEntityType()));
        } else {
            String notification = result.getMessage();
            if (StringUtils.isBlank((CharSequence)notification) && result.getSourceEntityNumber().equalsIgnoreCase("er_dailyloanbill")) {
                if (result.getTargetEntityNumber().equalsIgnoreCase("er_tripreimbursebill")) {
                    notification = ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u4e0a\u62c9\u9884\u4ed8\u7684\u501f\u6b3e\u5355\u7528\u4e8e\u51b2\u9500\u3002", (String)"BotpDrawServiceStdImpl_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                } else if (result.getTargetEntityNumber().equalsIgnoreCase("er_dailyreimbursebill")) {
                    notification = ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u4e0a\u62c9\u9884\u4ed8\u7684\u501f\u6b3e\u5355\u7528\u4e8e\u51b2\u9500\u3002", (String)"BotpDrawServiceStdImpl_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                }
            }
            if (result.getSourceEntityNumber().equalsIgnoreCase("er_dailyapplybill")) {
                notification = ResManager.loadKDString((String)"\u5355\u636e\u4e0b\u6e38\u5b58\u5728\u5bf9\u516c\u9884\u4ed8\u501f\u6b3e\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e2a\u4eba\u62a5\u9500\u3002", (String)"BotpDrawServiceStdImpl_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            this.view.showTipNotification(notification);
            logger.info(result.getMessage());
        }
        return resultList;
    }

    @Override
    public List<DynamicObject> draw(Map.Entry<String, ListSelectedRowCollection> bill, List<ConvertOperationResult> convertResults, Recorder<Pair<Boolean, DrawArgs>> exsitFail) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)4);
        ListSelectedRowCollection rows = bill.getValue();
        String entityName = bill.getKey();
        DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)entityName, (String)this.model.getDataEntityType().getName(), (IFormView)this.view, (ListSelectedRowCollection)rows);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        convertResults.add(result);
        if (result.isSuccess()) {
            BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, (List)resultList, (BillEntityType)((BillEntityType)this.model.getDataEntityType()));
        } else {
            exsitFail.setRecord((Object)new Pair((Object)true, (Object)args));
        }
        return resultList;
    }

    @Override
    public void paint(List<DynamicObject> dataEntitysDyn) {
        DynamicObject pushDyn = this.mergeResult(dataEntitysDyn);
        ((IBillModel)this.model).push((Object)pushDyn);
        WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.view);
        this.recalculateAmount();
        IRefrencedataProvider refProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
            }
        };
        RedisModelCache modelCache = new RedisModelCache(refProvider, (MainEntityType)((BillEntityType)this.model.getDataEntityType()), this.view.getPageId());
        modelCache.release();
    }

    @Override
    public void paintWriteOffMoney(List<DynamicObject> dataEntitysDyn) {
        DynamicObject pushDyn = this.mergeResultWriteOffMoney(dataEntitysDyn);
        ((IBillModel)this.model).push((Object)pushDyn);
        WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.view);
        this.recalculateAmount();
        IRefrencedataProvider refProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
            }
        };
        RedisModelCache modelCache = new RedisModelCache(refProvider, (MainEntityType)((BillEntityType)this.model.getDataEntityType()), this.view.getPageId());
        modelCache.release();
    }

    private void recalculateAmount() {
        DynamicObjectCollection expense = this.model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        if (expense != null && !expense.isEmpty()) {
            BigDecimal approveCurrAmountOld = (BigDecimal)this.model.getValue("expeapprovecurramount", 0);
            this.model.beginInit();
            this.model.setValue("expeapprovecurramount", (Object)0, 0);
            this.model.endInit();
            this.model.setValue("expeapprovecurramount", (Object)approveCurrAmountOld, 0);
            if (this.view instanceof IMobileView) {
                WriteOffMoneyUtils.changeApproveAmount((IDataModel)this.model);
            }
        }
        this.view.updateView("advconap");
        this.view.updateView("advconap21");
        this.view.updateView("advconapoffapply");
        if (this.view instanceof MobileBillView) {
            this.view.updateView("flexpanelap2");
            this.view.updateView("flexpanelap9");
            this.view.updateView("accountflex");
        }
    }

    private DynamicObject mergeResult(List<DynamicObject> dataEntitysDyn) {
        DynamicObject result = dataEntitysDyn.get(0);
        HashSet<String> contains = new HashSet<String>();
        DynamicObjectCollection clearLoanEntry = result.getDynamicObjectCollection("writeoffapply");
        for (DynamicObject clearRow : clearLoanEntry) {
            contains.add(clearRow.getString("sourceapplyentryid") + clearRow.getString("sourceapplybillid"));
        }
        for (int i = 1; i < dataEntitysDyn.size(); ++i) {
            DynamicObject temp = dataEntitysDyn.get(i);
            DynamicObjectCollection tempClearLoanEntry = temp.getDynamicObjectCollection("writeoffapply");
            for (DynamicObject tempClearRow : tempClearLoanEntry) {
                String conStr = tempClearRow.getString("sourceapplyentryid") + tempClearRow.getString("sourceapplybillid");
                if (contains.contains(conStr)) continue;
                clearLoanEntry.add((Object)tempClearRow);
            }
        }
        return result;
    }

    private DynamicObject mergeResultWriteOffMoney(List<DynamicObject> dataEntitysDyn) {
        DynamicObject result = dataEntitysDyn.get(0);
        HashSet<String> contains = new HashSet<String>();
        DynamicObjectCollection clearLoanEntry = result.getDynamicObjectCollection("writeoffmoney");
        for (DynamicObject clearRow : clearLoanEntry) {
            contains.add(clearRow.getString("sourceentryid") + clearRow.getString("sourcebillid"));
        }
        for (int i = 1; i < dataEntitysDyn.size(); ++i) {
            DynamicObject temp = dataEntitysDyn.get(i);
            DynamicObjectCollection tempClearLoanEntry = temp.getDynamicObjectCollection("writeoffmoney");
            for (DynamicObject tempClearRow : tempClearLoanEntry) {
                String conStr = tempClearRow.getString("sourceentryid") + tempClearRow.getString("sourcebillid");
                if (contains.contains(conStr)) continue;
                clearLoanEntry.add((Object)tempClearRow);
            }
        }
        return result;
    }
}

