/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.wb.repayment;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.formplugin.botp.wb.repayment.factory.RepaymentWbServiceFactory;
import kd.fi.er.formplugin.botp.wb.repayment.service.AbstractRepaymentWbService;

public class RepaymentWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(RepaymentWriteBackPlugin.class);

    public void preparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("reqaccountentryid");
        fieldKeys.add("loanclearoriamount");
        fieldKeys.add("triporiaccappamount");
        fieldKeys.add("company");
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String entityName = e.getSrcMainType().getName();
        AbstractRepaymentWbService writeBackService = this.getWriteBackService(entityName);
        if (writeBackService == null) {
            logger.warn("\u8fd8\u6b3e\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u670d\u52a1\uff1a\u539f\u5355\u7c7b\u578b:" + entityName);
            return;
        }
        writeBackService.addKeys(e.getFieldKeys());
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        DynamicObject sourceBill = e.getSrcActiveRow();
        DynamicObject parentObject = (DynamicObject)sourceBill.getParent();
        String entityName = null;
        entityName = parentObject != null ? parentObject.getDataEntityType().getName() : sourceBill.getDataEntityType().getName();
        AbstractRepaymentWbService writeBackService = this.getWriteBackService(entityName);
        if (writeBackService == null) {
            logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u670d\u52a1\uff1a\u539f\u5355\u7c7b\u578b:" + entityName);
            return;
        }
        DynamicObject targetBill = e.getTargetActiveRow();
        if (targetBill == null) {
            return;
        }
        DynamicObject tarParentObject = (DynamicObject)targetBill.getParent();
        if (tarParentObject == null) {
            return;
        }
        writeBackService.writeBack(sourceBill, targetBill);
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        DynamicObject currObject = e.getSrcActiveRow();
        DynamicObject parentObject = (DynamicObject)currObject.getParent();
        String entityName = null;
        entityName = parentObject != null ? parentObject.getDataEntityType().getName() : currObject.getDataEntityType().getName();
        AbstractRepaymentWbService writeBackService = this.getWriteBackService(entityName);
        if (writeBackService == null) {
            logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u670d\u52a1\uff1a\u539f\u5355\u7c7b\u578b:" + entityName);
            return;
        }
        DynamicObject tarObject = e.getTargetActiveRow();
        if (tarObject == null) {
            return;
        }
        DynamicObject tarParentObject = (DynamicObject)tarObject.getParent();
        if (tarParentObject == null) {
            return;
        }
        writeBackService.validator(currObject, tarObject, e);
    }

    private AbstractRepaymentWbService getWriteBackService(String entityName) {
        AbstractRepaymentWbService writeBackService = RepaymentWbServiceFactory.getInstance(entityName, this.getOpType());
        return writeBackService;
    }
}

