/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.budget;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang.StringUtils;

public class BudgetCommonUtil {
    private static Log logger = LogFactory.getLog(BudgetCommonUtil.class);
    public static final String isQueryBudgetFlag = "isQueryBudgetFlag";
    private static final String isQueryEASBudgetFlag = "isQueryEASBudgetFlag";
    private static final String isQueryEASBgByShare = "isQueryEASBgByShare";
    private static final String isTripReqShowExpenseitemFlag = "isTripReqShowExpenseitemFlag";
    private static final String EASBgExcludeOrgNumber = "QueryEASBgExcludeOrgNumber";
    private static final String isBudgetStatusFlag = "isBudgetStatusFlag";
    private static Boolean isAddRow;
    public static final String viewBudgetBtn = "viewbudget";
    public static final String isQueryBudgetField = "isquerybudget";
    public static final String budgetAmountField = "budgetamount";
    public static final String noBudgetControlStr = "";
    public static final String budgetAmountLabel = "lab_budgetbalance";
    public static final String entryBudgetAmount = "entrybudgetamount";
    public static final String budgetAmountFlex = "flex_budget";
    public static final String budgetAmountMobTitle = "lab_bugettitle";
    public static final String budgetMsgField = "budgetmsg";
    public static final String entryBudgetMsgField = "entrybudgetmsg";
    public static final String BUDGETMSG_CONTROL = "budgetmsgcontrol";

    public static Set<Long> getEASBgExcludeOrg() {
        String excludeOrgNumber = IscHelper.getISCSettingValue((String)EASBgExcludeOrgNumber);
        if (excludeOrgNumber != null && !excludeOrgNumber.isEmpty()) {
            DynamicObjectCollection excludeOrg = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)excludeOrgNumber.split(";"))});
            return excludeOrg.stream().map(org -> org.getLong("id")).collect(Collectors.toSet());
        }
        return null;
    }

    public static String getMsgNoBudgetControlStr() {
        return ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public static String getBudgetAmountField(IFormView view) {
        if (BudgetCommonUtil.isTripReimGrid(view)) {
            return entryBudgetAmount;
        }
        return budgetAmountField;
    }

    public static void setIsQueryBudgetFlag(IPageCache pageCache, boolean isQueryBudget) {
        pageCache.put(isQueryBudgetFlag, String.valueOf(isQueryBudget));
    }

    public static boolean getIsQueryBudgetFlag(IPageCache pageCache) {
        String flag = pageCache.get(isQueryBudgetFlag);
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)flag) && "true".equalsIgnoreCase(flag);
    }

    public static void setIsQueryEASBudgetFlag(IPageCache pageCache, boolean isQueryBudget) {
        pageCache.put(isQueryEASBudgetFlag, String.valueOf(isQueryBudget));
    }

    public static boolean getIsQueryEASBudgetFlag(IPageCache pageCache) {
        String flag = pageCache.get(isQueryEASBudgetFlag);
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)flag) && "true".equalsIgnoreCase(flag);
    }

    public static void setIsQueryEASBgByShare(IPageCache pageCache, boolean flag) {
        pageCache.put(isQueryEASBgByShare, String.valueOf(flag));
    }

    public static Object getIsQueryEASBgByShare(IPageCache pageCache) {
        String flag = pageCache.get(isQueryEASBgByShare);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)flag)) {
            if ("true".equalsIgnoreCase(flag)) {
                return true;
            }
            if ("false".equalsIgnoreCase(flag)) {
                return false;
            }
        }
        return flag;
    }

    public static void setIsTripReqShowExpenseitemFlag(IPageCache pageCache, boolean isQueryBudget) {
        pageCache.put(isTripReqShowExpenseitemFlag, String.valueOf(isQueryBudget));
    }

    public static boolean getIsTripReqShowExpenseitemFlag(IPageCache pageCache) {
        String flag = pageCache.get(isTripReqShowExpenseitemFlag);
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)flag) && "true".equalsIgnoreCase(flag);
    }

    public static void buildBudgetAmountField(IFormView view) {
        logger.info("buildBudgetAmountField \u7ec4\u88c5\u9884\u7b97\u5f00\u59cb");
        IDataModel model = view.getModel();
        boolean dataChange = model.getDataChanged();
        model.setValue(isQueryBudgetField, (Object)true);
        Boolean isHaveExpenseItem = Boolean.FALSE;
        Map<String, String> expenseSign = BudgetCommonUtil.getExpenseSign(view);
        String expenseEntrySign = expenseSign.get("expenseEntrySign");
        String expenseItemSign = expenseSign.get("expenseItemSign");
        DynamicObjectCollection expenseEntryEntity = null;
        if (!(view instanceof IMobileView) && "entryentity".equalsIgnoreCase(expenseEntrySign)) {
            DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            if (tripEntry.size() > 0) {
                expenseEntryEntity = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity");
            }
        } else if (model.getDataEntity().containsProperty(expenseEntrySign)) {
            expenseEntryEntity = model.getDataEntity(true).getDynamicObjectCollection(expenseEntrySign);
        } else {
            logger.info("buildBudgetAmountField expenseEntrySign\u4e0d\u5b58\u5728");
            return;
        }
        logger.info("expenseEntryEntity \u5224\u65ad\u5f00\u59cb");
        if (expenseEntryEntity != null && expenseEntryEntity.size() > 0) {
            for (int i = 0; i < expenseEntryEntity.size(); ++i) {
                DynamicObject expenseEntity = (DynamicObject)expenseEntryEntity.get(i);
                DynamicObject expenseItem = expenseEntity.getDynamicObject(expenseItemSign);
                if (expenseItem == null) continue;
                isHaveExpenseItem = Boolean.TRUE;
                break;
            }
        }
        if (isHaveExpenseItem.booleanValue()) {
            DynamicObject billObj = model.getDataEntity(true);
            DynamicObject newBillObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)billObj, (boolean)false, (boolean)true);
            DynamicObjectCollection newExpenseEntryEntity = new DynamicObjectCollection();
            if (!(view instanceof IMobileView) && "entryentity".equalsIgnoreCase(expenseEntrySign)) {
                DynamicObjectCollection tripEntry = newBillObj.getDynamicObjectCollection("tripentry");
                if (tripEntry.size() > 0) {
                    newExpenseEntryEntity = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity");
                }
            } else {
                newExpenseEntryEntity = newBillObj.getDynamicObjectCollection(expenseEntrySign);
            }
            Iterator entrys = newExpenseEntryEntity.iterator();
            while (entrys.hasNext()) {
                DynamicObject entry = (DynamicObject)entrys.next();
                DynamicObject expenseItem = entry.getDynamicObject(expenseItemSign);
                if (expenseItem != null) continue;
                entrys.remove();
            }
            String budgetData = BudgetCommonUtil.queryBudgetAmount(newBillObj);
            int expenseEntrySize = expenseEntryEntity == null ? 0 : expenseEntryEntity.size();
            List budgetDataArray = JSONObject.parseArray((String)budgetData, JSONObject.class);
            if (budgetDataArray != null && budgetDataArray.size() > 0) {
                if (((JSONObject)budgetDataArray.get(0)).get((Object)"success") != null && !((Boolean)((JSONObject)budgetDataArray.get(0)).get((Object)"success")).booleanValue()) {
                    for (int i = 0; i < expenseEntrySize; ++i) {
                        model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)noBudgetControlStr, i);
                        model.setValue(BudgetCommonUtil.getBudgetField(view), (Object)"-", i);
                    }
                    return;
                }
                for (int i = 0; i < expenseEntrySize; ++i) {
                    DynamicObject expenseEntry = (DynamicObject)expenseEntryEntity.get(i);
                    for (int j = 0; j < budgetDataArray.size(); ++j) {
                        DynamicObject currencyDyn;
                        int seq;
                        int entrySeq;
                        boolean continueFlag;
                        JSONObject budgetDataJson = (JSONObject)budgetDataArray.get(j);
                        if (budgetDataJson.get((Object)"entrySeq") == null || !(budgetDataJson.get((Object)"entrySeq") instanceof Integer) ? (continueFlag = BudgetCommonUtil.verifyProp(model, i, budgetDataJson)) : (entrySeq = budgetDataJson.getIntValue("entrySeq")) != (seq = expenseEntry.getInt("seq"))) continue;
                        BigDecimal budgetAmount = budgetDataJson.getBigDecimal("balance");
                        if (budgetAmount == null) {
                            if (expenseEntry.get(BudgetCommonUtil.getBudgetAmountField(view)) == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)expenseEntry.get(BudgetCommonUtil.getBudgetAmountField(view)).toString())) continue;
                            model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]), i);
                            continue;
                        }
                        if (budgetDataJson.get((Object)"Currency") != null) {
                            JSONObject currency = (JSONObject)budgetDataJson.get((Object)"Currency");
                            String currencyNumber = currency.getString("bgnumber");
                            currencyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber), new QFilter("enable", "=", (Object)"1")});
                        } else {
                            currencyDyn = (DynamicObject)model.getValue("currency");
                        }
                        String currencySign = noBudgetControlStr;
                        int amtprecision = 2;
                        if (currencyDyn != null) {
                            currencySign = currencyDyn.getString("sign");
                            amtprecision = currencyDyn.getInt("amtprecision");
                        }
                        String budgetCurAmount = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)budgetAmount, (int)amtprecision);
                        model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)budgetCurAmount, i);
                        String budgeMsgText = BudgetCommonUtil.structureBudgetMsg(budgetDataJson, model);
                        model.setValue(BudgetCommonUtil.getBudgetField(view), (Object)budgeMsgText, i);
                        break;
                    }
                    if (expenseEntry.get(BudgetCommonUtil.getBudgetAmountField(view)) != null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)expenseEntry.get(BudgetCommonUtil.getBudgetAmountField(view)).toString())) continue;
                    model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]), i);
                }
            } else {
                for (int i = 0; i < expenseEntrySize; ++i) {
                    DynamicObject expenseEntry = (DynamicObject)expenseEntryEntity.get(i);
                    if (expenseEntry.get(expenseItemSign) == null) continue;
                    model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]), i);
                    model.setValue(BudgetCommonUtil.getBudgetField(view), (Object)"-", i);
                }
            }
        } else {
            logger.info("\u8bf7\u9664\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728\u7684\u60c5\u51b5\u4e0b\u7684\u9884\u7b97\u4fe1\u606f,\u5206\u5f55\u957f\u5ea6" + (expenseEntryEntity == null ? 0 : expenseEntryEntity.size()));
            BudgetCommonUtil.clearBudget(view, model, expenseItemSign, expenseEntryEntity, expenseEntryEntity == null ? 0 : expenseEntryEntity.size());
        }
        if (!dataChange) {
            model.setDataChanged(dataChange);
        }
    }

    private static boolean verifyProp(IDataModel model, int i, JSONObject budgetDataJson) {
        boolean continueFlag = false;
        Iterator keys = budgetDataJson.keySet().iterator();
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)model.getDataEntityType().getName());
        while (keys.hasNext()) {
            String noneProp;
            String propField;
            String prop;
            String key = (String)keys.next();
            if (!(budgetDataJson.get((Object)key) instanceof JSONObject)) continue;
            JSONObject dimensionObject = (JSONObject)budgetDataJson.get((Object)key);
            String dimensionNumber = dimensionObject.getString("dimension.number");
            String notContain = "Period,Year,Version";
            if (dimensionNumber == null || notContain.contains(dimensionNumber) || (prop = dimensionObject.getString("dimension.prop")) == null || entity.findProperty(propField = prop.contains(".") ? prop.substring(prop.lastIndexOf(46) + 1, prop.length()) : prop) == null || (noneProp = dimensionObject.getString("dimension.none")) != null && Boolean.parseBoolean(noneProp) && model.getValue(propField, i) == null) continue;
            if (model.getValue(propField, i) == null) {
                continueFlag = true;
                break;
            }
            if (!(model.getValue(propField, i) instanceof DynamicObject)) continue;
            String propNumber = dimensionObject.getString("number");
            String modelPropNumber = ((DynamicObject)model.getValue(propField, i)).getString("number");
            if (propNumber != null && modelPropNumber != null && propNumber.equalsIgnoreCase(modelPropNumber)) continue;
            if (model.getValue(budgetAmountField, i) != null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)model.getValue(budgetAmountField, i).toString())) {
                model.setValue(budgetAmountField, (Object)ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]), i);
            }
            continueFlag = true;
            break;
        }
        return continueFlag;
    }

    public static void buildBudgetAmountField(IFormView view, Integer rowIndex) {
        IDataModel model = view.getModel();
        if (view instanceof IMobileView && BudgetCommonUtil.isTripReimGrid(view) && "0".equals(model.getValue("showbudgetposition"))) {
            return;
        }
        DynamicObject newBillObj = BudgetCommonUtil.genBgDynamicObject(view, rowIndex);
        if (newBillObj == null) {
            model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)noBudgetControlStr, rowIndex.intValue());
            model.setValue(BudgetCommonUtil.getBudgetField(view), (Object)"-", rowIndex.intValue());
            return;
        }
        Map budgetMap = BudgetCommonUtil.queryBudgetAmountMap(view, newBillObj);
        logger.info("\u9884\u7b97\u67e5\u8be2\u7ed3\u679c" + budgetMap);
        if (budgetMap != null && budgetMap.size() > 0) {
            if (budgetMap.get("budgetAmount") != null) {
                DynamicObject currencyDyn;
                if (budgetMap.get("currency") != null) {
                    JSONObject currency = (JSONObject)budgetMap.get("currency");
                    String currencyNumber = currency.getString("bgnumber");
                    currencyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber), new QFilter("enable", "=", (Object)"1")});
                } else {
                    currencyDyn = (DynamicObject)model.getValue("currency");
                }
                String currencySign = noBudgetControlStr;
                int amtprecision = 2;
                if (currencyDyn != null) {
                    currencySign = currencyDyn.getString("sign");
                    amtprecision = currencyDyn.getInt("amtprecision");
                }
                String budgetCurAmount = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)((BigDecimal)budgetMap.get("budgetAmount")), (int)amtprecision);
                model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)budgetCurAmount, rowIndex.intValue());
            } else {
                model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]), rowIndex.intValue());
            }
            if (budgetMap.containsKey("budgetMsg")) {
                model.setValue(BudgetCommonUtil.getBudgetField(view), budgetMap.get("budgetMsg"), rowIndex.intValue());
            }
        } else {
            model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)noBudgetControlStr, rowIndex.intValue());
            model.setValue(BudgetCommonUtil.getBudgetField(view), (Object)"-", rowIndex.intValue());
        }
    }

    public static DynamicObject genBgDynamicObject(IFormView view, Integer rowIndex) {
        IDataModel model = view.getModel();
        Map<String, String> expenseSign = BudgetCommonUtil.getExpenseSign(view);
        String expenseEntrySign = expenseSign.get("expenseEntrySign");
        String expenseItemSign = expenseSign.get("expenseItemSign");
        DynamicObject expenseItem = (DynamicObject)model.getValue(expenseItemSign, rowIndex.intValue());
        if (expenseItem == null) {
            return null;
        }
        DynamicObject billObj = null;
        if (view instanceof IMobileView || !(view instanceof IBillView)) {
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            billObj = parentView.getModel().getDataEntity(true);
        } else {
            billObj = view.getModel().getDataEntity(true);
        }
        DynamicObject newBillObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)billObj, (boolean)false, (boolean)true);
        DynamicObjectCollection rows = null;
        if (!(view instanceof IMobileView) && "entryentity".equalsIgnoreCase(expenseEntrySign)) {
            DynamicObjectCollection tripEntry = newBillObj.getDynamicObjectCollection("tripentry");
            if (tripEntry.size() > 0) {
                rows = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity");
            }
        } else if (newBillObj.containsProperty(expenseEntrySign)) {
            rows = (DynamicObjectCollection)newBillObj.get(expenseEntrySign);
        }
        if (rows == null) {
            return null;
        }
        if (rows.size() > 0) {
            rows.clear();
        }
        DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
        DataEntityPropertyCollection entryProps = rows.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (entryProps.get((Object)propertyName) != null) {
                row.set(propertyName, model.getValue(propertyName, rowIndex.intValue()));
            }
            if (!(property instanceof EntryProp)) continue;
            if (rows.getDynamicObjectType().getName().equalsIgnoreCase(propertyName)) {
                DataEntityPropertyCollection currentEntryProps = ((EntryProp)property).getItemType().getProperties();
                for (IDataEntityProperty currentProperty : currentEntryProps) {
                    String currentPropertyName = currentProperty.getName();
                    if (entryProps.get((Object)currentPropertyName) == null || currentPropertyName.equalsIgnoreCase("seq")) continue;
                    row.set(currentPropertyName, model.getValue(currentPropertyName, rowIndex.intValue()));
                }
                continue;
            }
            if (!"entryentity".equalsIgnoreCase(expenseEntrySign) || !rows.getDynamicObjectType().getName().equalsIgnoreCase("entryentity")) continue;
            DataEntityPropertyCollection entryentityProps = ((EntityType)model.getDataEntityType().getAllEntities().get("entryentity")).getProperties();
            for (IDataEntityProperty entryentityProperty : entryentityProps) {
                String entryentityPropertyName = entryentityProperty.getName();
                if (entryProps.get((Object)entryentityPropertyName) == null || entryentityPropertyName.equalsIgnoreCase("seq")) continue;
                row.set(entryentityPropertyName, model.getValue(entryentityPropertyName, rowIndex.intValue(), 0));
            }
        }
        row.set("seq", (Object)(rowIndex + 1));
        rows.add((Object)row);
        Iterator entrys = rows.iterator();
        while (entrys.hasNext()) {
            DynamicObject entry = (DynamicObject)entrys.next();
            DynamicObject newExpenseItem = entry.getDynamicObject(expenseItemSign);
            if (newExpenseItem != null) continue;
            entrys.remove();
        }
        return newBillObj;
    }

    private static Map<String, String> getExpenseSign(IFormView view) {
        HashMap<String, String> expenseSign = new HashMap<String, String>();
        String expenseEntrySign = "expenseentryentity";
        String expenseItemSign = "expenseitem";
        String entryCurrency = "entrycurrency";
        String entityId = view.getEntityId();
        if ("er_tripentryedit".equals(entityId) || ErEntityTypeUtils.isTripReqBill((String)entityId) || ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            expenseEntrySign = "tripentry";
            expenseItemSign = "tripexpenseitem";
            entryCurrency = "tripcurrency";
        }
        if (BudgetCommonUtil.isTripReimGrid(view)) {
            expenseEntrySign = "entryentity";
            expenseItemSign = "travelexpenseitem";
            entryCurrency = "entrycurrency";
        }
        expenseSign.put("expenseEntrySign", expenseEntrySign);
        expenseSign.put("expenseItemSign", expenseItemSign);
        expenseSign.put("entryCurrency", entryCurrency);
        return expenseSign;
    }

    public static void buildBudgetAmountFieldByHead(IFormView view) {
        Label lab_budgetbalance = (Label)view.getControl(budgetAmountLabel);
        if (lab_budgetbalance == null) {
            return;
        }
        lab_budgetbalance.setText(noBudgetControlStr);
        IDataModel model = view.getModel();
        if (model.getDataEntityType().getProperty("headexpenseitem") == null) {
            return;
        }
        DynamicObject expenseItem = (DynamicObject)model.getValue("headexpenseitem");
        if (expenseItem == null) {
            return;
        }
        DynamicObject newBillObj = model.getDataEntity(true);
        if (newBillObj == null) {
            return;
        }
        Map budgetMap = BudgetCommonUtil.queryBudgetAmountMap(view, newBillObj);
        if (budgetMap != null && budgetMap.size() > 0) {
            if (budgetMap.get("budgetAmount") != null) {
                DynamicObject currencyDyn;
                if (budgetMap.get("currency") != null) {
                    JSONObject currency = (JSONObject)budgetMap.get("currency");
                    String currencyNumber = currency.getString("number");
                    currencyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber), new QFilter("enable", "=", (Object)"1")});
                } else {
                    currencyDyn = (DynamicObject)model.getValue("currency");
                }
                String currencySign = noBudgetControlStr;
                int amtprecision = 2;
                if (currencyDyn != null) {
                    currencySign = currencyDyn.getString("sign");
                    amtprecision = currencyDyn.getInt("amtprecision");
                }
                String budgetCurAmount = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)((BigDecimal)budgetMap.get("budgetAmount")), (int)amtprecision);
                if (view.getControl(budgetAmountMobTitle) == null) {
                    budgetCurAmount = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d %S", (String)"BudgetCommonUtil_3", (String)"fi-er-formplugin", (Object[])new Object[0]), budgetCurAmount);
                }
                lab_budgetbalance.setText(budgetCurAmount);
            } else {
                String tips = ResManager.loadKDString((String)"\u65e0\u9884\u7b97\u63a7\u5236", (String)"BudgetCommonUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                if (view.getControl(budgetAmountMobTitle) == null) {
                    tips = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d %S", (String)"BudgetCommonUtil_3", (String)"fi-er-formplugin", (Object[])new Object[0]), tips);
                }
                lab_budgetbalance.setText(tips);
            }
        }
    }

    private static Map queryBudgetAmountMap(IFormView view, DynamicObject billObj) {
        String budgetData = BudgetCommonUtil.queryBudgetAmount(billObj);
        List budgetDataArray = JSONObject.parseArray((String)budgetData, JSONObject.class);
        HashMap<String, Object> budgetMap = new HashMap<String, Object>();
        if (budgetDataArray != null && budgetDataArray.size() > 0) {
            for (int i = 0; i < budgetDataArray.size(); ++i) {
                JSONObject budgetDataJson = (JSONObject)budgetDataArray.get(i);
                if (budgetDataJson.get((Object)"success") != null && !((Boolean)budgetDataJson.get((Object)"success")).booleanValue()) {
                    return budgetMap;
                }
                BigDecimal budgetAmount = budgetDataJson.getBigDecimal("balance");
                budgetMap.put("budgetAmount", budgetAmount);
                budgetMap.put("budgetMsg", BudgetCommonUtil.structureBudgetMsg(budgetDataJson, view.getModel()));
                budgetMap.put("currency", budgetDataJson.get((Object)"Currency"));
            }
        } else {
            budgetMap.put(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u67e5\u5230\u9884\u7b97\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u7f16\u5236\u3002", (String)"BudgetCommonUtil_4", (String)"fi-er-formplugin", (Object[])new Object[0]), null);
        }
        return budgetMap;
    }

    private static String queryBudgetAmount(DynamicObject billObj) {
        String budgetData = null;
        try {
            budgetData = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"queryBalance", (Object[])new Object[]{billObj});
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable() instanceof InvocationTargetException) {
                budgetData = BudgetCommonUtil.getErrorMessage(((InvocationTargetException)e.getUndeclaredThrowable()).getTargetException().getMessage());
                logger.info("\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3queryBudgetAmount \u5931\u8d25:" + e.getUndeclaredThrowable());
            }
        }
        catch (Exception e) {
            budgetData = BudgetCommonUtil.getErrorMessage(e.getMessage());
            logger.info("\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3queryBudgetAmount \u5931\u8d25:" + e.getMessage());
        }
        logger.info("\u7ed3\u675f\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3, \u9884\u7b97\u4f59\u989d\u6570\u636e:" + SerializationUtils.toJsonString((Object)budgetData));
        return budgetData;
    }

    private static String getErrorMessage(String message) {
        JSONArray errorArray = new JSONArray();
        JSONObject errorData = new JSONObject();
        errorData.put("success", (Object)false);
        errorData.put("message", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5931\u8d25: %s", (String)"BudgetCommonUtil_2", (String)"fi-er-formplugin", (Object[])new Object[0]), message));
        errorArray.add((Object)errorData);
        return JSONObject.toJSONString((Object)errorArray);
    }

    public static boolean isShowBudget(String entityNumber, Long orgUnitId) {
        boolean isShowBudget = false;
        try {
            isShowBudget = (Boolean)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"isShowBalance", (Object[])new Object[]{entityNumber, orgUnitId});
        }
        catch (Exception e) {
            logger.info("\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u662f\u5426\u663e\u793a\u9884\u7b97\u53c2\u6570\u63a5\u53e3isShowBalance \u5931\u8d25:" + e.getMessage());
        }
        logger.info(String.format("\u7ed3\u675f\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u662f\u5426\u663e\u793a\u9884\u7b97\u53c2\u6570\u63a5\u53e3, \u5355\u636e\u7c7b\u578b:%1$s, \u7533\u8bf7\u4eba\u516c\u53f8\u7ec4\u7ec7id:%2$s, \u53c2\u6570\u503c:%3$s", entityNumber, orgUnitId, isShowBudget));
        return isShowBudget;
    }

    private static String structureBudgetMsg(JSONObject budgetDataJson, IDataModel model) {
        logger.info("\u9884\u7b97\u63a5\u53e3\u8fd4\u56deJSON\u6570\u636e" + budgetDataJson);
        StringBuilder budgeMsgText = new StringBuilder();
        String resultMsg = noBudgetControlStr;
        BigDecimal budget = budgetDataJson.getBigDecimal("budget");
        BigDecimal occupation = budgetDataJson.getBigDecimal("occupation");
        BigDecimal execute = budgetDataJson.getBigDecimal("execute");
        BigDecimal balance = budgetDataJson.getBigDecimal("balance");
        if (Objects.isNull(budget) && Objects.isNull(occupation) && Objects.isNull(execute) && Objects.isNull(balance)) {
            budgeMsgText.append("-");
        } else {
            DynamicObject currencyDyn;
            if (budgetDataJson.get((Object)"currency") != null) {
                JSONObject currency = (JSONObject)budgetDataJson.get((Object)"currency");
                String currencyNumber = currency.getString("number");
                currencyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber), new QFilter("enable", "=", (Object)"1")});
            } else {
                currencyDyn = (DynamicObject)model.getValue("currency");
            }
            String currencySign = "-";
            int amtprecision = 2;
            if (currencyDyn != null) {
                currencySign = currencyDyn.getString("sign");
                amtprecision = currencyDyn.getInt("amtprecision");
            }
            String budgetText = "-";
            if (budget != null) {
                budgetText = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)budget, (int)amtprecision);
            }
            budgeMsgText.append(ResManager.loadKDString((String)"\u9884\u7b97\u6570:", (String)"BudgetCommonUtil_5", (String)"fi-er-formplugin", (Object[])new Object[0])).append(budgetText).append(" ");
            String occupationText = "-";
            if (occupation != null) {
                occupationText = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)occupation, (int)amtprecision);
            }
            budgeMsgText.append(ResManager.loadKDString((String)"\u5360\u7528\u6570:", (String)"BudgetCommonUtil_6", (String)"fi-er-formplugin", (Object[])new Object[0])).append(occupationText).append(" ");
            String executeText = "-";
            if (execute != null) {
                executeText = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)execute, (int)amtprecision);
            }
            budgeMsgText.append(ResManager.loadKDString((String)"\u6267\u884c\u6570:", (String)"BudgetCommonUtil_7", (String)"fi-er-formplugin", (Object[])new Object[0])).append(executeText).append(" ");
            String balanceText = "-";
            if (balance != null) {
                balanceText = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)balance, (int)amtprecision);
            }
            budgeMsgText.append(ResManager.loadKDString((String)"\u53ef\u7528\u9884\u7b97\u4f59\u989d:", (String)"BudgetCommonUtil_8", (String)"fi-er-formplugin", (Object[])new Object[0])).append(balanceText);
            resultMsg = org.apache.commons.lang3.StringUtils.equals((CharSequence)"-", (CharSequence)balanceText) ? "-" : budgeMsgText.toString();
        }
        return resultMsg;
    }

    public static String getBudgetField(IFormView view) {
        if (BudgetCommonUtil.isTripReimGrid(view)) {
            return entryBudgetMsgField;
        }
        return budgetMsgField;
    }

    public static void setBudgetMsgIsVisible(IPageCache pageCache, String budgeMsgValue) {
        pageCache.put(isQueryBudgetFlag, budgeMsgValue);
    }

    private static void clearBudget(IFormView view, IDataModel model, String expenseItemSign, DynamicObjectCollection expenseEntryEntity, int expenseEntrySize) {
        for (int i = 0; i < expenseEntrySize; ++i) {
            model.setValue(BudgetCommonUtil.getBudgetAmountField(view), (Object)noBudgetControlStr, i);
            model.setValue(BudgetCommonUtil.getBudgetField(view), (Object)noBudgetControlStr, i);
        }
    }

    public static void setBudgeInfoVisible(String budgeMsgValue, IFormView view) {
        if (StringUtils.isNotEmpty((String)budgeMsgValue) && "0".equals(budgeMsgValue)) {
            view.setVisible(Boolean.valueOf(true), new String[]{budgetAmountField});
            view.setVisible(Boolean.valueOf(false), new String[]{budgetMsgField});
        } else if (StringUtils.isNotEmpty((String)budgeMsgValue) && "1".equals(budgeMsgValue)) {
            view.setVisible(Boolean.valueOf(true), new String[]{budgetMsgField});
            view.setVisible(Boolean.valueOf(false), new String[]{budgetAmountField});
        }
    }

    public static boolean isTripReimGrid(IFormView view) {
        Object o = ActionLocalCache.get().get("BudgetCommonUtil.isTripReimGrid", (Object)"isTripReimGrid", () -> {
            DynamicObject dataEntity = view.getModel().getDataEntity();
            if (!dataEntity.containsProperty("billkind")) {
                return false;
            }
            String reimburseShowType = dataEntity.getString("billkind");
            return "1".equals(reimburseShowType);
        });
        return (Boolean)o;
    }
}

