/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.StringUtils;

public class DailyApplyToDailyLoanBotpPlugin
extends AbstractConvertPlugIn {
    private static final String DAILY_REIMBURSE_BILL = "er_dailyreimbursebill";
    private static final String PUBLIC_REIMBURSE_BILL = "er_publicreimbursebill";
    private static final String REIMBURSE_EXPENSE_ENTRY = "expenseentryentity";
    private static final long DAILY_TABLE_ID;
    private static final long DAILY_ENTRY_TABLE_ID;
    private static final long PUBLIC_TABLE_ID;
    private static final long PUBLIC_ENTRY_TABLE_ID;
    private static final Set<String> BILL_STATUS_SET;
    private static final String NONE_BILLNO = "none_billno";
    private static final Log logger;

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        boolean isValidate;
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        HashSet noBillNIDSet = new HashSet(3);
        Map<Long, String> srcBillIdMapNo = selectedRows.stream().filter(Objects::nonNull).collect(Collectors.toMap(key -> (Long)key.getPrimaryKeyValue(), value -> {
            if (value.getBillNo() == null) {
                noBillNIDSet.add((Long)value.getPrimaryKeyValue());
                return NONE_BILLNO;
            }
            return value.getBillNo();
        }, (v1, v2) -> v1));
        if (!noBillNIDSet.isEmpty()) {
            DynamicObjectCollection bills = QueryServiceHelper.query((String)this.getRule().getSourceEntityNumber(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", noBillNIDSet)});
            bills.forEach(bill -> srcBillIdMapNo.put(bill.getLong("id"), bill.getString("billno")));
        }
        if (isValidate = ErStdConfig.getBoolean((String)"applytoreimburse.validate.loanbill")) {
            logger.info("\u4e0b\u63a8\u65f6\u4e0d\u6821\u9a8c\u4e0b\u6e38\u62a5\u9500\u5355\u662f\u5426\u5728\u9014--------------");
            return;
        }
        List linkDownBill = BFTrackerServiceHelper.loadBillLinkDown((String)this.getSrcMainType().getName(), (Long[])srcBillIdMapNo.keySet().toArray(new Long[srcBillIdMapNo.size()]), (boolean)true);
        Map<Long, List<BFRow>> linkDownBillMap = linkDownBill.stream().filter(item -> {
            Long tableId = item.getId().getTableId();
            return tableId.equals(DAILY_ENTRY_TABLE_ID) || tableId.equals(PUBLIC_ENTRY_TABLE_ID) || tableId.equals(DAILY_TABLE_ID) || tableId.equals(PUBLIC_TABLE_ID);
        }).collect(Collectors.groupingBy(item -> item.getId().getBillId()));
        QFilter qFilter = new QFilter("id", "in", linkDownBillMap.keySet());
        QFilter statusQFilter = new QFilter("billstatus", "in", BILL_STATUS_SET);
        QFilter amountFilter = new QFilter("billstatus", "=", (Object)"E");
        amountFilter.and("payamount", "!=", (Object)0);
        qFilter.and(statusQFilter.or(amountFilter));
        DynamicObjectCollection remBill = QueryServiceHelper.query((String)DAILY_REIMBURSE_BILL, (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection pubBill = QueryServiceHelper.query((String)PUBLIC_REIMBURSE_BILL, (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        if (remBill.isEmpty() && pubBill.isEmpty()) {
            return;
        }
        remBill.addAll((Collection)pubBill);
        List disAbleId = remBill.stream().map(row -> (List)linkDownBillMap.get(row.getLong("id"))).filter(item -> item != null).flatMap(bfs -> bfs.stream()).map(bf -> bf.getSId().getBillId()).collect(Collectors.toList());
        if (!disAbleId.isEmpty()) {
            String disAbleBillno = disAbleId.stream().map(id -> (String)srcBillIdMapNo.get(id)).filter(billNo -> billNo != null).distinct().collect(Collectors.joining(","));
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u4e0b\u6e38\u5b58\u5728\u5728\u9014\u62a5\u9500\u5355\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"DailyApplyToDailyLoanBotpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), disAbleBillno);
            e.setCustFilterDesc(errorMsg);
            e.setCustFilterExpression(String.format("id not in (%s)", StringUtils.join((Object[])disAbleId.toArray(), (String)",")));
            e.getCustQFilters().add(new QFilter("id", "not in", disAbleId));
        }
    }

    static {
        logger = LogFactory.getLog(DailyApplyToDailyLoanBotpPlugin.class);
        DAILY_TABLE_ID = EntityMetadataCache.loadTableDefine((String)DAILY_REIMBURSE_BILL, (String)DAILY_REIMBURSE_BILL).getTableId();
        DAILY_ENTRY_TABLE_ID = EntityMetadataCache.loadTableDefine((String)DAILY_REIMBURSE_BILL, (String)REIMBURSE_EXPENSE_ENTRY).getTableId();
        PUBLIC_TABLE_ID = EntityMetadataCache.loadTableDefine((String)PUBLIC_REIMBURSE_BILL, (String)PUBLIC_REIMBURSE_BILL).getTableId();
        PUBLIC_ENTRY_TABLE_ID = EntityMetadataCache.loadTableDefine((String)PUBLIC_REIMBURSE_BILL, (String)REIMBURSE_EXPENSE_ENTRY).getTableId();
        BILL_STATUS_SET = Collections.unmodifiableSet(Stream.of("A", "B", "C", "F").collect(Collectors.toSet()));
    }
}

