/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.trip.dailybiz.DailyReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ApplyToReimburseAutoCreateLoanRowEnum;
import kd.fi.er.formplugin.daily.botp.AbstractToReimburseBotpPlugin;

public class DailyApplyToReimBotpPlugin
extends AbstractToReimburseBotpPlugin {
    private EntryType offEntryType;
    protected DynamicObject[] loanBills = null;
    private static final Log logger = LogFactory.getLog(DailyApplyToReimBotpPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        this.loanBills = BusinessDataServiceHelper.load((String)"er_dailyloanbill", (String)this.getLoanBillSelectFileds(), (QFilter[])new QFilter[]{new QFilter("expenseentryentity.sourcebillid", "in", pkLists)});
        boolean isValidate = ErStdConfig.getBoolean((String)"applytoreimburse.validate.loanbill");
        if (isValidate) {
            logger.info("\u4e0b\u63a8\u65f6\u4e0d\u6821\u9a8c\u4e0b\u6e38\u501f\u6b3e\u5355\u662f\u5426\u5728\u9014---------------");
            return;
        }
        boolean waitingLoadBillFlag = false;
        String errorMsg = null;
        if (this.loanBills != null && this.loanBills.length > 0) {
            DynamicObject[] dynamicObjectArray = this.loanBills;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                String waitingStatus = "A,B,C,D,E,F";
                DynamicObject loanBill = dynamicObjectArray[i];
                if (!waitingStatus.contains(loanBill.getString("billstatus"))) continue;
                waitingLoadBillFlag = true;
                errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u4e0b\u6e38\u6709\u6b63\u5728\u7533\u8bf7\u7684\u501f\u6b3e\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u9500\u3002", (String)"DailyApplyToReimBotpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        if (waitingLoadBillFlag) {
            e.setCustFilterDesc(errorMsg);
            e.setCustFilterExpression(" billstatus = '-1' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"-1");
            e.getCustQFilters().add(qFilter);
        }
    }

    @Override
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        Long time = System.currentTimeMillis();
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map srcfldPro = e.getFldProperties();
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObject company = targetBill.getDynamicObject("company");
            if (company == null || !SystemParamterUtil.getMeettingToTrip((Long)ErCommonUtils.getPk((Object)company))) continue;
            this.genOrderEntrys(billDataEntity, srcfldPro, targetBill);
        }
        logger.info("DailyApplyToReimBotpPlugin.afterFieldMapping \u8d39\u7528\u7533\u8bf7\u5355\u4e0b\u63a8\u8017\u8d39 {}", (Object)(System.currentTimeMillis() - time));
    }

    protected String getLoanBillSelectFileds() {
        return "id, billno, billstatus, applier, bizdate,description, expenseentryentity.entrycurrency, expenseentryentity.entrycostdept, expenseentryentity.entrycostcompany, expenseentryentity.exchangerate, expenseentryentity.orgiexpebalanceamount, expenseentryentity.expebalanceamount,expenseentryentity.expenseitem,expenseentryentity.expquotetype";
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        super.afterCreateLink(e);
        String autoCreate = ErStdConfig.get((String)"applytoreimburse.autocreateloanrow");
        if (ApplyToReimburseAutoCreateLoanRowEnum.NO_AUTO_CREATE_LOANROW.getValue().equals(autoCreate)) {
            logger.info("\u4e0b\u63a8\u4e0a\u62c9\u65f6\u4e0d\u81ea\u52a8\u5e26\u51fa\u501f\u6b3e\u5355-----------");
            return;
        }
        ExtendedDataEntity[] expenseRows = e.getTargetExtDataEntitySet().FindByEntityKey("writeoffapply");
        if (this.loanBills == null || this.loanBills.length < 1 || expenseRows == null || expenseRows.length < 1) {
            return;
        }
        this.offEntryType = (EntryType)this.getTgtMainType().getAllEntities().get("writeoffmoney");
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        ArrayList<Long> sourceBillIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> mapSourceIdToReimburseBills = new HashMap<Long, DynamicObject>();
        for (ExtendedDataEntity expenseRow : expenseRows) {
            DynamicObjectCollection linkRows = expenseRow.getDataEntity().getDynamicObjectCollection("writeoffapply_lk");
            for (DynamicObject linkRow : linkRows) {
                Long sourceId = linkRow.getLong("writeoffapply_lk_sid");
                if (sourceId == null || sourceId.compareTo(Long.valueOf("0")) == 0) continue;
                sourceIds.add(sourceId);
                sourceBillIds.add(linkRow.getLong("writeoffapply_lk_sbillid"));
                mapSourceIdToReimburseBills.put(sourceId, (DynamicObject)expenseRow.getDataEntity().getParent());
            }
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)"er_dailyapplybill", (String)"expenseentryentity", (Long[])sourceIds.toArray(new Long[sourceIds.size()]));
        if (targetRows.isEmpty()) {
            targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)"er_dailyapplybill", (Long[])sourceBillIds.toArray(new Long[sourceBillIds.size()]), null);
        }
        Long targetTableId = EntityMetadataCache.loadTableDefine((String)"er_dailyloanbill", (String)"expenseentryentity").getTableId();
        TreeMap<Long, DynamicObject> reimburseBillEntryRows = new TreeMap<Long, DynamicObject>();
        for (BFRow targetRow : targetRows) {
            Long sourceEntryId = targetRow.getSId().getEntryId();
            DynamicObject reimburseBill = (DynamicObject)mapSourceIdToReimburseBills.get(sourceEntryId);
            if (reimburseBill == null) continue;
            Long targetEntryId = targetRow.getId().getEntryId();
            reimburseBillEntryRows.put(targetEntryId, reimburseBill);
        }
        for (DynamicObject loanBill : this.loanBills) {
            String billstatus = loanBill.getString("billstatus");
            if (!"G".equals(billstatus)) continue;
            DynamicObjectCollection loanBillExpenses = loanBill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject loanBillExpense : loanBillExpenses) {
                BigDecimal balanceAmount;
                Long loanBillExpenseId = (Long)loanBillExpense.getPkValue();
                DynamicObject reimburseBill = (DynamicObject)reimburseBillEntryRows.get(loanBillExpenseId);
                if (reimburseBill == null || (balanceAmount = loanBillExpense.getBigDecimal("orgiexpebalanceamount")) == null || balanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObjectCollection offRows = reimburseBill.getDynamicObjectCollection("writeoffmoney");
                DynamicObject offRow = this.createWriteOffLoanRow(loanBillExpense, targetTableId);
                offRow.set("seq", (Object)(offRows.size() + 1));
                offRows.add((Object)offRow);
            }
        }
        this.clearDrawOffRows(reimburseBillEntryRows);
    }

    protected void clearDrawOffRows(Map<Long, DynamicObject> reimburseBillEntryRows) {
        Collection<DynamicObject> reimburseBills = reimburseBillEntryRows.values();
        ArrayListMultimap drawMap = ArrayListMultimap.create();
        ArrayListMultimap pushMap = ArrayListMultimap.create();
        for (DynamicObject reimburseBill : reimburseBills) {
            drawMap.clear();
            pushMap.clear();
            DynamicObjectCollection offRows = reimburseBill.getDynamicObjectCollection("writeoffmoney");
            for (DynamicObject next : offRows) {
                if (!next.getBoolean("sourcesign")) {
                    drawMap.put((Object)next.getString("sourcebillid"), (Object)next);
                    continue;
                }
                pushMap.put((Object)next.getString("sourcebillid"), (Object)next);
            }
            Set drawSet = drawMap.keySet();
            Set pushSet = pushMap.keySet();
            drawSet.retainAll(pushSet);
            Iterator iterator = offRows.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (!drawSet.contains(next.get("sourcebillid")) || next.getBoolean("sourcesign")) continue;
                iterator.remove();
            }
        }
    }

    private DynamicObject createWriteOffLoanRow(DynamicObject loanExpense, Long sTableId) {
        DynamicObject loanBill = (DynamicObject)loanExpense.getParent();
        DynamicObject offRow = new DynamicObject((DynamicObjectType)this.offEntryType);
        String loanbillnov1 = loanBill.getString("billno");
        String loanperson = loanBill.getDynamicObject("applier").getString("name");
        Date loanapplydatev1 = loanBill.getDate("bizdate");
        String loandescriptionv1 = loanBill.getString("description");
        DynamicObject entrycostdept = loanExpense.getDynamicObject("entrycostdept");
        DynamicObject entrycostcompany = loanExpense.getDynamicObject("entrycostcompany");
        DynamicObject loancurrency = loanExpense.getDynamicObject("entrycurrency");
        DynamicObject expenseitem = loanExpense.getDynamicObject("expenseitem");
        BigDecimal loanexchangerate = loanExpense.getBigDecimal("exchangerate");
        BigDecimal loanamount = loanExpense.getBigDecimal("orgiexpebalanceamount");
        BigDecimal currloanamount = loanExpense.getBigDecimal("expebalanceamount");
        String expquotetype = loanExpense.getString("expquotetype");
        offRow.set("sourceentrycostdept", (Object)entrycostdept);
        offRow.set("sourceentrycostcompany", (Object)entrycostcompany);
        offRow.set("loanbillnov1", (Object)loanbillnov1);
        offRow.set("loanperson", (Object)loanperson);
        offRow.set("loanapplydatev1", (Object)loanapplydatev1);
        offRow.set("loandescriptionv1", (Object)loandescriptionv1);
        offRow.set("loancurrency", (Object)loancurrency);
        offRow.set("loanexchangerate", (Object)loanexchangerate);
        offRow.set("loanamount", (Object)loanamount);
        offRow.set("currloanamount", (Object)currloanamount);
        offRow.set("accloanamount", (Object)loanamount);
        offRow.set("curraccloanamount", (Object)currloanamount);
        offRow.set("sourcebillid", loanBill.getPkValue());
        offRow.set("sourceentryid", loanExpense.getPkValue());
        offRow.set("sourcesign", (Object)1);
        offRow.set("sourceexpenseitem", (Object)expenseitem);
        offRow.set("writeoffquotetype", (Object)expquotetype);
        offRow.set("srcbilltype", (Object)"er_dailyloanbill");
        DynamicObjectCollection offLinkRows = offRow.getDynamicObjectCollection("writeoffmoney_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("writeoffmoney_lk_stableid", (Object)sTableId);
        offLinkRow.set("writeoffmoney_lk_sbillid", loanBill.getPkValue());
        offLinkRow.set("writeoffmoney_lk_sid", loanExpense.getPkValue());
        offLinkRows.add((Object)offLinkRow);
        return offRow;
    }

    protected void genOrderEntrys(ExtendedDataEntity billDataEntity, Map<String, DynamicProperty> srcfldPro, DynamicObject targetBill) {
        Long time = System.currentTimeMillis();
        List sourceBillRows = (List)billDataEntity.getValue("ConvertSource");
        ArrayList<Long> applyBillIds = new ArrayList<Long>(sourceBillRows.size());
        ArrayList<String> applyBillNos = new ArrayList<String>(sourceBillRows.size());
        for (int i = 0; i < sourceBillRows.size(); ++i) {
            Long reqbillId = (Long)srcfldPro.get("id").getValue(sourceBillRows.get(i));
            String reqbillNo = (String)srcfldPro.get("billno").getValue(sourceBillRows.get(i));
            applyBillIds.add(reqbillId);
            applyBillNos.add(reqbillNo);
        }
        Long companyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company"));
        List notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByDailyApply(applyBillIds, applyBillNos, (Long)companyId);
        DynamicObjectCollection orderEntry = targetBill.getDynamicObjectCollection("orderentry");
        HashSet existOrderNumSet = new HashSet();
        orderEntry.stream().forEach(v -> existOrderNumSet.add(v.getString("ordernumber")));
        notReimbursedOrderList.removeIf(m -> !TripNotReimbursedOrderUtil.checkAvailableOrder((DynamicObject)m) || existOrderNumSet.contains(m.getString("ordernum")));
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return;
        }
        String formId = targetBill.getDataEntityType().getName();
        DynamicObjectCollection expenseentryentity = targetBill.getDynamicObjectCollection("expenseentryentity");
        if (expenseentryentity != null && expenseentryentity.size() > 0) {
            DynamicObject expenseEntry = (DynamicObject)expenseentryentity.get(0);
            DailyReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)expenseEntry, (DynamicObjectCollection)orderEntry, (List)notReimbursedOrderList, (boolean)false, null, null, (String)formId, null);
        } else if (expenseentryentity != null && expenseentryentity.size() == 0) {
            DynamicObject expenseEntry = expenseentryentity.addNew();
            DailyReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)expenseEntry, (DynamicObjectCollection)orderEntry, (List)notReimbursedOrderList, (boolean)false, null, null, (String)formId, null);
        }
        logger.info("DailyApplyToReimBotpPlugin.genOrderEntrys \u7533\u8bf7\u5355\u4e0b\u63a8\u8017\u8d39 {}", (Object)(System.currentTimeMillis() - time));
    }
}

