/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.formplugin.daily.botp.AbstractToReimburseBotpPlugin;

public class DailyLoanToReimBotpPlugin
extends AbstractToReimburseBotpPlugin {
    private EntryType offEntryType;
    private DynamicObjectCollection applyBillExpenses = new DynamicObjectCollection();

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        String selectProperties;
        DynamicObject[] applyBills;
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        HashSet applyBillIds = new HashSet();
        if (pkLists != null && pkLists.size() > 0) {
            Long[] pkArray = new Long[pkLists.size()];
            int index = 0;
            for (Object pk : pkLists) {
                pkArray[index] = (Long)pk;
                ++index;
            }
            Map sourceBillMap = BFTrackerServiceHelper.findSourceBills((String)"er_dailyloanbill", (Long[])pkArray);
            for (Map.Entry entry : sourceBillMap.entrySet()) {
                Set ids = (Set)entry.getValue();
                applyBillIds.addAll(ids);
            }
        }
        if (applyBillIds != null && applyBillIds.size() > 0 && (applyBills = BusinessDataServiceHelper.load((String)"er_dailyapplybill", (String)(selectProperties = "id, billno, billstatus, applier, bizdate, description, expenseentryentity.entrycurrency, expenseentryentity.exchangerate, expenseentryentity.orgiexpebalanceamount, expenseentryentity.expebalanceamount,expenseentryentity.entrycostdept, expenseentryentity.happendate, expenseentryentity.expenseitem,expenseentryentity.expquotetype"), (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)})) != null && applyBills.length > 0) {
            boolean applyBillBalanceFlag = false;
            for (DynamicObject applyBill : applyBills) {
                DynamicObjectCollection applyBillExpenses = applyBill.getDynamicObjectCollection("expenseentryentity");
                for (DynamicObject applyBillExpense : applyBillExpenses) {
                    BigDecimal balanceAmount = applyBillExpense.getBigDecimal("orgiexpebalanceamount");
                    if (balanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    applyBillBalanceFlag = true;
                    this.applyBillExpenses.add((Object)applyBillExpense);
                }
            }
            if (!applyBillBalanceFlag) {
                e.setCustFilterDesc(ResManager.loadKDString((String)"\u501f\u6b3e\u5355\u4e0a\u6e38\u7684\u7533\u8bf7\u5355\u5df2\u7ecf\u62a5\u5b8c\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u62a5\u9500\u3002", (String)"DailyLoanToReimBotpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCustFilterExpression(" billstatus = '-1' ");
                QFilter qFilter = new QFilter("billstatus", "=", (Object)"-1");
                e.getCustQFilters().add(qFilter);
            }
        }
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        DynamicObject reimburseBill;
        super.afterCreateLink(e);
        ExtendedDataEntity[] expenseRows = e.getTargetExtDataEntitySet().FindByEntityKey("writeoffmoney");
        if (this.applyBillExpenses == null || this.applyBillExpenses.size() < 1 || expenseRows == null || expenseRows.length < 1) {
            return;
        }
        this.offEntryType = (EntryType)this.getTgtMainType().getAllEntities().get("writeoffapply");
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> mapSourceIdToReimburseBills = new HashMap<Long, DynamicObject>();
        for (ExtendedDataEntity expenseRow : expenseRows) {
            expenseRow.setValue("sourcesign", (Object)1);
            DynamicObjectCollection linkRows = expenseRow.getDataEntity().getDynamicObjectCollection("writeoffmoney_lk");
            for (DynamicObject linkRow : linkRows) {
                Long sourceId = linkRow.getLong("writeoffmoney_lk_sid");
                if (sourceId == null || sourceId.compareTo(Long.valueOf("0")) == 0) continue;
                sourceIds.add(sourceId);
                mapSourceIdToReimburseBills.put(sourceId, (DynamicObject)expenseRow.getDataEntity().getParent());
            }
        }
        List sourceRows = BFTrackerServiceHelper.loadSourceRowIds((String)"er_dailyloanbill", (String)"expenseentryentity", (Long[])sourceIds.toArray(new Long[sourceIds.size()]));
        Long sourceTableId = EntityMetadataCache.loadTableDefine((String)"er_dailyapplybill", (String)"expenseentryentity").getTableId();
        TreeMap<Long, DynamicObject> reimburseBillEntryRows = new TreeMap<Long, DynamicObject>();
        for (BFRow sourceRow : sourceRows) {
            Long entryId = sourceRow.getId().getEntryId();
            reimburseBill = (DynamicObject)mapSourceIdToReimburseBills.get(entryId);
            if (reimburseBill == null) continue;
            Long sourceEntryId = sourceRow.getSId().getEntryId();
            reimburseBillEntryRows.put(sourceEntryId, reimburseBill);
        }
        for (DynamicObject applyBillExpense : this.applyBillExpenses) {
            BigDecimal balanceAmount;
            Long applyBillExpenseId = (Long)applyBillExpense.getPkValue();
            reimburseBill = (DynamicObject)reimburseBillEntryRows.get(applyBillExpenseId);
            if (reimburseBill == null || (balanceAmount = applyBillExpense.getBigDecimal("orgiexpebalanceamount")) == null || balanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObjectCollection offRows = reimburseBill.getDynamicObjectCollection("writeoffapply");
            DynamicObject offRow = this.createWriteOffLoanRow(applyBillExpense, sourceTableId);
            offRow.set("seq", (Object)(offRows.size() + 1));
            offRows.add((Object)offRow);
        }
    }

    private DynamicObject createWriteOffLoanRow(DynamicObject applyExpense, Long sTableId) {
        DynamicObject applyBill = (DynamicObject)applyExpense.getParent();
        DynamicObject offRow = new DynamicObject((DynamicObjectType)this.offEntryType);
        String applybillno = applyBill.getString("billno");
        String applyperson = applyBill.getDynamicObject("applier").getString("name");
        Date applybilldate = applyBill.getDate("bizdate");
        String applydescription = applyBill.getString("description");
        DynamicObject applycurrency = applyExpense.getDynamicObject("entrycurrency");
        BigDecimal applyexchangerate = applyExpense.getBigDecimal("exchangerate");
        BigDecimal orgiexpebalanceamount = applyExpense.getBigDecimal("orgiexpebalanceamount");
        BigDecimal expebalanceamount = applyExpense.getBigDecimal("expebalanceamount");
        String expquotetype = applyExpense.getString("expquotetype");
        offRow.set("applybillno", (Object)applybillno);
        offRow.set("applyperson", (Object)applyperson);
        offRow.set("applybilldate", (Object)applybilldate);
        offRow.set("applydescription", (Object)applydescription);
        offRow.set("applycurrency", (Object)applycurrency);
        offRow.set("applyexchangerate", (Object)applyexchangerate);
        offRow.set("orgiexpebalanceamount", (Object)orgiexpebalanceamount);
        offRow.set("expebalanceamount", (Object)expebalanceamount);
        offRow.set("reimbursedamount", (Object)orgiexpebalanceamount);
        offRow.set("reimbursedcurramount", (Object)expebalanceamount);
        offRow.set("sourceapplybillid", applyBill.getPkValue());
        offRow.set("sourceapplyentryid", applyExpense.getPkValue());
        offRow.set("orgfield", applyExpense.get("entrycostdept"));
        offRow.set("datefield", applyExpense.get("happendate"));
        offRow.set("expenseitemfield", applyExpense.get("expenseitem"));
        offRow.set("writeoffapplyquotetype", (Object)expquotetype);
        DynamicObjectCollection offLinkRows = offRow.getDynamicObjectCollection("writeoffapply_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("writeoffapply_lk_stableid", (Object)sTableId);
        offLinkRow.set("writeoffapply_lk_sbillid", applyBill.getPkValue());
        offLinkRow.set("writeoffapply_lk_sid", applyExpense.getPkValue());
        offLinkRows.add((Object)offLinkRow);
        return offRow;
    }
}

