/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mob;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.formplugin.daily.ErMyTripStandardPlugin;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class ErMytripStdMobPlugin
extends ErMyTripStandardPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(ErMytripStdMobPlugin.class);

    private static String getEMPTY_MESSAGE() {
        return ResManager.loadKDString((String)"\u6682\u672a\u8bbe\u7f6e\u6807\u51c6", (String)"ErMytripStdMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        Long companyId = TripStandardUtils.getCurrentUserCompanyId();
        if (companyId == null) {
            log.info(String.format("\u5f53\u524d\u7528\u6237(%d)\u6240\u5728\u7ec4\u7ec7(%d)\u672a\u67e5\u8be2\u5176\u6240\u5728\u7684\u516c\u53f8\uff0c\u8bf7\u8bbe\u7f6e\u516c\u53f8\uff01", userID, RequestContext.get().getOrgId()));
            return;
        }
        String airStd = this.getVehicleStdByUserIDAndVehicleType(userID, "air", companyId);
        this.getLable("lab_planestd").setText(StringUtils.isEmpty((CharSequence)airStd) ? ErMytripStdMobPlugin.getEMPTY_MESSAGE() : airStd);
        String trainStd = this.getVehicleStdByUserIDAndVehicleType(userID, "train", companyId);
        this.getLable("lab_trainstd").setText(StringUtils.isEmpty((CharSequence)trainStd) ? ErMytripStdMobPlugin.getEMPTY_MESSAGE() : trainStd);
        String shipStd = this.getVehicleStdByUserIDAndVehicleType(userID, "ship", companyId);
        this.getLable("lab_shipstd").setText(StringUtils.isEmpty((CharSequence)shipStd) ? ErMytripStdMobPlugin.getEMPTY_MESSAGE() : shipStd);
        this.settingTripArea(userID, companyId);
    }

    private void settingTripArea(Long userId, Long companyId) {
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        List tripStdEntry = tripStdService.getTripStdEntryByUserIdAndCompanyId(userId, companyId);
        Set tripAreas = tripStdEntry.stream().map(entry -> entry.getDynamicObject("triparea")).collect(Collectors.toSet());
        TreeSet sortedSet = new TreeSet((a, b) -> a.getString("number").compareTo(b.getString("number")));
        sortedSet.addAll(tripAreas);
        sortedSet.forEach(tripArea -> {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("fld_tripareaname", (Object)tripArea.getString("name"), rowIndex);
            this.getModel().setValue("fld_tripareaid", tripArea.getPkValue(), rowIndex);
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        boolean isEntryEntity;
        Object source = evt.getSource();
        boolean bl = isEntryEntity = source instanceof Control && Objects.equals(((Control)source).getKey(), "entryentity");
        if (isEntryEntity) {
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            mobileFormShowParameter.setFormId("er_mytripstddetail_mb");
            mobileFormShowParameter.setCustomParam("tripareaid", this.getModel().getValue("fld_tripareaid"));
            mobileFormShowParameter.setCaption((String)this.getModel().getValue("fld_tripareaname"));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        }
    }
}

