/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;

public class ErApplyProjectMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener {
    private static final String ER_APPLY_PROJECT_ENTRY = "er_apply_project_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_expense_add"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (view.getParentView() != null) {
            String billPageId = view.getPageId();
            IPageCache parentPageCache = (IPageCache)view.getParentView().getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
        }
        CommonViewControlUtil.expensePageRules(model, view);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.refreshBillAmount();
                break;
            }
            case "submit": {
                this.refreshBillAmount();
            }
        }
    }

    private void refreshBillAmount() {
        String detailtype;
        IDataModel dataModel = this.getModel();
        BigDecimal applyAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"currexpenseamount");
        dataModel.setValue("applyamount", (Object)applyAmount);
        BigDecimal expeAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"expeapprovecurramount");
        dataModel.setValue("approveamount", (Object)expeAmount);
        dataModel.setValue("balanceamount", (Object)expeAmount);
        dataModel.setValue("billcanloanamount", (Object)expeAmount);
        if (ErEntityTypeUtils.isApplyProjectBill((String)dataModel.getDataEntityType().getName()) && "biztype_applybill".equals(detailtype = (String)dataModel.getValue("detailtype"))) {
            BigDecimal nonpayamount = (BigDecimal)dataModel.getValue("nonpayamount");
            BigDecimal costimateamount = (BigDecimal)dataModel.getValue("costimateamount");
            BigDecimal contractamount = (BigDecimal)dataModel.getValue("contractamount");
            BigDecimal notpayamount = expeAmount.subtract(costimateamount).subtract(contractamount);
            BigDecimal availableAmount = notpayamount.subtract(nonpayamount);
            dataModel.setValue("notpayamount", (Object)notpayamount);
            dataModel.setValue("availableamount", (Object)availableAmount);
        }
    }
}

