/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public class ErPublicReimSupplementChooseEntryMobPlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener {
    private static Log log = LogFactory.getLog(ErPublicReimSupplementChooseEntryMobPlugin.class);
    private static final String ENTRY = "entryentity";

    public void initialize() {
        super.initialize();
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObjectCollection collection = parentView.getModel().getEntryEntity("expenseentryentity");
        if (collection.size() == 0) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.getQueryFilterParameter().getQFilters().add(new QFilter("id", "=", parentView.getModel().getDataEntity().getPkValue()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "confrim"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control menuItem = (Control)evt.getSource();
        switch (key = menuItem.getKey()) {
            case "confrim": {
                ListSelectedRowCollection collection = ((BillList)this.getView().getControl("billlistap")).getSelectedRows();
                if (collection.isEmpty()) {
                    log.info("\u5206\u5f55\u65e0\u6570\u636e");
                    this.getView().close();
                    return;
                }
                HashMap entryIds = Maps.newHashMapWithExpectedSize((int)collection.size());
                for (ListSelectedRow row : collection) {
                    entryIds.put((Long)row.getEntryPrimaryKeyValue(), row.getRowKey());
                }
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.getPageCache().put("er_reimburse_supplement", SerializationUtils.toJsonString((Object)entryIds));
                }
                HashMap map = new HashMap(2);
                map.put("ids", entryIds.keySet());
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String text = mobileSearchTextChangeEvent.getText();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        QFilter qFilter = new QFilter("id", "=", this.getView().getParentView().getModel().getDataEntity().getPkValue());
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            qFilter.and(new QFilter("expenseentryentity.expenseitem.name", "like", (Object)("%" + text + "%")));
        }
        billList.getQueryFilterParameter().getQFilters().add(qFilter);
        billList.refresh();
    }
}

