/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.util.CommonModelControlUtil;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.util.DataCopyUtils;
import kd.fi.er.formplugin.util.FormOperateUtil;
import kd.fi.er.formplugin.web.ErTripReimAutoWriteDescription;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.lang.StringUtils;

public class ExpenseBaseMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String LB_CHANGE = "lb_change";
    private static final Log logger = LogFactory.getLog(ExpenseBaseMobPlugin.class);
    private static final String ER_DAILY_APPLIER_MOB = "er_daily_applier_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LB_CHANGE, "labelap_addpayer"});
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("std_costcenter");
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (costCenterF7 != null) {
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)LB_CHANGE) || org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)"labelap_addpayer")) {
            CommonViewControlUtil.changeApplier(entityName, (IFormPlugin)this, this.getView());
        }
    }

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        CommonModelControlUtil.initPage(this.getModel(), this.getView());
        if (!ErCostCenterUtil.checkCostOrg((AbstractFormPlugin)this, (String)"6")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain", "mtoolbarap"});
        }
        this.setFundingOrg();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("ok".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (!(this.getView() instanceof ListView)) {
                this.getModel().setDataChanged(false);
            }
            this.getView().close();
        }
    }

    private void setFundingOrg() {
        IDataModel model = this.getModel();
        Object costCompany = model.getValue("costcompany");
        if (this.isNeedToSetPayCompany() && costCompany != null) {
            logger.info("\u5f00\u59cb\u8bbe\u7f6e\u652f\u4ed8\u516c\u53f8");
            DynamicObject fundingCompany = CoreBaseBillServiceHelper.getFundingOrg((DynamicObject)((DynamicObject)costCompany));
            model.setValue("paycompany", (Object)fundingCompany);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (!org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "D"})) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"label_expense_delete"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LB_CHANGE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_expense_add"});
        }
        CommonServiceHelper.setUnsubmitToVisible((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"bar_unsubmit");
    }

    public void afterBindData(EventObject e) {
        String formId;
        Object payCompany;
        super.afterBindData(e);
        this.hideBillHead(this.getView());
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            logger.info("\u7236\u4eb2\u9875\u9762\u662f:" + parentView.getEntityId());
            this.hideBillHead(parentView);
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String entityId = this.getView().getEntityId();
        if ((ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyApplyBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isReimCtlApplyBill((String)entityId)) && FormOperateUtil.isCopyOperate((EventObject)e)) {
            DataCopyUtils.handleData((IDataModel)model, (IFormView)view);
        }
        this.initaccbalamount();
        Object currencyDO = model.getValue("currency");
        if (currencyDO == null) {
            Long companyId = ErCommonUtils.getPk((Object)model.getValue("company"));
            Long costCompanyId = ErCommonUtils.getPk((Object)model.getValue("costcompany"));
            Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)companyId, (Object)costCompanyId);
            logger.info("\u518d\u6b21\u83b7\u53d6\u672c\u4f4d\u5e01\uff0ccompanyId={}, costCompanyId={}, currencyId={}", new Object[]{companyId, costCompanyId, currencyId});
            model.setValue("currency", (Object)currencyId);
        }
        if (model.getDataEntity().getDataEntityState().isPushChanged() && this.isNeedToSetPayCompany() && (payCompany = model.getValue("paycompany")) == null) {
            this.setFundingOrg();
        }
        if ((ErEntityTypeUtils.isPublicReimburseBill((String)(formId = this.getView().getEntityId())) || ErEntityTypeUtils.isDailyReimburseBill((String)formId)) && model.getEntryRowCount("withholdingentry") > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5728\u79fb\u52a8\u7aef\u4fee\u6539\u51b2\u9884\u63d0\u7684\u62a5\u9500\u5355\u3002", (String)"ExpenseBaseMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            model.setValue("billstatus", (Object)"E");
            this.getView().setVisible(Boolean.FALSE, new String[]{LB_CHANGE, "btn_expense_add", "btn_add_invoice", "btn_next_add_expense", "label_expense_delete", "flex_add_apply", "lab_delete_offapply"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_add_invoice", "btn_next_add_expense", "importinvoiceonebyone", "recordpooldraw", "flex_add_apply"});
        }
        CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getPageCache().put("pageCopyData", "true");
        DataCopyUtils.afterCopyBill((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Long companyId = 0L;
        switch (propName) {
            case "costdept": {
                this.costDeptChange((DynamicObject)propValue);
                break;
            }
            case "bizdate": {
                this.refreshRepaymentDate();
                break;
            }
            case "costcompany": 
            case "company": {
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                this.refreshRepaymentDate();
                this.setFundingOrg();
                if (propValue != null) {
                    InvoiceUtils.changeAutoInvoice((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)((Long)((DynamicObject)propValue).getPkValue()));
                }
                CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)this.getModel());
                DynamicObject company = null;
                company = "costcompany".equals(propName) ? (DynamicObject)this.getModel().getValue("company") : (DynamicObject)valueSet[0].getNewValue();
                if (company != null) {
                    companyId = (Long)company.getPkValue();
                }
                PublicBillUtil.refreshSuplier((IDataModel)this.getModel(), (String)propName, (Long)companyId);
                break;
            }
            case "org": {
                this.deptChange((DynamicObject)propValue);
            }
            case "expenseitem": {
                Object description = this.getModel().getValue("description");
                if (description != null && !((String)description).isEmpty()) break;
                logger.info("come in there one , description : " + description);
                ErTripReimAutoWriteDescription.setDiscription(this.getView());
                break;
            }
            case "applier": 
            case "currency": {
                this.initaccbalamount();
                break;
            }
            case "std_costcenter": {
                if (!ErCostCenterUtil.isLeafCostCenter((Object)propValue)) break;
                ErCostCenterUtil.headCostCenterChange((IFormView)this.getView(), (Object)propValue, (boolean)true);
            }
        }
    }

    private void refreshRepaymentDate() {
        if (this.getModel().getProperty("repaymentdate") != null) {
            this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        Long oldCurrencyId = ErCommonUtils.getPk((Object)model.getValue("currency"));
        if (ER_DAILY_APPLIER_MOB.equalsIgnoreCase(event.getActionId())) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean b = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                b.set(p.beforeClosedCallBack(ExpenseBaseMobPlugin.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), event.getReturnData()}));
                return null;
            });
            if (b.get() && event.getReturnData() != null) {
                Map map = (Map)event.getReturnData();
                DynamicObject applier = (DynamicObject)map.get("applier");
                String userId = applier.getString("id");
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                this.setApplierInfo(model, map);
                this.setDeptInfo(model, map);
                pageCache.put("consignorId", userId);
                if (model.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"writeoffapply")) {
                    DynamicObjectCollection writeOffApplyEntry;
                    Long newCompanyID = (Long)((DynamicObject)model.getValue("company")).getPkValue();
                    Long newCostCompanyID = (Long)((DynamicObject)model.getValue("costcompany")).getPkValue();
                    String filterType = ErCommonUtils.getEMParameter((long)newCompanyID, (String)"relatapplybillfilterrange").toString();
                    Long newCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)newCompanyID, (Object)newCostCompanyID);
                    if (!newCurrencyId.equals(oldCurrencyId)) {
                        model.deleteEntryData("writeoffapply");
                    }
                    if ((writeOffApplyEntry = model.getDataEntity(true).getDynamicObjectCollection("writeoffapply")).size() > 0) {
                        LinkedList<Integer> noExistRow = new LinkedList<Integer>();
                        Set<String> allBiiIdSet = this.getAllBillIdSet(filterType);
                        for (int i = 0; i < writeOffApplyEntry.size(); ++i) {
                            if (allBiiIdSet.contains(((DynamicObject)writeOffApplyEntry.get(i)).getString("applybillno"))) continue;
                            noExistRow.add(i);
                        }
                        int[] noExistIndexs = noExistRow.stream().mapToInt(Integer::intValue).toArray();
                        if (noExistIndexs.length > 0) {
                            model.deleteEntryRows("writeoffapply", noExistIndexs);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56e0\u201c\u5173\u8054\u7533\u8bf7\u5355\u8fc7\u6ee4\u8303\u56f4\u201d\u516c\u53f8\u53c2\u6570\u8bbe\u7f6e\uff0c\u7533\u8bf7\u4eba\u7b49\u4fe1\u606f\u53d8\u66f4\u5bfc\u81f4\u4e0a\u6e38\u8d39\u7528\u7533\u8bf7\u5355\u5173\u8054\u6e05\u9664\uff0c\u91d1\u989d\u4e0d\u80fd\u6b63\u5e38\u53cd\u5199\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"ExpenseBaseMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), Integer.valueOf(80000));
                        }
                    }
                }
                if (!ErEntityTypeUtils.isContractBill((String)this.getView().getEntityId())) {
                    ExpenseBaseMobPlugin.changeAppilerinfoAndAccInfo(model, this.getView());
                }
                if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPrePayBill((String)this.getView().getEntityId())) {
                    String relationcontract = "0";
                    if (model.getValue("company") != null) {
                        relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
                    }
                    model.setValue("relationcontract", (Object)relationcontract);
                }
            }
            pluginProxy.callReplace(p -> {
                p.afterClosedCallBack(ExpenseBaseMobPlugin.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), event.getReturnData()});
                return null;
            });
        }
    }

    public static void changeAppilerinfoAndAccInfo(IDataModel model, IFormView view) {
        String entityid = view.getEntityId();
        if (ErEntityTypeUtils.isDailyApplyBill((String)entityid) || ErEntityTypeUtils.isReimCtlApplyBill((String)entityid) || ErEntityTypeUtils.isApplyProjectBill((String)entityid)) {
            return;
        }
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        if ("1".equals(isgetaccountcurrency)) {
            model.setValue("iscurrency", (Object)Boolean.TRUE);
            if (model.getEntryRowCount("accountentry") == 0) {
                return;
            }
            String payertype = (String)model.getValue("payertype", 0);
            if ("er_payeer".equals(payertype)) {
                Object currentUser = model.getValue("applier");
                DynamicObject payer = PayeeServiceHelper.getDefaultAccount((Long)Long.valueOf(((DynamicObject)currentUser).getPkValue().toString()));
                model.setValue("payer", payer == null ? null : payer.getPkValue(), 0);
                Map exchangeMap = AmountChangeUtil.getCurrencyByParamentForInit((IFormView)view, (IDataModel)model, (String)isgetaccountcurrency);
                model.beginInit();
                model.setValue("accountcurrency", exchangeMap.get("currencyId"), 0);
                model.setValue("accexchangerate", exchangeMap.get("exchangeRate"), 0);
                model.setValue("accquotetype", (Object)((String)exchangeMap.get("quoteType")), 0);
                model.endInit();
                ErCommonUtils.updateView((IFormView)view, (int)0, (String[])new String[]{"accexchangerate", "accountcurrency", "accquotetype"});
                AmountChangeUtil.accExchangeRateChange((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (int)0, (IDataModel)model, (IFormView)view);
            }
            String billType = model.getDataEntity().getDynamicObjectType().getName();
            BigDecimal payAmount = BigDecimal.ZERO;
            String loanType = "1";
            if (ErEntityTypeUtils.isDailyReimburseBill((String)billType) || ErEntityTypeUtils.isPublicReimburseBill((String)billType)) {
                payAmount = (BigDecimal)model.getValue("payamount");
                loanType = (String)model.getValue("writeofftype");
            } else if (ErEntityTypeUtils.isDailyLoanBill((String)billType)) {
                payAmount = (BigDecimal)model.getValue("approveamount");
            } else if (ErEntityTypeUtils.isTripReimburseBill((String)billType)) {
                payAmount = (BigDecimal)model.getValue("encashamount");
                loanType = (String)model.getValue("loanchecktype");
            } else if (ErEntityTypeUtils.isTripReqBill((String)billType)) {
                payAmount = (BigDecimal)model.getValue("encashamount");
            }
            if (payAmount != null && payAmount.compareTo(BigDecimal.ZERO) > 0 && model.getValue("accountcurrency", 0) != null) {
                AmountChangeUtil.setReciveAmount((IFormView)view, (IDataModel)model, (BigDecimal)payAmount, (String)loanType);
            }
        } else if ("0".equals(isgetaccountcurrency) && model.getEntryRowCount("accountentry") == 1) {
            model.setValue("accexchangerate", (Object)BigDecimal.ONE, 0);
            model.setValue("accquotetype", (Object)"0", 0);
            model.setValue("accountcurrency", model.getValue("currency"), 0);
            AmountChangeUtil.accExchangeRateChange((Object)BigDecimal.ONE, (int)0, (IDataModel)model, (IFormView)view);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && parentView.getEntityId().contains("moblist")) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    private boolean isNeedToSetPayCompany() {
        String formId = this.getView().getEntityId();
        return ErEntityTypeUtils.isPrePayBill((String)formId) || ErEntityTypeUtils.isDailyLoanBill((String)formId) || ErEntityTypeUtils.isApplyPayBill((String)formId) || ErEntityTypeUtils.isDailyReimburseBill((String)formId) || ErEntityTypeUtils.isPublicReimburseBill((String)formId);
    }

    private void setApplierInfo(IDataModel model, Map paraMap) {
        DynamicObject applier = (DynamicObject)paraMap.get("applier");
        model.setValue("applier", applier == null ? null : applier.getPkValue());
        DynamicObject applierobj = (DynamicObject)model.getValue("applier");
        String applierStr = applierobj.getLocaleString("name").getLocaleValue();
        Label applierName = (Label)this.getControl("lb_name");
        applierName.setText(applierStr);
        String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applierobj.getPkValue()));
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
        model.setValue("applierpositionstr", paraMap.get("applierpositionstr"));
        model.setValue("tel", paraMap.get("tel"));
        if (applier != null) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put("consignorId", applier.getString("id"));
        }
    }

    protected void setDeptInfo(IDataModel model, Map<String, Object> map) {
        DynamicObject org = (DynamicObject)map.get("org");
        DynamicObject company = (DynamicObject)map.get("company");
        Long orgId = 0L;
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        Long companyId = 0L;
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        model.setValue("org", (Object)orgId);
        model.setValue("costcompany", (Object)CoreBaseBillServiceHelper.getAccountOrgId((Long)orgId));
        model.setValue("company", (Object)companyId);
        model.setValue("costdept", (Object)orgId);
    }

    protected void hideBillHead(IFormView view) {
        if (CommonServiceHelper.isSCENE((IFormView)view)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_applierinfo"});
        }
    }

    private void initaccbalamount() {
        try {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
            if (applier == null || currency == null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_norepay"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_norepay"});
            String sign = currency.getString("sign");
            sign = sign == null ? "\u00a5" : sign;
            int amtprecision = currency.getInt("amtprecision");
            amtprecision = amtprecision == 0 ? 2 : amtprecision;
            BigDecimal loanBalance = LoanBalanceServiceHelper.getPersonalLoanBalance((Long)((Long)applier.getPkValue()), (Long)currency.getLong("id"));
            if (loanBalance.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_norepay"});
                return;
            }
            loanBalance = loanBalance.setScale(amtprecision, 4);
            Label loanBalanceLabel = (Label)this.getControl("lab_norepayamount");
            loanBalanceLabel.setText(sign + AmountUtils.getThousandthFormat((Long)ErCommonUtils.getPk((Object)applier), (int)amtprecision, (BigDecimal)loanBalance));
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_norepay"});
        }
    }

    private void costDeptChange(DynamicObject costDept) {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (costDept == null || company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
        boolean isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        boolean isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue())));
        IDataModel dataModel = this.getModel();
        if (!isNotRelated && isModeOne) {
            if (showType == 3) {
                if (this.getModel().getEntryRowCount("expenseentryentity") > 0) {
                    dataModel.setValue("entrycostdept", (Object)costDept, 0);
                }
                return;
            }
            DynamicObject costCompany = (DynamicObject)dataModel.getValue("costcompany");
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            dataModel.setValue("costcompany", (Object)costCompanyId);
        } else {
            DynamicObject costCompany = (DynamicObject)dataModel.getValue("costcompany");
            int entryRowCount = dataModel.getEntryRowCount("expenseentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                dataModel.setValue("entrycostdept", (Object)costDept, i);
                if (!isModeOne) continue;
                dataModel.setValue("entrycostcompany", (Object)costCompany, i);
            }
        }
        if (!isModeOne) {
            ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "unsubmit": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LB_CHANGE});
            }
        }
    }

    private Set<String> getAllBillIdSet(String filterType) {
        String selectFieds = "id as billid,billno,applier,org,company";
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"E");
        qFilter.and(new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO));
        switch (filterType) {
            case "0": {
                qFilter.and(new QFilter("applier", "=", (Object)this.getFilterTypeId("applier")));
                qFilter.and(new QFilter("company", "=", (Object)this.getFilterTypeId("company")));
                break;
            }
            case "1": {
                qFilter.and(new QFilter("org", "=", (Object)this.getFilterTypeId("org")));
                break;
            }
            case "2": {
                qFilter.and(new QFilter("company", "=", (Object)this.getFilterTypeId("company")));
            }
        }
        Map allBillMap = BusinessDataServiceHelper.loadFromCache((String)"er_dailyapplybill", (String)selectFieds, (QFilter[])new QFilter[]{qFilter});
        Set<String> allBillIdSet = allBillMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()).stream().map(v -> v.getString("billno")).collect(Collectors.toSet());
        return allBillIdSet;
    }

    protected void deptChange(DynamicObject dept) {
        if (dept != null) {
            DynamicObjectCollection expItems;
            IDataModel model = this.getModel();
            Long deptId = (Long)dept.getPkValue();
            Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)deptId);
            model.setValue("company", (Object)companyId);
            int showType = 1;
            String billtype = (String)this.getModel().getValue("formid");
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyId);
            }
            if (showType == 2 && (expItems = this.getModel().getEntryEntity("expenseentryentity")).size() > 0) {
                this.getModel().setValue("entrycostdept", (Object)dept, 0);
            }
        }
    }

    private Long getFilterTypeId(String type) {
        if (StringUtils.equals((String)"company", (String)type) || StringUtils.equals((String)"org", (String)type)) {
            DynamicObject typeObject = (DynamicObject)this.getModel().getValue(type);
            return typeObject == null ? Long.valueOf(0L) : Long.valueOf(typeObject.getLong("id"));
        }
        if (StringUtils.equals((String)"applier", (String)type)) {
            DynamicObject typeObject = (DynamicObject)this.getModel().getValue(type);
            return typeObject == null ? Long.valueOf(0L) : (Long)typeObject.getPkValue();
        }
        return 0L;
    }
}

