/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.workflow.component.ApprovalRecord;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.ApplyToReimburseAutoCreateLoanRowEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.field.writeoffmoney.PublicContractWriteOffFields;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.common.ExpenseEntryMobPlugin;
import kd.fi.er.formplugin.daily.mobile.reimburse.propertychange.DailyReimbursePropChange;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ErDailyReimburseBillEditPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ErDailyReimburseBillEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_expense_add", "btn_next_add_expense", "label_expense_delete", "label_expense_done", "btn_addsection", "lab_delete", "lab_done", "lb_change"});
        AbstractGrid expenseGrid = (AbstractGrid)this.getView().getControl("expenseentryentity");
        expenseGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save", "btn_submit"});
        IDataModel dataModel = this.getModel();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) && this.getView() instanceof IMobileView) {
            dataModel.setValue("origin", (Object)2);
        }
    }

    public void afterLoadData(EventObject e) {
        IFormView parentView;
        super.afterLoadData(e);
        Object billstatus = this.getModel().getValue("billstatus");
        if ((StringUtils.equals((CharSequence)"A", (CharSequence)billstatus.toString()) || StringUtils.equals((CharSequence)"B", (CharSequence)billstatus.toString()) || StringUtils.equals((CharSequence)"D", (CharSequence)billstatus.toString())) && (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null) {
            parentView.setVisible(Boolean.valueOf(true), new String[]{"mtoolbarap"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        CommonViewControlUtil.initViewUserInfo(dataModel, view);
        CommonViewControlUtil.expensePageRules(dataModel, view);
        String billsStatus = (String)dataModel.getValue("billstatus");
        if (dataModel.getEntryRowCount("accountentry") < 1 && (StringUtils.equals((CharSequence)"A", (CharSequence)billsStatus) || StringUtils.equals((CharSequence)"D", (CharSequence)billsStatus))) {
            if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
                Object detailType = dataModel.getValue("detailtype");
                if (!"biztype_contract".equals(detailType)) {
                    CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)dataModel);
                }
            } else {
                CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)dataModel);
            }
        }
        if (view.getViewNoPlugin(view.getFormShowParameter().getParentPageId()) != null) {
            String billPageId = view.getPageId();
            IPageCache parentPageCache = (IPageCache)view.getViewNoPlugin(view.getFormShowParameter().getParentPageId()).getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
            logger.info("pageId:" + billPageId + ",view :" + view.getEntityId());
        }
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        CommonUtilHelper.setWriteOffAmountLable(dataModel, this.getView(), new boolean[0]);
        String loanType = (String)this.getModel().getValue("writeofftype");
        if (loanType.trim().isEmpty()) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            Object writeOffType = null;
            if (company != null) {
                writeOffType = ErCommonUtils.getLoanCheckType((long)Long.parseLong(company.getPkValue().toString()));
            }
            if (writeOffType == null || StringUtils.isBlank((CharSequence)writeOffType.toString())) {
                writeOffType = WriteOffTypeEnum.CURR_WO.getValue();
            }
            boolean dataChanged = this.getModel().getDataChanged();
            this.getModel().setValue("writeofftype", writeOffType);
            this.getModel().setDataChanged(dataChanged);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        String writeType = (String)dataModel.getValue("writeofftype");
        BigDecimal taxRate = null;
        switch (key) {
            case "payer": {
                if (propValue == null) break;
                DynamicObject payer = (DynamicObject)propValue;
                if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) break;
                CommonViewControlUtil.setPayerLabel(payer, this.getView());
                break;
            }
            case "expenseamount": {
                taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex);
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
                DailyReimbursePropChange.refreshAfterSetExpeAmount(propValue, rowIndex, dataModel);
                this.getModel().setValue("expeapproveamount", propValue, rowIndex);
                this.getView().updateView("currexpenseamount", rowIndex);
                this.getView().updateView("exchangerate", rowIndex);
                this.getView().updateView("expeapproveamount", rowIndex);
                this.getView().updateView("expeapprovecurramount", rowIndex);
                CommonUtilHelper.setWriteOffAmountLable(dataModel, this.getView(), new boolean[0]);
                break;
            }
            case "expeapproveamount": {
                WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propValue), (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                CommonUtilHelper.setWriteOffAmountLable(dataModel, this.getView(), new boolean[0]);
                taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                AmountChangeUtil.updateApproveInfo((IDataModel)this.getModel(), (int)rowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)key);
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"currency", (ChangeField)ChangeField.EXPEAPPROVE_AMOUNT);
                break;
            }
            case "accloanamount": {
                if (!WriteOffTypeEnum.ORGI_WO.getValue().equals(writeType)) break;
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propValue), (String)"curraccloanamount", (String)"loanexchangerate", (String)"writeoffquotetype", (int)rowIndex);
                break;
            }
            case "reimbursedamount": {
                if (!writeType.equals(WriteOffTypeEnum.ORGI_WO.getValue())) break;
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propValue), (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"writeoffapplyquotetype", (int)rowIndex);
                break;
            }
            case "reimbursedcurramount": {
                if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeType)) {
                    return;
                }
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("writeoffapplyquotetype", rowIndex)), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)dataModel.getValue("applyexchangerate", rowIndex)), (Object)BigDecimal.ONE);
                BigDecimal currAmount = (BigDecimal)propValue;
                BigDecimal oriAmount = AmountUtils.getOriAmount((BigDecimal)currAmount, (BigDecimal)exchangeRate, (int)AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"applycurrency"), (String)quoteType);
                dataModel.setValue("reimbursedamount", (Object)oriAmount, rowIndex);
            }
            case "applier": 
            case "company": {
                DynamicObjectCollection writeoffmoneyCols = (DynamicObjectCollection)dataModel.getDataEntity(true).get("writeoffmoney");
                writeoffmoneyCols.stream().forEach(writeoffmoney -> {
                    writeoffmoney.set("curraccloanamount", (Object)BigDecimal.ZERO);
                    writeoffmoney.set("accloanamount", (Object)BigDecimal.ZERO);
                });
                CommonUtilHelper.setWriteOffAmountLable(dataModel, this.getView(), new boolean[0]);
                dataModel.deleteEntryData("writeoffmoney");
                break;
            }
            case "org": {
                Long companyId = ErCommonUtils.getPk((Object)dataModel.getValue("company"));
                String range = SystemParamterUtil.getLoanDrawRange((Long)companyId);
                if (!StringUtils.equals((CharSequence)range, (CharSequence)"2")) break;
                DynamicObjectCollection writeoffmoneyCols = (DynamicObjectCollection)dataModel.getDataEntity(true).get("writeoffmoney");
                writeoffmoneyCols.stream().forEach(writeoffmoney -> {
                    writeoffmoney.set("curraccloanamount", (Object)BigDecimal.ZERO);
                    writeoffmoney.set("accloanamount", (Object)BigDecimal.ZERO);
                });
                CommonUtilHelper.setWriteOffAmountLable(dataModel, this.getView(), new boolean[0]);
                dataModel.deleteEntryData("writeoffmoney");
                break;
            }
            case "costcompany": {
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)SystemParamterUtil.getLoanDrawRange((Long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")))) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) break;
                while (this.getModel().getEntryRowCount("writeoffmoney") > 0) {
                    dataModel.deleteEntryRow("writeoffmoney", 0);
                }
                break;
            }
            case "expenseitem": {
                DynamicObject newExpenseItem = (DynamicObject)propValue;
                if (newExpenseItem == null) {
                    InvoiceUtils.updateTaxWhenItemChange((IFormView)this.getView(), (IDataModel)dataModel, (BigDecimal)BigDecimal.ZERO, (int)rowIndex, (int)parentRowIndex);
                } else if (newExpenseItem.containsProperty("taxrate")) {
                    BigDecimal taxRateFromExpenseItem = newExpenseItem.getBigDecimal("taxrate");
                    InvoiceUtils.updateTaxWhenItemChange((IFormView)this.getView(), (IDataModel)dataModel, (BigDecimal)taxRateFromExpenseItem, (int)rowIndex, (int)parentRowIndex);
                }
                if (newExpenseItem == null) {
                    InvoiceUtils.updateOffsetWhenItemChange((IFormView)this.getView(), (IDataModel)dataModel, (Boolean)false, (int)rowIndex, (int)parentRowIndex);
                    break;
                }
                if (!newExpenseItem.containsProperty("offset")) break;
                Boolean itemOffset = newExpenseItem.getBoolean("offset");
                InvoiceUtils.updateOffsetWhenItemChange((IFormView)this.getView(), (IDataModel)dataModel, (Boolean)itemOffset, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "currency": {
                CommonViewControlUtil.expensePageRules(this.getModel(), this.getView());
                CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
                this.changeWriteOffLabel();
                break;
            }
            case "approvetax": {
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency", (ChangeField)ChangeField.APPROVE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.APPROVE_TAX);
                break;
            }
            case "taxamount": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false);
                this.setDefaultApproveTax(rowIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false, (String)key);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.TAX_AMOUNT);
                break;
            }
            case "offset": {
                taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)key);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "price": {
                AmountChangeUtil.setCurPrice((IDataModel)dataModel, (IFormView)this.getView(), (BigDecimal)((BigDecimal)propValue), (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency");
                break;
            }
            case "iteminoutamount": {
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "deductibletax": {
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency", (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "invoicecurrency": {
                if (propValue == null) break;
                long pkValue = (Long)((DynamicObject)propValue).getPkValue();
                InvoiceUtils.lockCurrency((IFormView)this.getView(), Collections.singleton(pkValue));
                break;
            }
            case "entrycurrency": {
                if (propValue == null) {
                    dataModel.setValue("entrycurrency", valueSet[0].getOldValue(), rowIndex);
                    break;
                }
                Object company = this.getModel().getValue("company");
                Object costCompany = this.getModel().getValue("costcompany");
                Long headCurrency = (Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue();
                Long entryCurrencyId = (Long)((DynamicObject)propValue).getPkValue();
                Map changeRateMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)entryCurrencyId, (Long)headCurrency, (Object)this.getModel());
                if (changeRateMap == null || changeRateMap.isEmpty()) break;
                this.getModel().setValue("expquotetype", changeRateMap.get("quoteType"), rowIndex);
                this.getModel().setValue("exchangerate", changeRateMap.get("exchangeRate"), rowIndex);
                break;
            }
            case "expeapprovecurramount": {
                ExpenseEntryMobPlugin.refreshAmount(dataModel, this.getView());
                if (this.getView() instanceof MobileBillView && ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityId())) {
                    ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
                }
                int entryRowCount = this.getModel().getEntryRowCount("writeoffmoney");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getView().updateView("curraccloanamount", i);
                }
                if (!ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) break;
                int count = dataModel.getEntryRowCount("expenseentryentity");
                String billPayerType = (String)dataModel.getValue("billpayertype");
                if (count == 1 && org.apache.commons.lang3.StringUtils.equals((CharSequence)billPayerType, (CharSequence)"bos_user")) {
                    PublicBillUtil.refreshAccountEntry((IDataModel)dataModel);
                }
                PublicBillUtil.writeOffContract((IDataModel)dataModel, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                if ("1".equals(writeType) && dataModel.getEntryRowCount("contractentry") > 0) {
                    DynamicObjectCollection contracts = dataModel.getEntryEntity("contractentry");
                    for (int i = 0; i < contracts.size(); ++i) {
                        PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)dataModel, (BigDecimal)((DynamicObject)contracts.get(i)).getBigDecimal("contractwriteoff"), (int)i);
                    }
                }
                PublicBillUtil.updateContractWriteoffView((IDataModel)dataModel, (IFormView)this.getView());
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if ("expenseentryentity".equalsIgnoreCase(e.getEntryProp().getName())) {
            IDataModel model = this.getModel();
            model.beginInit();
            String writeOffType = (String)model.getValue("writeofftype");
            WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
            WriteOffMoneyUtils.writeOffMoney((IDataModel)model, (String)writeOffType, (IFormView)this.getView());
            if (WriteOffTypeEnum.ORGI_WO.getValue().equalsIgnoreCase(writeOffType)) {
                int i;
                if (model.getEntryRowCount("writeoffmoney") > 0) {
                    for (i = 0; i < model.getEntryRowCount("writeoffmoney"); ++i) {
                        BigDecimal woAmount = (BigDecimal)model.getValue("accloanamount", i);
                        AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woAmount, (String)"curraccloanamount", (String)"loanexchangerate", (String)"writeoffquotetype", (int)i);
                    }
                }
                if (model.getEntryRowCount("writeoffapply") > 0) {
                    for (i = 0; i < model.getEntryRowCount("writeoffapply"); ++i) {
                        BigDecimal woApplyAmount = (BigDecimal)model.getValue("reimbursedamount", i);
                        AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woApplyAmount, (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"writeoffapplyquotetype", (int)i);
                    }
                }
            }
            model.endInit();
            CommonUtilHelper.setWriteOffAmountLable(model, this.getView(), new boolean[0]);
            this.refreshLoanCheckEntry();
        }
    }

    private void refreshLoanCheckEntry() {
        int entryRowCount = this.getModel().getEntryRowCount("writeoffmoney");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().updateView("accloanamount", i);
            this.getView().updateView("curraccloanamount", i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        Boolean isCopy = Boolean.valueOf(this.getPageCache().get("isentrycopy"));
        this.getPageCache().remove("isentrycopy");
        Boolean bl = isCopy = isCopy == null ? Boolean.FALSE : isCopy;
        if ("expenseentryentity".equals(entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
            DynamicObject costDept = (DynamicObject)model.getValue("costdept");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                if (isCopy.booleanValue()) {
                    BigDecimal amount = BigDecimal.ZERO;
                    try {
                        amount = rowDataEntity.getDataEntity().getBigDecimal("expenseamount");
                    }
                    catch (Exception msg) {
                        amount = BigDecimal.ZERO;
                    }
                    this.getModel().setValue("expenseamount", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("expenseamount", (Object)amount, rowIndex);
                    continue;
                }
                model.beginInit();
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), rowIndex);
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), rowIndex);
                model.endInit();
                this.getView().updateView("entrycostcompany", rowIndex);
                this.getView().updateView("entrycostdept", rowIndex);
                model.setValue("entrycurrency", currency == null ? null : currency.getPkValue(), rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        String entityId = this.getView().getEntityId();
        switch (operateKey) {
            case "save": {
                if (this.validata(args, operateKey)) {
                    return;
                }
                this.refreshBillAmount();
                break;
            }
            case "submit": {
                boolean isReimber;
                if (this.validata(args, operateKey)) {
                    return;
                }
                boolean bl = isReimber = ErEntityTypeUtils.isTripReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId);
                if (isReimber) {
                    OffsetUtils.updateInvoiceOffsetBeforeOpe((IFormView)this.getView(), (IDataModel)this.getModel());
                }
                this.refreshBillAmount();
            }
        }
    }

    private void refreshBillAmount() {
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        BigDecimal expeAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"expeapprovecurramount");
        dataModel.setValue("reimburseamount", (Object)expeAmount);
        dataModel.setValue("approveamount", (Object)expeAmount);
        BigDecimal notpayamount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"accountentry", (String)"accnotpayamount");
        dataModel.setValue("notpayamount", (Object)notpayamount);
        BigDecimal totalPayedAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"accountentry", (String)"oriaccpayedamount");
        dataModel.setValue("payedamount", (Object)totalPayedAmount);
        BigDecimal totalWriteOffAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"writeoffmoney", (String)"curraccloanamount");
        dataModel.setValue("totalaccloanamount", (Object)totalWriteOffAmount);
        if (ErEntityTypeUtils.isPublicReimburseBill((String)dataModel.getDataEntityType().getName())) {
            PublicBillUtil.calNonpayAmount((IDataModel)dataModel);
        }
        dataModel.endInit();
    }

    private boolean validata(BeforeDoOperationEventArgs args, String operateKey) {
        String writeOffType;
        boolean isCancel = false;
        IDataModel dataModel = this.getModel();
        if (dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null && Boolean.TRUE.equals(dataModel.getValue("proxytax"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u5355\u636e\u8bf7\u5728PC\u7aef\u5904\u7406\u3002", (String)"ErDailyReimburseBillEditPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        if ("submit".equals(operateKey)) {
            int accountRowCount = this.getModel().getEntryRowCount("accountentry");
            if (accountRowCount < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u94f6\u884c\u5361\u3002", (String)"ErDailyReimburseBillEditPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
            Object value = this.getModel().getValue("payer");
            Object payername = this.getModel().getValue("payername");
            String entityId = this.getView().getEntityId();
            if (value == null && payername == null && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u94f6\u884c\u5361\u3002", (String)"ErDailyReimburseBillEditPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
        }
        if (!(writeOffType = (String)ErCommonUtils.getLoanCheckType((long)Long.parseLong(((DynamicObject)dataModel.getValue("company")).getPkValue().toString()))).equals("1")) {
            BigDecimal expenseAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"currexpenseamount");
            BigDecimal writeOffAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"writeoffmoney", (String)"curraccloanamount");
            if (writeOffAmount.compareTo(BigDecimal.ZERO) > 0 && expenseAmount.compareTo(writeOffAmount) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u8d39\u7528\u62a5\u9500\u603b\u8ba1\u91d1\u989d\u3002", (String)"ErDailyReimburseBillEditPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
        }
        args.setCancel(isCancel);
        return isCancel;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && !result.isSuccess()) {
            return;
        }
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        switch (key) {
            case "submit": {
                BillShowParameter billShowParameter;
                if (parentView != null) {
                    parentView.close();
                    view.sendFormAction(parentView);
                }
                if ((billShowParameter = (BillShowParameter)view.getFormShowParameter()).getBillStatus() != BillOperationStatus.ADDNEW && billShowParameter.getBillStatus() != BillOperationStatus.SUBMIT && BillOperationStatus.EDIT != billShowParameter.getBillStatus()) break;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("formId", view.getEntityId());
                paramMap.put("templateId", "er_reimbursebill_moblist");
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("need_refresh", "Y");
                paramMap.put("customParam", customParam);
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "copy": {
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)parentView.getEntityId(), (CharSequence)"er_dlbill_tabap")) break;
                ApprovalRecord approvalRecord = (ApprovalRecord)parentView.getControl("approvalrecordap");
                approvalRecord.setArData(null);
                parentView.updateView("approvalrecordap");
                view.sendFormAction(parentView);
            }
        }
    }

    private void changeWriteOffLabel() {
        if (this.getModel().getProperty("writeoffmoney") != null && this.getModel().getProperty("curraccloanamount") != null && this.getControl("label_writeoff_account") != null) {
            CommonViewControlUtil.setAmountToLabel(this.getModel(), this.getView(), "writeoffmoney", "curraccloanamount", "label_writeoff_account", (DynamicObject)this.getModel().getValue("currency"));
        }
    }

    private void setDefaultApproveTax(int rowIndex) {
        if (this.getModel().getProperty("approvetax") != null) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex);
            this.getModel().setValue("approvetax", (Object)taxAmount, rowIndex);
        }
    }

    private void whenExchangeRateChangeRefreshCurrAmount(ChangeData[] valueSet, int rowIndex, int parentRowIndex) {
        IDataModel dataModel = this.getModel();
        if (dataModel.getProperty("tripbookamount") != null && dataModel.getProperty("tripbookcuramount") != null) {
            BigDecimal oriorderamt = (BigDecimal)dataModel.getValue("tripbookamount", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)oriorderamt, (String)"tripbookcuramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
            BigDecimal monthSettleAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"tripbookcuramount");
            dataModel.setValue("monthsettleamount", (Object)monthSettleAmount);
        }
        BigDecimal orgReimAmount = (BigDecimal)dataModel.getValue("expenseamount", rowIndex, parentRowIndex);
        AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)orgReimAmount, (String)"currexpenseamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        if (dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null) {
            BigDecimal oriproxyamt = (BigDecimal)dataModel.getValue("proxyamt", rowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)oriproxyamt, (String)"curproxyamt", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
        }
        if (dataModel.getProperty("expeapproveamount") != null && dataModel.getProperty("expeapprovecurramount") != null) {
            BigDecimal approveAmount = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)approveAmount, (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        }
        if (dataModel.getProperty("price") != null && dataModel.getProperty("curprice") != null) {
            BigDecimal price = (BigDecimal)dataModel.getValue("price", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)price, (String)"curprice", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && "writeoffmoney".equalsIgnoreCase(e.getEntryProp().getName())) {
            String autoCreate = ErStdConfig.get((String)"applytoreimburse.autocreateloanrow");
            int[] rowIndexs = e.getRowIndexs();
            if (rowIndexs != null && ApplyToReimburseAutoCreateLoanRowEnum.AUTO_CREATE_LOANROW.getValue().equals(autoCreate)) {
                for (int i : rowIndexs) {
                    if (!((Boolean)this.getModel().getValue("sourcesign", i)).booleanValue()) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u5173\u8054\u7684\u501f\u6b3e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ErDailyReimburseBillEditPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }
}

