/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ErDailyReimburseBillListPlugin
extends CoreBaseBillListNew
implements ClickListener,
TabSelectListener {
    private Log logger = LogFactory.getLog(ErDailyReimburseBillListPlugin.class);
    private static final List<String> doingStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E1", "F"}));
    private static final List<String> didStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"E2", "G", "H", "I"}));
    private static final MobileListStateInfo doingStateInfo = new MobileListStateInfo("doingtab", doingStateList, new MultiLang(ErDailyReimburseBillListPlugin.getAuditMsg(), "ErDailyReimburseBillListPlugin_2", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", didStateList, new MultiLang(ErDailyReimburseBillListPlugin.getCompleteMsg(), "ErDailyReimburseBillListPlugin_3", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)2);

    public ErDailyReimburseBillListPlugin() {
        super(stateInfoList);
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        super.contextMenuClick(e);
        String billName = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
        MobileListShowParameter mobListShowParameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        String billFormId = mobListShowParameter.getBillFormId();
        if (e.getItemKey().toLowerCase().equals("add_reimburse")) {
            MobileBillShowParameter showParameter = new MobileBillShowParameter();
            String formId = billFormId + "_mob";
            showParameter.setFormId(formId);
            showParameter.setCaption(billName);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)ShowType.Floating, (Object)ShowType.Floating);
            showParameter.getOpenStyle().setShowType(showType);
            showParameter.setAppId("18X6P1ZSXS44");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Object expenseitemid;
        if (StringUtils.isEmpty((CharSequence)this.getView().getFormShowParameter().getAppId())) {
            this.getView().getFormShowParameter().setAppId("exp");
        }
        if ((expenseitemid = this.isEmployeeAmount()) != null) {
            return;
        }
        super.afterCreateNewData(e);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        Object expenseitemid;
        if (StringUtils.isEmpty((CharSequence)this.getView().getFormShowParameter().getAppId())) {
            this.getView().getFormShowParameter().setAppId("exp");
        }
        if ((expenseitemid = this.isEmployeeAmount()) != null) {
            ArrayList qfList = Lists.newArrayList();
            qfList.addAll(e.getQFilters());
            qfList.add(e.getSpecialDataPermQFilter());
            this.hasDate(qfList);
            if (this.isPersonalAmountQuery()) {
                e.setSpecialDataPermQFilter(null);
            }
        } else {
            super.setFilter(e);
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object expenseitemid = this.isEmployeeAmount();
        if (expenseitemid != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.setCancel(true);
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_dlbill_tabap");
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "copy": {
                String entityName = source.getEntityId();
                if (!ErEntityTypeUtils.isPublicReimburseBill((String)entityName)) break;
                Long pkId = (Long)source.getListSelectedData().get(0).getPrimaryKeyValue();
                DynamicObject selectedBill = QueryServiceHelper.queryOne((String)entityName, (String)"detailtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
                if (StringUtils.equalsIgnoreCase((CharSequence)"biztype_other", (CharSequence)selectedBill.getString("detailtype"))) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62a5\u9500\u5355\u7684\u5173\u8054\u4e1a\u52a1\u4e0d\u4e3a\u5176\u4ed6\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ErDailyReimburseBillListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void hasDate(List<QFilter> qfList) {
        DynamicObject dobj = QueryServiceHelper.queryOne((String)"er_dailyreimbursebill", (String)"billstatus", (QFilter[])qfList.toArray(new QFilter[0]));
        if (dobj != null) {
            this.showDefaultViewInfo(true);
        } else {
            this.showDefaultViewInfo(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"page_default"});
        }
    }

    private Object isEmployeeAmount() {
        Object formid;
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        if (paraMap != null && ObjectUtils.equals(formid = paraMap.get("formid"), (Object)"er_employee_amt_query_mb")) {
            Object expenseitemid = paraMap.get("expenseitemid");
            return expenseitemid;
        }
        return null;
    }

    private boolean isPersonalAmountQuery() {
        Object formid;
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        if (paraMap != null && ObjectUtils.equals(formid = paraMap.get("formid"), (Object)"er_employee_amt_query_mb")) {
            return StringUtils.equals((CharSequence)((String)paraMap.get("amounttype")), (CharSequence)"1");
        }
        return false;
    }

    private static String getAuditMsg() {
        return ResManager.loadKDString((String)"\u62a5\u9500\u4e2d", (String)"ErDailyReimburseBillListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ErDailyReimburseBillListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(doingStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

