/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse.listener;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.list.AbstractMobF7Plugin;
import kd.bos.list.OrgList;
import kd.bos.list.events.BackPressedEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ItemSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.events.QueryListEvent;
import kd.bos.list.events.SelectEvent;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class ExpenseItemF7SelectMobileList
extends AbstractMobF7Plugin
implements ListSelectedListener {
    public static final String EXPENSE_ITEM_MOBILE_LIST = "expenseitemmobilelist";
    private static final long ROOT_EXPENSE_ITEM_ID = OrgUnitServiceHelper.getRootOrgId();
    private static final String ENTITY_ER_EXPENSEITEMEDIT = "er_expenseitemedit";
    private static final String SPLIT_LONG_NUMBER = ".";
    private static final String ALGO = ExpenseItemF7SelectMobileList.class.getName();

    private static String getROOT_EXPENSE_ITEM_NAME() {
        return ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u865a\u62df\u6839\u8282\u70b9", (String)"ExpenseItemF7SelectMobileList_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        OrgList orgList = (OrgList)this.getView().getControl(EXPENSE_ITEM_MOBILE_LIST);
        if (orgList != null) {
            orgList.addListSelectedListener((ListSelectedListener)this);
            this.addClickListeners(new String[]{EXPENSE_ITEM_MOBILE_LIST});
        }
    }

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
        dataMap.put("k", EXPENSE_ITEM_MOBILE_LIST);
        Long initExpenseItemId = ROOT_EXPENSE_ITEM_ID;
        dataMap.put("initOrgId", ((Object)initExpenseItemId).toString());
        dataMap.put("initOrgHistory", this.initExpenseItemHistory());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", dataMap);
    }

    private List<Map<String, Object>> initExpenseItemHistory() {
        ArrayList<Map<String, Object>> expenseItemList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", ROOT_EXPENSE_ITEM_ID);
        dataMap.put("name", ExpenseItemF7SelectMobileList.getROOT_EXPENSE_ITEM_NAME());
        dataMap.put("hp", true);
        dataMap.put("hc", true);
        expenseItemList.add(dataMap);
        return expenseItemList;
    }

    public void itemSelect(ItemSelectEvent evt) {
        long expenseItemId = ROOT_EXPENSE_ITEM_ID;
        if (StringUtils.isNotBlank((Object)evt.getData())) {
            expenseItemId = Long.parseLong(evt.getData().toString());
        }
        this.updateClientData(expenseItemId, false);
    }

    private void updateClientData(long expenseItemId, boolean isUseCache) {
        Map dataMap = null;
        String dataCache = null;
        if (isUseCache) {
            dataCache = this.getPageCache().get(Long.toString(expenseItemId));
        }
        dataMap = dataCache == null ? this.queryExpenseItemDataById(expenseItemId) : (Map)SerializationUtils.fromJsonString((String)dataCache, Map.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", (Object)dataMap);
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> queryExpenseItemDataById(long expenseItemId) {
        dataMap = new HashMap<String, Object>();
        config = new HashMap<String, LocaleString>();
        config.put("title", new LocaleString(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"ExpenseItemF7SelectMobileList_1", (String)"fi-er-formplugin", (Object[])new Object[0])));
        dataMap.put("config", config);
        filters = null;
        expItemMap = new HashMap<Long, HashMap<K, V>>();
        expendedLongNumber_and_split = "";
        if (expenseItemId != ExpenseItemF7SelectMobileList.ROOT_EXPENSE_ITEM_ID) {
            filters = new QFilter[]{new QFilter("id", "=", (Object)expenseItemId)};
            ds = QueryServiceHelper.queryDataSet((String)ExpenseItemF7SelectMobileList.ALGO, (String)"er_expenseitemedit", (String)"longnumber,name,parent,isleaf", (QFilter[])filters, null);
            var9_8 = null;
            try {
                iterator = ds.iterator();
                if (!iterator.hasNext()) ** GOTO lbl64
                row = (Row)iterator.next();
                expendedLongNumber_and_split = row.getString("longnumber") + ".";
                expId = expenseItemId;
                parentId = row.getLong("parent");
                isLeaf = row.getBoolean("isleaf");
                expItem = new HashMap<String, Object>();
                expItem.put("id", expId);
                expItem.put("name", row.get("name"));
                expItem.put("longnumber", row.get("longnumber"));
                expItem.put("parent", parentId);
                expItem.put("isleaf", isLeaf);
                expItemMap.put(expId, expItem);
            }
            catch (Throwable iterator) {
                var9_8 = iterator;
                throw iterator;
            }
            finally {
                if (ds != null) {
                    if (var9_8 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iterator) {
                            var9_8.addSuppressed(iterator);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        } else {
            expenseItemId = 0L;
            expItem = new HashMap<String, Object>();
            expItem.put("id", expenseItemId);
            expItem.put("name", "root");
            expItem.put("longnumber", "");
            expItem.put("parent", -1L);
            expItem.put("isleaf", false);
            expItemMap.put(expenseItemId, expItem);
        }
lbl64:
        // 3 sources

        relatedExpenseItemFilter = this.buildRelatedFilter();
        filters = expendedLongNumber_and_split.isEmpty() == false ? new QFilter[]{relatedExpenseItemFilter, new QFilter("longnumber", "like", (Object)(expendedLongNumber_and_split + "%"))} : new QFilter[]{relatedExpenseItemFilter};
        selectFields = "id,name,parent,isleaf,longnumber";
        expIdsNeedToFindAncestor = new HashSet<Long>();
        ds = QueryServiceHelper.queryDataSet((String)ExpenseItemF7SelectMobileList.ALGO, (String)"er_expenseitemedit", (String)selectFields, (QFilter[])filters, null);
        expId = null;
        try {
            for (Row row : ds) {
                expId = row.getLong("id");
                parentId = row.getLong("parent");
                isLeaf = row.getBoolean("isleaf");
                if (!isLeaf) continue;
                if (parentId == expenseItemId) {
                    expItem = new HashMap<String, Object>();
                    expItem.put("id", expId);
                    expItem.put("name", row.get("name"));
                    expItem.put("longnumber", row.get("longnumber"));
                    expItem.put("parent", parentId);
                    expItem.put("isleaf", isLeaf);
                    expItemMap.put(expId, expItem);
                    continue;
                }
                expIdsNeedToFindAncestor.add(parentId);
            }
        }
        catch (Throwable var13_30) {
            expId = var13_30;
            throw var13_30;
        }
        finally {
            if (ds != null) {
                if (expId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable var13_29) {
                        expId.addSuppressed(var13_29);
                    }
                } else {
                    ds.close();
                }
            }
        }
        while (!expIdsNeedToFindAncestor.isEmpty()) {
            filters = new QFilter[]{new QFilter("id", "in", expIdsNeedToFindAncestor)};
            ds = QueryServiceHelper.queryDataSet((String)ExpenseItemF7SelectMobileList.ALGO, (String)"er_expenseitemedit", (String)"id,name,parent,longnumber", (QFilter[])filters, null);
            expId = null;
            try {
                expIdsNeedToFindAncestor.clear();
                for (Row row : ds) {
                    expId = row.getLong("id");
                    parentId = row.getLong("parent");
                    if (parentId == expenseItemId) {
                        expItem = new HashMap<String, Object>();
                        expItem.put("id", expId);
                        expItem.put("name", row.get("name"));
                        expItem.put("longnumber", row.get("longnumber"));
                        expItem.put("parent", parentId);
                        expItem.put("isleaf", false);
                        expItemMap.put(expId, expItem);
                        continue;
                    }
                    if (parentId <= 0L) continue;
                    expIdsNeedToFindAncestor.add(parentId);
                }
            }
            catch (Throwable var13_32) {
                expId = var13_32;
                throw var13_32;
            }
            finally {
                if (ds == null) continue;
                if (expId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable var13_31) {
                        expId.addSuppressed(var13_31);
                    }
                    continue;
                }
                ds.close();
            }
        }
        if (!expItemMap.isEmpty()) {
            expItemList = new ArrayList<V>(expItemMap.values());
            expItemList.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$queryExpenseItemDataById$0(java.util.Map java.util.Map ), (Ljava/util/Map;Ljava/util/Map;)I)());
            subExpenseItemList = new ArrayList<HashMap<String, Object>>(expItemMap.size());
            for (Map expItem : expItemList) {
                curExpenseItemId = (Long)expItem.get("id");
                if (expenseItemId == curExpenseItemId) {
                    this.genDataMap(curExpenseItemId, dataMap, expItem);
                    continue;
                }
                subDataMap = new HashMap<String, Object>();
                this.genDataMap(curExpenseItemId, subDataMap, expItem);
                subExpenseItemList.add(subDataMap);
            }
            dataMap.put("orgs", subExpenseItemList);
        }
        returnDataMap = new HashMap<String, Object>();
        returnDataMap.put("k", "expenseitemmobilelist");
        returnDataMap.put("data", dataMap);
        this.getPageCache().put(Long.toString(expenseItemId), SerializationUtils.toJsonString(returnDataMap));
        return returnDataMap;
    }

    private QFilter buildRelatedFilter() {
        List numbers;
        DynamicObject projecttype;
        DynamicObject standardType;
        Set nums;
        String reimbursetype;
        String formIdSign = (String)this.getView().getFormShowParameter().getCustomParam("formIdSign");
        Object costcompany = this.getView().getFormShowParameter().getCustomParam("costcompanyId");
        Object costOrg = this.getView().getFormShowParameter().getCustomParam("costOrgId");
        Long costcompanyId = 0L;
        if (costcompany != null && StringUtils.isNotBlank((CharSequence)costcompany.toString())) {
            costcompanyId = Long.valueOf(costcompany.toString());
        }
        Long costOrgId = 0L;
        if (costOrg != null && StringUtils.isNotBlank((CharSequence)costOrg.toString())) {
            costOrgId = Long.valueOf(costOrg.toString());
        }
        QFilter bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_ER_EXPENSEITEMEDIT, (Long)costcompanyId);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getModel().getProperty("reimbursetype") != null && StringUtils.isNotBlank((CharSequence)(reimbursetype = (String)parentView.getModel().getValue("reimbursetype"))) && !(nums = FeeStandardHelper.getStandardTypeFilterInExpenseItem((DynamicObject)(standardType = FeeStandardHelper.queryStandardType((String)reimbursetype)))).isEmpty()) {
            QFilter qfilter = new QFilter("number", "in", (Object)nums);
            if (bdFilter != null) {
                qfilter.and(bdFilter);
            }
            qfilter.and(ExpenseItemServiceHelper.getRelDeptFilter((Long)costOrgId));
            return qfilter;
        }
        QFilter treeFilter = ExpenseItemServiceHelper.getRelExpItemsFilter((String)formIdSign, (Long)costOrgId);
        if (bdFilter != null) {
            treeFilter.and(bdFilter);
        }
        if (parentView instanceof MobileBillView && ("er_apply_project_entry".equals(((MobileBillView)parentView).getFormId()) || "er_contractplan_mb".equals(((MobileBillView)parentView).getFormId()) || "er_contractplan_change_mb".equals(((MobileBillView)parentView).getFormId()) || "er_prepay_expense_entry".equals(((MobileBillView)parentView).getFormId()) || "er_loan_expense_entry".equals(((MobileBillView)parentView).getFormId()) || "er_reimburse_expense_mb".equals(((MobileBillView)parentView).getFormId()) || "er_apply_expense_entry".equals(((MobileBillView)parentView).getFormId()) || "er_pub_reim_expense_mb".equals(((MobileBillView)parentView).getFormId())) && parentView.getModel() != null && parentView.getModel().getProperty("projecttype") != null && (projecttype = (DynamicObject)parentView.getModel().getValue("projecttype")) != null && !(numbers = projecttype.getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong("expenseitem.id")).collect(Collectors.toList())).isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", numbers);
            treeFilter.and(qFilter);
        }
        if (parentView instanceof MobileBillView && ErEntityTypeUtils.isReimCtlApplyBill((String)parentView.getEntityId())) {
            QFilter qFilter = new QFilter("isreimburseamountctl", "=", (Object)"1");
            treeFilter.and(qFilter);
        }
        return treeFilter;
    }

    private DynamicObjectCollection queryExpenseItemByFilter(QFilter filter) {
        String selectFields = "id, name, parent, isleaf, longnumber";
        QFilter[] filters = new QFilter[]{filter, this.buildRelatedFilter()};
        DynamicObjectCollection expenseItemCol = QueryServiceHelper.query((String)ENTITY_ER_EXPENSEITEMEDIT, (String)selectFields, (QFilter[])filters, (String)"isleaf, longnumber");
        return expenseItemCol;
    }

    private Set<String> getOneLevelNumberSet(Set<String> longNumberSet) {
        int setSize = 20;
        HashSet<String> oneLevelNumSet = new HashSet<String>(setSize);
        if (longNumberSet == null || longNumberSet.size() < 1) {
            return oneLevelNumSet;
        }
        for (String longNumber : longNumberSet) {
            if (StringUtils.isBlank((CharSequence)longNumber)) continue;
            String oneLevelNumber = this.substringFirstIndex(longNumber);
            oneLevelNumSet.add(oneLevelNumber);
        }
        return oneLevelNumSet;
    }

    private String substringFirstIndex(String str) {
        if (!StringUtils.isEmpty((CharSequence)str) && !StringUtils.isEmpty((CharSequence)SPLIT_LONG_NUMBER) && str.indexOf(SPLIT_LONG_NUMBER) != -1) {
            int pos = str.indexOf(SPLIT_LONG_NUMBER);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    private void genDataMap(long expenseItemId, Map<String, Object> dataMap, Map<String, Object> expenseItem) {
        dataMap.put("id", Long.toString(expenseItemId));
        dataMap.put("name", (String)expenseItem.get("name"));
        dataMap.put("hp", (Long)expenseItem.get("parent") != -1L);
        boolean isleaf = (Boolean)expenseItem.get("isleaf");
        dataMap.put("hc", !isleaf);
        dataMap.put("ca", isleaf);
    }

    public void backPressed(BackPressedEvent evt) {
        if (StringUtils.isBlank((Object)evt.getData())) {
            this.getView().close();
            return;
        }
        long expenseItemId = Long.parseLong(evt.getData().toString());
        if (ROOT_EXPENSE_ITEM_ID == expenseItemId) {
            this.getView().close();
            return;
        }
        QFilter expenseItemFilter = new QFilter("id", "=", (Object)expenseItemId);
        DynamicObjectCollection expenseItemCol = this.queryExpenseItemByFilter(expenseItemFilter);
        if (expenseItemCol == null || expenseItemCol.isEmpty()) {
            this.getView().close();
            return;
        }
        long parentId = ((DynamicObject)expenseItemCol.get(0)).getLong("parent");
        if (parentId == 0L) {
            parentId = ROOT_EXPENSE_ITEM_ID;
        }
        this.updateClientData(parentId, true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void endSelect(EndSelectEvent endSelectEvent) {
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)endSelectEvent.getData();
        if (listSelectedRows == null || listSelectedRows.size() == 0) {
            listSelectedRows = new ListSelectedRowCollection();
            listSelectedRows.setClearFlag(true);
        }
        endSelectEvent.setData((Object)listSelectedRows);
        this.getView().returnDataToParent(endSelectEvent.getData());
        this.getView().close();
    }

    public void select(SelectEvent evt) {
        long expenseItemId = ROOT_EXPENSE_ITEM_ID;
        if (StringUtils.isNotBlank((Object)evt.getData())) {
            expenseItemId = Long.parseLong(evt.getData().toString());
        }
        this.updateClientData(expenseItemId, true);
    }

    public void query(QueryListEvent evt) {
        if (StringUtils.isBlank((Object)evt.getData())) {
            this.updateClientData(ROOT_EXPENSE_ITEM_ID, false);
        } else {
            String name = (String)evt.getData();
            List<Map<String, Object>> dataList = this.queryExpenseItemDataByName(name);
            HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(1);
            dataMap.put("data", dataList);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod(EXPENSE_ITEM_MOBILE_LIST, "setLookUpListValue", new Object[]{dataMap});
        }
    }

    private List<Map<String, Object>> queryExpenseItemDataByName(String name) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        QFilter nameFilter = new QFilter("name", "like", (Object)('%' + name + '%'));
        DynamicObjectCollection expenseItemCol = this.queryExpenseItemByFilter(nameFilter);
        if (expenseItemCol != null && !expenseItemCol.isEmpty()) {
            for (DynamicObject expenseItem : expenseItemCol) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("id", expenseItem.getString("id"));
                dataMap.put("name", expenseItem.getString("name"));
                dataMap.put("orgs", new ArrayList(0));
                dataMap.put("ca", expenseItem.getBoolean("isleaf"));
                dataList.add(dataMap);
            }
        }
        return dataList;
    }

    private static /* synthetic */ int lambda$queryExpenseItemDataById$0(Map v1, Map v2) {
        return ((String)v1.get("longnumber")).compareTo((String)v2.get("longnumber"));
    }
}

