/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.reimctl;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.CopyEntryRow;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.ReimctlApplyExpenseItemSelectListener;

public class ErApplyReimburseAmountNewPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ErApplyReimburseAmountNewPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit entrycostcompanyF7;
        BasedataEdit expenseitemF7;
        super.registerListener(e);
        UserEdit userEdit = (UserEdit)this.getControl("entryemployee");
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((expenseitemF7 = (BasedataEdit)this.getControl("expenseitem")) != null) {
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new ReimctlApplyExpenseItemSelectListener("expenseitem", "1"));
        }
        if ((entrycostcompanyF7 = (BasedataEdit)this.getControl("entrycostcompany")) != null) {
            entrycostcompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if ("entryemployee".equals(arg0.getProperty().getName())) {
            int rowindex = arg0.getRow();
            DynamicObject company = (DynamicObject)this.getModel().getValue("entrycompany", rowindex);
            if (company != null) {
                ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(Long.valueOf(company.get("masterid").toString())), (boolean)true);
                QFilter qFilter = new QFilter("entryentity.dpt.masterid", "in", (Object)allOrgList);
                cardF7Param.getListFilterParameter().getQFilters().add(qFilter);
                cardF7Param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            }
        }
        if ("entrycostcompany".equals(arg0.getProperty().getName())) {
            QFilter qFilter = new QFilter("enable", "=", (Object)true);
            arg0.getCustomQFilters().add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("expenseentryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.addLine(i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "company": {
                DynamicObjectCollection expenseentryentity = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                for (int i = 0; i < expenseentryentity.size(); ++i) {
                    model.setValue("entrycompany", newValue, i);
                    model.setValue("entryemployee", null, i);
                }
                break;
            }
            case "entryeffectivedate": 
            case "entryduedate": {
                break;
            }
            case "entrycostcompany": {
                if (newValue == null) break;
                ErApplyReimburseAmountNewPlugin.checkExpenseItemValid((Long)((DynamicObject)newValue).getPkValue(), rowIndex, model);
                break;
            }
        }
    }

    public static void checkExpenseItemValid(Long newCostCompanyPk, int rowIndex, IDataModel model) {
        if (newCostCompanyPk == null) {
            return;
        }
        DynamicObject expenseitem = (DynamicObject)model.getValue("expenseitem", rowIndex);
        if (expenseitem == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)newCostCompanyPk);
        DynamicObject single = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, QFilter.of((String)"id = ?", (Object[])new Object[]{expenseitem.getPkValue()})});
        if (single == null) {
            model.setValue("expenseitem", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operate = args.getSource();
        if (operate instanceof CopyEntryRow) {
            this.getPageCache().put("othercopy", "true");
        }
    }

    public boolean belongCalendar(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            return true;
        }
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return !begin.after(end);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        Boolean isCopy = Boolean.valueOf(this.getPageCache().get("othercopy"));
        this.getPageCache().remove("othercopy");
        if (isCopy.booleanValue()) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"expenseentryentity", (CharSequence)entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.addLine(rowIndex);
            }
        }
    }

    private void addLine(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject employee = (DynamicObject)model.getValue("applier");
        model.setValue("entrycompany", (Object)company, rowIndex);
        model.setValue("entryemployee", (Object)employee, rowIndex);
        Calendar start = Calendar.getInstance();
        start.set(start.get(1), start.get(2), 1);
        start.add(2, 1);
        model.setValue("entryeffectivedate", (Object)start.getTime(), rowIndex);
        Calendar end = Calendar.getInstance();
        end.clear();
        end.set(1, start.get(1));
        end.roll(6, -1);
        model.setValue("entryduedate", (Object)end.getTime(), rowIndex);
    }
}

