/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.reimctl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class ErReimburseAmountListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ErReimburseAmountListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn yearColumn = new CommonFilterColumn();
        yearColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"ErReimburseAmountListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0])));
        yearColumn.setFieldName("dateyear");
        yearColumn.setMustInput(true);
        if (filterColumnList.contains(yearColumn)) {
            filterColumnList.remove(yearColumn);
        }
        LocalDate localDate = LocalDate.now();
        int currentYear = localDate.getYear();
        int listSize = 10;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(listSize);
        ComboItem empty = new ComboItem();
        empty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ErReimburseAmountListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0])));
        empty.setValue("");
        combos.add(empty);
        for (int i = -2; i < 4; ++i) {
            int yearValue = currentYear + i;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"ErReimburseAmountListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), yearValue)));
            item.setValue(yearValue + "");
            combos.add(item);
        }
        yearColumn.setComboItems(combos);
        yearColumn.setType("enum");
        filterColumnList.add(yearColumn);
        yearColumn.setDefaultValue(String.valueOf(currentYear));
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"yearforward"});
    }

    public void filterColumnSetFilter(SetFilterEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "company.name": {
                event.getQFilters().add(new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"}));
                break;
            }
            case "dept.name": {
                FilterColumnSetFilterEvent columnEvent;
                List companyIds;
                if (!(event instanceof FilterColumnSetFilterEvent) || (companyIds = (columnEvent = (FilterColumnSetFilterEvent)event).getCommonFilterValue("company.name")) == null || companyIds.isEmpty()) break;
                ArrayList<Long> deptIds = new ArrayList<Long>(companyIds.size() * 4);
                ArrayList<Long> newCompanyIds = new ArrayList<Long>(companyIds.size());
                for (Object comId : companyIds) {
                    String cId = (String)comId;
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cId})) continue;
                    newCompanyIds.add(Long.valueOf(cId));
                }
                deptIds.addAll(this.getDeptIdSIncludeSelfByCompanyIds(newCompanyIds));
                if (CollectionUtils.isEmpty(deptIds)) break;
                event.getQFilters().add(new QFilter("id", "in", deptIds));
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"dept.id")) {
            String companyIds = this.getPageCache().get("companyIds");
            if (StringUtils.isNotBlank((CharSequence)companyIds)) {
                String[] companyIdArr = companyIds.split(",");
                ArrayList<Long> deptIds = new ArrayList<Long>(companyIds.length() * 4);
                ArrayList<Long> newCompanyIds = new ArrayList<Long>(companyIdArr.length);
                for (String companyId : companyIdArr) {
                    newCompanyIds.add(Long.valueOf(companyId));
                }
                deptIds.addAll(this.getDeptIdSIncludeSelfByCompanyIds(newCompanyIds));
                if (!CollectionUtils.isEmpty(deptIds)) {
                    args.getQfilters().add(new QFilter("id", "in", deptIds));
                }
            }
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"company.id")) {
            args.getQfilters().add(new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"}));
        }
    }

    private List<Long> getDeptIdSIncludeSelfByCompanyIds(List<Long> companyIds) {
        String deptIdsStr = this.getPageCache().get("deptIds$$" + companyIds);
        List<Long> deptIds = Lists.newArrayList();
        if (!StringUtils.isBlank((CharSequence)deptIdsStr)) {
            deptIds = JSON.parseArray((String)deptIdsStr, Long.class);
        } else {
            deptIds.addAll(OrgServiceHelper.getAllSubOrgWithoutCompany(companyIds, (Boolean)false));
            this.getPageCache().put("deptIds$$" + companyIds, JSON.toJSONString(deptIds));
        }
        deptIds.addAll(companyIds);
        return deptIds;
    }

    private List<Long> getDeptIdsIncludeSelf(Long companyId) {
        logger.info("getDeptIdsIncludeSelf(" + companyId + ")");
        String deptIdsStr = this.getPageCache().get("deptIds$$" + companyId);
        List<Long> deptIds = Lists.newArrayList();
        if (!StringUtils.isBlank((CharSequence)deptIdsStr)) {
            deptIds = JSON.parseArray((String)deptIdsStr, Long.class);
        } else {
            deptIds = OrgServiceHelper.getAllSubOrgWithoutCompany((Long)companyId);
            deptIds.add(companyId);
            this.getPageCache().put("deptIds$$" + companyId, JSON.toJSONString(deptIds));
        }
        deptIds.add(companyId);
        return deptIds;
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        List fieldNames;
        if (args.getCurrentCommonFilter() != null && (fieldNames = (List)args.getCurrentCommonFilter().get("FieldName")) != null && !fieldNames.isEmpty()) {
            List values;
            String fieldName = fieldNames.get(0).toString();
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"company.id") && (values = (List)args.getCurrentCommonFilter().get("Value")) != null && !values.isEmpty()) {
                String companyIds = StringUtils.join((Iterable)values, (String)",");
                this.getPageCache().put("companyIds", companyIds);
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"dateyear")) {
                String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                List values2 = (List)args.getCurrentCommonFilter().get("Value");
                if (values2 != null && !values2.isEmpty()) {
                    Object o = values2.get(0);
                    this.getPageCache().put("choosedateyear", String.valueOf(o));
                    if ("er_reimburseamount".equals(billFormId)) {
                        if ("".equals(o)) {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"comcarryforward"});
                        } else if (Year.now().getValue() == Integer.parseInt(String.valueOf(o))) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"comcarryforward"});
                        } else {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"comcarryforward"});
                        }
                    }
                    if ("".equals(o)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"yearforward"});
                    } else if (Year.now().getValue() > Integer.parseInt(String.valueOf(o))) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"yearforward"});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"yearforward"});
                    }
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("actionIdQuotaCopy".equals(actionId) || "actionIdCarryForward".equals(actionId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        } else if ("er_yearforward".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Map ret = (Map)returnData;
            boolean isAssignPeriod = (Boolean)ret.get("isAssignPeriod");
            String assignedPeriod = (String)ret.get("assignedPeriod");
            String choosedateyear = (String)ret.get("choosedateyear");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isAssignPeriod", isAssignPeriod + "");
            option.setVariableValue("assignedPeriod", assignedPeriod);
            option.setVariableValue("choosedateyear", choosedateyear);
            option.setVariableValue("sourceName", "MessageCallBackType");
            option.setVariableValue("sourceEvent", "Operation");
            this.getView().invokeOperation("yearforward", option);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate foper = (FormOperate)args.getSource();
        String key = foper.getOperateKey();
        ListSelectedRowCollection rows = args.getListSelectedData();
        if (StringUtils.equals((CharSequence)"copymodify", (CharSequence)key)) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ErReimburseAmountListPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            Object[] primaryKeyValue = selectedRows.getPrimaryKeyValues();
            QFilter reimburseAmountFilter = new QFilter("id", "=", primaryKeyValue[0]);
            DynamicObject reimAmount = QueryServiceHelper.queryOne((String)billFormId, (String)"id, auditstatus,isyearforward", (QFilter[])new QFilter[]{reimburseAmountFilter});
            if (!reimAmount.getString("auditstatus").equals("1")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5df2\u5ba1\u6279\u7684\u6570\u636e\u8fdb\u884c\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ErReimburseAmountListPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (reimAmount.getBoolean("isyearforward")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u8fc7\u8de8\u5e74\u7ed3\u8f6c\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErReimburseAmountListPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("wbsrcbillid", "=", primaryKeyValue[0]);
            qFilter.and(new QFilter("wbsrcbilltype", "=", (Object)"er_reimctl_modify"));
            if (QueryServiceHelper.exists((String)billFormId, (QFilter[])new QFilter[]{qFilter})) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u8c03\u6574\u7684\u989d\u5ea6\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8c03\u6574\u3002", (String)"ErReimburseAmountListPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("copymodify_wbsrcbillid", String.valueOf(reimAmount.getLong("id")));
        } else if (StringUtils.equals((CharSequence)"yearforward", (CharSequence)key)) {
            this.yearForward(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        ListSelectedRowCollection selectedRows;
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        boolean isSuccess = false;
        if (event.getOperationResult() != null) {
            isSuccess = event.getOperationResult().isSuccess();
        }
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if ("quotacopy".equals(operateKey) && isSuccess) {
            selectedRows = this.getSelectedRows();
            Object[] primaryKeyValue = selectedRows.getPrimaryKeyValues();
            List<Object> ids = Arrays.stream(primaryKeyValue).collect(Collectors.toList());
            HashSet excludeIds = new HashSet(16);
            HashSet<Object> lastIds = new HashSet<Object>(16);
            for (Object t : ids) {
                if (excludeIds.contains(t)) continue;
                Object id = this.getLastModifyQuota(billFormId, t, excludeIds);
                lastIds.add(id);
            }
            ids.removeAll(excludeIds);
            ids.addAll(lastIds);
            if (ids.size() == 0) {
                return;
            }
            Map reimburseAmountItemDOs = BusinessDataServiceHelper.loadFromCache((String)billFormId, (QFilter[])new QFilter[]{new QFilter("id", "=", ids.get(0))});
            Object object = ((DynamicObject)reimburseAmountItemDOs.values().stream().findFirst().get()).get("company.id");
            Long costcompany = null;
            if (object != null) {
                costcompany = CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)object), (Boolean)true);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("selectIds", ids.toArray(new Object[0]));
            params.put("billFormId", billFormId);
            params.put("costcompany", costcompany);
            params.put("company", object);
            if ("er_reimburseamount".equals(billFormId)) {
                params.put("quotaType", "quotaPersonal");
            } else {
                params.put("quotaType", "quotaDepartmental");
            }
            ShowPageUtils.openDynamicPage((IFormView)this.getView(), (String)"", (String)"er_quotacopy", (ShowType)ShowType.Modal, params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "actionIdQuotaCopy"));
        }
        if ("comcarryforward".equals(operateKey) && isSuccess) {
            Collection reimburseAmountList;
            selectedRows = this.getSelectedRows();
            if (selectedRows.size() > 1000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u591a\u53ef\u9009\u62e91000\u6761\u989d\u5ea6\u8bb0\u5f55\u8fdb\u884c\u7ed3\u8f6c\u3002", (String)"ErReimburseAmountListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            Map reimburseAmountMap = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"er_reimburseamount");
            if (!CollectionUtils.isEmpty((Map)reimburseAmountMap) && !(reimburseAmountList = reimburseAmountMap.values()).isEmpty()) {
                long notAuditCount = reimburseAmountList.stream().filter(e -> "0".equals(e.get("auditstatus"))).count();
                if (notAuditCount > 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5b58\u5728\u672a\u5ba1\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5df2\u5ba1\u6570\u636e\u3002", (String)"ErReimburseAmountListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                long l = reimburseAmountList.stream().filter(e -> "3".equals(e.get("auditstatus"))).count();
                if (l > 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u51bb\u7ed3\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5df2\u5ba1\u6570\u636e\u3002", (String)"ErReimburseAmountListPlugin_24", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map<Object, List<DynamicObject>> companyGroup = reimburseAmountList.stream().collect(Collectors.groupingBy(e -> e.get("company.id") + e.getString("expenseitem.reimburseamountctlmethod")));
                if (companyGroup.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6240\u9009\u62e9\u7684\u6570\u636e\u516c\u53f8\u548c\u8d39\u7528\u9879\u76ee\u7684\u989d\u5ea6\u63a7\u5236\u65b9\u6cd5\u76f8\u540c\u3002", (String)"ErReimburseAmountListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("selectIds", primaryKeyValues);
            params.put("billFormId", billFormId);
            ShowPageUtils.openDynamicPage((IFormView)this.getView(), (String)"", (String)"er_carryforward", (ShowType)ShowType.Modal, params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "actionIdCarryForward"));
        } else if ("yearforward".equals(operateKey) && !event.getOperationResult().getSuccessPkIds().isEmpty()) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)"freeze", (CharSequence)operateKey) && !event.getOperationResult().getSuccessPkIds().isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u6210\u529f\u3002", (String)"ErReimburseAmountListPlugin_22", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)"unfreeze", (CharSequence)operateKey) && !event.getOperationResult().getSuccessPkIds().isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u51bb\u6210\u529f\u3002", (String)"ErReimburseAmountListPlugin_23", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private Object getLastModifyQuota(String billFormId, Object soruceId, HashSet excludeIds) {
        DynamicObject quo = QueryServiceHelper.queryOne((String)billFormId, (String)"id, wbsrcbillid", (QFilter[])new QFilter[]{new QFilter("wbsrcbillid", "=", soruceId)});
        if (quo == null) {
            return soruceId;
        }
        excludeIds.add(soruceId);
        return this.getLastModifyQuota(billFormId, quo.get("id"), excludeIds);
    }

    private void yearForward(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        if (option.containsVariable("isAssignPeriod")) {
            return;
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        Map reimburseAmountMap = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)((ListView)this.getView()).getBillFormId());
        String ctrlMethod = "";
        if (!CollectionUtils.isEmpty((Map)reimburseAmountMap)) {
            Collection reimburseAmountList = reimburseAmountMap.values();
            if (!reimburseAmountList.isEmpty()) {
                long notAuditCount = reimburseAmountList.stream().filter(e -> "0".equals(e.get("auditstatus"))).count();
                if (notAuditCount > 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u989d\u5ea6\u4e0d\u5141\u8bb8\u7ed3\u8f6c\u3002", (String)"ErReimburseAmountListPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map<Object, List<DynamicObject>> methodGroup = reimburseAmountList.stream().collect(Collectors.groupingBy(e -> e.getString("expenseitem.reimburseamountctlmethod")));
                if (methodGroup.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u989d\u5ea6\u7684\u63a7\u5236\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ErReimburseAmountListPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean anyMatch = reimburseAmountList.stream().anyMatch(v -> !v.getBoolean("isyearforward"));
                if (!anyMatch) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u989d\u5ea6\u5df2\u5168\u90e8\u6267\u884c\u8fc7\u8de8\u5e74\u7ed3\u8f6c\u3002", (String)"ErReimburseAmountListPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ctrlMethod = (String)methodGroup.keySet().iterator().next();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ErReimburseAmountListPlugin_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String choosedateyear = this.getPageCache().get("choosedateyear");
        if ("C".equals(ctrlMethod)) {
            if (choosedateyear == null || choosedateyear.trim().length() == 0) {
                int thisyear = Year.now().getValue();
                choosedateyear = thisyear - 1 + "";
            }
            option.setVariableValue("isAssignPeriod", "false");
            option.setVariableValue("assignedPeriod", "0");
            option.setVariableValue("choosedateyear", choosedateyear);
        } else {
            args.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("er_yearforward");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_yearforward"));
            formShowParameter.setCustomParam("ctrlMethod", (Object)ctrlMethod);
            formShowParameter.setCustomParam("choosedateyear", (Object)choosedateyear);
            this.getView().showForm(formShowParameter);
        }
    }
}

