/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.reimctl.mobile;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.UserProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.ReimctlApplyExpenseItemSelectListener;
import kd.fi.er.formplugin.daily.reimctl.ErApplyReimburseAmountNewPlugin;

public class ErReimctlDetailMobPlugin
extends AbstractMobBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] mustInputProp = new String[]{"entrycompany", "entryemployee", "entrycostcompany", "expenseitem", "entrycurrency", "expenseamount", "entryeffectivedate", "entryduedate"};

    public void registerListener(EventObject e) {
        BasedataEdit entrycostcompanyF7;
        BasedataEdit expenseitemF7;
        super.registerListener(e);
        this.entryemployeeControl();
        UserEdit userEdit = (UserEdit)this.getControl("entryemployee");
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((expenseitemF7 = (BasedataEdit)this.getControl("expenseitem")) != null) {
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new ReimctlApplyExpenseItemSelectListener("expenseitem", "1"));
        }
        if ((entrycostcompanyF7 = (BasedataEdit)this.getControl("entrycostcompany")) != null) {
            entrycostcompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btn_save"});
    }

    private void entryemployeeControl() {
        IDataEntityProperty entryemployeeProp = this.getModel().getProperty("entryemployee");
        if (entryemployeeProp instanceof UserProp) {
            ((UserProp)entryemployeeProp).setF7Style(2);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if ("entryemployee".equals(arg0.getProperty().getName())) {
            int rowindex = arg0.getRow();
            DynamicObject company = (DynamicObject)this.getModel().getValue("entrycompany", rowindex);
            if (company != null) {
                ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(Long.valueOf(company.get("masterid").toString())), (boolean)true);
                QFilter qFilter = new QFilter("entryentity.dpt.masterid", "in", (Object)allOrgList);
                ArrayList list = Lists.newArrayList();
                Map reimburserRang = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
                if (reimburserRang != null && reimburserRang.size() > 0) {
                    reimburserRang.forEach((key, value) -> list.add(String.valueOf(key)));
                }
                cardF7Param.getListFilterParameter().getQFilters().add(qFilter);
                arg0.getFormShowParameter().setCustomParam("rang", (Object)list);
            }
        }
        if ("entrycostcompany".equals(arg0.getProperty().getName())) {
            QFilter qFilter = new QFilter("enable", "=", (Object)true);
            arg0.getCustomQFilters().clear();
            arg0.getCustomQFilters().add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("expenseentryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.addLine(i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"expenseentryentity", (CharSequence)entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.addLine(rowIndex);
            }
        }
    }

    private void addLine(int rowIndex) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        IDataModel model = this.getModel();
        model.setValue("entrycompany", parentModel.getValue("company"), rowIndex);
        model.setValue("entryemployee", parentModel.getValue("applier"), rowIndex);
        Calendar start = Calendar.getInstance();
        start.set(start.get(1), start.get(2), 1);
        start.add(2, 1);
        model.setValue("entryeffectivedate", (Object)start.getTime(), rowIndex);
        Calendar end = Calendar.getInstance();
        end.clear();
        end.set(1, start.get(1));
        end.roll(6, -1);
        model.setValue("entryduedate", (Object)end.getTime(), rowIndex);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        int i = 0;
        while (i < this.getModel().getEntryRowCount("expenseentryentity")) {
            int index = i++;
            String noValueProps = Stream.of(mustInputProp).filter(prop -> {
                Object value = this.getModel().getValue(prop, index);
                return this.getModel().getProperty(prop) != null && (value == null || value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0);
            }).map(prop -> this.getModel().getProperty(prop).getDisplayName().toString()).distinct().collect(Collectors.joining("\uff0c"));
            if (StringUtils.isBlank((CharSequence)noValueProps)) continue;
            evt.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bf7\u586b\u5199%2$s\u3002", (String)"ErReimctlDetailMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), String.valueOf(i + 1), noValueProps));
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "btn_save": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
                DynamicObject currecncy = (DynamicObject)this.getModel().getValue("entrycurrency", 0);
                String string = "entrycurrency";
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "entrycostcompany": {
                if (newValue == null) break;
                ErApplyReimburseAmountNewPlugin.checkExpenseItemValid((Long)((DynamicObject)newValue).getPkValue(), rowIndex, model);
                break;
            }
        }
    }
}

