/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ControlTypes;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.formplugin.daily.web.workflow.ErDailyWorkFlowService;

public class ErWorkflowForCheckingPayBill
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.isNoApproval()) {
            IFormView view = this.getView();
            CommonServiceHelper.isHiddenApprovalFlex((IFormView)view, (Boolean)true);
            ErDailyWorkFlowService.noApprovel((IFormView)view);
        }
    }

    private boolean isNoApproval() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        BillOperationStatus status = BillOperationStatus.VIEW;
        if (view.getFormShowParameter() instanceof BillShowParameter) {
            status = ((BillShowParameter)view.getFormShowParameter()).getBillStatus();
        }
        BillShowParameter billShow = (BillShowParameter)this.getView().getFormShowParameter();
        String billStatus = (String)model.getValue("billstatus");
        Object businessKey = billShow.getPkId();
        boolean isInProcess = false;
        if (businessKey != null) {
            List records = WorkflowServiceHelper.getAllApprovalRecord((String)businessKey.toString());
            if (records.isEmpty()) {
                return true;
            }
            isInProcess = WorkflowServiceHelper.inProcess((String)businessKey.toString());
        }
        return billStatus != null && "A".equals(billStatus) && !isInProcess || BillOperationStatus.ADDNEW.compareTo((Enum)status) == 0 || CommonServiceHelper.isSSC((IFormView)view) || CommonServiceHelper.isSCENE((IFormView)view);
    }

    static {
        ControlTypes.register(ApprovalRecord.class);
    }
}

