/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.web.AbstractReceiveEntryPlugin;
import org.apache.commons.lang3.StringUtils;

public class ReceiveEntryPlugin
extends AbstractReceiveEntryPlugin {
    private static String isgetaccountcurrency = "0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realCardF7 = (BasedataEdit)this.getControl("payer");
        realCardF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject applier = this.getModel().getDataEntity(true).getDynamicObject("applier");
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            CoreBaseBillServiceHelper.setPayeeF7Filter((ListShowParameter)formShowParameter, (DynamicObject)applier, (List)CoreBaseBillServiceHelper.getMultiReimburserIdCollection((IFormView)this.getView()));
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                int i = 0;
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("currency", "!=", (Object)i));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        if (((IBillModel)model).isFromImport()) {
            return;
        }
        String formId = (String)model.getValue("formid");
        if (ErEntityTypeUtils.isPrePayBill((String)formId)) {
            int rowIndex = model.createNewEntryRow("accountentry");
            String payertype = (String)model.getValue("payertype", rowIndex);
            if ("er_payeer".equals(payertype)) {
                model.deleteEntryData("accountentry");
                this.createDefaultAcountInfo(model);
            } else {
                if (StringUtils.isEmpty((CharSequence)payertype)) {
                    model.setValue("payertype", model.getValue("billpayertype"), rowIndex);
                }
                DynamicObject payMode = PayeeServiceHelper.getDefaultPayMode();
                model.setValue("paymode", (Object)ErCommonUtils.getPk((Object)payMode), rowIndex);
                if (model.getValue("payer", rowIndex) == null) {
                    DynamicObject currency = (DynamicObject)model.getValue("currency");
                    model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
                }
            }
        } else {
            this.createDefaultAcountInfo(model);
        }
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
        }
        if ("0".equals(isgetaccountcurrency)) {
            this.setAcountCurency(model);
        } else if ("1".equals(isgetaccountcurrency)) {
            model.setValue("iscurrency", (Object)Boolean.TRUE);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PayeeServiceHelper.viewStorageLimits((IFormView)this.getView());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "accexchangerate": {
                this.accExchangeRateChange(propValue, rowIndex, model, this.getView());
                break;
            }
            case "payer": {
                String isgetaccountcurrency = "0";
                if (this.getModel().getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
                }
                DynamicObject payer = (DynamicObject)propValue;
                if (!"1".equals(isgetaccountcurrency) || payer == null || payer.getDynamicObject("CURRENCY") != null) break;
                model.beginInit();
                model.setValue("accexchangerate", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("accountcurrency", null, rowIndex);
                model.setValue("accountcurrency", null, rowIndex);
                model.setValue("accquotetype", (Object)"0", rowIndex);
                model.endInit();
                model.setValue("orireceiveamount", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("receiveamount", (Object)BigDecimal.ZERO, rowIndex);
                ErCommonUtils.updateView((IFormView)this.getView(), (int)rowIndex, (String[])new String[]{"accexchangerate", "accountcurrency", "accquotetype"});
                break;
            }
            case "company": {
                PayeeServiceHelper.viewStorageLimits((IFormView)this.getView());
            }
        }
    }

    protected void accExchangeRateChange(Object propValue, int rowIndex, IDataModel model, IFormView view) {
        AmountChangeUtil.accExchangeRateChange((Object)propValue, (int)rowIndex, (IDataModel)model, (IFormView)view);
    }

    private void createDefaultAcountInfo(IDataModel model) {
        int rowIndex = CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)model);
        if (((DynamicObject)model.getEntryEntity("accountentry").get(0)).get("accountcurrency") == null) {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
        }
    }

    private void setAcountCurency(IDataModel model) {
        int entryRowCount = model.getEntryRowCount("accountentry");
        if (entryRowCount > 0) {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency == null) {
                Map billMap = CoreBaseBillServiceHelper.createNewData((Long)Long.valueOf(RequestContext.get().getUserId()));
                CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
                CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
                currency = (DynamicObject)model.getValue("currency");
            }
            for (int i = 0; i < entryRowCount; ++i) {
                model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        int rowIndex;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        String billType = model.getDataEntity().getDynamicObjectType().getName();
        if ("accountentry".equalsIgnoreCase(entryName) && e.getRowDataEntities().length > 0) {
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                RowDataEntity[] rowDataEntities2;
                RowDataEntity[] rowDataEntityArray = rowDataEntities2 = e.getRowDataEntities();
                int n = rowDataEntityArray.length;
                for (int i = 0; i < n; ++i) {
                    RowDataEntity rowDataEntity = rowDataEntityArray[i];
                    rowIndex = rowDataEntity.getRowIndex();
                    if (rowIndex != 0) continue;
                    Map exchangeMap = AmountChangeUtil.getCurrencyByParamentForInit((IFormView)this.getView(), (IDataModel)model, (String)isgetaccountcurrency);
                    model.setValue("accountcurrency", exchangeMap.get("currencyId"), 0);
                    model.setValue("accexchangerate", exchangeMap.get("exchangeRate"), 0);
                }
            }
        }
        if ("accountentry".equalsIgnoreCase(entryName)) {
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                DynamicObject currencyId = rowDataEntity.getDataEntity().getDynamicObject("accountcurrency");
                rowIndex = rowDataEntity.getRowIndex();
                if (currencyId != null) continue;
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
            }
        }
        if ("accountentry".equalsIgnoreCase(entryName) && model.getProperty("acccostcompany") != null) {
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                model.setValue("acccostcompany", model.getValue("costcompany"), rowDataEntity.getRowIndex());
            }
        }
        if ("accountentry".equalsIgnoreCase(entryName) && !ErEntityTypeUtils.isPrePayBill((String)billType) && !this.isPublicContractReimburse()) {
            PayeeServiceHelper.defualtCurrencySetting((AfterAddRowEventArgs)e, (IDataModel)model, (IFormView)this.getView());
            PayeeServiceHelper.clearLimitInfo((IDataModel)model);
        }
    }

    private boolean isPublicContractReimburse() {
        String detailType;
        boolean flag = false;
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && (StringUtils.equalsIgnoreCase((CharSequence)(detailType = this.getModel().getValue("detailtype").toString()), (CharSequence)"biztype_contract") || StringUtils.equalsIgnoreCase((CharSequence)detailType, (CharSequence)"biztype_contractestimate"))) {
            flag = true;
        }
        return flag;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if ("accountentry".equals(e.getEntryProp().getName())) {
            AmountChangeUtil.handleDiiff((IDataModel)this.getModel(), (String)"accountentry", (String)"receiveamount", (String)"orireceiveamount", (String)"accexchangerate", (String)"currency");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Submit || args.getSource() instanceof Audit) {
            PayeeServiceHelper.clearLimitInfo((IDataModel)this.getModel());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        PayeeServiceHelper.clearLimitInfo((IDataModel)this.getModel());
    }
}

