/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ModelTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class ReimburseAmountControlFormPlugin
extends AbstractBillPlugIn {
    protected static final String[] reimburseControlRelativeFields = new String[]{"company", "applier", "expenseitem", "happendate", "entrycurrency", "reimburser", "pubreimburser", "ismultireimburser", "org", "entrycostdept", "reimctldept"};
    private static final Log log = LogFactory.getLog(ReimburseAmountControlFormPlugin.class);
    public static final String CURRENT_EXPENSE_ENTRY_INDEX = "currentExpenseEntryIndex";
    private String quotaDateField = ErStdConfig.get((String)"quotaDateField");
    private static final String LIMITCONTROL = "limitcontrol";

    public void registerListener(EventObject e) {
        this.addEntryRowClick();
    }

    private void addEntryRowClick() {
        EntryGrid expenseEntry = (EntryGrid)this.getControl("expenseentryentity");
        expenseEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                ReimburseAmountControlFormPlugin.this.getPageCache().put(ReimburseAmountControlFormPlugin.CURRENT_EXPENSE_ENTRY_INDEX, String.valueOf(row));
                if (!(ReimburseAmountControlFormPlugin.this.getIsShowInExp().booleanValue() || ReimburseAmountControlFormPlugin.this.getView().getFormShowParameter().getFormId().equals("er_dailyreimbursebill_mob") || ReimburseAmountControlFormPlugin.this.getView().getFormShowParameter().getFormId().equals("er_publicreimbursebill_mob"))) {
                    ReimburseAmountControlFormPlugin.this.showBalanceAmount();
                }
            }
        });
    }

    public void afterBindData(EventObject e) {
        this.setHapendDateSelectedRange();
        this.setExpBalanceFieldVisible();
        this.showBalanceAmount();
        this.getModel().setDataChanged(false);
    }

    private void setHapendDateSelectedRange() {
        QuotaCtrlUtil.setHappenDateSelectedRange((IDataModel)this.getModel(), (DateEdit[])new DateEdit[]{(DateEdit)this.getControl("happendate")});
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            LocalDate minLocalDate = LocalDate.of(1990, 1, 1);
            DateEdit happenDE = (DateEdit)this.getControl("happendate");
            happenDE.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)minLocalDate));
        } else {
            String special = (String)this.getModel().getValue("specialbill");
            if (StringUtils.isBlank((CharSequence)special)) {
                LocalDate minLocalDate = LocalDate.of(1990, 1, 1);
                DateEdit happenDE = (DateEdit)this.getControl("happendate");
                happenDE.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)minLocalDate));
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (LIMITCONTROL.equals(e.getName())) {
            this.showBalanceAmount();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"company", (CharSequence)propName)) {
            this.getPageCache().remove("empCltBill");
            this.getPageCache().remove("deptCltBill");
            this.getPageCache().remove("getIsEnableContrl");
            this.getPageCache().remove("getIsShowInExp");
            this.setExpBalanceFieldVisible();
        }
        if (ThreadCache.get((Object)LIMITCONTROL) != null) {
            return;
        }
        boolean isBizDateQuota = "bizdate".equals(ErStdConfig.getQuotaDateField());
        if (Arrays.asList(reimburseControlRelativeFields).contains(propName) || StringUtils.equals((CharSequence)ReimburseControlUtils.getPersonReimCtlCompanyField(), (CharSequence)propName) || isBizDateQuota) {
            ThreadCache.put((Object)LIMITCONTROL, (Object)LIMITCONTROL);
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getPageCache().put(CURRENT_EXPENSE_ENTRY_INDEX, String.valueOf(rowIndex));
            this.getView().addClientCallBack(LIMITCONTROL);
        }
    }

    private void setExpBalanceFieldVisible() {
        Boolean isEnableContrl = this.getIsEnableContrl();
        boolean isContainsTripReim = ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName()) ? this.getEmpCltBill().contains("3") || this.getDeptCltBill().contains("3") : this.getEmpCltBill().contains("1") || this.getDeptCltBill().contains("1");
        String billstatus = (String)this.getModel().getValue("billstatus");
        boolean isEnableStatus = Arrays.asList("A", "D", "B", "C").contains(billstatus);
        if (isEnableContrl.booleanValue() && isContainsTripReim && isEnableStatus) {
            ((Label)this.getControl("reimbursecontrolinfo")).setText("");
            if (this.getView().getFormShowParameter().getFormConfig().getModelType().equalsIgnoreCase(ModelTypeEnum.PC_BIll.getType())) {
                if (this.getIsShowInExp().booleanValue()) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"amount_balanceamount"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"amount_balanceamount"});
                }
            }
        } else {
            ((Label)this.getControl("reimbursecontrolinfo")).setText("");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"amount_balanceamount"});
        }
    }

    private List<String> getEmpCltBill() {
        String pageEmpCltBill = this.getPageCache().get("empCltBill");
        if (StringUtils.isNotBlank((CharSequence)pageEmpCltBill)) {
            List<String> empCltList = Arrays.asList(pageEmpCltBill.split(","));
            return empCltList;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return new ArrayList<String>();
        }
        String empCltBill = (String)ErCommonUtils.getEMParameter((long)((Long)company.getPkValue()), (String)"empquotaapplicablebill");
        this.getPageCache().put("empCltBill", empCltBill);
        return Arrays.asList(empCltBill.split(","));
    }

    private List<String> getDeptCltBill() {
        String pageDeptCltBill = this.getPageCache().get("deptCltBill");
        if (StringUtils.isNotBlank((CharSequence)pageDeptCltBill)) {
            List<String> deptCltList = Arrays.asList(pageDeptCltBill.split(","));
            return deptCltList;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return new ArrayList<String>();
        }
        String deptCltBill = (String)ErCommonUtils.getEMParameter((long)((Long)company.getPkValue()), (String)"deptquotaapplicablebill");
        this.getPageCache().put("deptCltBill", deptCltBill);
        return Arrays.asList(deptCltBill.split(","));
    }

    private Boolean getIsEnableContrl() {
        String isEnableContrl = this.getPageCache().get("getIsEnableContrl");
        if (StringUtils.isNotBlank((CharSequence)isEnableContrl)) {
            return Boolean.valueOf(isEnableContrl);
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return Boolean.FALSE;
        }
        boolean isEnable = SystemParamterUtil.isEnableReimburseControlByCompany((Long)((Long)company.getPkValue()));
        this.getPageCache().put("getIsEnableContrl", String.valueOf(isEnable));
        return isEnable;
    }

    private Boolean getIsShowInExp() {
        String getIsShowInExp = this.getPageCache().get("getIsShowInExp");
        if (StringUtils.isNotBlank((CharSequence)getIsShowInExp)) {
            return Boolean.valueOf(getIsShowInExp);
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return Boolean.FALSE;
        }
        boolean isShow = SystemParamterUtil.isShowBalanceAmtInExpdetail((Long)((Long)company.getPkValue()));
        this.getPageCache().put("getIsShowInExp", String.valueOf(isShow));
        return isShow;
    }

    private void showBalanceAmount() {
        if (ErCommonUtils.isBatchExcelImportExpenseEnry((IPageCache)this.getPageCache())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
        if (expenseEntries.size() == 0) {
            return;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (billStatus != null && !Arrays.asList("A", "D", "B", "C").contains(billStatus)) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        if (!this.getIsEnableContrl().booleanValue()) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        DynamicObject amountControlCompanyDO = ReimburseControlUtils.getReimburseControlCompany((DynamicObject)dataEntity);
        if (amountControlCompanyDO == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        List<String> empCltList = this.getEmpCltBill();
        List<String> deptCltList = this.getDeptCltBill();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            if (!empCltList.contains("3") && !deptCltList.contains("3")) {
                this.setBalanceAmountDefaultValue();
                return;
            }
        } else if (!empCltList.contains("1") && !deptCltList.contains("1")) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        if (this.getView().getFormShowParameter().getFormConfig().getModelType().equalsIgnoreCase(ModelTypeEnum.PC_BIll.getType())) {
            if (this.getIsShowInExp().booleanValue()) {
                this.showExpenseBalanceAmount();
            } else {
                this.showHeadBalanceAmount();
            }
        } else {
            this.showExpenseBalanceAmount();
        }
    }

    private void setBalanceAmountDefaultValue() {
        IDataModel model = this.getModel();
        ((Label)this.getControl("reimbursecontrolinfo")).setText("");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
        if (expenseEntries != null && expenseEntries.size() > 0) {
            for (int j = 0; j < expenseEntries.size(); ++j) {
                model.beginInit();
                this.getModel().setValue("amount_balanceamount", (Object)"--", j);
                model.endInit();
                this.getView().updateView("amount_balanceamount", j);
            }
        }
    }

    private void showHeadBalanceAmount() {
        DynamicObject expenseEntry;
        ((Label)this.getControl("reimbursecontrolinfo")).setText("");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
        String rowIndexStr = this.getPageCache().get(CURRENT_EXPENSE_ENTRY_INDEX);
        int currentRowIndex = 0;
        currentRowIndex = StringUtils.isNotBlank((CharSequence)rowIndexStr) ? Integer.parseInt(rowIndexStr) : this.getModel().getEntryCurrentRowIndex("expenseentryentity");
        if (currentRowIndex < 0 || expenseEntries.size() <= 0) {
            ((Label)this.getControl("reimbursecontrolinfo")).setText("");
            return;
        }
        if (currentRowIndex >= expenseEntries.size()) {
            currentRowIndex = 0;
        }
        if (!this.validRow(expenseEntry = (DynamicObject)expenseEntries.get(currentRowIndex))) {
            ((Label)this.getControl("reimbursecontrolinfo")).setText("");
            return;
        }
        IDataModel model = this.getModel();
        Long companyId = ErCommonUtils.getPk((Object)((DynamicObject)model.getValue("company")));
        String personCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"personctlcurrency");
        String deptCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"deptctlcurrency");
        List<String> empCltList = this.getEmpCltBill();
        List<String> deptCltList = this.getDeptCltBill();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Long currencyId = currency == null ? Long.valueOf(0L) : (Long)currency.getPkValue();
        DynamicObject amountControlCompanyDO = ReimburseControlUtils.getReimburseControlCompany((DynamicObject)model.getDataEntity());
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        reimAmountBO.setCompanyId((Long)amountControlCompanyDO.getPkValue());
        reimAmountBO.setEmpCtlBill(empCltList);
        reimAmountBO.setDeptCtlBill(deptCltList);
        DynamicObject expenseitem = expenseEntry.getDynamicObject("expenseitem");
        reimAmountBO.setExpenseItemId((Long)expenseitem.getPkValue());
        reimAmountBO.setCtrlCount(Integer.valueOf(expenseitem.getInt("reimburseamountctlcount")));
        reimAmountBO.setCtrlMethod(expenseitem.getString("reimburseamountctlmethod"));
        reimAmountBO.setCtrlType(expenseitem.getString("reimctltype"));
        String isreimburseamountctl = expenseitem.getString("isreimburseamountctl");
        reimAmountBO.setCtrlMode(isreimburseamountctl);
        Long oriCurrencyId = (Long)expenseEntry.getDynamicObject("entrycurrency").getPkValue();
        String showName = "";
        if ("1".equals(isreimburseamountctl)) {
            if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
                if (expenseEntry.containsProperty("pubreimburser") && expenseEntry.getDynamicObject("pubreimburser") != null) {
                    reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("pubreimburser").getPkValue());
                } else {
                    reimAmountBO.setUserOrDeptId((Long)dataEntity.getDynamicObject("applier").getPkValue());
                }
            } else {
                reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("reimburser").getPkValue());
            }
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
            showName = ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName()) ? (expenseEntry.containsProperty("pubreimburser") && expenseEntry.getDynamicObject("pubreimburser") != null ? expenseEntry.getDynamicObject("pubreimburser").getLocaleString("name").getLocaleValue() : dataEntity.getDynamicObject("applier").getLocaleString("name").getLocaleValue()) : expenseEntry.getDynamicObject("reimburser").getLocaleString("name").getLocaleValue();
        } else if ("2".equals(isreimburseamountctl)) {
            reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("reimctldept").getPkValue());
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
            showName = expenseEntry.getDynamicObject("reimctldept").getString("name");
        }
        Date date = expenseEntry.getDate("happendate");
        if ("2".equals(this.quotaDateField)) {
            date = (Date)model.getValue("bizdate");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        reimAmountBO.setHappenDate(YearMonth.of(calendar.get(1), calendar.get(2) + 1));
        boolean isAduit = false;
        if (Arrays.asList("B", "C").contains((String)model.getValue("billstatus"))) {
            isAduit = true;
        }
        ArrayList<Long> excludeReimbureBillIds = new ArrayList<Long>();
        if (isAduit) {
            excludeReimbureBillIds.add((Long)model.getDataEntity().getPkValue());
            log.info("\u662f\u5ba1\u6838\u72b6\u6001, \u6392\u9664\u7684\u5355\u636e\u4e3a: " + excludeReimbureBillIds);
        }
        reimAmountBO.setNotInIds(excludeReimbureBillIds);
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
        BigDecimal balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO);
        if ("2".equals(reimAmountBO.getCtrlType()) && balanceAmount == null) {
            ((Label)this.getControl("reimbursecontrolinfo")).setText("");
            return;
        }
        if (balanceAmount == null) {
            balanceAmount = BigDecimal.ZERO;
        }
        String balanceAmountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)balanceAmount, (CurrencyBO)new CurrencyBO(reimAmountBO.getCurrencyId()));
        String expenseItemName = expenseitem.getLocaleString("name").getLocaleValue();
        String template = ResManager.loadKDString((String)"\u53ef\u7528\u989d\u5ea6: %1$s|%2$s|%3$s", (String)"ReimburseAmountControlFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
        String reimburseControlInfo = String.format(template, showName, expenseItemName, balanceAmountStr);
        ((Label)this.getControl("reimbursecontrolinfo")).setText(reimburseControlInfo);
    }

    private void showExpenseBalanceAmount() {
        IDataModel model = this.getModel();
        Long companyId = ErCommonUtils.getPk((Object)((DynamicObject)model.getValue("company")));
        String personCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"personctlcurrency");
        String deptCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"deptctlcurrency");
        List<String> empCltList = this.getEmpCltBill();
        List<String> deptCltList = this.getDeptCltBill();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Long currencyId = currency == null ? Long.valueOf(0L) : (Long)currency.getPkValue();
        DynamicObject amountControlCompanyDO = ReimburseControlUtils.getReimburseControlCompany((DynamicObject)model.getDataEntity());
        Date bizDate = (Date)model.getValue("bizdate");
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
        for (int i = 0; i < expenseEntries.size(); ++i) {
            DynamicObject expenseEntry = (DynamicObject)expenseEntries.get(i);
            if (!this.validRow(expenseEntry)) {
                model.setValue("amount_balanceamount", (Object)"--", i);
                continue;
            }
            QuotaAmountBO reimAmountBO = new QuotaAmountBO();
            reimAmountBO.setCompanyId((Long)amountControlCompanyDO.getPkValue());
            reimAmountBO.setEmpCtlBill(empCltList);
            reimAmountBO.setDeptCtlBill(deptCltList);
            DynamicObject expenseitem = expenseEntry.getDynamicObject("expenseitem");
            reimAmountBO.setExpenseItemId((Long)expenseitem.getPkValue());
            reimAmountBO.setCtrlCount(Integer.valueOf(expenseitem.getInt("reimburseamountctlcount")));
            reimAmountBO.setCtrlMethod(expenseitem.getString("reimburseamountctlmethod"));
            reimAmountBO.setCtrlType(expenseitem.getString("reimctltype"));
            String isreimburseamountctl = expenseitem.getString("isreimburseamountctl");
            reimAmountBO.setCtrlMode(isreimburseamountctl);
            Long oriCurrencyId = (Long)expenseEntry.getDynamicObject("entrycurrency").getPkValue();
            if ("1".equals(isreimburseamountctl)) {
                if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
                    if (expenseEntry.containsProperty("pubreimburser") && expenseEntry.getDynamicObject("pubreimburser") != null) {
                        reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("pubreimburser").getPkValue());
                    } else {
                        reimAmountBO.setUserOrDeptId((Long)dataEntity.getDynamicObject("applier").getPkValue());
                    }
                } else {
                    reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("reimburser").getPkValue());
                }
                QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
            } else if ("2".equals(isreimburseamountctl)) {
                reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("reimctldept").getPkValue());
                QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
            }
            Date date = expenseEntry.getDate("happendate");
            if ("2".equals(this.quotaDateField)) {
                date = bizDate;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            reimAmountBO.setHappenDate(YearMonth.of(calendar.get(1), calendar.get(2) + 1));
            boolean isAduit = false;
            if (Arrays.asList("B", "C").contains((String)model.getValue("billstatus"))) {
                isAduit = true;
            }
            ArrayList<Long> excludeReimbureBillIds = new ArrayList<Long>();
            if (isAduit) {
                excludeReimbureBillIds.add((Long)model.getDataEntity().getPkValue());
                log.info("\u662f\u5ba1\u6838\u72b6\u6001, \u6392\u9664\u7684\u5355\u636e\u4e3a: " + excludeReimbureBillIds);
            }
            reimAmountBO.setNotInIds(excludeReimbureBillIds);
            QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
            BigDecimal balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO);
            if ("2".equals(reimAmountBO.getCtrlType()) && balanceAmount == null) {
                model.setValue("amount_balanceamount", (Object)"--", i);
                continue;
            }
            if (balanceAmount == null) {
                balanceAmount = BigDecimal.ZERO;
            }
            String balanceAmountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)balanceAmount, (CurrencyBO)new CurrencyBO(reimAmountBO.getCurrencyId()));
            model.setValue("amount_balanceamount", (Object)balanceAmountStr, i);
        }
    }

    private boolean validRow(DynamicObject entry) {
        boolean on;
        DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
        boolean bl = on = expenseitem != null && entry.getDynamicObject("entrycurrency") != null && entry.getDate("happendate") != null;
        if (!on) {
            return false;
        }
        String isreimburseamountctl = expenseitem.getString("isreimburseamountctl");
        if ("1".equals(isreimburseamountctl)) {
            DynamicObject reimburser = ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName()) ? (entry.containsProperty("pubreimburser") ? entry.getDynamicObject("pubreimburser") : this.getModel().getDataEntity().getDynamicObject("applier")) : entry.getDynamicObject("reimburser");
            if (reimburser == null) {
                return false;
            }
        } else if ("2".equals(isreimburseamountctl)) {
            DynamicObject reimctldept = entry.getDynamicObject("reimctldept");
            if (reimctldept == null) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"copyentryrow")) {
            this.showBalanceAmount();
        }
    }
}

